// RCS $Id: memread.c,v 1.1 2001/07/20 09:41:54 solarb Exp solarb $
//
// RCS $Source: /home/solarb/util/pm/fileread/RCS/memread.c,v $
//
// RCS $Log: memread.c,v $
// RCS Revision 1.1  2001/07/20 09:41:54  solarb
// RCS Initial revision
// RCS
//
///////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <errno.h>
#include <string.h>

#define MIN_MD_PKT_SIZE	(256 + 2)			// In bytes
#define MAX_MD_PKT_SIZE	(256 + ((256 * 1024) * 2))	// In bytes

typedef struct {
  unsigned short	version;
  unsigned short	type;
  unsigned short	sec_hdr;
  unsigned short	apid;
  unsigned short	seq_flag;
  unsigned short	seq_count;
  unsigned short	length;
  unsigned long		sc_time;
} CCSDS_HEADER;

typedef struct {
  unsigned char		blank1;
  unsigned char		conf_flag;
  unsigned char		seq_flag;
  unsigned char		blank2;
  unsigned short	dsc;	// dump sequence counter
  unsigned long		length;
  unsigned char		blank3;
  unsigned char		mem_table;
  unsigned char		user;
  unsigned long		address;
} DUMP_ID;

int	read_ccsds_header(FILE *, CCSDS_HEADER *);
void	print_header(unsigned long, CCSDS_HEADER);

int	read_ccsds_data(FILE *, unsigned short, unsigned char *);

//void	hex_dump(unsigned char *);
void	hex_dump(unsigned char *, unsigned long);

void	decode_dump_id(DUMP_ID *, unsigned char *);

int	check_dump_id(DUMP_ID *);

void	print_dump_id(DUMP_ID *);
void	dump_dump(unsigned char *, unsigned long);

FILE	*out_fd;

int main(int argc, char **argv) {

  FILE	*st_fd;
  CCSDS_HEADER	ccsds_header;
  DUMP_ID	dump_id;
  unsigned char	packet[4096];
  unsigned long		number_of_pixels;
  int	res, err = 0;
  unsigned long	ccsds_packets = 0;
  unsigned long	mem_packet = 0, unknown_packet = 0;
  char	fname[255];
  char	outname[255];

  fname[0] = '\0';
  switch(argc) {
  case 2 :
    strcpy(fname,argv[1]);
    break;
  }
  fprintf(stderr,"fname = %s\n", fname);
  if((st_fd = fopen(fname,"r")) == (FILE *)NULL) {
    fprintf(stderr,"Cannot open input file: %s\n", strerror(errno));
    exit(1);
  }
  fprintf(stderr,"Opened %s\n",fname);
  //  fprintf(stdout, "#Input file is %s\n", fname);
  outname[0] = '\0';
  strcpy(outname, fname);
  strcat(outname, ".dump");
  /*
  if((out_fd = fopen(outname,"w")) == (FILE *)NULL) {
    fprintf(stderr,"Cannot open out file: %s\n", strerror(errno));
    exit(1);
  }
  */
  while(!err) {
    err = read_ccsds_header(st_fd, &ccsds_header);
    if(err != 0) {
      if (err == -1) {
	fprintf(stderr,"EOF\n");
	break;
      }
      else {
	fprintf(stderr,"read ccsds header error: %d\n", err);
	break;
      }
    }
    if(check_ccsds_header(ccsds_header)) {
      ++ccsds_packets;
      ////      print_header(ccsds_packets,ccsds_header);
      //      if((ccsds_header.length - 4 + 1) > 501 + 3) {
      if((ccsds_header.length - 4 + 1) > 501) {
	fprintf(stderr,"ccsds hdr len = %u\n", ccsds_header.length - 4 + 1);
	break;
      }

      res = read_ccsds_data(st_fd, ccsds_header.length - 4 + 1, packet);
      if(res == 0) {
	fprintf(stderr, "Error reading ccsds data\n");
	break;
      }

      switch(ccsds_header.apid) {
      case 0x0320 :
	++mem_packet;
	if(ccsds_header.length > 3) {	// real data in memory packet
	  decode_dump_id(&dump_id, packet);
	  if(check_dump_id(&dump_id)) {
	    //	    dump_dump(packet, dump_id.length + 13);
	    print_dump_id(&dump_id);
	    hex_dump(packet, dump_id.length + 13);

	  }

	}
	break;
      default :
	++unknown_packet;
      }
      
    }
    else {
      fprintf(stderr,"Bad ccsds header\n");
      break;
    }
  }	// while(!err)
  //  fprintf(stdout,"#Total ccsds: %lu, total memory: %lu, total unknown: %lu\n",
  //	  ccsds_packets,
  //	  mem_packet,
  //	  unknown_packet);
}


int	read_ccsds_header(FILE *fd, CCSDS_HEADER *hdr) {
  
  unsigned char	ccsds_header[10];
  unsigned short tmp, tmp1;
  
  size_t	res;

  res = fread((void *)ccsds_header,
	      sizeof(unsigned char),
	      10,
	      fd);
  
  ////  hex_dump(ccsds_header);
  
  if(res == 0) return(-1);
  
  hdr->version = ccsds_header[0] >> 5;
  hdr->type    = (ccsds_header[0] >> 4) & 1;
  hdr->sec_hdr = (ccsds_header[0] >> 3) & 1;
  tmp = (((ccsds_header[0] & 0x7) << 8) | ccsds_header[1]);
  hdr->apid    = tmp;
  hdr->seq_flag  = ccsds_header[2] >> 6;
  tmp = ((ccsds_header[2] & 0x3F) << 8) | ccsds_header[3];
  hdr->seq_count = tmp;
  
  tmp = (ccsds_header[4] << 8) | ccsds_header[5];
  hdr->length = tmp;
  
  tmp  = (ccsds_header[6] << 8) | ccsds_header[7];
  tmp1 = (ccsds_header[8] << 8) | ccsds_header[9];
  hdr->sc_time = tmp << 16;
  hdr->sc_time |= tmp1;
  
  return(0);
  
}


void	print_header(unsigned long num,CCSDS_HEADER hdr) {
  
  fprintf(stdout,
	  "#(%04lu) Ver %1u Type %1u Sec %1u APID %06X Seq Flg %1u Seq Cnt %07X Len %5u Time %08lX\n",
	  num,
	  hdr.version,
	  hdr.type,
	  hdr.sec_hdr,
	  hdr.apid,
	  hdr.seq_flag,
	  hdr.seq_count,
	  hdr.length,
	  hdr.sc_time);
  
}

int	check_ccsds_header(CCSDS_HEADER hdr) {
  
  if(hdr.apid == 0x0320) return(1);
  
  fprintf(stderr,"APID = %04X\n", hdr.apid);
  return(0);
  
}

int	read_ccsds_data(FILE *fd, unsigned short num, unsigned char *pkt) {
  
  int	res,i,index = 0, count = 0;
  
  res = fread((void *)pkt,
	      sizeof(unsigned char),
	      num,
	      fd);
  if(res == EOF) return(-1);
  return(1);
}

//void	hex_dump(unsigned char *data) {
void	hex_dump(unsigned char *data, unsigned long len) {
  
  int i,j,k,rows,rows1;
  char str[256];
  //  char tmp[64];
  
  rows = (len / 16);
  rows1 = (len % 16);

  k = 0;
  for(i = 0; i < rows; i++) {
    fprintf(stdout,"\t");
    for(j = 0; j < 16; j++) {
      fprintf(stdout,"%02X ",data[k++]);
    }
    fprintf(stdout,"\n");
  }

  if(rows1) {
    fprintf(stdout,"\t");
    for(i = 0; i < rows1; i++)
      fprintf(stdout,"%02X ",data[k++]);
    fprintf(stdout,"\n");
  }  
}

void	decode_dump_id(DUMP_ID *dump_id, unsigned char *packet) {
  
  dump_id->blank1 = *packet;
  dump_id->conf_flag = *(packet + 1);
  //  dump_id->seq_flag = (*(packet + 2)) & 3;
  //  dump_id->blank2 = *(packet + 2) >> 6;
  dump_id->seq_flag = (*(packet + 2)) >> 6;
  dump_id->blank2 = *(packet + 2) & 3;

  dump_id->dsc = (*(packet + 3) << 8) | *(packet + 4);
  dump_id->length = (*(packet + 5) << 16) |
    (*(packet + 6) << 8) |
    *(packet + 7);
  dump_id->blank3 = *(packet + 8);
  dump_id->mem_table = *(packet + 9) >> 4;
  dump_id->user = *(packet + 9) & 0x0F;
  dump_id->address = (*(packet + 10) << 16) |
    (*(packet + 11) << 8) |
    *(packet + 12);

}

int	check_dump_id(DUMP_ID *dump_id) {

  return(1);

}

  
void	print_dump_id(DUMP_ID *dump_id) {

  fprintf(stdout,
	  "\n\tB1  %u\tCONF FLG %u\tSEQ FLG %u\tB2 %u\n\tDSC %u\tLEN %#03X (%u)\tB3 %u\n\tMEM %01X\tUSER %01X\tADDR %#08lX\n",
	  dump_id->blank1,
	  dump_id->conf_flag,
	  dump_id->seq_flag,
	  dump_id->blank2,
	  dump_id->dsc,
	  dump_id->length,
	  dump_id->length,
	  dump_id->blank3,
	  dump_id->mem_table,
	  dump_id->user,
	  dump_id->address);	  
}

void	dump_dump(unsigned char *data, unsigned long len) {

  unsigned length;
  unsigned char *ptr;

  //  fprintf(stdout, "length = %d\n", len);
  length = len - 13;

  ptr = data;
  ptr += 13;

  while(length--) {
    fprintf(stdout, "%02X\n", *ptr++);
    //    ++ptr;
  }
}
