#!/usr/local/bin/perl

## RCS $Id:$
##
## RCS $Source:$
##
## RCS $Log:$
## RCS
##
###############################################################################

use Env qw(EGSE_SW_LIB);

##########################
# Once only initialization
##########################

do "$EGSE_SW_LIB/bytes_per_word1.pl" || warn "mem_recon: can't do bytes_per_word1: $!\n";
do "$EGSE_SW_LIB/overall_memory_map.pl" || warn "mem_recon: can't do overall_memory_map: $!\n";

#$address = sprintf "%u", 0;

$byte_count = 0;

while(<>) {
    next if(m/^\#/);
    next if(m/^ADDRESS/);
    next if(m/^RAM/);
    next if(m/^MEMORY/);
    chop;

    ++$byte_count;
    &output_line if($byte_count == 128);
}

if($byte_count) {
    &output_line;
}

sub output_line {

###    my $hex_addr = sprintf "%06X", $address;
    my $hex_addr = sprintf "%X", $address;
    my $hex_num  = sprintf "%02X", $byte_count;

    chop $bytes;	# Remove last ,
###    print STDOUT "load_eeprom 0x$hex_addr, 0x$hex_num," . $bytes . "\ntaskdelay 1.0\n";
    print STDOUT "load_mhcram 0x$hex_addr, $byte_count," . $bytes . "\ntaskdelay 4.0\n";
    $bytes = "";
    $address += $byte_count;
    $byte_count = 0;
}


### Functions

# Program address always starts at 0.
# Used to generate images for use with the prom programmer.
# If prom image max length is 0x10000;
# If eeprom image max length per eeprom is 0x???? and
# max number of eeproms is 8 TBC.
# If eeprom starting address may change too.
###sub output_intel_hex_function {
sub output_intel_hex {

    my $line = shift;
    my $hex_byte;
    my $new_line;
    my $address;
    my $line_len = length($line);

# If eeprom image get address from number specified on command line
# or the default in the master map file

    $address = sprintf("%04X", $ihex_record_address);	# need separate var from prom_address
####    $new_line = sprintf("%02X", (($line_len / 2) + 3 + 1)) . $address . "00" . $line;
    $new_line = sprintf("%02X", ($line_len / 2)) . $address . "00" . $line;
    $hex_byte = sprintf("%02X", generate_checksum($new_line));
    print ":" . $new_line . $hex_byte . "\n";
    $ihex_record_address += ($line_len / 2);
}


sub generate_checksum {

    my $line = shift;
    my $len;
    my $byte;
    my $xsum = 0;
    my $offset = 0;
    my $num;

    $len = length($line);
    while($len) {
	$byte = substr $line, $offset, 2 ;
	$offset += 2;
	$num = sprintf("%u", hex("0x" . $byte));
	$xsum += $num;
	$len -= 2;
    }

    $xsum &= 0xFF;

# This will return 0x100 if $xsum == 0 ... %02X in sprintf not working
#    return (0x100 - $xsum);
#    return (((0x100 - $xsum) - 1) & 0xFF);
    return ((0x100 - $xsum) & 0xFF);
#    return ((~$xsum) & 0xFF);
}


sub dummy_function {

#	return @_;
	return $_;
}

# Bit of confusion why length(@_) gives 1 here or length(\@_) gives 14...
sub reverse_words_function {

    my $len;
    my $byte;
    my $new_line = "";
    my $num_bytes;

    $len = length $_;
#    print "Line length = $len (@_)\t";
    $word_count = 1;
    while($len) {
	$num_bytes = $bytes_per_word;
	$offset = ($bytes_per_word * $word_count * 2) - 2;
	while($num_bytes) {
#	    $byte = substr @_, $offset, 2;
	    $byte = substr $_, $offset, 2;
#print "len = $len\toffset = $offset\tbyte = $byte\n";
	    $new_line .= $byte;
	    $offset -= 2;
	    --$num_bytes;
	}
	++$word_count;
	$len -= ($bytes_per_word * 2);
    }
    return($new_line);

#    return reverse(@_);		# Not proper just for test
}

