#!/usr/bin/perl

#
# Started by a cron job at 03:45 at the beginning of every month.
# 
# Get today's date, split into year, month.
# If the year is a leap year then increment days_in_month array element 2
# For the mission and status branches:
#    If the year directory does not exist in DARTS, create it.
#    If the year directory exists in DARTS:
#       If the month directory does not exist in DARTS, create it.
#       If the month directory does exist in DARTS:
#          For each day in 1 .. number of days in month
#             If the day directory does not exist then create it
#
# mcrw, MSSL November 2006

use Time::Local;
use Date::Calc qw(Add_Delta_Days);
use Env qw(EGSE_SW_LIB);

do "$EGSE_SW_LIB/date_calc.pl"     || die "Can't do date_calc.pl: $!\n";
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

# Not usually a leap year
my $leap_year = 0;

# Days in month
@days_in_month = (0,31,28,31,30,31,30,31,31,30,31,30,31);

# Get today's date
# $year needs 1900 to be added to it to get current year
# $mon (month) range is [0..11]
($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime();

# Adjust year
$year += 1900;

# Perform leap year check (not bothering about century years)
$leap_year = 1      if(($year % 4) == 0);
++$days_in_month[2] if $leap_year;

# Adjust month
++$mon;

# Put into 2 element string
$mon_str = sprintf "%02u", $mon;

# Do for both mission and status branches
foreach $branch ("mission", "status") {

    # Test if year exists; if not, create it
    if(!(-e "$darts/$branch/$year")) {
	system("/bin/mkdir $darts/$branch/$year");
	system("/bin/mkdir $soda_darts_mission/$year");
	make_staging_directories() if ($branch eq "mission");
    }

    # Do the same for the quicklook area
    if(!(-e "$darts_quicklook/$branch/$year")) {
	system("/bin/mkdir $darts_quicklook/$branch/$year");
    }
   
    # Test for month exists; if not, create it
    if(!(-e "$darts/$branch/$year/$mon_str")) {
	system("/bin/mkdir $darts/$branch/$year/$mon_str");
	system("/bin/mkdir $darts/$branch/$year/$mon_str/packet_check") if($branch eq "mission");
#	system("/bin/mkdir $darts/$branch/$year/$mon_str/decompression_factors") if($branch eq "mission");
	system("/bin/mkdir $soda_darts_mission/$year/$mon_str");
	system("/bin/mkdir $darts/$branch/$year/$mon_str/trends") if($branch eq "status");
#	system("/bin/mkdir $soda_darts/$branch/$year/$mon_str/trends") if($branch eq "status");
    }

    # Do the same for the quicklook
    if(!(-e "$darts_quicklook/$branch/$year/$mon_str")) {
	system("/bin/mkdir $darts_quicklook/$branch/$year/$mon_str");
#	system("/bin/mkdir $darts_quicklook/$branch/$year/$mon_str/trends") if($branch eq "status");
    }

    # Test if each day exists; if not, create them
    foreach $day (1 .. $days_in_month[$mon]) {
	$day_str = sprintf "%02u", $day;
	if(!(-e "$darts/$branch/$year/$mon_str/$day_str")) {
	    system("/bin/mkdir $darts/$branch/$year/$mon_str/$day_str") if($branch eq "status");
	    system("/bin/mkdir $darts_quicklook/$branch/$year/$mon_str/$day_str");
	    system("/bin/mkdir $soda_darts_mission/$year/$mon_str/$day_str");
	}
    }
}

sub make_staging_directories {
	system("/bin/mkdir $darts/staging/reformat_summary/$year");
	system("/bin/mkdir $darts/staging/packet_summary/$year");
	system("/bin/mkdir $darts/staging/orl/$year");
	system("/bin/mkdir $darts/staging/obstbl/$year");
	system("/bin/mkdir $darts/staging/fits_headers/$year");
	system("/bin/mkdir $darts/staging/eis_plan/$year");
	system("/bin/mkdir $darts/staging/logs/check_tables/dumps/$year");
	system("/bin/mkdir $darts/staging/logs/check_tables/tables/$year");
	system("/bin/mkdir $darts/staging/logs/data_loss/$year");
	system("/bin/mkdir $darts/staging/logs/decompression/$year");
	system("/bin/mkdir $darts/staging/logs/decompression/rescue/$year");
	system("/bin/mkdir $darts/staging/logs/md_reformat/$year");
	system("/bin/mkdir $darts/staging/logs/md_reformat/rescue/$year");
	system("/bin/mkdir $darts/staging/logs/md_translation/$year");
	system("/bin/mkdir $darts/staging/logs/pipeline_mission/$year");
	system("/bin/mkdir $darts/staging/logs/pipeline_mission/rescue/$year");
	system("/bin/mkdir $darts/staging/logs/pipeline_status/$year");
	system("/bin/mkdir $darts/staging/logs/shutter/$year");
	system("/bin/mkdir $darts/staging/dmp/$year");
}
