#!/usr/bin/perl

#
# Run monthly on the last day of each month
#

use Time::Local;
use Date::Calc;
use Env qw(EGSE_SW_LIB);

do "$EGSE_SW_LIB/date_calc.pl" || warn "Can't do date_calc.pl: $!\n";
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

#open(MLOG, ">> $pipeline_log/pipeline_log.txt") || die "Can't open $pipeline_log/pipeline_log.txt for writing: $!";
#print MLOG scalar(localtime), " (JST) daily_merge_status1 started ";

$state = "cron"; # Default to cron job

# Set default values for start date, end date and start time to empty strings. If in
# interactive state these are not set then bail out.

$sdate = "";

# If there is anything on the command line then this is interactive mode

if($#ARGV != -1) {
    $state = "interactive";
    if(@ARGV) { $sdate = shift; }
    die "No start date" if $sdate eq "";
    $log_file = "$pd_decompression_dir/update_log.txt";
    open(LOG, ">> $log_file") || die "Can't open $log_file for writing: $!";
    print LOG "Started (manually) ", scalar(localtime), " (JST)\n";
    ($log, $perform, $title) = init_log_and_perform(*LOG, "interactive");
}
else {
    # Started by cron. Calculate start date, end date and start time
    @today = today();	# @today[0..6] = seconds,minutes,hours,day,month,year,day_of_week (0 = sunday)
    @start_day = other_date(@today, -10);
    $syear  = sprintf "%04u", $start_day[5];	# Get starting year
    $smonth = sprintf "%02u", $start_day[4];	# Get starting month
    $sday   = sprintf "%02u", $start_day[3];	# Get starting day
    
    $sdate = "$syear$smonth$sday";

    $log_file = "$pd_decompression_dir/update_log.txt";
    open(LOG, ">> $log_file") || die "Can't open $log_file for writing: $!";
    print LOG "Started (cron) ", scalar(localtime), " (JST)\n";
    ($log, $perform, $title) = init_log_and_perform(*LOG, "cron");
}

# Split the start date into constituent parts
$year  = substr $sdate, 0, 4;
$month = substr $sdate, 4, 2;
$day   = substr $sdate, 6, 2;

# And bung them back again
$ym = "$year$month";

# List of compression types
my @type_list = qw(dpcm jpeg50 jpeg65 jpeg75 jpeg85 jpeg90 jpeg92 jpeg95 jpeg98);


############################################### 0 - Move existing decompression record

$dest_file = "$pd_record_name" . "_$ym" . ".txt";

&$title("Renaming decompression record");
&$perform("/bin/cat $pd_decompression_dir/$pd_record_name.txt | sort | uniq > $pd_monthly_records/$dest_file");
&$perform("/bin/rm $pd_decompression_dir/$pd_record_name.txt");


############################################### 1 - Extract monthly factors

&$title("Extract monthly factors");
&$perform("~/bin/extract_monthly_factors.awk --assign yyyymm=$ym < $pd_monthly_records/$dest_file > ~/work/tmp/decomp_monthly_factors.txt");
#&$perform("~/bin/extract_monthly_factors.awk --assign yyyymm=$ym < $pd_monthly_records/$pd_record_name_$ym.txt > ~/work/tmp/decomp_monthly_factors.txt");


############################################### 2 - Update monthly averages

&$title("Update monthly averages");
&$log("Open ~/work/tmp/decomp_monthly_factors.txt");
open(MF, "< $HOME/work/tmp/decomp_monthly_factors.txt") || die "Can't open ~/work/tmp/decomp_monthly_factors.txt : $!";
@lines = <MF>;
foreach $type (@type_list) {
    foreach $line (@lines) {
	chomp $line;
	if($line =~ m/$type/) {
	    open(F, ">> $pd_monthly_tracks/$type.txt") || die "Can't open $pd_monthly_tracks/$type.txt : $!";
	    my @things = split(' ', $line);
	    print F "$things[0] $things[2] $things[3]\n";
	    close F;
	}
    }
}
close MF;

############################################### 3 - Update averages

&$title("Update averages");
foreach $type (@type_list) {
    &$perform("~/bin/update_averages.awk < $pd_monthly_tracks/$type.txt > $pd_type_average/$type.txt");
}


############################################### 4 - Tidy up

&$title("Tidy up");
&$perform("/bin/rm ~/work/tmp/decomp_monthly_factors.txt");


############################################### 5 - Close and move log

close LOG;
&$perform("/bin/cp $pd_decompression_dir/update_log.txt $HOME/data/staging/logs/decompression/");

