#!/usr/bin/perl

use Env qw(EGSE_SW_LIB);

do "$EGSE_SW_LIB/date_calc.pl"     || die "Can't do date_calc.pl: $!\n";
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

$opt = "";

# Get the date for the dr repro
if($#ARGV == 0) {
    $sdate = shift;
}
elsif($#ARGV == 1) {
    $opt = shift;
    $date = shift;
    if($opt ne "-s") {
        die "Usage: daily_passes [-s] yyyymmdd\n";
    }
}
else {
    die "Usage: daily_passes [-s] yyyymmdd\n";
}

# Get contact info
#$src_file = $sdate . "_contacts.txt";
#$file     = `/bin/ls $pass_list_dir/$src_file`;
#die "Can't find contact file\n" unless $file ne "";

$file     = "/data/SOLAR-B/downlinked.passes";
die "Can't find contact file\n" unless $file ne "";

# Open the contacts file for this date
open(PASS, "< $file") or die "Can't open contacts file\n";

# Make the necessary files for this daily data
# Uncomment next lines
system("/bin/mkdir $sdtp/md/$sdate")           unless(-e "$sdtp/md/$sdate");
system("/bin/mkdir $sdtp/status/$sdate")       unless(-e "$sdtp/status/$sdate");
system("/bin/mkdir $sdtp/fits/mission/$sdate") unless(-e "$sdtp/fits/mission/$sdate");
system("/bin/mkdir $sdtp/fits/status/$sdate")  unless(-e "$sdtp/fits/status/$sdate");
system("/bin/mkdir $sdtp/plots/$sdate")        unless(-e "$sdtp/plots/$sdate");

# Empty out the dr directory
###system("/bin/rm -f $sdtp/dr/eis_*");
system("cd $sdtp/dr && /bin/rm -f eis_*");

# Read the pass info and get the data from the dr
while(<PASS>) {

#    print;
#    next if /real/;	# Don't bother with real as it will be replicated in the dr repro
#    system("$_\n");

    next if !/$sdate/;
    s/\s+/ /g;
    ($start_date, $end_date, $antenna, $band) = split;
#    print "$start_date, $end_date, $antenna, $band\n";
    $stime = substr $start_date, 8, 4;
    $end_date1 = substr $end_date, 0, 8;
    next unless $sdate =~ /$end_date1/;
    $etime = substr $end_date, 8, 4;

    # Make sure the end time is later than in the file
    $end_time_hour   = sprintf "%02u", substr($etime, 0, 2);
    $end_time_minute = sprintf "%02u", substr($etime, 2, 2);
    ++$end_time_minute;
    if($end_time_minute == 60) {
	++$end_time_hour;
	$end_time_minute = sprintf "%02u", 0;
    }
    next if $end_time_hour == 24;
    $the_end_time = "$end_time_hour$end_time_minute";
#    print "$stime, $etime ($the_end_time)\n";
    
    $band_number = 1;
    $band_number = 2 unless $band eq "S";

    print "\nsdtp dr band=$band_number $antenna sdate=$sdate stime=$stime etime=$the_end_time\n";
    system("sdtp dr band=$band_number $antenna sdate=$sdate stime=$stime etime=$the_end_time");

}

#############system("/bin/mv $sdtp/dr/eis_md_*  $sdtp/md/$sdate")     if(-e "$sdtp/md/$sdate");

# Uncomment next lines
system("/bin/mv $sdtp/dr/eis_sts_* $sdtp/status/$sdate") if(-e "$sdtp/status/$sdate");
system("/bin/mv $sdtp/dr/eis_dmp_* $sdtp/dmp");
system("cd $sdtp/dr && /bin/mv eis_md_* $sdtp/md/$sdate")     if(-e "$sdtp/md/$sdate");
