#!/usr/bin/perl

#
# This program is scheduled to run on pg4
#

# crontab entry
# 30 9 * * fri $HOME/bin/pass_list_cron.pl
#
# So every friday at 09:30 get the pass list from the eisco machine
#
# crontab entry on eisco
# 0 9 * * fri $HOME/bin/pass_list_cron.csh

#
# Copy today's obev file on eisco to the obev_list directory
#

use Time::Local;
use Date::Calc;
use Env qw(EGSE_SW_LIB);

do "$EGSE_SW_LIB/date_calc.pl"     || die "Can't do date_calc.pl: $!\n";
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

open(LOG, ">> $pipeline_log/obev_cron.txt");

#
# Create the pass list files for the next week
#
@today = today();	# @today[0..6] = seconds,minutes,hours,day,month,year,day_of_week (0 = sunday)

#
# If today is sunday then don't do anything
#
exit if($today[6] == 0);

#
# Split today's date up
#
$year  = sprintf "%04u", $today[5];	# Get starting year
$month = sprintf "%02u", $today[4];	# Get starting month
$day   = sprintf "%02u", $today[3];	# Get starting day
$current_time = scalar(localtime);
print LOG "$current_time: today's date is $year $month $day\n";

#
# Make the source filename
#
$src_file = "obev_" . "$year$month$day" . "????.evt";
#$cmdpln = "$HOME/eisco/cmdpln/$year$month$day/auxiliary";
$cmdpln = "$HOME/eisco/../cp/cmdpln/$year$month$day/auxiliary";

print LOG "\tLooking for $src_file in $cmdpln/\n";
#
# If there is a matching file in eisco's latest directory then copy it across
#
@files = `ls $cmdpln/$src_file`;
if(@files) {
    print LOG "\tFOUND $src_file in $cmdpln/\n";
    system("/bin/cp $cmdpln/$src_file $obev_dir");
    system("/bin/cp $cmdpln/$src_file $HOME/data/staging/obev");
}

close(LOG);

system("/bin/cp $pipeline_log/obev_cron.txt $HOME/data/staging/obev/");
