#!/usr/bin/perl

#
# This program is scheduled to run on pg4
#

# crontab entry
# 30 9 * * fri $HOME/bin/pass_list_cron.pl
#
# So every friday at 09:30 get the pass list from the eisco machine
#
# crontab entry on eisco
# 0 9 * * fri $HOME/bin/pass_list_cron.csh

#
# Copy today's orl file on eisco to the orl_list directory
#

use Time::Local;
use Date::Calc;
use Env qw(EGSE_SW_LIB);

do "$EGSE_SW_LIB/date_calc.pl"     || die "Can't do date_calc.pl: $!\n";
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

open(LOG, ">> $pipeline_log/obstbl_cron.txt");

#
# Create the pass list files for the next week
#
@today = today();	# @today[0..6] = seconds,minutes,hours,day,month,year,day_of_week (0 = sunday)

#
# If today is sunday then don't do anything
#
exit if($today[6] == 0);

#
# Split today's date up
#
$year  = sprintf "%04u", $today[5];	# Get starting year
$month = sprintf "%02u", $today[4];	# Get starting month
$day   = sprintf "%02u", $today[3];	# Get starting day
$current_time = scalar(localtime);
#print LOG "$current_time: today's date is $year $month $day\n";
print LOG "$current_time\n";

#
# Make the source filename
#
#$src_file = "EIS_OBSTBL_" . "$year$month$day" . "????.hex";
#$cmdpln = "$HOME/eisco/cmdpln";
$src_file = "EIS_OBSTBL_" . "$year$month$day" . "????.hex";
$cmdpln = "$HOME/eisco/cmdpln";
$eisco = "$HOME/eisco/EIS_CPT_output/obstbl";

#print LOG "\tLooking for $src_file in $cmdpln/used/archive/OBSTBL/\n";

#
# Have a look in archive
#
print LOG "\tLooking for $src_file in $eisco\n";
#@files = `ls $cmdpln/used/archive/OBSTBL/$src_file`;
@files = `ls $eisco/$src_file`;
if(@files) {
    foreach $file (@files) {
	my $dest = "$HOME" . "/data/staging/obstbl/" . "$year" . "$file";
	if (-f $dest) {
	    last;
	}
	else {
	    print LOG "\tFOUND $src_file in archive\n";
	    #system("/bin/cp $cmdpln/used/archive/OBSTBL/$src_file $HOME/data/staging/obstbl/");
	    system("/bin/cp $eisco/$src_file $HOME/data/staging/obstbl/$year/");
	    last;
	}
    }
}
else {
    print LOG "\tNOT found\n";
}

close(LOG);

system("/bin/cp $pipeline_log/obstbl_cron.txt $HOME/data/staging/obstbl/");
