#!/usr/bin/perl

#
# This program is scheduled to run on pg4
#

# crontab entry
# 30 9 * * fri $HOME/bin/pass_list_cron.pl
#
# So every friday at 09:30 get the pass list from the eisco machine
#
# crontab entry on eisco
# 0 9 * * fri $HOME/bin/pass_list_cron.csh

#
# Copy today's orl file on eisco to the orl_list directory
#

use File::Basename;
use Time::Local;
use Date::Calc;
use Env qw(EGSE_SW_LIB);

do "$EGSE_SW_LIB/date_calc.pl"     || die "Can't do date_calc.pl: $!\n";
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

@today = today();	# @today[0..6] = seconds,minutes,hours,day,month,year,day_of_week (0 = sunday)

#
# If today is sunday then don't do anything
#
exit if($today[6] == 0);

#($log, $perform, $title) = init_log_and_perform(*LOG, "interactive");
open(LOG, ">> $pipeline_log/orl_cron.txt");

#
# Split today's date up
#
$year  = sprintf "%04u", $today[5];	# Get starting year
$month = sprintf "%02u", $today[4];	# Get starting month
$day   = sprintf "%02u", $today[3];	# Get starting day
$current_time = scalar(localtime);
#print LOG "$current_time\n";

#
# Make the source filename
#
$src_file  = "EIS_" . "$year$month$day" . "????.orl";
#$cmdpln    = "$HOME/eisco/cmdpln";
$cmdpln    = "$HOME/eisco/EIS_CPT_output/orl";
$cp_cmdpln = "$HOME/eisco/../cp/cmdpln/" . "$year$month$day" . "/ORL_original";

#
# If there is a matching file in eisco's latest directory then copy it across
#

my @suffix_list = ("orl");
###$src_file = "EIS_20230722????.orl";
@files = `ls $cmdpln/$src_file`;
if(@files) {
###    print "FILES: @files\n";
###    FILES: /home/sbukeis/eisco/EIS_CPT_output/orl/EIS_202307228000.orl
    foreach $file (@files) {
###	print "FILE: $file\n";
###     FILE: /home/sbukeis/eisco/EIS_CPT_output/orl/EIS_202307228000.orl
	my($filename, $dirs, $suffix) = fileparse($file, @suffix_list);
	chomp $filename;
###	print "Filename, dirs, suffix: $filename, $dirs, $suffix\n";
###	Filename, dirs, suffix: EIS_202307228000., /home/sbukeis/eisco/EIS_CPT_output/orl/, orl

	my $new_file = $filename . "txt";
	my $dest  = $HOME . "/data/staging/orl/" . $new_file;
	my $dest1 = $HOME . "/data/staging/orl/" . $year . "/" . $new_file;

	if ((-f $dest) || (-f $dest1)) {
	    print LOG "$current_time\t$src_file already found\n";
	}
	else {
	    print LOG "$current_time\tLooking for $src_file in $cmdpln/\n";
	    print LOG "/bin/cp $cmdpln/$src_file $orl_dir\n";
	    system("/bin/cp $cmdpln/$src_file $orl_dir");
	    print LOG "/bin/cp $cmdpln/$src_file $HOME/data/staging/orl/$new_file\n";
	    print LOG "/bin/cp $cmdpln/$src_file $HOME/data/staging/orl/$year/$new_file\n";
#	    system("/bin/cp $file $HOME/data/staging/orl/$new_file");
#	    system("/bin/cp $file $HOME/data/staging/orl/$year/$new_file");
	    system("/bin/cp $cmdpln/$src_file $HOME/data/staging/orl/$new_file");
	    system("/bin/cp $cmdpln/$src_file $HOME/data/staging/orl/$year/$new_file");
	}
    }
    
#    my $new_file = fileparse($src_file, ".orl");
#    print LOG "\tFOUND $src_file in $cmdpln\n";
#    system("/bin/cp $cmdpln/$src_file $orl_dir");
#    #system("/bin/cp $cmdpln/$src_file $HOME/data/staging/orl/");
#    #system("/bin/cp $cmdpln/$src_file $HOME/data/staging/orl/$year");
#    system("/bin/cp $cmdpln/$src_file $HOME/data/staging/orl/$new_file.txt");
#    system("/bin/cp $cmdpln/$src_file $HOME/data/staging/orl/$year/$new_file.txt");
}
print LOG "Done\n----------\n\n";
close(LOG);

system("/bin/cp $pipeline_log/orl_cron.txt $HOME/data/staging/orl/");
