#!/usr/bin/perl

#
# This program is scheduled to run on pg4 by cron but can also be run from the command line.
#

#
# allband = 0xF1
# antenna = 0xF0 merge
#           0xF1 allant
#
# Base start time on the first usc contact of the day in the contacts file for the day
# (20061029_contacts.txt appears not to have any usc passes - thats because it was a
# sunday...)
# 20061101_contacts.txt msp1 is first real, so maybe look for first real contact time
# and use that as the start time. Also sundays do not have any real time contacts...
#

use Time::Local;
use Date::Calc;
use Env qw(EGSE_SW_LIB);

# Instead of die-ing would be better to report the error in a file somewhere
# and then exit. This applies to all instances of die of course. Todo.

do "$EGSE_SW_LIB/date_calc.pl"     || die "Can't do date_calc.pl: $!\n";
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";


# Set default values for start date, end date and start time to empty strings. If in
# interactive state these are not set then bail out.

$sdate = "";
$edate = "";
$stime = "";

# If there is anything on the command line then this is interactive mode
if($#ARGV != -1) {
    $state = "interactive";
    #
    # Get any command line arguments (must be in this order)
    #
    if(@ARGV) { $sdate  = shift; }
    if(@ARGV) { $edate  = shift; }
    if(@ARGV) { $stime 	= shift; }
    if(@ARGV) { $etime 	= shift; }
    #
    # Simple check for arguments. Could test actual times but sdtp will catch errors
    #
    die "No start date" if $sdate eq "";
    die "No end date"   if $edate eq "";

    $stime_str = parse_orl_file($sdate, *LOG);
    $etime_str = parse_orl_file($edate, *LOG);

}

# Split the start date into constituent parts
$year  = substr $sdate, 0, 4;
$month = substr $sdate, 4, 2;
$day   = substr $sdate, 6, 2;

print "sdate = $sdate\n";
print "edate = $edate\n";
print "stime = $stime_str\n";
print "etime = $etime_str\n";

print "year = $year\n";
print "month = $month\n";
print "day = $day\n";

sub parse_orl_file {
    my $date = shift;	# Date of contact
    my $fh   = shift;	# Log file filehandle

    my $line;
    my $src_file;
    my $file;
	
    # Parse orl file to get start time. $orl_dir needs to be defined in pipeline_defs.
    $src_file = "EIS_" . "$date" . "????.orl";
    $file = `/bin/ls $orl_dir/$src_file`;
    if($file eq "") {
	print $fh "\tCan't find orl file for $date\n";
	return "";
    }
    chomp $file;
    print $fh "\tUsing orl file $file for $date\n";
    $line = "";

    if(open(ORL, "< $file")) {
	while(<ORL>) {
	    if(/^START/) {
		$line = $_;
		last;
	    }
	    next;
	}
	close(ORL);
    }
    else {
    	print $fh "\tCan't open orl file for $date ($!)\n";
    	return "";
    }

    if($line eq "") {
        print $fh "\tNo start time found in $file\n";
        return "";
    }
    #
    # $line should be like: START:2007/02/13.10:00:00 { SEQ:EIS_LOAD_OBSTBL_REAL ;}
    # Return hhmm portion
    #
    $hh = substr $line, 17, 2;
    $mm = substr $line, 20, 2;

    return "$hh$mm";
}
