#!/usr/local/bin/perl

# pad_db.pl < md_hdrs_yyyymmdd.html

# Optional as far as I can see
#use NDBM_File;

use Env qw(EGSE_SW_LIB);
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

while(<>) {
    last if /^\<pre\>/;
}

<>;

dbmopen(%db,   "$HOME/work/reformat/exp_pad.db", '0333') or die "Can't open database: $!";
dbmopen(%done, "$HOME/work/reformat/done.db", '0333') or die "Can't open database: $!";
#$first = 1;
while(<>) {
    last if /^\<\/pre\>/;
#next if /^$/ && $first;
    next if /eis_md/;
    next if /^Type/;
    next if /^Pixel/;
    next if /headers/;
    next if /ccsds/;
    if(/^$/) {
#	print "Setting done for $key\n";
#	$done{$key} = 1;
	next if $key == 0;
	$val = $db{$key};
	@list = split /:/, $val;
	$len = @list;
	$done{$key} = $len;
	next;
    }
    chomp;
    @stuff = split;

    $key = $stuff[25];	# Raster id
    next if $key == 0;
    next if $done{$key};

    @packet_data = extract_data(@stuff);
#    $len = @packet_data;
    $line = join ' ', @packet_data;
    $line .= ':';
    $db{$key} .= $line;
#    $done{$key} = $len;
}

dbmclose %db;
dbmclose %done;

#dbmopen(%db, "/$HOME/work/reformat/exp_pad.db", '0555') or die "Can't open database the second time: $!";
dbmopen(%db, "/$HOME/work/reformat/done.db", '0555') or die "Can't open database the second time: $!";

print "The database:\n";

while(($key, $val) = each %db) {
    print $key, ' = [', $val, "]\n";
    
#    @list = split /:/, $val;
#    $len = @list;
#    print "Len = $len\n";
}
print "\n";
#while(($key, $val) = each %db) {
#    print $key, ' = [', $val, "]\n";
    
#    @list = split /:/, $val;
#    $len = @list;
#    print "Len = $len\n";
#}
#print "\n";

#dbmclose %db;
dbmclose %done;

sub extract_data {
    my @s = @_;
    my @constants;
    my @data;
    
    push @data, $s[1];	# Size;
    push @data, $s[4];	# MSF
    push @data, $s[5];	# MSC
    push @data, $s[6];	# ppe
    push @data, $s[9];	# SSF
    push @data, $s[11];	# FX
    push @data, $s[12];	# FY
    push @data, $s[13];	# BX
    push @data, $s[14];	# BY
    push @data, $s[15];	# PX
    push @data, $s[16];	# PY
	
    return(@data);
#return(@constants, @data);
}
