#!/usr/bin/perl

#
# usc34 & 20 assume automatic dr repro
#

#
# parse_contact_file.pl 20061102 ~/work/pass_list/pass_list.txt > ~/work/pass_list/20061102_contacts.txt
#

# Just for now - start date search string. Pass in from another program or use local date and adjust.
my $search_date = "20061025";

# If there are 2 arguments on the command line then the search date must be first
$search_date = shift if($#ARGV == 1);

# List of the lines for the search date in the current pass list
my @contacts;

# Not needed?
my @outputs;

# Read in the contacts file
while($line = <>) {
    last if $line =~ /$search_date/;	# Loop until the search date matches
    next if $line =~ /^=/;		# Ignore
    next if $line =~ /^\#/;		# Ignore
    next if $line =~ /^</;		# Ignore
    next if $line =~ /^\[/;		# Ignore
}

# Found anything?
die "No contacts found\n" if $line eq "";

# Save in the contacts list
chomp $line;
push @contacts, lc $line; 

# Now loop through the file until the search date no longer matches
while($line = <>) {
    next if $line =~ /^\<\</;		# Ignore
    next if $line =~ /^\[/;		# Ignore
    last if !($line =~ /$search_date/);	# Bail when no longer a date match
    chomp $line;			
    push @contacts, lc $line; 		# Save contact in list
}

#foreach $c (@contacts) {
#    print "CONTACT: [$c]\n";
#}
#print "\n";

# For every contact in the contact list
foreach $c (@contacts) {
    # Get rid of characters that get in the way of a clean split
    $c =~ s/\*\*\*\*//g;
    $c =~ s/[-]+//g;
    $c =~ s/\>//;
    $c =~ s/[\/]+//g;
    $c =~ s/\[//;
    $c =~ s/\]//;
    $c =~ s/^\*/ \*/;
    $c =~ s/://g;

    # Split the contact into it's components
    ($junk,$ant, $date, $date1, $st, $st1, $et, $et1, $d, $d1, $e, $a,$a1,$a2,$a3, $type) = split /[ \t]+/, $c;
    
###    print "ant $ant\tdate $date1\tstime $st\tetime $et1\ttype $type\t";

    # Initialize the output line
    $out_line = "sdtp ";

    # What is the * for anyway?
    $ant =~ s/\*//;

    #
    # Calculate time for the at job
    #    at TIME -f job_file

    # Make the start time nice
    $st = substr $st, 0, 4;

    # Make the end time larger than the one in the file
    $ehr = sprintf("%02u", substr($et1, 0, 2));
    $emi = sprintf("%02u", substr($et1, 2, 2));

    ++$emi;
    if($emi == 60) {
	++$ehr;		# NO CHECK FOR WRAP INTO NEXT DAY
	$emi = sprintf("%02u", 0);
    }
    $ehr_str = "$ehr$emi";

    # Set up the sdtp program depending on what type of contact it is

    if(($type =~ 'xrepro') || ($ant =~ /usc/)) {
	$out_line .= "dr   band=2 $ant sdate=$date1 stime=$st etime=$ehr_str ";
    }
    else {
	$out_line .= "real band=2 $ant sdate=$date1 stime=$st etime=$ehr_str ";
    }

    print "$out_line\n";
    
}
