#!/usr/bin/perl

#
# This program is scheduled to run on pg4
#

# crontab entry
# 30 9 * * fri $HOME/bin/pass_list_cron_low_dr_world.pl
#
# So every friday at 09:30 get the pass list from the eisco machine
#
# crontab entry on eisco
# 0 9 * * fri $HOME/bin/pass_list_cron.csh

#
# pass_list_cron.csh on eisco puts the latest contacts html file into ~eisco/tmp/pass_list
#

use Env qw(EGSE_SW_LIB);

do "$EGSE_SW_LIB/date_calc.pl"     || die "Can't do date_calc.pl: $!\n";
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

open(LOG, ">> $pipeline_log/pass_list_cron.txt");

$current_time = scalar(localtime);
print LOG "$current_time\n";

# Gzip up and move existing contact lists into the old directory
#system("gzip $pass_list_dir/*_contacts.txt");
#system("mv $pass_list_dir/*gzip $pass_list_dir/old");

# Copy the file across
#print LOG "/bin/cp $HOME/eisco/tmp/pass_list $pass_list_dir/pass_list.txt";
#system("/bin/cp $HOME/eisco/tmp/pass_list $pass_list_dir/pass_list.txt\n");

# Create the pass list files for the next week
@today = today();	# @today[0..6] = seconds,minutes,hours,day,month,year,day_of_week (0 = sunday)

# Create a back up copy of the pass list and put it into the old directory
$syear  = sprintf "%04u", $today[5];	# Get starting year
$smonth = sprintf "%02u", $today[4];	# Get starting month
$sday   = sprintf "%02u", $today[3];	# Get starting day

$latest_pass_list = "pass_list_" . "$syear$smonth$sday" . ".txt";
print LOG "/bin/cp $pass_list_dir/pass_list.txt $pass_list_dir/old/$latest_pass_list\n";
system("/bin/cp $pass_list_dir/pass_list.txt $pass_list_dir/old/$latest_pass_list");
system("/bin/cp $pass_list_dir/old/$latest_pass_list $HOME/data/staging/pass_list/old/");

# Create pass list files for the next 7 days
foreach $d (0..6) {
    @new_date = other_date(@today, $d);

    $syear  = sprintf "%04u", $new_date[5];	# Get starting year
    $smonth = sprintf "%02u", $new_date[4];	# Get starting month
    $sday   = sprintf "%02u", $new_date[3];	# Get starting day

    $date = "$syear$smonth$sday";
    $file = "$date" . "_contacts.txt";

    print LOG "parse_contact_file $date $pass_list_dir/pass_list.txt > $pass_list_dir/$file\n";
    system("parse_contact_file $date $pass_list_dir/pass_list.txt > $pass_list_dir/$file");
    system("/bin/cp $pass_list_dir/$file $HOME/data/staging/pass_list/");
}

system("/bin/cp $pass_list_dir/pass_list.txt $HOME/data/staging/pass_list/");

print LOG "------------------------\n\n";
close(LOG);
system("/bin/cp $pipeline_log/pass_list_cron.txt $HOME/data/staging/pass_list/");
