#!/usr/bin/perl -W

use Time::Local;
use Date::Calc;
use Env qw(EGSE_SW_LIB);
use lib "$EGSE_SW_LIB/perllib/CcsdsLib";
use CcsdsInterface;
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

my %filenames;
my %headless;
my %incomplete;
my %files_seq_counts;

#
# One command line arg: directory name containing ccsds packet files
#
$file_type = "eis_md*";
if($#ARGV == 0) {
    $dirname = $ARGV[0];
}
elsif($#ARGV == 1) {
#    $file_type = "eis_sts*";
    $file_type = $ARGV[0];
    $dirname = $ARGV[1];
}
else {
    message("Usage: pipeline_ccsds_check [sts] dirname");
    exit -1;
}

print STDOUT "Dirname: $dirname\n";
$archive = CcsdsInterface->new();
###@files = `ls $dirname/$file_type*`;
@files = `ls $dirname | grep eis_md`;
foreach $file (@files) {
    chomp $file;
    print STDOUT "\n$dirname/$file\n";
    print STDOUT "Time, Version, Type, Sec, APID, Flg, Count, Len\n";
    if($archive->openForReading("$dirname/$file")) {
	$missing_count = 0;
	$gaps = 0;
	$first = 1;

	$archive->setPrimaryHeaderLength(6);
	$archive->setSecondaryHeaderLength(4);
	$archive->setEndian("big");

	if($archive->nextPacket()) {
	    $archive->printHeadersSummary();
	    $seq_count = $archive->getSequenceCount();
	    $first_seq_count = $seq_count if $first;
	    $first = 0;
	    $first_flag = $archive->firstPacketOfSequence();
	    $headless{$file} = 'Headless packet' unless $archive->isFirstPacketOfSequence();
	    while($archive->nextPacket()) {
		$next_seq_count = $archive->getSequenceCount();
		if($next_seq_count != (($seq_count + 1) & 0x3FFF)) {
		    if(!(($next_seq_count == 0) and ($seq_count == 0x3FFF))) {
			++$gaps;
			# Get count of number of missing packets
			$missing = $next_seq_count - $seq_count - 1;
			# Adjust for wrap around
			$missing = 16384 + $missing if $missing < 0;
			# Add to total
			$missing_count += $missing;
			print STDOUT "*** Missing packets: $missing\n";
			$filenames{$file} = 'Missing packets';
		    }
		}
		$seq_count = $next_seq_count;
		$archive->printHeadersSummary();
	    }
	    # Check whether last packet's flag is 2
#	    $filenames{$file} = 'Missing packets' unless $archive->isLastPacketOfSequence();
	    $last_flag = $archive->lastPacketOfSequence();
	    $incomplete{$file} = 'Incomplete packets' unless $archive->isLastPacketOfSequence();
	    ++$gaps unless $archive->isLastPacketOfSequence();
	    $archive->report();
	    print STDOUT "Number of gaps: $gaps\nNumber of packets missing: $missing_count\n";
#
# Record filename & first, last sequence count
#
	    $files_seq_counts{$file} = [$first_seq_count, $seq_count, $first_flag, $last_flag, $archive->numberOfPackets(), $missing_count, $gaps];
	}
	else {
	    print STDOUT "Failed to get first packet\n";
	    print STDERR "Failed to get first packet\n";
	}
#	$archive->printHeaders();
    }
    else {
	print STDOUT "Failed to open file $file : $!\n";
	print STDERR "Failed to open file $file : $!\n";
    }
}

if(%filenames) {
    print STDERR "Missing filenames hash has something\n";
    open(SUMMARY, "> $dirname/missing_packets.txt") || print STDERR "Can't open $dirname/missing_packets.txt : $!\n";
    print SUMMARY "Missing\n";
    foreach $key (keys %filenames) {
	if($filenames{$key} eq 'Missing packets') {
	    print SUMMARY "$key\n";
	}
    }
    print SUMMARY "\n";
    close SUMMARY;
}
else {
    print STDERR "Missing filenames hash has NOTHING\n";
}

if(%headless) {
    print STDERR "Headless filenames hash has something\n";
    open(SUMMARY, "> $dirname/headless_packets.txt") || print STDERR "Can't open $dirname/headless_packets.txt : $!\n";
    print SUMMARY "Headless\n";
    foreach $key (sort keys %headless) {
	if($headless{$key} eq 'Headless packet') {
	    print SUMMARY "$key\n";
	}
    }
    print SUMMARY "\n";
    close SUMMARY;
}
else {
    print STDERR "Headless filenames hash has NOTHING\n";
}

if(%incomplete) {
    print STDERR "Incomplete filenames hash has something\n";
    open(SUMMARY, "> $dirname/incomplete_packets.txt") || print STDERR "Can't open $dirname/incomplete_packets.txt : $!\n";
    print SUMMARY "Incomplete\n";
    foreach $key (sort keys %incomplete) {
	if($incomplete{$key} eq 'Incomplete packets') {
	    print SUMMARY "$key\n";
	}
    }
    print SUMMARY "\n";
    close SUMMARY;
}
else {
    print STDERR "Incomplete filenames hash has NOTHING\n";
}

if(open(COUNTS, "> $dirname/sequence_counts.txt")) {
    print COUNTS "Filename                    Seq1  Seq2 Flg1 Flg2    Rec   Miss  Gaps\n";
#    $~ = "SEQ";
    foreach $file (sort keys %files_seq_counts) {
	$seq1 = sprintf "%5u", $files_seq_counts{$file}[0];
	$seq2 = sprintf "%5u", $files_seq_counts{$file}[1];
	$flg1 = sprintf "%4u", $files_seq_counts{$file}[2];
	$flg2 = sprintf "%4u", $files_seq_counts{$file}[3];
	$crec = sprintf "%6u", $files_seq_counts{$file}[4];
	$miss = sprintf "%6u", $files_seq_counts{$file}[5];
	$gapn = sprintf "%5u", $files_seq_counts{$file}[6];
	print COUNTS "$file $seq1 $seq2 $flg1 $flg2 $crec $miss $gapn\n";

#	print COUNTS "$file ", $files_seq_counts{$file}[0], " ", $files_seq_counts{$file}[1], " ", $files_seq_counts{$file}[2], " ", $files_seq_counts{$file}[3], " ", $files_seq_counts{$file}[4], " ", $files_seq_counts{$file}[5], " ", $files_seq_counts{$file}[6], "\n";
#	write;
    }
    close COUNTS;
}

sub message {
    my $message = shift;

    print STDOUT "$message\n";
}

format SEQ = 
@<<<<<<<<<<<<<<<<<<<<<<<<<< @##### @#####   @#    @# @###### @###### @#####
$file, $files_seq_counts{$file}[0], $files_seq_counts{$file}[1], $files_seq_counts{$file}[2], $files_seq_counts{$file}[3], $files_seq_counts{$file}[4], $files_seq_counts{$file}[5], $files_seq_counts{$file}[6]
.



