#!/usr/bin/perl -W

use Time::Local;
use Date::Calc;
use Env qw(EGSE_SW_LIB);
use lib "$EGSE_SW_LIB/perllib/CcsdsLib";
use CcsdsInterface;
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

my %filenames;
my %headless;
my %incomplete;
my %files_seq_counts;

#
# One command line arg: directory name containing ccsds packet files
#
$file_type = "eis_md*";
if($#ARGV == 0) {
    $dirname = $ARGV[0];
}
elsif($#ARGV == 1) {
#    $file_type = "eis_sts*";
    $file_type = $ARGV[0];
    $dirname = $ARGV[1];
}
else {
    message("Usage: pipeline_ccsds_check [sts] dirname");
    exit -1;
}

print STDOUT "Key: Summary line (S first_seq_count, seq_count, first_flag, last_flag, number_of_packets, missing_count, number_of_gaps)\n\n";

print STDOUT "Dirname: $dirname\n";
$archive = CcsdsInterface->new();
#@files = `ls $dirname/$file_type*`;
@files = `ls $dirname | grep eis_md`;
foreach $file (@files) {
    chomp $file;
    print STDOUT "\n$dirname/$file\n";
    print STDOUT "Time, Version, Type, Sec, APID, Flg, Count, Len\n";
    if($archive->openForReading("$dirname/$file")) {
	$missing_count = 0;
	$gaps = 0;
	$first = 1;

	$archive->setPrimaryHeaderLength(6);
	$archive->setSecondaryHeaderLength(4);
	$archive->setEndian("big");

	my $npackets = 0;
	if($archive->nextPacket()) {
	    $seq_count = $archive->getSequenceCount();
	    $archive->printHeadersSummary() if $first;
	    $first_seq_count = $seq_count if $first;
	    $first = 0;
	    $first_flag = $archive->firstPacketOfSequence();
	    while($archive->nextPacket()) {
		$next_seq_count = $archive->getSequenceCount();
		if($next_seq_count != (($seq_count + 1) & 0x3FFF)) {
		    if(!(($next_seq_count == 0) and ($seq_count == 0x3FFF))) {
			print STDOUT "+ $npackets\n" unless $npackets == 0;
			$npackets = 1;
			++$gaps;
			# Get count of number of missing packets
			$missing = $next_seq_count - $seq_count - 1;
			# Adjust for wrap around
			$missing = 16384 + $missing if $missing < 0;
			# Add to total
			$missing_count += $missing;
			print STDOUT "- $missing\n";
		    }
		}
		else {
		    ++$npackets;
		}
		$seq_count = $next_seq_count;
		#$archive->printHeadersSummary();
	    }
	    # Check whether last packet's flag is 2
#	    $filenames{$file} = 'Missing packets' unless $archive->isLastPacketOfSequence();
	    $last_flag = $archive->lastPacketOfSequence();
	    $incomplete{$file} = 'Incomplete packets' unless $archive->isLastPacketOfSequence();
	    ++$gaps unless $archive->isLastPacketOfSequence();
	    --$npackets unless $npackets == 0;
	    print STDOUT "+ $npackets\n" unless $npackets == 0;
	    $archive->printHeadersSummary();
	    #$archive->report();
#
# Record filename & first, last sequence count
#
	    $files_seq_counts{$file} = [$first_seq_count, $seq_count, $first_flag, $last_flag, $archive->numberOfPackets(), $missing_count, $gaps];
	    print STDOUT "S $first_seq_count, $seq_count, $first_flag, $last_flag,", $archive->numberOfPackets(), ", $missing_count, $gaps\n";
	}
	else {
	    print STDOUT "Failed to get first packet\n";
	    print STDERR "Failed to get first packet\n";
	}
#	$archive->printHeaders();
    }
    else {
	print STDOUT "Failed to open file $file : $!\n";
	print STDERR "Failed to open file $file : $!\n";
    }
}


if(open(COUNTS, "> $dirname/sequence_counts_pre_check.txt")) {
    print COUNTS "Filename                    Seq1  Seq2 Flg1 Flg2    Rec   Miss  Gaps\n";
#    $~ = "SEQ";
    foreach $file (sort keys %files_seq_counts) {
	$seq1 = sprintf "%5u", $files_seq_counts{$file}[0];
	$seq2 = sprintf "%5u", $files_seq_counts{$file}[1];
	$flg1 = sprintf "%4u", $files_seq_counts{$file}[2];
	$flg2 = sprintf "%4u", $files_seq_counts{$file}[3];
	$crec = sprintf "%6u", $files_seq_counts{$file}[4];
	$miss = sprintf "%6u", $files_seq_counts{$file}[5];
	$gapn = sprintf "%5u", $files_seq_counts{$file}[6];
	print COUNTS "$file $seq1 $seq2 $flg1 $flg2 $crec $miss $gapn\n";

#	print COUNTS "$file ", $files_seq_counts{$file}[0], " ", $files_seq_counts{$file}[1], " ", $files_seq_counts{$file}[2], " ", $files_seq_counts{$file}[3], " ", $files_seq_counts{$file}[4], " ", $files_seq_counts{$file}[5], " ", $files_seq_counts{$file}[6], "\n";
#	write;
    }
    close COUNTS;
}

sub message {
    my $message = shift;

    print STDOUT "$message\n";
}

format SEQ = 
@<<<<<<<<<<<<<<<<<<<<<<<<<< @##### @#####   @#    @# @###### @###### @#####
$file, $files_seq_counts{$file}[0], $files_seq_counts{$file}[1], $files_seq_counts{$file}[2], $files_seq_counts{$file}[3], $files_seq_counts{$file}[4], $files_seq_counts{$file}[5], $files_seq_counts{$file}[6]
.



