#!/usr/local/bin/perl -w
# !/usr/bin/env perl -w

#system "source $ENV{'HINODE_LIB'}/pointing.sh";
#my $plan_output = $ENV{'PLAN_OUTPUT'};
#my $fits_dump_output = $ENV{'FITS_DUMP_OUTPUT'};
#print "plan_output = [$plan_output], fits_dump_output = [$fits_dump_output]\n";
#die;
# Want to do the above but cant...!??!
my $plan_output = $ENV{'HOME'} . "/tmp/output/plan";
my $fits_dump_output = $ENV{'HOME'} . "/tmp/output/fits_dump";

#print "Combining $ARGV[0] $ARGV[1]\n";

my $year  = sprintf "%u", $ARGV[0];
my $month = sprintf "%02u", $ARGV[1];
my $day   = sprintf "%02u", $ARGV[2];

print STDERR "combine1.pl $year $month $day\n";

my $match = 1;

#my $plan_filename = "../Plan/$year/summary/$month/summary_$year$month$day.txt";
##my $plan_filename = "$plan_output/$year/$month/eis_plan_" . "$year$month$day" . "_pointings.txt";
my $plan_filename = "$plan_output/eis_plan_" . "$year$month$day" . "_pointings.txt";
my $plan_file;
open($plan_file, $plan_filename) or die "Could not open $plan_filename because $!";

#my $pt_filename = "../packet_summary/$year/summary/$month/pointing_$year$month$day.txt";
##my $pt_filename = "$fits_dump_output/$year/$month/fits_dump_" . "$year$month$day" . "_pointings.txt";
my $pt_filename = "$fits_dump_output/fits_dump_" . "$year$month$day" . "_pointings.txt";
my $pt_file;
open($pt_file, $pt_filename) or die "Could not open $pt_filename because $!";

#print "plan_filename: $plan_filename\n";
#print "pt_filename:   $pt_filename\n";
#die;

my $pt_line;
my @pt_fields;

# Program generating plan summary needs to put more space between tl_id and study id...
print " Tlid Stid            Study Acronym   Rid           Raster Acronym       xpos       ypos        xcen        ycen        dx        dy                fits file\n";

while(<$plan_file>) {
    chomp;
    
    my $plan_line = $_;
    my @plan_fields = split ' ', $plan_line;

    if ($match == 1) {
	$pt_line = <$pt_file>;
	@pt_fields = split ' ', $pt_line;

	chomp $pt_line;
    }
    
#    goto foo;
    
    my $pt_tl_id = sprintf "%u", $pt_fields[1];
    my $plan_tl_id = sprintf "%u", $plan_fields[0];

    my $xcen = sprintf "%9.2f", $pt_fields[6];
    my $ycen = sprintf "%9.2f", $pt_fields[7];
    my $xpos = sprintf "%.2f", $plan_fields[5];
    my $ypos = sprintf "%.2f", $plan_fields[6];
    my $dx = sprintf "%9.2f", $xpos - $xcen;
    my $dy = sprintf "%9.2f", $ypos - $ycen;
    my $fitsfile = $pt_fields[0];

    if ($pt_tl_id == $plan_tl_id) {
#my $xcen = sprintf "%9.2f", $pt_fields[6];
#my $ycen = sprintf "%9.2f", $pt_fields[7];
#my $xpos = sprintf "%.2f", $plan_fields[5];
#my $ypos = sprintf "%.2f", $plan_fields[6];
#my $dx = sprintf "%9.2f", $xpos - $xcen;
#my $dy = sprintf "%9.2f", $ypos - $ycen;
#my $fitsfile = $pt_fields[0];
	$match = 1;
	print "$plan_line   $xcen   $ycen $dx $dy   $fitsfile\n";
    }
    elsif ($plan_tl_id > $pt_tl_id) {
	$match = 1;
	my $st_id = sprintf "%3u", $pt_fields[2];
	my $st_acr = sprintf "%24s", $pt_fields[3];
	my $ra_id = sprintf "%3u", $pt_fields[4];
	my $ra_acr = sprintf "%24s", $pt_fields[5];
	print "$pt_tl_id  $st_id $st_acr   $ra_id $ra_acr        N/A        N/A   $xcen   $ycen       N/A       N/A   $fitsfile\n";
    }
    else {
	$match = 0;
	print "$plan_line         N/A         N/A       N/A       N/A                  No file\n";
    }

    foo:
#    print "$plan_line\n";
#    print "pt_line: $pt_line\n";
#    print "plan_line: $plan_line\n";
#    print "pt_fields: ", @pt_fields, "\nplan_fields: ", @plan_fields, "\n";
}

close $pt_file;
close $plan_file;
