#!/usr/bin/perl

use Env qw(EGSE_SW_LIB);
 
do "$EGSE_SW_LIB/hex.pl" || warn "Can't do hex.pl: $!\n";

$address = sprintf("%u", 0x00000);

$len = "1E";
$zerozero = "00";
($offset, $line) = &ulba_line($address);
print $line;
$count = 0;
$data = "";
while($byte = <>) {
    next if($byte =~ m/ADDRESS/);
    next if($byte =~ m/RAM-ID/);
    next if($byte =~ m/MEMORY/);
    chop($byte);
    ++$count;
    $data .= $byte;
    if($count == 30) {
	$count = 0;
	$hex_offset = sprintf("%04X", $offset);
	$xsum = sprintf("%02X", &checksum($len . $hex_offset . $data));
#	print "XSUM : $xsum\n";
##	print ": $len $hex_offset $zerozero $data $xsum\n", 
	print ":$len$hex_offset$zerozero$data$xsum\n";
	$offset += 30;
	$data = "";
    }
}
$line = "00000001";
$checksum = sprintf "%02X", &checksum($line);
print STDOUT ":" . $line . $checksum . "\n";
