#!/usr/bin/perl

use Time::Local;
use Date::Calc;
use Env qw(EGSE_SW_LIB);
use lib "$EGSE_SW_LIB/perllib/CcsdsLib";
use MdInterface;
use File::Basename;

do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

my %filenames;
my %eng_rasters = (
		   'C014' => 'ADC Offset',		# regcal014
		   'C015' => 'Short Darks',		# regcal015
		   'C016' => 'Long Darks',		# regcal016
		   'C017' => 'Short Flats',		# regcal017
		   'C018' => 'Long Flats',		# regcal018
		   'C019' => 'Intensity Calibration',	# regcal019
		   'D020' => 'Pointing and Alignment',	# regcal020
		   'D022' => 'Pointing and Alignment',	# regcal022
		   'D067' => 'EUV',			# regcal067
		   'D068' => 'EUV',			# regcal068
		   'C070' => '???',			# regcal070
		   'C071' => 'Dark Bottom',		# regcal071
		   'C072' => 'Dark Top',		# regcal072
		   'C073' => 'Reduced Long',		# regcal073
		   'C074' => 'Dark Overscan',		# regcal074
		   'C075' => 'Flat Oscn',		# regcal075
		   );

$num_args = $#ARGV;
if($num_args == 0) {
    $dirname = $ARGV[0];
}
else {
    if($num_args > 0) {
	while(@ARGV) {
	    $arg = shift;
	    if($arg =~ /^\-/) {
		next;
	    }
	    $dirname = $arg;
	    last;
#	    if($verbose ne "-v") {
#		print STDERR "verbose flag is $verbose\n";
#	    exit;
#	    }
	}
    }
    else {
	print STDERR "Not enough arguments\n"; write_log($filename, "Not enough args"); exit;
    }
}
#print STDERR "DIRNAME  = $dirname\n";

$archive = MdInterface->new();

#open(SHUT, ">> $shutter_log/shutter.txt") || print STDERR "Can't open shutter log.txt : $!\n";

@files = `ls $dirname | grep eis_md`;

my $file;

foreach $filen (@files) {
    chomp $filen;
    $last_file = $filen;
#    print STDOUT "\n$filen\n";
    $file = "$dirname/$filen";
###    print STDOUT "\n$file\n";
###    print STDERR "\n$file\n";
#    @filepath = split($file, /\//);
    my $short_name = substr $file, -26, 26;

    my $done = 0;
    $md_headers = 0;
    if($archive->openForReading($file)) {
    print STDOUT "\n$file\n";
#    print STDERR "\n$file\n";
	$archive->header_report_header();
	while(1) {
	    if($archive->get_bigendian_header_packet()) {
		$archive->printHeaders() if $verbose;
		$archive->printPrimaryHeader() if $verbose;
		++$md_headers;
		$archive->header_report1();
		$raster_id = $archive->raster_id();
		($eng, $type) = eng($raster_id);
		$filenames{$file} = $type if $eng;
		while($archive->nextPacket()) {
		    last if($archive->isLastPacketOfSequence());
		}
	    }
	    else {
		last if($archive->{_packetValid} == 0);
		print STDOUT "Pixel data\n" if !$done;
##		print STDERR "$file : Pixel data\n" if !$done;
#		$filenames{$file} = 'Missing packets';
		$done = 1;
	    }
	}
	print "$md_headers headers\n";
	$archive->report();
#	print SHUT "$file : ", sprintf("%5u", ($md_headers * 2)), "\n";
	print SHUT "$short_name : ", sprintf("%5u", ($md_headers * 2)), "\n";
    }
    else {
	print STDERR "Failed to open file\n";
    }
}
#print SHUT "\n";
#close SHUT;

#if(%filenames) {
#    print STDERR "Data summary filenames hash has something\n";
#    open(SUMMARY, "> $dirname/engineering.txt") || print STDERR "Can't open engineering.txt : $!\n";
#    print SUMMARY "Engineering\n";
#    foreach $key (keys %filenames) {
#	if($filenames{$key} =~ m/^Eng/) {
#	    $val = $filenames{$key};
#	    $val =~ s/Eng //;
#	    print SUMMARY "$key:$val\n";
#	}
#    }
#    print SUMMARY "\n";
#    close SUMMARY;
#}
#else {
#    print STDERR "Data summary filenames hash has NOTHING\n";
#}

#
# $last_file has the name of the last file processed.
# Extract the date and hhmm portion of the filename
# and save to a file, ready for the next time the
# pipeline runs it can start with the last file of
# the previous run in case that file was truncated.
# Filename: eis_md_yyyymmdd_hhmmsstthh

$date  = substr($last_file, 7, 8);
$stime = substr($last_file, 16, 4);

exit(0);

sub eng {
    my $ras_id = shift;
    return (1, 'Eng ' . $eng_rasters{$ras_id}) if $eng_rasters{$ras_id};
    return (0, "");
}

