#!/usr/bin/perl

# ARGV[0] is the input filename
# Get only the filename from the path
$fname = substr $ARGV[0], -21, 21;
#print $ARGV[0], " ($fname)\n";

while(<>) {
    next if(/^$/);			# Ignore blank lines
    chomp;				# Remove newline
    chop;				# Remove semi-colon at end of line
    $_ =~ s/[ \t]+/ /g;			# Make everything separated by one space
    chop;				# Remove terminal space
    $_ =~ s/\//-/g;			# Substitute / for -
    $_ =~ s/\./T/;			# Substitute . for T
    $_ =~ s/ : /,/;			# Substitute only the first : for a ,
    ($event, $date) = split(',');	# Split on that ,
    $date .= ".000";			# Add the milliseconds
#    print "$event\t$date\n";

    # Now everything is in the correct format collect up all the events into lists

    push @hla_entry, $date if /HLA_ENTRY/;
    push @hla_exit,  $date if /HLA_EXIT/;
    push @saa_entry, $date if /SAA_ENTRY/;
    push @saa_exit,  $date if /SAA_EXIT/;
    push @ngt_entry, $date if /NGT_ENTRY/;
    push @ngt_exit,  $date if /NGT_EXIT/;

}

output($ARGV[0], "HLA entries", ".hla_entry", @hla_entry);
output($ARGV[0], "HLA exits",   ".hla_exit",  @hla_exit);
output($ARGV[0], "SAA entries", ".saa_entry", @saa_entry);
output($ARGV[0], "SAA exits",   ".saa_exit",  @saa_exit);
output($ARGV[0], "NGT entries", ".ngt_entry", @ngt_entry);
output($ARGV[0], "NGT exits",   ".ngt_exit",  @ngt_exit);

print "HLA entries : ", $#hla_entry + 1, "\n";
print "HLA exits   : ", $#hla_exit + 1,  "\n";
print "SAA entries : ", $#saa_entry + 1, "\n";
print "SAA exits   : ", $#saa_exit + 1,  "\n";
print "NGT entries : ", $#ngt_entry + 1, "\n";
print "NGT exits   : ", $#ngt_exit + 1,  "\n";

#foreach $d (@saa_entry) {
#    print "$d\n";
#}

sub output {
    my $base = shift;
    my $desc = shift;
    my $ext  = shift;
    my @data = @_;

    return unless @data;
#    open(FILE, "> $base$ext") or die "Can't open output for $desc: $!";
    open(FILE, "> $fname$ext") or die "Can't open output for $desc: $!";
    print FILE "# Data for $desc\n";
    print FILE $#data + 1, "\n";
    foreach $d (@data) {
	print FILE "$d\n";
    }
    close FILE;
}
