#!/usr/bin/perl

# make_new_style.pl < full_record.txt > new_full_record.txt

%dbase;

%comp_setting = (
		 '2B28'=> '   DPCM',
		 '3B28'=> '   DPCM',
		 '3F28'=> 'JPEG_98',
		 '3F29'=> 'JPEG_90',
		 '3F2A'=> 'JPEG_75',
		 '3F2B'=> 'JPEG_50',
		 '3F2C'=> 'JPEG_95',
		 '3F2D'=> 'JPEG_92',
		 '3F2E'=> 'JPEG_85',
		 '3F2F'=> 'JPEG_65',
		 );

$csv = "";
$num_args = $#ARGV;

#print "Num args = $num_args\n";
if($num_args == 1) {
    $csv = shift;
    $csv =~ s/-//;
}
#print "$csv\n";

while(<>) {
    last if eof();
    next if /^$/;
    chomp;
    if(/eis_md/) {
	$filename = $_;
	$table = <>;
	chomp $table;

	if($table =~ /eis_md/) {
#    $filename1 = $_;
#    $fname = get_filename($filename);
	    next;
	}

#print "The table is: $table\n";
	$table =~ s/^([Cc]omp|omp)//;
	$table =~ s/table//;
	$table =~ s/[ \t]+/ /g;
#print "The table is now: $table\n";
	@numbers = split(" ",$table);
#print "The numbers are: @numbers\n";
	$comp_table_str = "[";
	while(@numbers) {
	    $number = sprintf("%02X", shift @numbers);
	    $comp_table_str .= "$number";
#    print "Number: $number\n";
	}
	$comp_table_str .= "]";
#print "Comp table: $comp_table_str\n";
#die;

	$fname = get_filename($filename);
#print "$fname\n";
	$type = <>;
	chomp $type;
	$type =~ s/type//;
	$type =~ s/DPCM//;
	$type =~ s/JPEG//;
	$type =~ s/[ ]*//g;
	$int_in = <>;
	chomp $int_in;
	$int_in =~ s/Integers in ://;
	$int_in =~ s/[ ]*//g;
	$int_out = <>;
	chomp $int_out;
	$int_out =~ s/Integers out://;
	$int_out =~ s/[ ]*//g;
	$comp = <>;
	chomp $comp;
	$comp =~ s/Compression://;
	$comp =~ s/[ ]*//g;
###$dbase{$fname} = [$table, $type, $int_in, $int_out, $comp];

	$comp_type = $comp_setting{$type};
	$int_in1  = sprintf "%8u", $int_in;
	$int_out1 = sprintf "%8u", $int_out;
	$comp1    = sprintf "%02.2f", $comp;

	$factor = sprintf "%02.2f", ($int_out1 / $int_in1);

#$dbase{$fname} = [$type, $int_in, $int_out, $comp];
##$dbase{$fname} = [$comp_type, $int_in1, $int_out1, $comp1, $factor];
	$dbase{$fname} = [$int_in1, $int_out1, $comp1, $factor, $type, $comp_type, $comp_table_str];
    }
}

$sep = ",";
$sep = "\t" unless $csv;
foreach $key (sort keys %dbase) {
    $line = "";
    @vals = @{$dbase{$key}};
#    print "$key\t";
#    print "$key$sep";
    $line .= "$key$sep";
    foreach $v (@vals) {
#print "$v\t";
#print "$v$sep";
	$line .= "$v$sep";
    }
    chop $line;
###    $line .= "$sep" . $comp_table;
    print STDOUT "$line\n";
#    print "\n";
}

sub get_filename {
    my $filepath = shift;
    my @bits = split('\/', $filepath);
    return $bits[-1];
}
