#!/usr/local/bin/perl

use Time::Local;
use Date::Calc;
use File::Basename;
use Env qw(EGSE_SW_LIB);

do "$EGSE_SW_LIB/date_calc.pl"     || die "Can't do date_calc.pl: $!\n";
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";
do "$EGSE_SW_LIB/pipeline.pl"      || die "Can't do pipeline.pl: $!\n";

open(MLOG, ">> $pipeline_log/pipeline_log_rescue.txt") || die "Can't open $pipeline_log/$pipeline_log_rescue.txt for writing: $!";
print MLOG scalar(localtime), " (JST) rescue_decomp.pl started ";

# The start time will either be passed in (interactive mode)
# or will be generated from cron using todays date minus 7 days

$state = "interactive";
if($#ARGV != -1) {
    $state = "interactive";
    if($#ARGV == 1) { $flag = shift; }
    if(@ARGV) { $sdate  = shift; }
}

$pipeline_mission_rescue_log = "$pipeline_log/pipeline_mission_rescue_log_rescue_$sdate";
open(LOG, ">> $pipeline_mission_rescue_log") || die "Can't open $pipeline_mission_rescue_log for writing: $!";
print LOG "Started (manually) ", scalar(localtime), " (JST)\n";
print MLOG "manually for $sdate\n";

$date_string  = $sdate;


############################################### 8 - MISSION DATA DECOMPRESS

print STDOUT scalar(localtime), " (JST) - Starting mission data decompress\n" if $state eq "interactive";
print LOG "\n", scalar(localtime), " (JST) - Starting mission data decompress\n";

@files = `ls $merge_dir/eis_md*`;
###@files = `ls $merge_dir/merge1/eis_md*`;
$pre_check_count = @files;
print LOG "\tFiles for rescue:\n@files\n";
$zero_sized_count = 0;
foreach $f (@files) {
    chomp $f;
    @stat = stat $f;
    if($stat[7] == 0) {
	++$zero_sized_count;
	$f1 = basename($f);
	print STDOUT "\t$f is zero-sized, moving to incomplete\n";
	print LOG "\t$f is zero-sized, moving to incomplete\n";
	system("/bin/mv $merge_dir/rescue/$f1 $merge_dir/incomplete/");
# mcrw 20130918
#???
#	system("/bin/rm $merge_dir/$f1");

###	system("/bin/rm $merge_dir/merge1/$f1");
    }
}
$post_check_count = $pre_check_count - $zero_sized_count;

print LOG "\t$pre_check_count files sent for rescue, $zero_sized_count empty, $post_check_count files rescued\n\n";

@rescued_files = `ls $merge_dir/eis_md*`;
###@rescued_files = `ls $merge_dir/merge1/eis_md*`;
print LOG "\tRescued Files: @rescued_files\n";

print LOG "\t(IDL) eis_md_decomp_chk_tbl_fix1script,'$merge_dir', /merge\n";
###print LOG "\t(IDL) eis_md_decomp_script,'$merge_dir/merge1', /merge\n";

# mcrw 20130916
###$temp_idl = "/nasA_solar1/home/sbukeis/work/localdata/pipeline/idl";

# mcrw 20130918
$local_idl = "/nasA_solar1/home/sbukeis/work/idl";

$output = <<EOF;
!quiet=1
.comp $local_idl/eis_ccsds_interface__define
;.comp $local_idl/eis_md_decomp
;.comp $local_idl/eis_md_decomp_script
;eis_md_decomp_script,'$merge_dir', /merge
.comp $local_idl/mdppmdctrecover
.comp $local_idl/eis_md_decomp_chk_tbl_fix1
.comp $local_idl/eis_md_decomp_chk_tbl_fix1_script
eis_md_decomp_chk_tbl_fix1_script,'$merge_dir', /merge
;;;eis_md_decomp_fix1_script,'$merge_dir/merge1', /merge
;'
EOF

# mcrw 20130916
open(MD_DECOMP, "> $temp_idl/md_decomp.pro");
#open(MD_DECOMP, "> /nasA_solar1/home/sbukeis/work/localdata/pipeline/idl/md_decomp.pro");
print MD_DECOMP $output;
close MD_DECOMP;

# Start the mission data decompress

$output_log = "$pipeline_log/md_decompress_rescue_" . $date_string . ".txt";
#system("/nasA_solar1/home/sbukeis/ssw_idl < $temp_idl/md_decomp.pro >& $output_log");
#system("$HOME/sbukeis/ssw_idl < $temp_idl/md_decomp.pro >& $output_log");
system("$HOME/ssw_idl < $temp_idl/md_decomp.pro >& $output_log");

log_msg(*LOG, $state, "/bin/cp $HOME/work/localdata/log/decompression/merge_decomp_record.txt $darts_staging/logs/decompression/");
# mcrw 20130918 - does it actually copy this file?

#system("/bin/mv $pipeline_log/md_decompress_rescue_$date_string.txt $darts_staging/logs/decompression/");
#######system("/bin/mv $output_log $darts_staging/logs/decompression/");
$decompress_log = "$darts_staging" . "/logs/decompression/rescue/md_decompress_rescue_" . "$date_string" . ".txt";
$alt_decompress_log = "$darts_staging" . "/logs/decompression/rescue/md_decompress_rescue_" . "$date_string" . "_alt.txt";
#perform(*LOG, $state, "$HOME/bin/slim.pl < $output_log > $darts_staging/logs/decompression/rescue/md_decompress_rescue_$date_string.txt");
#perform(*LOG, $state, "cat $output_log | $HOME/bin/slim.pl | $HOME/bin/slim_rescue.awk > $darts_staging/logs/decompression/rescue/md_decompress_rescue_$date_string_alt.txt");
perform(*LOG, $state, "$HOME/bin/slim.pl < $output_log > $decompress_log");
perform(*LOG, $state, "cat $decompress_log | awk -f '$HOME/bin/slim_rescue.awk' > $alt_decompress_log");

# mcrw 20190130
# Remove rescue decompress log too
perform(*LOG, $state, "/bin/rm $decompress_log");

#log_msg(*LOG, $state, "/bin/mv $pipeline_log/md_decompress_rescue_$date_string.txt $darts_staging/logs/decompression/");
#log_msg(*LOG, $state, "/bin/mv $output_log $darts_staging/logs/decompression/");
system("/bin/rm  $output_log");
####system("/bin/cp $HOME/work/localdata/log/decompression/merge_decomp_record.txt $darts_staging/logs/decompression/");

#system("/bin/cp $HOME/work/localdata/sdtp/decompressed/merge_decomp_record.txt $darts_staging/decompression/");
#system("/bin/cp $pipeline_log/md_decompress_manual_$date_string.txt $darts_staging/decompression/");
#system("remove_decomp_junk");
@post_decompression = `ls $merge_dir/decompressed/ | grep eis_md`;
###@post_decompression = `ls $merge_dir/merge1/decompressed1/ | grep eis_md`;
$number_post_decompression = @post_decompression;
log_msg(*LOG, $state, "Number of de-compressed files: $number_post_decompression");

log_msg(*LOG, $state, "rescue_decomp finished");
print MLOG scalar(localtime), " (JST) rescue_decomp.pl finished\n";
###pipeline_exit("rescue");
