#!/usr/bin/env perl

#
# This program is scheduled to run on pg4
#

# crontab entry
# 30 9 * * fri $HOME/bin/pass_list_cron.pl
#
# So every friday at 09:30 get the pass list from the eisco machine
#
# crontab entry on eisco
# 0 9 * * fri $HOME/bin/pass_list_cron.csh

#
# Copy today's orl file on eisco to the orl_list directory
#

use Time::Local;
use Date::Calc;
use Env qw(EGSE_SW_LIB);

do "$EGSE_SW_LIB/date_calc.pl"     || die "Can't do date_calc.pl: $!\n";
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

my %pending;

my $year;
my $month;
my $day;

my $current_time = scalar(localtime);
open(LOG, ">> $sat_rot_log");

if ($#ARGV != -1) {
    my $yyyymmdd = shift;
    $year = substr($yyyymmdd, 0, 4);
    $month = substr($yyyymmdd, 4, 2);
    $day = substr($yyyymmdd, 6, 2);
    fetch_file($year, $month, $day);
    check_file($year, $month, $day);
    print LOG "----\n";	
} else {
    read_pending_file();
    my @today = today();	# @today[0..6] = seconds,minutes,hours,day,month,year,day_of_week (0 = sunday)

# Try going back 7 days
#my $days_ago = -7;
    my $days_ago = -2;
    my @search_date = other_date(@today, $days_ago);

#
# Split today's date up
#
    $year  = sprintf "%04u", $search_date[5];	# Get starting year
    $month = sprintf "%02u", $search_date[4];	# Get starting month
    $day   = sprintf "%02u", $search_date[3];	# Get starting day

    if (defined($pending{"$year$month$day"})) {
	# print LOG "----\n";
    }
    else {
	my $exists = 0;
	$exists = 1 if -e "$sat_rot_csv_dir/$year$month$day.csv";

	unless ($exists) {
	    fetch_file($year, $month, $day);
	    check_file($year, $month, $day);
	    print LOG "----\n";	
	}
    }
}

#print LOG "----\n";
close(LOG);

system("/bin/cp $sat_rot_log $sat_rot_dir");

sub read_pending_file {
    my $count = 0;
    my @lines;
    if (open(FOO, "< $HOME/track/sat_rot_pending.txt")) {
	while(<FOO>) {
	    chomp;
	    push @lines, $_;
	    ++$count;
	}
	close FOO;
	if ($count > 0) {
	    while(@lines) {
		my $line = shift @lines;
		$pending{"$line"} = 1;
	    }
	}
    }
}

sub fetch_file {
    my $y = shift;
    my $m = shift;
    my $d = shift;

    print LOG "$current_time\n";
    print LOG "Fetching csv file for $y$m$d\n";
    system("curl https://solar.physics.montana.edu/HINODE/XRT/roll_angle/CSV/$y$m$d.csv -o $sat_rot_csv_dir/$y$m$d.csv");
}

sub check_file {
    my $year = shift;
    my $month = shift;
    my $day = shift;

    #
    # Now check the file
    #
    if ( -e "$sat_rot_csv_dir/$year$month$day.csv") {
	# Check file contents
	if (open(FD, "<$sat_rot_csv_dir/$year$month$day.csv")) {
	    while(<FD>) {
		chomp;
		if (m/Found/) {
		    $ok = 0;
		    print LOG "csv file for $year$month$day does not contain the proper csv information\n";
		    print LOG "removing $sat_rot_csv_dir/$year$month$day.csv\n";
		    system("/bin/rm $sat_rot_csv_dir/$year$month$day.csv");
		    if (!defined($pending{"$year$month$day"})) {
#			$pending{"$year$month$day"} = 1;
			system("echo $year$month$day >> $HOME/track/sat_rot_pending.txt");
			}
		    last;
		}
	    }
	    close FD;
	}
	else {
	    $ok = 0;
	}
    }
    else {
	$ok = 0;
    }
}
