#!/usr/bin/perl

use Env qw(EGSE_SW_LIB);
do "$EGSE_SW_LIB/date_calc.pl" || die "Can't find date_calc.pl: $!\n";

$hmesg = "sdtp [real|late|merge|dr] ant [band=1|2|3] sdate=yyyymmdd [edate=yyyymmdd] stime=hhmm etime=hhmm [verbose] [-n] [help]\n";

$home_dir = "/nasA_solar1/home/sbukeis";

# Command line assigns
my %assigns = (sdate,1,edate,1,stime,1,etime,1,band,1);

# Command line single options
my %mode = (real,1,late,2,dr,3,daily,99,cron,999,merge,9999,status_merge,1000,mission_merge,1001);

# Antenna data for real time and dr stuff only
#               Ant name    Ant-id  ?    ?   Real   ?     Dr
#my %cpn_data = (usc20	=> ["16",  "0", "0", "0", "252", "4"],
####		usc34	=> ["17",  "0", "0", "2", "252", "4"],
#		usc34	=> ["17",  "0", "0", "0", "252", "4"],
#		ksc34	=> ["17",  "0", "0", "0", "252", "4"],
#		sval    => ["97",  "0", "0", "0", "252", "4"],
#		snt1	=> ["148", "0", "0", "0", "252", "4"],
#		prt1	=> ["149", "0", "0", "0", "252", "4"],
#		msp1	=> ["150", "0", "0", "0", "252", "4"],
#		krn1	=> ["151", "0", "0", "0", "252", "4"],
#		gna	=> ["154", "0", "0", "0", "252", "4"],
#		gnb	=> ["155", "0", "0", "0", "252", "4"],
#		merge   => ["240", "0", "0", "0", "252", "4"],
#		allant  => ["241", "0", "0", "0", "252", "4"],
#		);

# Antenna data for real time and dr stuff only
#               Ant name    Ant-id pcid pcid Real   ?     Dr
my %cpn_data = (usc20	=> ["16",  "0", "0", "0", "252", "0"],
###		usc34	=> ["17",  "0", "0", "2", "252", "4"],
		usc34	=> ["17",  "0", "0", "0", "252", "4"],
		ksc34	=> ["17",  "0", "0", "0", "252", "0"],
		gsfc    => ["81",  "0", "0", "0", "252", "0"],
		sval    => ["97",  "0", "0", "0", "252", "4"],
		snt1	=> ["148", "0", "0", "0", "252", "0"],
		prt1	=> ["149", "0", "0", "0", "252", "0"],
		msp1	=> ["150", "0", "0", "0", "252", "0"],
		krn1	=> ["151", "0", "0", "0", "252", "0"],
		ngna	=> ["154", "0", "0", "0", "252", "0"],
		ngnb	=> ["155", "0", "0", "0", "252", "0"],
		merge   => ["240", "0", "0", "0", "252", "0"],
		allant  => ["241", "0", "0", "0", "252", "0"],
		);

$verbose = 0;

# Default antenna and mode
$ant          = 'usc34';
$ant_default  = 1;
$mode         = 2;
$mode_default = 1;

# Check there are some command line assigns
$argc = $#ARGV;
if($argc == -1) {
    print "No args - exit\n";
    print "Usage : $hmesg";
    exit 1;
}

# Count starts at zero so bump it up by one for the loop
++$argc;
while($argc--) {

    # Lower case please
    $arg = lc shift;

    # Split param=value command line assigns.
    ($param, $value) = split /=/, $arg;

    if($param eq "help") {
	print STDOUT $hmesg;
	exit 0;
    }

    if($param eq "verbose") {
	$verbose = 1 ;
	next;
    }

    if($param eq "-n") {
	$no = 1;
	next;
    }

    # See if it's a valid option
    if($assigns{$param}) {
	$arg1 = "\$$param = \"$value\";";
	eval $arg1;
	next;
    }
    # Single parameter
    elsif($mode{$param}) {
	$mode = $mode{$param};
	$mode_default = 0;
	next;
    }
    # Antenna selection
    elsif($cpn_data{$param}) {
	$ant = $param;
	$ant_default=0;
	next;
    }
    else {
	print "Ignoring $arg\n";
    }
}

if ($verbose) {
    print "sdate = $sdate\n";
    print "edate = $edate\n";
    print "band  = $band\n";
    print "ant   = $ant\n";
    print "mode  = $mode\n";
}

if(!defined($sdate)) {
    print STDERR "sdate not defined, exiting\n";
    exit 1;
}

# Check sdate

if(defined($stime)) {
    $stime .= "00";
}
else {
    print STDERR "stime not defined, exit\n";
    exit 2;
}

# Check stime

if(defined($etime)) {
    $etime .= "00";
}
else {
    print STDERR "etime not defined, exit\n";
    exit 3;
}

# Check etime

if(!defined($band)) {
    print STDERR "band not defined, using 3\n";
    $band = 3;
}

if(!defined($edate)) {
    $edate=$sdate;
    print STDERR "edate not defined, using sdate\n";
}

# Check edate

if($ant_default) {
    print STDERR "No antenna specified, using usc34\n";
}

if($mode_default) {
    print STDERR "No mode specified, using late\n";
}

if($mode == 999) {	# Cron job daily playback
    $cmd = "$home_dir/bin/CRON_DAILY > /dev/null <<EOF
$band
$cpn_data{$ant}[0]
$sdate$stime
$edate$etime
1
EOF\n";
}
elsif($mode == 99) {	# Daily playback
    $ant = 'merge';
    $band = 3;
    $cmd = "$home_dir/bin/DAILY > /dev/null <<EOF
$band
$cpn_data{$ant}[0]
$sdate$stime
$edate$etime
1
EOF\n";
}
elsif($mode == 9999) {	# Merge playback
    $ant = 'merge';
    $band = 3;
    $cmd = "$home_dir/bin/MERGE > $home_dir/tmp/merge_record.txt <<EOF
$band
$cpn_data{$ant}[0]
$sdate$stime
$edate$etime
1
EOF\n";
}

elsif($mode == 1) {	# Realtime contact
    if($band == 3) {
	print STDERR "Can't use band 3 and realtime. Using band 2\n";
	$band = 2;
    }
    $cmd = "$home_dir/bin/REAL > /dev/null <<EOF
$band
$cpn_data{$ant}[0]
$sdate$stime
$edate$etime
1
$cpn_data{$ant}[1]
$cpn_data{$ant}[2]
$cpn_data{$ant}[3]
$cpn_data{$ant}[4]
EOF\n";
}

elsif($mode == 3) {	# DR contact
    if($band == 3) {
	print STDERR "Can't use band 3 and dr. Using band 2\n";
	$band = 2;
    }
    $cmd = "$home_dir/bin/DR > /dev/null <<EOF
$band
$cpn_data{$ant}[0]
$sdate$stime
$edate$etime
1
$cpn_data{$ant}[1]
$cpn_data{$ant}[2]
$cpn_data{$ant}[5]
$cpn_data{$ant}[4]
EOF\n";
}

elsif($mode == 1000) {	# Merge status playback
    $ant = 'merge';
    $band = 3;
    $cmd = "$home_dir/bin/STATUS_MERGE > $home_dir/tmp/status_merge_record.txt <<EOF
$band
$cpn_data{$ant}[0]
$sdate$stime
$edate$etime
1
EOF\n";
}

elsif($mode == 1001) {	# Merge mission playback
    $ant = 'merge';
    $band = 3;
    $cmd = "$home_dir/bin/MISSION_MERGE > $home_dir/tmp/merge_record.txt <<EOF
$band
$cpn_data{$ant}[0]
$sdate$stime
$edate$etime
1
EOF\n";
}

else {			# Late buffering from SIRIUS
    $cmd = "$home_dir/bin/LATE > /dev/null <<EOF
$band
$cpn_data{$ant}[0]
$sdate$stime
$edate$etime
1
EOF\n";
}

print "CMD : $cmd" if $verbose;

exit 0 if $no;

system($cmd);
