#!/usr/bin/perl

# shutter_count

use Time::Local;
use Date::Calc;
use Env qw(EGSE_SW_LIB);

do "$EGSE_SW_LIB/date_calc.pl"     || die "Can't do date_calc.pl: $!\n";
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

open(SHUT, ">> $shutter_log/shutter.txt") || print STDERR "Can't open shutter log.txt : $!\n";

#
# Go through all mission data directories searching the md_hdrs txt file for 'headers'
# keep a count of the number of headers * 2 for each file
# Actually need to get all the different SIDs.
#

my %sids;

@dirs = `ls -d $darts_mission/2*`;
if(@dirs) {
    foreach $ydir (@dirs) {
	chop $ydir;
	@mission_dir = `ls $ydir`;
	if(@mission_dir) {
	    foreach $mdir (@mission_dir) {
		chop $mdir;
		$ddir = "$ydir/$mdir";
		next unless -d "$ddir";
#		print "$ddir\n";
		@files = `ls $ddir/md_hdrs*`;
		next unless @files;
		foreach $file (@files) {
		    chop $file;
		    open(HDR, $file) || warn "Can't open $file: $!";
		    while(<HDR>) {
			next unless m/eis_md/;
			s/File://;
			($fname, @junk) = split;
			print SHUT "$fname : ";
###			print "$fname : ";
			while(<HDR>) {
			    last if m/^$/;
			    next if m/headers/;
			    next if m/Read/;
			    next if m /Type/;
			    @params = split;
			    $sid = "$params[8]";
			    $sids{$sid} = $sid;
			}
			$exps = scalar keys %sids;
			$shutter_moves = sprintf("%u", $exps);
			$shutter_moves *= 2;
			print SHUT sprintf("%5u", $shutter_moves), "\n";
###			print sprintf("%5u", $shutter_moves), "\n";
			#
			foreach $k (keys %sids) {
			    delete $sids{$k};
			}
#			%sids = {};
			@params = ();
		    }
		    close HDR;
		}
	    }
	}
    }
}

close SHUT;
exit 0;

@dirs = `ls -d $darts_mission/2*`;
if(@dirs) {
    foreach $ydir (@dirs) {
	chop $ydir;
	@mission_dir = `ls $ydir`;
	if(@mission_dir) {
	    foreach $mdir (@mission_dir) {
		chop $mdir;
		$ddir = "$ydir/$mdir";
		next unless -d "$ddir";
		print "$ddir\n";
		@files = `ls $ddir/md_hdrs*`;
		next unless @files;
		foreach $file (@files) {
		    chop $file;
		    open(HDR, $file) || warn "Can't open $file: $!";
		    while(<HDR>) {
			if(m/eis_md/) {
			    ($fname, @junk) = split;
			    print SHUT "$fname : ";
			}
			next unless m/headers/;
			($exps, @junk) = split;
			$shutter_moves = sprintf("%u", $exps);
			$shutter_moves *= 2;
			print SHUT sprintf("%5u", $shutter_moves), "\n";
		    }
		    close HDR;
		}
	    }
	}
    }
}

