#!/usr/bin/perl

#
# This program is scheduled to run on pg1
#

#
# allband = 0xF1
# antenna = 0xF0 merge
#           0xF1 allant
#
# Base start time on the first usc contact of the day in the contacts file for the day
# (20061029_contacts.txt appears not to have any usc passes - thats because it was a
# sunday...)
# 20061101_contacts.txt msp1 is first real, so maybe look for first real contact time
# and use that as the start time. Also sundays do not have any real time contacts...
#

use Time::Local;
use Date::Calc;
use Env qw(EGSE_SW_LIB);

do "$EGSE_SW_LIB/date_calc.pl"     || die "Can't do date_calc.pl: $!\n";
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

# The start time will either be passed in (interactive mode)
# or will be generated from cron using todays date minus 7 days

$state = "cron"; # Default to cron job

$ant='usc34';	# Not needed for merge as sdtp will substitute merge ant
$band=3;	# Merge telemetry
$mode='merge';	# Merge telemetry

# Set default values for start date, end date and start time to empty strings. If in
# interactive state these are not set then bail out.

$sdate = "";
$edate = "";
$stime = "";

# If there is anything on the command line then this is interactive mode

if($#ARGV != -1) {
    $state = "interactive";
    if(@ARGV) { $sdate  = shift; }
    if(@ARGV) { $edate  = shift; }
    if(@ARGV) { $stime 	= shift; }
    die "No start date" if $sdate eq "";
    die "No end date"   if $edate eq "";
    die "No start time" if $stime eq "";
    $etime = $stime;
#    open(LOG, ">> $pipeline_log/pipeline_log_$sdate") || die "Can't open $pipeline_log_$sdate for writing: $!";
#    print LOG "Started ", scalar(localtime), " (JST)\n";
}

if($state eq "merge") {
    print STDERR "Wrong state\n";
    exit;
}

# Split the start date into constituent parts
$year  = substr $sdate, 0, 4;
$month = substr $sdate, 4, 2;
$day   = substr $sdate, 6, 2;

############################################### CLEAR OLD DATA

print STDOUT scalar(localtime), " (JST) - Removing old data in $merge_dir\n" if $state eq "interactive";
#print LOG scalar(localtime), " (JST) - Removing old data in $merge_dir\n";

print LOG "\t/bin/rm -f $merge_dir/eis_*\n";
#system("/bin/rm -f $merge_dir/eis_*");

print LOG "\t/bin/rm -f $merge_dir/decompressed/eis_*\n";
#system("/bin/rm -f $merge_dir/decompressed/eis_*");


############################################### FETCH DATA

print STDOUT scalar(localtime), " (JST) - Fetching data\n" if $state eq "interactive";
#print LOG scalar(localtime), " (JST) - Fetching data\n";

#print LOG "\t$HOME/bin/sdtp $mode $ant band=$band sdate=$sdate edate=$edate stime=$stime etime=$etime\n";
system("$HOME/bin/sdtp $mode $ant band=$band sdate=$sdate edate=$edate stime=$stime etime=$etime");
