#!/bin/bash

if [ $# -eq 1 ]; then
    root=$1
else
    echo Need a directory of EIS level-0 files.
    exit -1
fi

for f in `ls ${root}` ; do
    echo -n "${root}${f} " >> ${HOME}/tmp/$$_sla.txt
#    fits_header_dump ${root}/${f} | grep SLIT - >> ${HOME}/tmp/$$_sla.txt
    fits_header_dump ${root}${f} | grep SLIT - | awk '/^SLIT_ID/ {id=$2;next} /^SLIT_IND/ {ind=$2;next} /^SLIT_NR/ {nr=$2;print id, ind, nr}' >> ${HOME}/tmp/$$_sla.txt
    cat ${HOME}/tmp/$$_sla.txt | awk -f ${HOME}/src/valid_sla.awk
    /bin/rm ${HOME}/tmp/$$_sla.txt
done
