#!/usr/local/bin/perl -W

# foreach f ( `ls ~/work/localdata/sdtp/merge/rescue/` )
# rescue_file.pl ~/work/localdata/sdtp/merge/rescue/$f
# end

# -m switch indicates the program was called by daily_merge_mission1

use lib "/nasA_solar1/home/sbukeis/lib/egse_sw_lib/perllib/EisCcsdsLib";
use lib "/nasA_solar1/home/sbukeis/lib/egse_sw_lib/perllib/EisCcsdsLib/Ccsds";
use lib "/nasA_solar1/home/sbukeis/lib/egse_sw_lib/perllib/EisCcsdsLib/Ccsds/Packet";

use Ccsds;
use Packet;
use Ccsds::Packet::GapReader;
use File::Basename;

use Env qw(EGSE_SW_LIB);

#do "$EGSE_SW_LIB/date_calc.pl" || warn "Can't do date_calc.pl: $!\n";
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";
#print STDERR "rescue_file.pl\n";

my $outputDir = "/nasA_solar1/work/eis/localdata/sdtp/merge/";
my $filename = "";
#if($#ARGV == 0) {
#    $filename = $ARGV[0] unless $ARGV[0] eq "-m";
#    die "Incorrect parameters" if $filename eq "";
#}
#elsif($#ARGV == 1) {
#    die "Unknown switch" unless $ARGV[0] eq "-m";
#    $filename = $ARGV[1];
#    $outputDir = "/nasA_solar1/work/eis/localdata/sdtp/merge/merge1/";
#}
#else {
#    print STDOUT "Supply filename to process\n";
#    exit;
#}
#print STDERR "Filename = $filename\n";
#die;

if($#ARGV != 2) {
    die "split_file.pl src_file_name num_headers out2_filename\n";
}
$filename = $ARGV[0];
my $num = $ARGV[1];
my $out2 = $ARGV[2];

$outputFile = basename($filename);
$outputFilename = "$outputDir" . "$outputFile";
###print STDOUT "Files: $filename, $outputFilename\n";

die "Can't open output file: $!" unless open(OUT, "> $outputFilename");

$r = Ccsds::Packet::Reader::GapReader->new();
$num_ccsds_pkts = 0;
$r->init();
$r->setInput($filename);
@data = ();
$md_out_count = 0;
$total_gaps = 0;
$packets_missing = 0;
$md_count = 0;
$md_headers = 0;
while(1) {
	last unless $r->readPacket();
	push @data, $r->rawData();
	if($r->isStartPacketOfSequence()) {
		++$md_headers;
		next;
	}
	if($r->isLastPacketOfSequence()) {
		++$md_count;
		if($r->numberOfGaps() == 0) {
		 	print OUT @data;
		 	++$md_out_count;
		}
		$total_gaps += $r->numberOfGaps();
		$packets_missing += $r->packetsMissing();
		$r->mark();
		@data = ();
		next;
	}
	
	last if($md_headers == $num);
}
# ????
if($r->isMiddlePacketOfSequence()) {
    $total_gaps += $r->numberOfGaps();
    $packets_missing += $r->packetsMissing();
}
# ????

close OUT;

# Open new output and dump the second file
$outputFilename = "$outputDir" . "$out2";
die "Can't open output file: $!" unless open(OUT, "> $outputFilename");

while(1) {
	last unless $r->readPacket();
	push @data, $r->rawData();
	if($r->isStartPacketOfSequence()) {
		++$md_headers;
		next;
	}
	if($r->isLastPacketOfSequence()) {
		++$md_count;
		if($r->numberOfGaps() == 0) {
		 	print OUT @data;
		 	++$md_out_count;
		}
		$total_gaps += $r->numberOfGaps();
		$packets_missing += $r->packetsMissing();
		$r->mark();
		@data = ();
		next;
	}
	
}


#$num_ccsds_pkts = $r->numberOfPackets();
$r->cleanUp();
close OUT;

#write STDOUT;
#
#format STDOUT = 
#@<<<<<<<<<<<<<<<<<<<<<<<<<<< @##### @##### @##### @###### @###### @#####
#$outputFile, $md_headers, $md_count, $md_out_count, $num_ccsds_pkts, $packets_missing, $total_gaps
#.

