/**********************************************************
 *
 *          * GEOTAIL SATELLITE TRANSMIT SYSTEM *
 *
 *      P.NAME      : hexasc
 *
 *      FUNCTION    : HEX(BCD) TO ASCII-CODE
 *
 *      CALLING SEQUENCE
 *          hexasc( hex , asc , leng , ispos , iepos )
 *
 *      RETURN VALUE
 *          int     :  0 normal end
 *                  : -1 error end
 *
 *      ARGUMENT
 *          hex     : (IN) (*char) hex(bcd)-code start pointer
 *          asc     : (IN) (*char) ascii-code    start pointer
 *          leng    : (IN) (*int)  change hex-code length
 *          ispos   : (IN) (*int)  input  data point(1<-4bit)
 *          iepos   : (IN) (*int)  output data point(1<-byte)
 *
 *      DATE        : 90.10.04 S.OGATA
 *
 *      note        : a-f : "oomoji" code desu. (A-F)
 *********************************************************/
#include	<inttypes.h>
#include        "bcd_ch.str"
#include        "com_hexasc.h"
 
static uint8_t     htoa ();
int
com_hexasc_ (hex, asc, leng, ispos, iepos)
    uint8_t            hex[], asc[];
int            *leng, *ispos, *iepos;

{
    union uni       un;
    int             start_point, end_point, asc_point, i;
    int			    order;

    /* ERROR CHECK */
    if (*leng < 1 || *ispos < 1 || *iepos < 1) {
	return (-1);
    }
    /* DATA SET */
    asc_point = *iepos - 1 + *leng - 1;
    start_point = *ispos - 1;
    end_point = *leng / 2 + start_point - 1;
    /* 4BIT DATA */
    if (*leng % 2 != 0) {
	un.bit = hex[end_point + 1];
        order = 1;
        if(*((char *) &order)){
	  asc[asc_point--] = htoa (un.st.bit_low);
	} else {
	  asc[asc_point--] = htoa (un.st.bit_high);
	}
    }
    /* LENGTH = 1 : END */
    if (end_point < 0) {
	return (0);
    }
    /* CHANGE DATA */
    for (i = end_point; i >= start_point; i--) {
	un.bit = hex[i];
        order = 1;
        if(*((char *) &order)){
	  asc[asc_point--] = htoa (un.st.bit_high);
	  asc[asc_point--] = htoa (un.st.bit_low);
	} else {
	  asc[asc_point--] = htoa (un.st.bit_low);
	  asc[asc_point--] = htoa (un.st.bit_high);
	}
    }
    return (0);
}
/* BINARY -> ASCII-CODE */
static uint8_t
htoa (dt)
    int32_t             dt;
{
    if (dt < 10) {
	return (dt + '0');
    }
    return (dt - 10 + 'A');
}
