/**********************************
 *
 *      SB_Time2Ti CHECK TEST MAIN
 *
 *      BASE_FILE : base file path environment name 
 *      LEAP_FILE : Leapsec file path environment name 
 *
 *      tst_timchk totalsec(double)
 *
 **********************************/
#include        <stdio.h>
#include        <stdlib.h>
#include        <string.h>
#include        <inttypes.h>
#include        "SB_Time.h"
#include        "SBTCA_com.h"
#include        "UtTt.h"

void    main( argc, argv )
int     argc;
char    *argv[];
{

	char		*Leap_FNAME, *Base_FNAME;
        /*unsigned char   wk[30]; */
        uint8_t   wk[30];

	int32_t 	rtn;
	uint32_t 	IntTI;
	double 		In_SBsec;

	/*--------------------------------------------------------------*/
	/* ĶѿեѥФ				*/
	/*--------------------------------------------------------------*/
	if( Base_FNAME = getenv( "BASE_FILE" ) );
	else {
		printf( "environment error :BASE_FILE\n" );
		exit(1);
	}

	if( Leap_FNAME = getenv( "LEAP_FILE" ) );
	else {
		printf( "environment error :LEAP_FILE\n" );
		exit(1);
	}
	rtn = UtTt_Init( Leap_FNAME );
	if( rtn < 0 ) {
		printf( "UtTt_Init error\n" );
		exit(1);
	}

	/*--------------------------------------------------------------*/
	/* ϥѥ᡼β						*/
	/*--------------------------------------------------------------*/
	if( argc != 2 ) {
		printf( "Usage : tst_timchk totalsec(double)\n" );
		exit(1);
	}

        In_SBsec = atof( argv[1] );

        /*--------------------------------------------------------------*/
        /* TttoUt() ¹                                              */
        /*--------------------------------------------------------------*/
        printf( "TttoUt START    \n" ) ;
        /****************************************************************/
        rtn = TttoUt( In_SBsec, wk );
        /****************************************************************/
        printf( "TttoUt END [%d]    \n",  rtn ) ;
        if( rtn < 0 ) {
                printf( "TttoUt error\n" );
                exit(1);
        }
        printf( "INPUT SB_Time[%lf] TIME[%02x%02x.%02x%02x %02x:%02x:%02x.%02x%02x%02x]\n",
                   In_SBsec, wk[0],wk[1],wk[2], wk[3],wk[4],wk[5], wk[6],wk[7],wk[8], wk[9]);

	/*--------------------------------------------------------------*/
	/* SB_Time_Init() ¹					*/
	/*--------------------------------------------------------------*/
	printf( "SB_Time_Init START [%s][%lf]\n", Base_FNAME, In_SBsec ) ;
	/****************************************************************/
	rtn = SB_Time_Init( Base_FNAME, In_SBsec);
	/****************************************************************/
	printf( "SB_Time_Init END [%d]\n",  rtn ) ;
	if( rtn < 0 ) {
		printf( "SB_Time_Init error\n" );
		exit(1);
	}

	/*--------------------------------------------------------------*/
	/* SB_Time2Ti() ¹					*/
	/*--------------------------------------------------------------*/
	printf( "SB_Time2Ti START [%lf]\n", In_SBsec ) ;
	/****************************************************************/
	rtn = SB_Time2Ti( In_SBsec, &IntTI );
	/****************************************************************/
	printf( "SB_Time2Ti END [%d] \n", rtn ) ;
	if( rtn != 0 ) {
		printf( "SB_Time2Ti error\n" );
		exit(1);
	}

	printf( "OUTPUT DHU-TI[%08x]\n", IntTI );
	exit(0);
	/*--------------------------------------------------------------*/

}
