/**********************************************************
 *
 *          * GEOTAIL SATELLITE TRANSMIT SYSTEM *
 *
 *      P.NAME      : binbcd
 *
 *      FUNCTION    : BIN-CODE TO BCD-CODE
 *
 *      CALLING SEQUENCE
 *          binbcd( bin , bcd , leng , ipos )
 *
 *      RETURN VALUE
 *          int     :  0 normal end
 *                  : -1 error  end
 *
 *      ARGUMENT
 *          bin     : (IN) (*int)  hex-code output pointer
 *          bcd     : (OUT)(*char) bcd-code start pointer
 *          leng    : (IN) (*int)  change bcd count
 *          ipos    : (IN) (*int)  start bcd count
 *
 *      DATE        : 90.09.27 S.OGATA
 *
 *********************************************************/
#include        <inttypes.h>
#include        "bcd_ch.str"
#include        "com_binbcd.h"

int
com_binbcd_ (bin, bcd, leng, ipos)
    uint8_t            bcd[];
int            *bin, *leng, *ipos;

{
    union uni       un;
    int             start_point, end_point, i, data;
    int			    order;

    /* ERROR CHECK */
    if (*leng < 1 || *ipos < 1) {
	return (-1);
    }
    /* DATA SET */
    start_point = *ipos - 1;
    end_point = *leng / 2 + start_point - 1;
    data = *bin;
    /* 4BIT DATA */
    if (*leng % 2 != 0) {
	un.bit = bcd[end_point + 1];
        order = 1;
        if(*((char *) &order)){
	  un.st.bit_low = data % 10;
	} else {
	  un.st.bit_high = data % 10;
	}
	data /= 10;
	bcd[end_point + 1] = un.bit;
    }
    /* LENGTH = 1 END */
    if (end_point < 0) {
	return (0);
    }
    /* DATA CHANGE */
    for (i = end_point; i >= start_point; i--) {
	/* DATA = BIN MOD 10 */
        order = 1;
        if(*((char *) &order)){
	  un.st.bit_high = data % 10;
	  data /= 10;
	  un.st.bit_low = data % 10;
	  data /= 10;
	} else {
	  un.st.bit_low = data % 10;
	  data /= 10;
	  un.st.bit_high = data % 10;
	  data /= 10;
        }
	/* DATA PUT  */
	bcd[i] = un.bit;
    }
    return (0);
}
