/**********************************
 *     
 *      TIME CHECK TEST MAIN
 *
 *      BASE_FILE : base file path environment name 
 *      LEAP_FILE : Leapsec file path environment name 
 *
 *      tst_timchk FFFFFFFF yyyymmddhhmmss
 *
 **********************************/
#include        <stdio.h>
#include        <stdlib.h>
#include        <string.h>
#include        <inttypes.h>
#include        "SB_Time.h"
#include        "SBTCA_com.h"
#include        "UtTt.h"
#include        "com_aschex.h"
#include        "com_ascbcd.h"

double UtASCtoTt( uint8_t* ut );

int    main( argc, argv )
int32_t     argc;
char    *argv[];
{

	char		*Leap_FNAME, *Base_FNAME;
	uint8_t  	INTI[30], TI[30];
	uint8_t  	INTIME[30], TIME[30];
	uint8_t  	wk[30];

	int 		ir, rtn;
	uint32_t 	IntTI;
	double 		SBsec, In_SBsec;
	int 		N1=1, N8=8, N14=14;

	/*--------------------------------------------------------------*/
	/* ĶѿեѥФ				*/
	/*--------------------------------------------------------------*/
	if( Base_FNAME = getenv( "BASE_FILE" ) );
	else {
		printf( "environment error :BASE_FILE\n" );
		exit(1);
	}

	if( Leap_FNAME = getenv( "LEAP_FILE" ) );
	else {
		printf( "environment error :LEAP_FILE\n" );
		exit(1);
	}
	rtn = UtTt_Init( Leap_FNAME );
	if( rtn < 0 ) {
		printf( "UtTt_Init error\n" );
		exit(1);
	}

	/*--------------------------------------------------------------*/
	/* ϥѥ᡼β						*/
	/*--------------------------------------------------------------*/
	if( argc != 3 ) {
		printf( "Usage : tst_timchk ffffffff yyyymmddhhmmss\n" );
		exit(1);
	}

	if( strlen(argv[1]) != 8 ) {
		printf( "TI(ffffffff) length error\n" );
		exit(1);
	}
	strcpy( INTI, argv[1] );
	com_aschex_( INTI, TI, &N8, &ir, &N1, &N1 );
	if( ir != 0 ) {
		printf( "TI(ffffffff) code error\n" );
		exit(1);
	}
	IntTI = (uint32_t)TI[0];
	IntTI = IntTI*256 + (uint32_t)TI[1];
	IntTI = IntTI*256 + (uint32_t)TI[2];
	IntTI = IntTI*256 + (uint32_t)TI[3];

	if( strlen(argv[2]) != 14 ) {
		printf( "TIME(yyyymmddhhmmss) length error\n" );
		exit(1);
	}
	strcpy( INTIME, argv[2] );
	com_ascbcd_( INTIME, TIME, &N14, &ir, &N1, &N1 );
	if( ir != 0 ) {
		printf( "TIME(yyyymmddhhmmss) code error\n" );
		exit(1);
	}
	strcat( INTIME, "0000" );
	In_SBsec = UtASCtoTt( INTIME );
	if( In_SBsec < 0.0 ) {
		printf( "TIME(yyyymmddhhmmss) error [%s]\n", INTIME );
		exit(1);
	}
	printf( "INPUT TI[%s] TIME[%s]\n", INTI, INTIME );

	/*--------------------------------------------------------------*/
	/* SB_Time_Init() ¹					*/
	/*--------------------------------------------------------------*/
	printf( "SB_Time_Init START [%s][%lf]\n", Base_FNAME, In_SBsec ) ;
	/****************************************************************/
	rtn = SB_Time_Init( Base_FNAME, In_SBsec);
	/****************************************************************/
	printf( "SB_Time_Init END [%d]\n",  rtn ) ;
	if( rtn < 0 ) {
		printf( "SB_Time_Init error\n" );
		exit(1);
	}

	/*--------------------------------------------------------------*/
	/* SB_Time_Convert() ¹					*/
	/*--------------------------------------------------------------*/
	printf( "SB_Time_Convert START    \n" ) ;
	/****************************************************************/
	SBsec = SB_Time_Convert( IntTI, In_SBsec );
	/****************************************************************/
	printf( "SB_Time_Convert END [%lf] \n", SBsec ) ;
	if( SBsec < 0.0 ) {
		printf( "SB_Time_Convert error\n" );
		exit(1);
	}


	/*--------------------------------------------------------------*/
	/* TttoUt() ¹						*/
	/*--------------------------------------------------------------*/
	printf( "TttoUt START    \n" ) ;
	/****************************************************************/
	rtn = TttoUt( SBsec, wk );
	/****************************************************************/
	printf( "TttoUt END [%d]    \n",  rtn ) ;
	if( rtn < 0 ) {
		printf( "TttoUt error\n" );
		exit(1);
	}
	printf( "OUTPUT SB_Time[%lf] TIME[%02x%02x.%02x%02x %02x:%02x:%02x.%02x%02x%02x]\n",
		SBsec, wk[0],wk[1],wk[2], wk[3],wk[4],wk[5], wk[6],wk[7],wk[8], wk[9]);
	exit(0);
	/*--------------------------------------------------------------*/

    return( 0 ) ;
}
