/* structures and code for the packet headers */

/* each HK packet has a packet header (not handled here) followed by
   the 3 status areas, an image info header and an array of image
   info blocks. There are 3 types of image info headers and each
   has a different block structure. */

#define	 STATUS1_SIZE  8
#define	 STATUS2_SIZE  172
#define	 STATUS3_SIZE  200

typedef struct {
	char	status1[STATUS1_SIZE];
	char	status2[STATUS2_SIZE];
	char	status3[STATUS3_SIZE];
} HKstatusData;

typedef struct {
	unsigned  spcam : 	12;
	unsigned  fgcam : 	12;
	unsigned  ctcam : 	12;
	unsigned  fpphtcp : 	12;
	unsigned  fppif : 	12;
	unsigned  fppehotwall : 12;
	unsigned  fpppwrhotwall : 12;
	unsigned  fppcpu : 	12;
	unsigned  fppeif : 	12;
	unsigned  fppstruct1 : 	12;
	unsigned  fppstruct2 : 	12;
	unsigned  fppstruct3 : 	12;
	unsigned  fppstruct4 : 	12;
	unsigned  fppy1p : 	12;
	unsigned  fppy2p : 	12;
	unsigned  fppy1m : 	12;
	unsigned  fppy2m : 	12;

	unsigned  tf1 : 	12;
	unsigned  tf2 : 	12;
	unsigned  tf3 : 	12;
	unsigned  tf4 : 	12;
	unsigned  tf5 : 	12;
	unsigned  tf6 : 	12;
	unsigned  tf7 : 	12;
	unsigned  tf8 : 	12;

	unsigned  mechelectr : 	12;
	unsigned  filterw1 : 	12;
	unsigned  filterw2 : 	12;
	unsigned  focus : 	12;
	unsigned  heatdump : 	12;
	unsigned  spslit : 	12;
	unsigned  spbs : 	12;

/* not complete */
} Thermistors;


#include "dataProduct.h"
#include "MM_status.h"

/* structure size are always rounded up to a machine dependent
alignment, hence we need to know the actual byte count for each
section and carefully figure the address in the telemetry. Often
this means that I*2 and I*4 values have to byte copied into a
properly aligned space to be used as such */

#define	CMSTAT2_SIZE	54
#define	TMSTAT2_SIZE	13
#define	FGSTAT2_SIZE	21
#define	SPSTAT2_SIZE	18
#define	MESTAT2_SIZE	20
#define	CTSTAT2_SIZE	6
#define	PWSTAT2_SIZE	1
#define	IFSTAT2_SIZE	8
#define	MMSTAT2_SIZE	30


 /* 8/10/2003 - doubt that many of these are correct, in particular the
 offset for the temperatures in status3 is supposed to be 136, not 118 */
#define	CMSTAT3_SIZE	13
#define	TMSTAT3_SIZE	2
#define	MESTAT3_SIZE	12
#define	CASTAT3_SIZE	20
#define	IFSTAT3_SIZE	8
#define	MMSTAT3_SIZE	34
#define	PWSTAT3_SIZE	29
#define	TH_ST3A_SIZE	82

typedef struct {        /* MDP HK APID 0x428 */
  int tr_mode;
  int use_ufss_a;
  int use_ufss_b;
  int byte211;
} MDP0x428;

int get_mdp_hk(MDP0x428 *hk0x428);
float get_att_z();
float get_sat_rot();
float get_ufss_x();
float get_ufss_y();
float get_xhelio();
float get_yhelio();
