/* 3/21/2003 - structures for data product information blocks */
/* notes - may still evolve, these are items that are put into the
  HK packets after the status snapshot. Perhaps more than we need
  for everyday work. Might evolve into a 2-level approach with more
  data saved in a diagnostic mode and less otherwise. */
/* PMU sets for shutterless FG's */
typedef struct {
	/* not that this is constructed to keep all I2's on even offsets
	and all I4 on multiples of 4, so the order may not make sense */
	unsigned phase : 4;
	unsigned state : 4;
	unsigned char PMUposition;

	UINT16 smconfig;
	UINT32 smstat0;
	UINT32 smstat1;
	UINT32 CTcounter;
	unsigned char temps[12];  /* not sure yet, most for TF */ 
	unsigned char mechs[11];  /* 8 tf's, 2 filters, mask wheel */ 
	unsigned char pad;
} FGinfoPMUset;

/* exposure sets for shuttered FG's */
typedef struct {
	unsigned  phaseAtOpen : 4;
	unsigned  phaseAtClose : 4;
	unsigned char mechs[11];  /* 8 tf's, 2 filters, mask */ 
//	short	woff, spare;	/* 1/5/2004 - added woff, replacing smstat0 */
	/* use spare for a focus position */
	short	woff, focus;	/* 1/5/2004 - added woff, replacing smstat0 */
	UINT32 smstat;		/* this is just the relevant one */
	unsigned char temps[12];  /* 8 TF thermistors only, each 12 bits */
	/* 9/13/2003 had only 16 bits for shutter, need 24 bits (or more) */
	//UINT16 shutterOpenTime;
	//UINT16 shutterCloseTime;
	UINT32 shutterOpenTime;
	UINT32 shutterCloseTime;
	UINT32 CTatOpen;
	UINT32 CTatClose;
	UINT32 CTatRdout;
	UINT16 smconfig;
} FGinfoExpset;

typedef struct {
	UINT16	n;	/* # of exposures or PMU cycles logged for this observation */
	unsigned char	version;
	unsigned char	mode;	/* 0 for PMU shutterless, 1 for exposure set, 2-7 for texp */
	UINT32	PMUcounter;	/* for first exposure */
	UINT32	CTcounter;	/* for first exposure */
	UINT32	MDPclock;	/* for first exposure */
	short	v;
	UINT16	x0;		/* the CCD cutout in CCD pixels, summing info */
	UINT16	x1;		/* is included in the camera configuartion */
	UINT16	y0;
	UINT16	y1;
	UINT16 cameraConfig;  /*3 bits of status, 9 bits of config, 3 bits of mode*/
	UINT16 dac;  	    /* the shadow DAC */
	UINT16 roiStart;
	UINT16 roiStop;
	unsigned char MDPclockHigh;
	unsigned char ncycles;
	unsigned char PMUdelay;
	unsigned char side;  /* only 1 bit used here so space for 7 more */
	//unsigned char error;
	//unsigned char pad;
	/* 9/22/2003 - use the last 16 bits instead for the GCUCONFIG */
	/* 1/5/2004 - now use it for the wavelength offset, this is needed
	especially for shutterless mode which doesn't have (or need) an offset
	for each exposure) */
	//UINT16 gcuconfig;
	short woff;
} FGinfo;

/* the items stored for SP diagnostic mode for each PMU pulse */
typedef struct {
	unsigned phase : 4;
	unsigned state : 4;
	unsigned char  PMUposition;

	UINT16 smconfig;
	UINT32 smstat0;
	UINT32 smstat1;
	UINT32 CTcounter;
	UINT16 slitPosition;  /* because we could be summing over 2 */
	/* this slitPosition is the commanded one */
	/* this is 18 bytes so far */
} SPinfoPMUset;

typedef struct {
  /* an image is usually made from a macro command but not always, we
  need to provide all necessary information to interpret a single image
  if there is no associated macro command */
	UINT16	n;	/* # of PMU cycles logged for this observation */
	unsigned char	version;
	unsigned char	mode;	/* 0 for PMU shutterless, 1 for exposure set */
	UINT32	PMUcounter;	/* for first exposure */
	UINT32	CTcounter;	/* for first exposure */
	UINT32	MDPclock;	/* for first exposure */
	short	v;
	short	slitPosition;  /* actual read slit position */
	UINT16	spaceOffset;
	UINT16	nspace;
	UINT16	cameraConfig;  /*3 bits of status, 9 bits of config, 3 bits of mode*/
	UINT16	dac;  	       /* the shadow DAC */
	unsigned char MDPclockHigh;
	unsigned char roiStart;
	unsigned char roiStop;
	unsigned char ncycles;
	unsigned char PMUdelay;
	unsigned char side;  /* only 1 bit used here so space for 7 more */
	//unsigned char error;
	//unsigned char pad;
	/* 9/22/2003 - use the last 16 bits instead for the GCUCONFIG */
	UINT16 gcuconfig;
} SPinfo;

/* and maintain some old forms */

typedef struct {
	unsigned  phaseAtOpen : 4;
	unsigned  phaseAtClose : 4;
	unsigned char mechs[11];  /* 8 tf's, 2 filters, mask */ 
	UINT32 smstat0;
	UINT32 smstat1;
	unsigned char temps[12];  /* not sure yet */
	UINT16 shutterOpenTime;
	UINT16 shutterCloseTime;
	UINT32 CTatOpen;
	UINT32 CTatClose;
	UINT32 CTatRdout;
	UINT16 smconfig;
} FGinfoExpset_version0;
