/* modules for the Data status monitor, particularly socket setups */

#include <math.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/time.h>
#include <strings.h>
#if linux
#include <netinet/in.h>
#endif

#include "command.h"
#include "xrt.h"
#include "HKformat.h"

#define ABS(x) ((x)>=0?(x):-(x))
#define	MIN(a,b) (((a)<(b))?(a):(b))
#define	MAX(a,b) (((a)>(b))?(a):(b))

#if __APPLE__
/* the G5's have 64 bit file stuff by default */
#define off64_t off_t
#define stat64 stat
#define lstat64 lstat
#define lseek64  lseek
#endif

double SB_Time_Convert( unsigned int In_tim, double In_SBsec);

//#if linux
/* for Linux, just use short files for now until we figure out large file support */
//#define off64_t off_t
//#define stat64 stat
//#define lstat64 lstat
//#define lseek64  fseek
//#endif
 /* the packet header structure, must be global */
 typedef union {
 PacketHeader pheader;
 CTpacketHeader ctheader;
 DIAGpacketHeader acheader;
 IscanPacketHeader isheader;
 XRTpacketHeader xrtheader;
 } Ph;
 Ph ph;
 int	pheadsize;
 int	datatype, psize;
 //int	FPPpsize, XRTpsize;	/* added 10/10/2006 */
#define NAPIDBUFFERS 8
 unsigned int FPPccsdsti, SBccsdsti, XRTccsdsti, APIDccsdsti[NAPIDBUFFERS];
 unsigned int old_ti_time; /* for TI time conversion */
 extern double sb_time_0;
 extern time_t	sdtpbasetime;
 extern char cnvfile_path[];
 double ti_now, ti_old;
 int msgsock;
 int needTimeRef = 1;
 int need_init_ti = 1;
 unsigned char rawbuf[2048], APIDpacketbuffer[NAPIDBUFFERS][132000], decompdata[132000];
 //unsigned char *packetbuffer;  /* used to point to one of 6 FG buffers */
 //unsigned char XRTpacketbuffer[132000];
 unsigned char *packdata1;
 //int	rawbufsize = 2048;
 //off64_t lastsynchpos = -1;
 unsigned char	*leftovers; /* move to global so it can be reset elsewhere */
 int 	ccsds_file;
#define IPPORT_USERRESERVED 5000
#define SERVER_PORT	(IPPORT_USERRESERVED + 5)
 extern	int	port_flag, data_port, socket_flag, infile, badshow_flag;
#define	DATATYPE0	0x42  /* FG  monitor */
#define	DATATYPE1	0x43  /* FG no monitor */
#define	DATATYPE2	0x44  /* SP monitor */
#define	DATATYPE3	0x45  /* SP no monitor */
#define	EGSEFLUSH	0x55  /* this should be otherwise illegal */
#define	DATAMEMDUMP	0x5e
#define	DATACTREF	0x52
#define	DATACTLIVE	0x54
#define	DATADIAGNOSTIC	0x56
#define	DATADIAGNOSTIC2	0x58
#define DATATYPEXRT     0xA2
#define DATATYPEXRT2    0xA3

 /* the reverse LUT's, these are read as needed according to version # */
 /* note, set stopOnLUT = 1 for interactive stop when reading LUT's */
 int    lutVersion = -1, stopOnLUT = 0, whosePacket;
 int	whichBuffer;	/* for the 6 FG buffers and the 2 XRT buffers */
 unsigned short  rluts[6][4096]; /* for 1,2,3,4,5,6 note that 0 is no LUT and 7 is EIS only */
 char   *defaultLutPath = "/home/sbussot/reverseLUTs/";
 char   *lutpath;
 FILE   *fin;
 int psizeCompressed;

 int	apid, ccsdssize, scount, sflag, dataoffset, datasize;
 unsigned short compIDS[NAPIDBUFFERS][4] /*, XRTcompIDS[4] */;
 unsigned short *XRTcompIDS, *FPPcompIDS;  /* these are used to pass appropiate compIDS for routines in ungu.c */
 unsigned int sechead;
 //int	fppsize, fppmaxsize = 131584, hflag, subid, comp_used_expanded[5], comptype;
 //int    XRTcomp_used_expanded[5], xrtsize;
 int	APIDsize[NAPIDBUFFERS], fppmaxsize = 131584, hflag, subid, comp_used_expanded[NAPIDBUFFERS][5], comptype;
 unsigned char	ccsdsdata[2048], *fpppacket;
 unsigned char hk420buf[2048], hk428buf[2048], hk544buf[2048], hk546buf[2048];
 unsigned char hk584buf[2048], hk5a2buf[2048], hk5a4buf[2048], hk440buf[2048];
 int	ccsdspos = 0, nccsdspacks = 0, ccsdsdebug=0, uselastFlag = 0;
 compression_parameters comp_used[NAPIDBUFFERS];
 //compression_parameters XRTcomp_used;
 /*------------------------------------------------------------------------- */
void wait_sec(xq) /* for internal use */
 float	xq;
 {
 struct timeval	tval;
 xq = MAX(0.0, xq);
 tval.tv_sec = (unsigned int) xq;
 xq = (xq - tval.tv_sec) * 1.e6;
 tval.tv_usec = (unsigned int) xq;
 select(0, NULL, NULL, NULL,&tval);
 }
 /*----------------------------------------------------------------------*/
int ccsds2hk(unsigned char *p, int plen)
{
  unsigned char *d;
  switch (apid) {
    case 0x420: d = hk420buf; break;
    case 0x428: d = hk428buf; break;
    case 0x440: d = hk440buf; break;
    case 0x544: d = hk544buf; break;
    case 0x546: d = hk546buf; break;
    case 0x584: d = hk584buf; break;
    case 0x5a2: d = hk5a2buf; break;
    case 0x5a4: d = hk5a4buf; break;
    default: return 0;
  }
  bcopy(p, d, plen);
  return 1;
}
 /*----------------------------------------------------------------------*/
// float get_sat_rot() /* ACU1_ERROR_ANG_Z_AS (deg) */
// {
//   int sat_rot = (hk440buf[219] << 16) & 0x00FF0000;
//   sat_rot |= (((hk440buf[220] << 8) & 0xFF00) | (hk440buf[221] & 0xFF));
//   if (hk440buf[219] & 0x80) sat_rot |= 0xFF000000;
//   return sat_rot*2.14576721e-5; /* 180.0/(2**23) */
// }
 /*----------------------------------------------------------------------*/
float get_att_y() /* HK2_ATT_X */
{
  /* ATT_X is ion the N/S direction but with opposite sign */
  /* conversion is C1 = 180/(2^23*60*60) and C0 = 0 (for now) */
  int attx = ((hk428buf[275] << 16) & 0xff0000) | ((hk428buf[276] << 8) &
	      0x00ff00) | (hk428buf[277] & 0x0000ff);
  if (attx & 0x800000) attx |= 0xFF000000;
  attx = -attx;	/* note, C0 is zero at present */
  return attx*10125.0/131072.0; /* 3600*180/2^23 */
}
 /*----------------------------------------------------------------------*/
float get_att_x() /* HK2_ATT_Y */
{
  int atty = ((hk428buf[278] << 16) & 0xff0000) | ((hk428buf[279] << 8) &
	      0x00ff00) | (hk428buf[280] & 0x0000ff);
  if (atty & 0x800000) atty |= 0xFF000000;
  atty = -atty;	/* note, C0 is zero at present */
  return atty*10125.0/131072.0; /* 3600*180/2^23 */
}
 /*----------------------------------------------------------------------*/
float get_att_z() /* HK2_ATT_Z (note deg rather than arc seconds) */
{
  int attz;
  attz = ((hk428buf[281] << 16) & 0xff0000) | ((hk428buf[282] << 8) &
	      0x00ff00) | (hk428buf[283] & 0x0000ff);
  if (attz & 0x800000) attz |= 0xFF000000;
  return attz*180.0/8388608.0; /* degrees */
}
 /*----------------------------------------------------------------------*/
// float get_ufss_x() /* ACU1_UFSS-A_YANG_AS or ACU1_UFSS-B_YANG_AS */
// {
//   int ufssx;
//   if (hk428buf[211] & 0x08) {
//     ufssx = ((hk440buf[53] << 8) & 0x7F00) | (hk440buf[54] & 0xFF);
//   } else if (hk428buf[211] & 0x04) {
//     ufssx = ((hk440buf[57] << 8) & 0x7F00) | (hk440buf[58] & 0xFF);
//   } else {
//     return 0.0;
//   }
//   return 1800.0 - 0.10986663*ufssx;
// }
//  /*----------------------------------------------------------------------*/
// float get_ufss_y() /* ACU1_UFSS-A_XANG_AS or ACU1_UFSS-B_XANG_AS */
// {
//   int ufssy;
//   if (hk428buf[211] & 0x08) {
//     ufssy = ((hk440buf[51] << 8) & 0xFF00) | (hk440buf[52] & 0xFF);
//   } else if (hk428buf[211] & 0x04) {
//     ufssy = ((hk440buf[55] << 8) & 0xFF00) | (hk440buf[56] & 0xFF);
//   } else {
//     return 0.0;
//   }
//   return 1800.0 - 0.10986663*ufssy;
// }
float xoffsu=0.0, yoffsu=0.0;
/*----------------------------------------------------------------------*/
/* See 'SOLAR-B "Hinode" Mission-Wide FITS Keywords' */
float get_xhelio()
/*
float get_xhelio(float xoffut, float yoffut, float inst_rot, float xccd,
                 float yccd, float dx, float dy)
*/
/* [x-y]offut: offset between UFSS Z-axis and CCD origin */
/* [x-y]ccd units are pixels, dx and dy are arcsec/pixel */
{
  return get_att_x();
/* raw ufss telem
  return get_ufss_x();
 *  */
/* The following is from 'Mission-Wide FITS Keywords', not used for now
  float ufss_x = get_ufss_x();
  float ufss_y = get_ufss_y();
  float z = M_PI*get_sat_rot()/180.0;
  float tot_rot = (M_PI*inst_rot/180.0) + z;
  return xoffsu + (ufss_x - xoffut)*cos(z) + (ufss_y - yoffut)*sin(z) +
                  xccd*dx*cos(tot_rot) + yccd*dy*sin(tot_rot);
*/
}
 /*----------------------------------------------------------------------*/
/* See 'SOLAR-B "Hinode" Mission-Wide FITS Keywords' */
float get_yhelio()
/*
float get_yhelio(float xoffut, float yoffut, float inst_rot, float xccd,
                 float yccd, float dx, float dy)
*/
/* [x-y]offut: offset between UFSS Z-axis and CCD origin */
/* [x-y]ccd units are pixels, dx and dy are arcsec/pixel */
{
  return get_att_y();
//  return get_ufss_y();
/* The following is from 'Mission-Wide FITS Keywords', not used for now
  float ufss_x = get_ufss_x();
  float ufss_y = get_ufss_y();
  float z = M_PI*get_sat_rot()/180.0;
  float tot_rot = (M_PI*inst_rot/180.0) + z;
  return yoffsu - (ufss_x - xoffut)*sin(z) + (ufss_y - yoffut)*cos(z) -
                  xccd*dx*sin(tot_rot) + yccd*dy*cos(tot_rot);
*/
}
 /*----------------------------------------------------------------------*/
int get_mdp_hk(MDP0x428 *hk0x428)
{
  hk0x428->tr_mode = (hk428buf[210] >> 5) & 0x07;
  hk0x428->use_ufss_a = (hk428buf[211] >> 3) & 0x01;
  hk0x428->use_ufss_b = (hk428buf[211] >> 2) & 0x01;
  hk0x428->byte211 = hk428buf[211];
  return 0;
}
 /*----------------------------------------------------------------------*/
int get_xrt_hk(XRT0x584 *hk0x584, XRT0x5a4 *hk0x5a4)
{
  hk0x584->ver   = (hk584buf[0] >> 5) & 0x07;
  hk0x584->type  = (hk584buf[0] >> 4) & 0x01;
  hk0x584->sh    = (hk584buf[0] >> 3) & 0x01;
  hk0x584->apid  = ((hk584buf[0] & 0x07) << 8) | hk584buf[1];
  hk0x584->seg   = (hk584buf[2] >> 6) & 0x03;
  hk0x584->psn   = ((hk584buf[2] & 0x3F) << 8) | hk584buf[3];
  hk0x584->plen  = (hk584buf[4] << 8) | hk584buf[5];
  hk0x584->ptime = (hk584buf[6] << 24) | (hk584buf[7] << 16) |
	           (hk584buf[8] << 8) | hk584buf[9];
  hk0x584->bor_code = (hk584buf[10] << 24) | (hk584buf[11] << 16) |
	           (hk584buf[8] << 12) | hk584buf[13];
  hk0x584->pkt_and_hdr_len = (hk584buf[14] << 8) | hk584buf[15];
  hk0x584->ptyp_code = hk584buf[16];
  hk0x584->t_sc_clock = (hk584buf[50] << 24) | (hk584buf[51] << 16) |
                        (hk584buf[52] << 8) | hk584buf[53];
  hk0x584->t_lo_clock = (hk584buf[54] << 24) | (hk584buf[55] << 16) |
                        (hk584buf[56] << 8) | hk584buf[57];
  hk0x584->t_lst_act = (hk584buf[58] << 8) | hk584buf[59];

  hk0x5a4->ver   = (hk5a4buf[0] >> 5) & 0x07;
  hk0x5a4->type  = (hk5a4buf[0] >> 4) & 0x01;
  hk0x5a4->sh    = (hk5a4buf[0] >> 3) & 0x01;
  hk0x5a4->apid  = ((hk5a4buf[0] & 0x07) << 8) | hk5a4buf[1];
  hk0x5a4->seg   = (hk5a4buf[2] >> 6) & 0x03;
  hk0x5a4->psn   = ((hk5a4buf[2] & 0x3F) << 8) | hk5a4buf[3];
  hk0x5a4->plen  = (hk5a4buf[4] << 8) | hk5a4buf[5];
  hk0x5a4->ptime = (hk5a4buf[6] << 24) | (hk5a4buf[7] << 16) |
	           (hk5a4buf[8] << 8) | hk5a4buf[9];
  hk0x5a4->cal_info = (hk5a4buf[10] >> 4) & 0x01;
  hk0x5a4->chip_sum = hk5a4buf[10] & 0x0F;
  hk0x5a4->roi_h_sta_pos = hk5a4buf[11];
  hk0x5a4->roi_v_sta_pos = hk5a4buf[12];
  hk0x5a4->roi_h_size = hk5a4buf[13] & 0x3F;
  hk0x5a4->roi_v_size = hk5a4buf[14] & 0x3F;
  hk0x5a4->ccd_read_port = hk5a4buf[15] & 0x01;
  hk0x5a4->ccd_temp = hk5a4buf[16];
  hk0x5a4->ccd_ope_sts1 = (hk5a4buf[17] >> 6) & 0x03;
  hk0x5a4->ccd_ope_sts2 = (hk5a4buf[17] >> 4) & 0x03;
  hk0x5a4->ccd_ope_sts3 = (hk5a4buf[17] >> 2) & 0x03;
  hk0x5a4->ccd_ope_sts4 = hk5a4buf[17] & 0x03;
  hk0x5a4->ccd_ope_sts5 = (hk5a4buf[18] >> 6) & 0x03;
  hk0x5a4->ccd_ope_sts6 = (hk5a4buf[18] >> 4) & 0x03;
  hk0x5a4->ccd_ope_sts7 = (hk5a4buf[18] >> 2) & 0x03;
  hk0x5a4->ccd_ope_sts8 = hk5a4buf[18] & 0x03;
  hk0x5a4->exp_sta_time = (hk5a4buf[19] << 8) | hk5a4buf[20];
  hk0x5a4->exp_end_time = (hk5a4buf[21] << 8) | hk5a4buf[22];
  hk0x5a4->read_end_time = (hk5a4buf[23] << 8) | hk5a4buf[24];
  hk0x5a4->timer_counter = (hk5a4buf[25] << 8) | hk5a4buf[26];
  return 0;
}
/*----------------------------------------------------------------------*/
int ccsdsread(p)
 unsigned char *p;
 {
 /* the internal CCSDS reader */
 /* get first 6 bytes, this gets primary header */
 unsigned char	p0;
 int	cnt, sheaderflag, plen;
 extern unsigned int timeRef;
 cnt = read(ccsds_file, p, 6);
 if (cnt != 6) { printf("**** CCSDS read error\n");  return 1; }
 ccsdspos += cnt;
 p0 = p[0];
 if ( p0 & 0xf0) { printf("top 4 bits not zero, %#x\n", p0); return 1; }
 /* normally we expect a secondary header for all Solar B packets, but check */
 sheaderflag = p0 & 0x08;
 apid = ((p0 & 0x07) << 8) | p[1];
 plen = (p[4] << 8) | p[5];
 sflag = (p[2] & 0xc0) >> 6;
 scount = ((p[2] & 0x3f) << 8) | p[3];
 if (ccsdsdebug) printf("#apid = %#x, plen = %4d, sflag = %d, scount = %6d, pck #%6d, pos %7d, ",
   apid, plen, sflag, scount, nccsdspacks, ccsdspos); 
 /* read the entire packet now */
 plen = plen + 1;
 p = p + 6;
 cnt = read(ccsds_file, p, plen);
 if (cnt != plen) { printf("CCSDS read error\n");  return 1; }
 ccsdspos += cnt;
 /* the total size */
 ccsdssize = plen + 6;
 /* also want the data position (offset) and the data size */
 dataoffset = 6;
  if (sheaderflag) {
    bcopy(p, (char *) &sechead, 4);
#if linux
    swapl((char *) &sechead, 1);
#endif
    dataoffset += 4;
    /* Heuristic time method (old) */
   if (needTimeRef) {
     needTimeRef = 0;
     timeRef = (int) sdtpbasetime - ((sechead >> 5) & 0x07ffffff);
     /* used to seed old_ti_time in ccsds2fpp() */
     if (need_init_ti) SBccsdsti = sechead;
     need_init_ti = 0;
   }
   SBccsdsti = sechead;
   ti_now = SBccsdsti; ti_old = old_ti_time;
   if (ccsdsdebug) printf(" TI %10d %#10x\n", SBccsdsti, SBccsdsti);
 /*
   if ((ti_old - ti_now) > 32.0 ) {
     printf("old_ti>new_ti, old: %u, new: %u, sb0: %lf\n",
             old_ti_time, SBccsdsti, sb_time_0);
     sb_time_0 = SB_Time_Convert(old_ti_time, sb_time_0);
     printf("New sb_time_0: %lf, %u %u\n", sb_time_0, old_ti_time, SBccsdsti);
     if (SB_Time_Init(cnvfile_path, sb_time_0)) {
       fprintf(stderr, "SB_Time_Init error\n");
       exit(1);
     }
   }
*/
   old_ti_time = SBccsdsti;
 }
 datasize = ccsdssize - dataoffset;
 nccsdspacks++;
 ccsds2hk(p-6, plen+6); /* if HK packet, update buffer for APID */
 //printf("nccsdspacks = %d, sflag = %d, apid = %#x\n", nccsdspacks, sflag, apid);
 /* another way to consider would be to put the header and the secondary
 header in their own places and put just the data in ccsdsdata */
 return 0;
 }
 /*----------------------------------------------------------------------*/
int ccsds2sci()
  /* reads CCSDS packets to construct a complete but still compressed FPP packet,
  also support for XRT packets with their own buffer (added 9/19/2006) and compression
  fields (since these are stored only at the start)
  Whenever ccsds2sci is called, it may have an incomplete packet that it is
  already working on. The current 2 types are maintained by ccsds2xrt and ccsds2fpp
  but first we have to get a CCSDS packet to determine which we have */
 {
 static int CCSDSstate;
 static int nbytes[NAPIDBUFFERS], APIDinProgress[NAPIDBUFFERS];
 static int nc[NAPIDBUFFERS], npack[NAPIDBUFFERS];
 int	nignored = 0, i, npad, n;
 static unsigned char   *packptr[NAPIDBUFFERS];
 unsigned char	*pccsds, *pfpp;
 //off64_t ipos64 = 0;
 enum {NEW_START, FPP_START, FPP_RESUME, RESUME };
 char *stateNames[] = {"NEW_START", "FPP_START", "FPP_RESUME", "RESUME" };
 /* read CCSDS packets, look for a start flag */
 /* note that we ignore the single packet case, those are type I's, we may
 want to pick them up later */

 CCSDSstate = NEW_START;
 //printf("enter ccsds2sci");
 //for (i=0;i<NAPIDBUFFERS;i++) printf("%d:%d ", i, APIDinProgress[i]);
 //printf("\n");
 for (i=0;i<NAPIDBUFFERS;i++) if (APIDinProgress[i])  { CCSDSstate = RESUME; /* printf("got one at i = %d\n", i);*/ break; }
 //printf("state after buffer check = %s\n", stateNames[CCSDSstate]);

 
 while (1) {
   //printf("state = %s\n", stateNames[CCSDSstate]);
   switch (CCSDSstate)
   {
     case NEW_START:
       /* nothing in progress, scan CCSDS packets looking for a new start
       use a 2 to indicate that ccsdsread has probably hit the EOF, the uselastFlag
       is set if we already read the CCSDS packet that we want to process in a
       previous call, in that case we don't do a ccsdsread the first time */
       while (1) {
         if (uselastFlag == 0)  if ( ccsdsread(ccsdsdata) ) return 2;
         uselastFlag = 0;
         if (sflag == 1) {
            /* only certain AP id's are good here, SOT's are 148/a/c/d/e/f,
	    XRT's are 1aa and 1ab */
            /* first check restricts it to APID's 0x148 - 0x14f */
            /* second check restricts it to APID's 0x1aa - 0x1ab */
            /* more complicated, whosePacket is 0 for FPP and 1 for XRT */
            whichBuffer = -1;
	    switch (apid) {
	    case 0x148:  whichBuffer = 0;  whosePacket = 0;  break;
	    case 0x14a:  whichBuffer = 1;  whosePacket = 0;  break;
	    case 0x14c:  whichBuffer = 2;  whosePacket = 0;  break;
	    case 0x14d:  whichBuffer = 3;  whosePacket = 0;  break;
	    case 0x14e:  whichBuffer = 4;  whosePacket = 0;  break;
	    case 0x14f:  whichBuffer = 5;  whosePacket = 0;  break;
	    case 0x1aa:  whichBuffer = 6;  whosePacket = 1;  break;
	    case 0x1ab:  whichBuffer = 7;  whosePacket = 1;  break;
	    default:  break;
	    }
	    //if ( (apid & 0x07f8) == 0x148) { whosePacket = 0;  break; }
            //  else  if ( (apid & 0x07fe) == 0x1aa)  { whosePacket = 1;  break; }
            //    /* else printf("rejected start for APID %#x\n", apid); */
	    if (whichBuffer >= 0) { APIDinProgress[whichBuffer] = 1; break; }
	 }
	 nignored++;
       }
       CCSDSstate = FPP_START;
       //printf("new start, whosePacket = %d, scount = %d, apid  %#x\n", whosePacket, scount, apid);
       break;

     case FPP_START:
       /* we have the first CCSDS packet, setup and stash compression info,
       we enter this from NEW_START, there is no ccsdsread in this state */
       /* this now handles both FPP and XRT packets, 8 types in all */

      pccsds = ccsdsdata + dataoffset;
      pfpp = packptr[whichBuffer] = APIDpacketbuffer[whichBuffer];
      bcopy(pccsds, compIDS[whichBuffer], 8);	/* the compression field */
#if linux
      swapb((char *) compIDS[whichBuffer], 8);
#endif
      pccsds += 8;
      datasize = datasize - 8;
      bcopy( pccsds, pfpp, datasize);
 /* usually the entire packet header is here except for some misunderstanding
 on the CT packets. But even then, the parts with the size and compression
 are here */
      nbytes[whichBuffer] = (pfpp[1] << 16) + (pfpp[2] << 8) + (pfpp[3]);
      //printf("starting a FPP, nbytes = %d\n", nbytes);
      if (nbytes[whichBuffer] > 132000) {
        printf("**** oversized sci packet buffer %d\n", nbytes);
        fprintf(stderr, "**** oversized sci packet buffer %d\n", nbytes);
      }
      //FPPpsize = nbytes;
     //printf("psize = %d\n", psize);
     //nx = (pfpp[26] << 8) | (pfpp[27]);
     //ny = (pfpp[28] << 8) | (pfpp[29]);
 /* and the compression area is always in bytes 30/31, this is the passed or used */
 /* needs to be updated to use the 8 bit table ID's since the onboard tables might
 change */
       bcopy(&pfpp[30], (char *) &comp_used[whichBuffer], 2);
#if linux
       swapb((char *) &comp_used[whichBuffer], 2);
#endif
       comp_used_expanded[whichBuffer][0] = comp_used[whichBuffer].bit_compression_mode;
       comp_used_expanded[whichBuffer][1] = comp_used[whichBuffer].image_compression_mode;
       comp_used_expanded[whichBuffer][2] = comp_used[whichBuffer].huffman_ac;
       comp_used_expanded[whichBuffer][3] = comp_used[whichBuffer].huffman_dc;
       comp_used_expanded[whichBuffer][4] = comp_used[whichBuffer].quantization;

       npack[whichBuffer] = 1;
       APIDsize[whichBuffer] = datasize;
       packptr[whichBuffer] += datasize;
       //baseadpid = apid;
       APIDccsdsti[whichBuffer] = sechead; /* save the TI time for the first CCSDS packet */
       nc[whichBuffer] = scount;
       //printf("FPP_START, nc = %d\n", nc);
       APIDinProgress[whichBuffer] = 1;
       CCSDSstate = RESUME;
       break;

     case RESUME:
       /* here we read just one CCSDS packet and then set state to either
       FPP_RESUME to accumulate in the appropiate buffer, we
       could enter this state from several others, it can also be the first
       state entered in a new call, if we have a problem, we usually end
       up back in RESUME */
       if (uselastFlag == 0)  if ( ccsdsread(ccsdsdata) ) return 2;
       uselastFlag = 0;
       //printf("resume, apid = %#x, scount = %d, sflag = %d\n", apid,scount,sflag); 
       /* this packet could be a continuation of an XRT or FPP packet or a
       new start, sflag =1 for a new start, =2 for the last, 0 for middle,
       and 3 if a single (but not used here), only accept FPP and XRT
       packets of course, so ... */
       switch (apid) {
       case 0x148:  whichBuffer = 0;  whosePacket = 0;  break;
       case 0x14a:  whichBuffer = 1;  whosePacket = 0;  break;
       case 0x14c:  whichBuffer = 2;  whosePacket = 0;  break;
       case 0x14d:  whichBuffer = 3;  whosePacket = 0;  break;
       case 0x14e:  whichBuffer = 4;  whosePacket = 0;  break;
       case 0x14f:  whichBuffer = 5;  whosePacket = 0;  break;
       case 0x1aa:  whichBuffer = 6;  whosePacket = 1;  break;
       case 0x1ab:  whichBuffer = 7;  whosePacket = 1;  break;
       default:  whichBuffer = -1;  break;
       }
       if (whichBuffer < 0) break;  /* this will cause us to just re-enter RESUME */
       if (sflag == 1) {
         /* this implies a new start, we have to check if we interrupted a stream */
         if (APIDinProgress[whichBuffer]) {
           printf("**** new start truncated a packet with apid  %#x\n",apid);
           fprintf(stderr, "**** new start truncated a packet with apid  %#x\n",apid);
           APIDinProgress[whichBuffer] = 0;  /* abandon and try the new one */
         }
         CCSDSstate = FPP_START;
       } else {
         /* normal case but we have to verify in progress */
         if (APIDinProgress[whichBuffer]) {
           CCSDSstate = FPP_RESUME;
         } else {
           printf("**** orphan packet for apid  %#x, sflag = %d\n",apid, sflag);
           fprintf(stderr, "**** orphan packet for apid  %#x, sflag = %d\n",apid, sflag);
           CCSDSstate = RESUME;
         }
       }
       break;

     case FPP_RESUME:
       /* we have a FPP section to add on, this state does not do any reads */
       nc[whichBuffer]++;             /* new expected scount for a check below */
       nc[whichBuffer] = nc[whichBuffer] & 0x3fff;
       CCSDSstate = RESUME;     /* usually we end up at RESUME next */
       if (scount != nc[whichBuffer]) {
         /* this is an error exception */
	 printf("**** CCSDS counter discontinuity, got %d, expected %d, pck # %d, pos = %d\n",
           scount, nc[whichBuffer], nccsdspacks, ccsdspos);
         printf("**** truncated a packet with apid = %#x\n", apid);
         /* we can't use this and must abandon */
         APIDinProgress[whichBuffer] = 0;
         /* if no other packet in progress, lets set state to NEW_START */
	 CCSDSstate = NEW_START;
	 for (i=0;i<NAPIDBUFFERS;i++) { if (APIDinProgress[i])  CCSDSstate = RESUME; break; }
         break;
       } else {
         /* this is normal progress */
	 npack[whichBuffer]++;
	 pfpp = packptr[whichBuffer];  /* use as a shorthand locally */
         pccsds = ccsdsdata + dataoffset;
         APIDsize[whichBuffer] += datasize; /* the new size */
         if (APIDsize[whichBuffer] >= fppmaxsize) {
           /* this seems to happen with bad compression (?), we just ignore
           the rest for present so as not to confuse nugu reader */
           printf("**** overflow in ccsds2sci\n");
           bcopy( pccsds, pfpp, fppmaxsize - (APIDsize[whichBuffer] - datasize));
           break;
         }
         bcopy( pccsds, pfpp, datasize);
         pfpp += datasize;
	 packptr[whichBuffer] = pfpp;
	 if ((pfpp - APIDpacketbuffer[whichBuffer]) > 132000) {
	   printf("**** FPP buffer overflow, packetbuffer = %#x, pfpp = %#x\n", APIDpacketbuffer[whichBuffer], pfpp);
	   fprintf(stderr, "**** FPP buffer overflow, packetbuffer = %#x, pxrt = %#x\n", APIDpacketbuffer[whichBuffer], pfpp);
	 }
         if (sflag == 2) {
	   /* our exit, this means that this packet is done, pad up to original packet size with 0's,
           this may not really be necessary anymore? */
           APIDinProgress[whichBuffer] = 0;
           npad = nbytes[whichBuffer] - APIDsize[whichBuffer];
	   //printf("npad = %d, apid %#x\n", npad, apid);
           if (npad < 0) {
             printf("**** pad size error, nbytes = %d, fppsize = %d, pck # %d, pos = %d\n",
                  nbytes[whichBuffer], APIDsize[whichBuffer], nccsdspacks, ccsdspos);
             /* for the present, we will assume a bad compression here and
             truncate the original so we don't confuse the nugu reader */
             APIDsize[whichBuffer] = nbytes[whichBuffer];
           }
           /* just pad up to 20 0's to save time, assuming this should be enough to stop a
	   confused de-compressor */
	   if (npad > 0) bzero(pfpp, MIN(npad, 20));
	   /* save this in a global for compression performance calculations,
           note that because we can only return one at a time, we just need
           one variable that will be used by all modes (FG, SP, XRT) */
	   psizeCompressed = APIDsize[whichBuffer];
	   psize = nbytes[whichBuffer];
	   /* note that get_sdtp_packet will use whichBuffer and whosePacket, we also set
	   FPPccsdsti and XRTccsdsti as appropiate */
	   if (whosePacket) {
	     XRTccsdsti = APIDccsdsti[whichBuffer];
	     XRTcompIDS = compIDS[whichBuffer];
	   } else {
	     FPPccsdsti = APIDccsdsti[whichBuffer];
	     FPPcompIDS = compIDS[whichBuffer];
           }
	   //printf("finished a packet, apid = %#x\n", apid);
           return 0;
         }
       }
       break;
   }


 }
 /* should be no way to get here */
 printf("**** unexpected escape from while loop in ccsds2sci\n");
 return 1;

 }
 /*------------------------------------------------------------------------- */
int get_sdtp_packet()
 {
 /* same function as get_data_packet but we are reading a set of CCSDS packets
 that we have to strip our FPP packets from */
 /* 9/19/2006 - the FPP and XRT packets can be interleaved at the CCSDS level (alas),
 this means that we might start an XRT packet in the middle of an FPP one. Hence we
 have to use separate buffers for FPP and XRT and return when either one has
 finished here. The global whosePacket is used to ID the completed one. Use
 0 for FPP and 1 for XRT. Others could be added if necessary. */
 int	stat, wasNotCompressed;
 int	eflag, i, n, ntrypack, cnt, havepack, errorlimit = 100;
 int    *compUsed=NULL;
 unsigned short *compIDSlocal;
 unsigned char	*p;
 ccsds_file = msgsock;
 /* we may have to skip over rough data, but if we lose our CCSDS synch, we
 have no way (yet) to recover */
 while (1) {
   stat = ccsds2sci();
   if (stat == 0) break;
   if (stat == 2) return 0;	/* this is the EOF (no data) return */
   if (stat) { printf("**** error in ccsds2sci\n"); }
   errorlimit--;
   if (errorlimit <= 0) { printf("**** exceeded error limit for bad ccsds2sci calls\n");
   	return 0; }
 }
 //printf("got a completed packet from ccsds2sci, whosePacket = %d, whichBuffer = %d\n", whosePacket, whichBuffer);
 /* ccsds2sci should have put a complete packet in packetbuffer, to mimic get_data_packet,
 we want the header in ph and the data in packdata1, first set data type (need to
 get the header size) */
 p = APIDpacketbuffer[whichBuffer];
 datatype = *p;
 /* to add XRT, would need to add new cases here ? */
 //printf("datatype = %d, %#x\n", datatype, datatype);
  switch (datatype) {
   case DATATYPE0:  eflag = 1; pheadsize = 80; break;
   case DATATYPE1:  eflag = 2; pheadsize = 80; break;
   case DATATYPE2:  eflag = 3; pheadsize = 80; break;
   case DATATYPE3:  eflag = 4; pheadsize = 80; break;
   /* 6/18/2001 - add memory dump via mission data I/F case */
   case DATAMEMDUMP:     eflag = 6; break;
   case DATACTREF:       eflag = 7; pheadsize = 96; break;
   case DATACTLIVE:      eflag = 8; pheadsize = 96; break;
   case DATADIAGNOSTIC2:
   case DATADIAGNOSTIC:  eflag = 9; pheadsize = 96; break;
   /* the XRT case is only done for SDTP type data */
   case DATATYPEXRT2:
   case DATATYPEXRT:  eflag = 10; pheadsize = 96;
     /* check if ccsds2sci agrees with this */
     if (whosePacket != 1) {
       printf("**** internal error, mismatch of data type for XRT\n");
       return 0;
     }
     break;
   //case EGSEFLUSH:	eflag = 0;  continue;  /* allows bypassing a section of flush */
   default: eflag = 0; break;
 }
 if (eflag != 10) {
   /* catches all FPP cases */
   hflag = (p[14] & 0x80) >> 7;
   hflag = hflag ^ 1;
   subid = p[15] & 0x1f;
   /* better check */
   if (whosePacket != 0) {
     printf("**** internal error, mismatch of data type for FPP\n");
     return 0;
   }
 } else hflag = 0;
 /* psize already set */
 bcopy(p, (char *) &ph, pheadsize);
#if linux
	switch (datatype) {
	  case DATATYPE0:
	  case DATATYPE1:
	    
	  case DATATYPE2:
	  case DATATYPE3:
	    PacketHeader_fix( (PacketHeader *) &ph);
	    break;
                	   /* 6/18/2001 - add memory dump via mission data I/F case */
	  case DATAMEMDUMP:
	    /* have a structure for this? */
	    break;

	  case DATACTREF:
	  case DATACTLIVE:
	    CTpacketHeader_fix( (CTpacketHeader *) &ph);
	    break;

	  case DATADIAGNOSTIC2:
	  case DATADIAGNOSTIC:
	    DIAGpacketHeader_fix( (DIAGpacketHeader *) &ph);
	    /* here we have to do the header info (first 32 bytes) to get the subID
	    in order to know how to do the data part of the packet header */
	    break;

            //A.Somani -- Fix for XRT data on Linux machine
          case DATATYPEXRT2:
          case DATATYPEXRT:
            XRTpacketHeader_fix( (XRTpacketHeader *) &ph);
            break;
	}
#endif  

 packdata1 = p + pheadsize;
 /* and check for decompression, first find out if we should even try */
 wasNotCompressed = 1;
 /* only FG and SP please, and no image headers, also add XRT here (eflag = 10) */ 
 if ( (eflag < 5 && eflag > 0 && !hflag) || eflag == 10) {
     /* the compression type is in comp_used_expanded[1] */
     compUsed = &comp_used_expanded[whichBuffer][0];
     compIDSlocal = &compIDS[whichBuffer][0];
     comptype = compUsed[1];
     /* note that the defined compression types are:
     0 => none, 2 => 8bit DCPM, 3 => 12 DCPM, 6 => 8bit JPEG, 7 => 12bit JPEG,
     all other codes are "reserved" */
     //printf("comptype = %d\n", comptype);
     if (comptype == 3 || comptype == 7) {
       n = psize - pheadsize;
       if (stat = fppdecomp(comptype, packdata1, n, decompdata, 132000)) {
         printf("**** FPPDECOMP error %d, comptype = %d, who = %d\n", stat, comptype, whosePacket);
       } else {
         /* successful decompress, point to it instead now */
         //printf("good decompression\n");
         packdata1 = decompdata;
         wasNotCompressed = 0;
       }
     } else if (comptype) printf("**** unexpected comptype = %d\n", comptype);
/* at this point the data will be in machine endian order if it went
   through fppdecomp, otherwise it will be in packet order which is big
   endian. We now have to check for "bit compression" which involves running
   the data through an reverse lookup table. For a big endian machine, everything
   is straightforward (because the packet and FITS order are both big endian).
   For a little endian machine, we use a scheme that minimizes swapping. */

   /* to make ramp files w/o conversion, enable with next line */
   //compUsed[0] = 0;

   if (compUsed[0]) {
     int  np, version, i, iq, it, outOfRangeCount;
     unsigned short       *image, *thisLUT;
     /* we have a LUT to undo, check if we already have this version, note that
     if the LUT was 0, we do nothing (pass through). We assume that the version number
     uses the last 4 bits for the LUT # and hence only check the upper bits here.
     This may have to be refined as we learn more about how these are used. */
     if (whosePacket ==1) {
       /* XRT shouldn't get here */
       printf("**** unexpected LUT usage for XRT, abort! LUT %d\n", compUsed[0]);
       return 0;
     }
     if ( (compIDSlocal[0] & 0xfff0) != (lutVersion & 0xfff0)) {
       char *lutName;
       int        i, ic;
       printf("reading in version %#x of LUT's, (other ID's are %#x, %#x, %#x)\n",
          compIDSlocal[0], compIDSlocal[1],compIDSlocal[2],compIDSlocal[3]);
       printf("the LUT to be used is %d, version %#x\n", compUsed[0], compIDSlocal[0]);
       if (stopOnLUT) {
         printf("hit a key to go on (Q to cancel these stops)\n");
         ic = getchar();
         if ( (char) ic == 'Q') stopOnLUT = 0;
       }
       /* we have to read in, do the whole set of 5 */
       if (lutpath == 0) {
         lutpath = getenv("FPP_LUTS");
         if (!lutpath) lutpath = defaultLutPath;
       }
       lutName = malloc(256);
       /* we actually read all 6 for the version set, so the version field
       will be compIDSlocal[0] & 0xfff0 + i */
       version = compIDSlocal[0] & 0xfff0;
       for (i=1;i<=6;i++) {
         snprintf(lutName, 255, "%s/RLUT%dv%.5x.lut", lutpath, i, version+i);
         printf("lutName = %s\n", lutName);
         if ((fin=fopen(lutName,"r")) == NULL) { perror("LUT file open error");
              return 0; }
         if ( fread(rluts[i-1], 2, 4096, fin) != 4096) { perror("LUT file read error");
              return 0; }
         fclose(fin);
       }
       free(lutName);
       lutVersion = compIDSlocal[0]& 0xfff0;
     }
     /* we either had or just got the LUT we need, packdata1 should be on an
     even boundary (if pheadsize is even and it should be for all valid cases) so
     we compute the number of I*2 pixels. */
#if linux | LITTLEENDIAN
     /* if we are little endian, we have to swap if we did not go through fppdecomp
     before we run through the reverse LUT */
     if (wasNotCompressed) swapb((char *)packdata1, psize);
#endif
     /* note that the result of the LUT will be big endian and hence ready for
     writing to FITS files */
     it = (int) (compUsed[0]);
     if (it < 1 || it > 6) {
       printf("**** out of range LUT # = %d, no reverse LUT performed\n", it);
     } else { 
       thisLUT = rluts[it - 1];
//     for (i=0;i<20;i++) printf("%4d: %d\n", i, thisLUT[i]);
//     for (i=2020;i<2060;i++) printf("%4d: %d\n", i, thisLUT[i]);
//     for (i=4080;i<4096;i++) printf("%4d: %d\n", i, thisLUT[i]);
       np = (psize - pheadsize)/2;
       //printf("psize, pheadsize, np = %d, %d, %d\n", psize, pheadsize, np);
       image = (unsigned short *) packdata1;
       outOfRangeCount = 0;
       for (i=0;i<np;i++) {
	 iq = (int) *image; 
	 if (iq < 0 || iq > 4095) {
           *image = 0; outOfRangeCount++;
	 } else { 
           *image = thisLUT[iq];
           //printf("%d  %d  %d\n", i, iq, *image);
	 }
	 image++;
       }
	 if (outOfRangeCount) {
           printf("**** number of out of range values = %d for LUT table %d\n", outOfRangeCount, compUsed[0]);
	 }
     }
   }
 }
 /* there are 4 possibilties here for little endian machines
 1: no JPEG (or DCPM) and no LUT  =>  already in big endian order, no action
 2: JPEG but no LUT => need to swap
 3: JPEG and LUT => no action
 4: no JPEG but LUT => already covered above, no action here
 so the only case that requires a swap is #2 (for little endian machines)
  */
#if linux | LITTLEENDIAN 
switch (whosePacket)
 {
   case 0: if (!wasNotCompressed && (compUsed[0] == 0)) swapb((char *)packdata1, psize);
     break;
  /* note that XRT should never use a LUT */
   case 1: if (!wasNotCompressed) swapb((char *)packdata1, psize);
     break;
 }
#endif

 return psize;
 }
 /*------------------------------------------------------------------------- */
