#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "command.h"
#include "dataProduct.h"
#include "endianfix.h"
#include "MM_status.h"
#include "xrt.h"

unsigned short ByteSwap16 (unsigned short nValue)
{
  return (((nValue>>8)) | (nValue<<8));
}

unsigned long ByteSwap32 (unsigned long nLongNumber)
{
  return (((nLongNumber&0x000000FF)<<24)+((nLongNumber&0x0000FF00)<<8)+((nLongNumber&0x00FF0000)>>8)+((nLongNumber&0xFF000000)>>24));
}

void FGinfoPMUset_fix (FGinfoPMUset *temptest)
{
  short tempshort = 0;
  short tempshort2 = 0;

  tempshort = temptest->phase;
  tempshort = tempshort | (temptest->state)<<4;
  tempshort2 = tempshort & 0xF0;
  temptest->phase = tempshort2>>4;
  temptest->state = tempshort & 0xF;

  temptest->smconfig = ByteSwap16(temptest->smconfig);
  temptest->smstat0 = ByteSwap32(temptest->smstat0);
  temptest->smstat1 = ByteSwap32(temptest->smstat1);
  temptest->CTcounter = ByteSwap32(temptest->CTcounter);

}

void FGinfoExpset_fix (FGinfoExpset *temptest)
{
  short tempshort = 0;
  short tempshort2= 0;

  tempshort = temptest->phaseAtOpen;
  tempshort = tempshort | (temptest->phaseAtClose)<<4;
  tempshort2 = tempshort & 0xF0;
  temptest->phaseAtOpen = tempshort2>>4;
  temptest->phaseAtClose = tempshort & 0xF;

  temptest->woff = ByteSwap16(temptest->woff);
  temptest->focus = ByteSwap16(temptest->focus);
  temptest->smstat = ByteSwap32(temptest->smstat);
  temptest->shutterOpenTime = ByteSwap32(temptest->shutterOpenTime);
  temptest->shutterCloseTime = ByteSwap32(temptest->shutterCloseTime);
  temptest->CTatOpen = ByteSwap32(temptest->CTatOpen);
  temptest->CTatClose = ByteSwap32(temptest->CTatClose);
  temptest->CTatRdout = ByteSwap32(temptest->CTatRdout);
  temptest->smconfig = ByteSwap16(temptest->smconfig);

}

void FGinfo_fix (FGinfo *temptest)
{
  temptest->n = ByteSwap16(temptest->n);
  temptest->PMUcounter = ByteSwap32(temptest->PMUcounter);
  temptest->CTcounter = ByteSwap32(temptest->CTcounter);
  temptest->MDPclock = ByteSwap32(temptest->MDPclock);
  temptest->v = ByteSwap16(temptest->v);
  temptest->x0 = ByteSwap16(temptest->x0);
  temptest->x1 = ByteSwap16(temptest->x1);
  temptest->y0 = ByteSwap16(temptest->y0);
  temptest->y1 = ByteSwap16(temptest->y1);
  temptest->cameraConfig = ByteSwap16(temptest->cameraConfig);
  temptest->dac = ByteSwap16(temptest->dac);
  temptest->roiStart = ByteSwap16(temptest->roiStart);
  temptest->roiStop = ByteSwap16(temptest->roiStop);
  temptest->woff = ByteSwap16(temptest->woff);

}

void SPinfoPMUset_fix (SPinfoPMUset *temptest)
{
  short tempshort = 0;
  short tempshort2= 0;

  tempshort = temptest->phase;
  tempshort = tempshort | (temptest->state)<<4;
  tempshort2 = tempshort & 0xF0;
  temptest->phase = tempshort2>>4;
  temptest->state = tempshort & 0xF;

  temptest->smconfig = ByteSwap16(temptest->smconfig);
  temptest->smstat0 = ByteSwap32(temptest->smstat0);
  temptest->smstat1 = ByteSwap32(temptest->smstat1);
  temptest->CTcounter = ByteSwap32(temptest->CTcounter);
  temptest->slitPosition = ByteSwap16(temptest->slitPosition);

}

void SPinfo_fix (SPinfo *temptest)
{
  temptest->n = ByteSwap16(temptest->n);
  temptest->PMUcounter = ByteSwap32(temptest->PMUcounter);
  temptest->CTcounter = ByteSwap32(temptest->CTcounter);
  temptest->MDPclock = ByteSwap32(temptest->MDPclock);
  temptest->v = ByteSwap16(temptest->v);
  temptest->slitPosition = ByteSwap16(temptest->slitPosition);
  temptest->spaceOffset = ByteSwap16(temptest->spaceOffset);
  temptest->nspace = ByteSwap16(temptest->nspace);
  temptest->cameraConfig = ByteSwap16(temptest->cameraConfig);
  temptest->dac = ByteSwap16(temptest->dac);
  temptest->gcuconfig = ByteSwap16(temptest->gcuconfig);

}

void FGinfoExpset_version0_fix (FGinfoExpset_version0 *temptest)
{
  short tempshort = 0;
  short tempshort2= 0;

  tempshort = temptest->phaseAtOpen;
  tempshort = tempshort | (temptest->phaseAtClose)<<4;
  tempshort2 = tempshort & 0xF0;
  temptest->phaseAtOpen = tempshort2>>4;
  temptest->phaseAtClose = tempshort & 0xF;

  temptest->smstat0 = ByteSwap32(temptest->smstat0);
  temptest->smstat1 = ByteSwap32(temptest->smstat1);
  temptest->shutterOpenTime = ByteSwap16(temptest->shutterOpenTime);
  temptest->shutterCloseTime = ByteSwap16(temptest->shutterCloseTime);
  temptest->CTatOpen = ByteSwap32(temptest->CTatOpen);
  temptest->CTatClose = ByteSwap32(temptest->CTatClose);
  temptest->CTatRdout = ByteSwap32(temptest->CTatRdout);
  temptest->smconfig = ByteSwap16(temptest->smconfig);

}

//command.h fixers
void IscanData_fix (IscanData *temptest)
{
  int ii = 0;
  unsigned temp;
  
  temptest->CTatOpen = ByteSwap32(temptest->CTatOpen);
  temptest->shutterOpenTime = ByteSwap32(temptest->shutterOpenTime);
  temptest->shutterCloseTime = ByteSwap32(temptest->shutterCloseTime);
  temptest->woff = ByteSwap16(temptest->woff);
  temp = temptest->phaseAtClose;
  temptest->phaseAtClose = temptest->phaseAtOpen;
  temptest->phaseAtOpen = temp;
  for (ii=0; ii<2; ii++)
  {
    temptest->sums[ii] = ByteSwap32(temptest->sums[ii]);
  }
  for (ii=0; ii<8; ii++)
  {
    temptest->therm[ii] = ByteSwap16(temptest->therm[ii]);
  }
  for (ii=0; ii<8; ii++)
  {
    temptest->eltemp[ii] = ByteSwap16(temptest->eltemp[ii]);
  }
}

void Iscan_data_info_fix (Iscan_data_info *temptest)
{
  temptest->packet_time = ByteSwap32(temptest->packet_time);
  temptest->wcorr = ByteSwap16(temptest->wcorr);
  temptest->nwave = ByteSwap32(temptest->nwave);
  temptest->gcuconfig = ByteSwap16(temptest->gcuconfig);
}

void IscanPacketHeader_fix (IscanPacketHeader *temptest)
{
  packet_info_fix( (packet_info *)&temptest->info );
  Iscan_data_info_fix( (Iscan_data_info *)&temptest->data);
}

void DIAGpacket_data_info_fix (DIAGpacket_data_info *temptest)
{
  int ii = 0;

  temptest->packet_time = ByteSwap32(temptest->packet_time);
  temptest->start_time = ByteSwap32(temptest->start_time);
  temptest->startCTcounter = ByteSwap32(temptest->startCTcounter);
  temptest->ntimes = ByteSwap32(temptest->ntimes);
  for (ii=0; ii<16; ii++)
  {
    temptest->devices[ii] = ByteSwap16(temptest->devices[ii]);
  }
  temptest->gcuconfig = ByteSwap16(temptest->gcuconfig);
}

void DIAGpacketHeader_fix (DIAGpacketHeader *temptest)
{
  packet_info_fix( (packet_info *)&temptest->info );
  //printf("here is the id ==> %d\n", temptest->info.subIdProduct);
  if (temptest->info.subIdProduct == DPC_ANALOG_DUMP)
  {  
    DIAGpacket_data_info_fix( (DIAGpacket_data_info *)&temptest->data);
  }
  else if (temptest->info.subIdProduct == DPC_FG_ENGG_FR)
  {
    Iscan_data_info_fix( (Iscan_data_info *)&temptest->data);
  }
  else
  {
    CTpacket_data_info_fix( (CTpacket_data_info *)&temptest->data);
  }
}

void CTpacket_data_info_fix (CTpacket_data_info *temptest)
{
  int ii=0;

  temptest->packet_time = ByteSwap32(temptest->packet_time);
  temptest->RefFrmCnt = ByteSwap16(temptest->RefFrmCnt);
  temptest->CTFrmNum = ByteSwap16(temptest->CTFrmNum);
  for (ii=0; ii<13; ii++)
  {
    temptest->sums[ii] = ByteSwap16(temptest->sums[ii]);
  }
  temptest->CTmode = ByteSwap16(temptest->CTmode);
  temptest->CTMAD = ByteSwap16(temptest->CTMAD);
  temptest->CTmeanCurrent = ByteSwap16(temptest->CTmeanCurrent);
  temptest->CTmeanNext = ByteSwap16(temptest->CTmeanNext);
  temptest->ref_count = ByteSwap16(temptest->ref_count);
  temptest->CTstatus = ByteSwap16(temptest->CTstatus);
  temptest->LiveErrX = ByteSwap16(temptest->LiveErrX);
  temptest->LiveErrY = ByteSwap16(temptest->LiveErrY);
  temptest->CTMEstatus = ByteSwap16(temptest->CTMEstatus);
  temptest->CTMEangleX = ByteSwap16(temptest->CTMEangleX);
  temptest->CTMEangleY = ByteSwap16(temptest->CTMEangleY);
  temptest->jitter_count = ByteSwap16(temptest->jitter_count);
  temptest->CTfn_write = ByteSwap16(temptest->CTfn_write);
  temptest->focus = ByteSwap16(temptest->focus);

}

void CTpacketHeader_fix (CTpacketHeader *temptest)
{
  packet_info_fix( (packet_info *)&temptest->info );
  CTpacket_data_info_fix((CTpacket_data_info *)&temptest->data);
}

void data_info_fix (data_info *temptest)
{
  temptest->packet_time = ByteSwap32(temptest->packet_time);

}

void PacketHeader_fix (PacketHeader *temptest)
{
  packet_info_fix( (packet_info *)&temptest->info );
  data_info_fix( (data_info *)&temptest->data);

}

void packet_info_fix (packet_info *temptest)
{
  short tempshort=0;
  short tempshort2=0;

  temptest->serial_no = ByteSwap32(temptest->serial_no);

  temptest->id = ByteSwap16(temptest->id);

  tempshort = temptest->main_seq_flag;
  tempshort = tempshort | (temptest->main_seq_count)<<2;
  tempshort = ByteSwap16(tempshort);
  tempshort2 = tempshort & 0xC000;
  temptest->main_seq_flag = tempshort2>>14;
  temptest->main_seq_count = tempshort & 0x3FFF;
  

  tempshort = 0;
  tempshort = temptest->reserved;
  tempshort = tempshort | (temptest->num_packets)<<2;
  tempshort = tempshort | (temptest->num_frames)<<10;
  tempshort = ByteSwap16(tempshort);
  tempshort2 = tempshort & 0xC000;
  temptest->reserved = tempshort2>>14;
  tempshort2 = tempshort & 0x3FC0;
  temptest->num_packets = tempshort2>>6; 
  temptest->num_frames = tempshort & 0x3F;

  tempshort = 0;
  tempshort = temptest->subIdHdr;
  tempshort = tempshort | (temptest->subIdCCDseg)<<1;
  tempshort = tempshort | (temptest->subIdAmpA)<<2;
  tempshort = tempshort | (temptest->subIdAmpB)<<3;
  tempshort = tempshort | (temptest->subIdSumMode)<<4;
  tempshort = tempshort | (temptest->subIdFGtype)<<6;
  tempshort = tempshort | (temptest->subIdShutterless)<<7;
//  tempshort = ByteSwap16(tempshort);
  tempshort2 = tempshort & 0x80;
  temptest->subIdHdr = tempshort2>>7;
  tempshort2 = tempshort & 0x40;
  temptest->subIdCCDseg = tempshort2>>6;
  tempshort2 = tempshort & 0x20;
  temptest->subIdAmpA = tempshort2>>5;
  tempshort2 = tempshort & 0x10;
  temptest->subIdAmpB = tempshort2>>4;
  tempshort2 = tempshort & 0xC;
  temptest->subIdSumMode = tempshort2>>2;
  tempshort2 = tempshort & 0x2;
  temptest->subIdFGtype = tempshort2>>1;
  temptest->subIdShutterless = tempshort & 0x1;
  tempshort = 0;
  tempshort = temptest->subIdSpare;
  tempshort = tempshort | (temptest->subIdProduct)<<3;
  tempshort2 = tempshort & 0xE0;
  temptest->subIdSpare = tempshort2>>5;
  temptest->subIdProduct = tempshort & 0x1F;

  tempshort = 0;
  tempshort = temptest->sub_seq_flag;
  tempshort = tempshort | (temptest->sub_seq_count)<<2;
  tempshort = ByteSwap16(tempshort);
  tempshort2 = tempshort & 0xC000;
  temptest->sub_seq_flag = tempshort2>>14;
  temptest->sub_seq_count = tempshort & 0x3FFF;

  temptest->nx = ByteSwap16(temptest->nx);

  temptest->ny = ByteSwap16(temptest->ny);

  temptest->x0 = ByteSwap16(temptest->x0);

  temptest->y0 = ByteSwap16(temptest->y0);

  temptest->nxp = ByteSwap16(temptest->nxp);

  temptest->nyp = ByteSwap16(temptest->nyp);

  tempshort = 0;
  tempshort = temptest->reserved_1;
  tempshort = tempshort | (temptest->bit_compression_mode)<<1;
  tempshort = tempshort | (temptest->image_compression_mode)<<5;
//  tempshort = ByteSwap16(tempshort);
  tempshort2 = tempshort & 0x80;
  temptest->reserved_1 = tempshort2>>7;
  tempshort2 = tempshort & 0x78;
  temptest->bit_compression_mode = tempshort2>>3;
  temptest->image_compression_mode = tempshort & 0x7;
  tempshort = 0;
  tempshort = temptest->reserved_2;
  tempshort = tempshort | (temptest->huffman_ac)<<1;
  tempshort = tempshort | (temptest->huffman_dc)<<3;
  tempshort = tempshort | (temptest->quantization)<<5;
  tempshort2 = tempshort & 0x80;
  temptest->reserved_2 = tempshort2>>7;
  tempshort2 = tempshort & 0x60;
  temptest->huffman_ac = tempshort2>>5;
  tempshort2 = tempshort & 0x18;
  temptest->huffman_dc = tempshort2>>3;
  temptest->quantization = tempshort & 0x7;

}

void flt_op_parameters_fix (flt_op_parameters *temptest)
{
  short tempshort = 0;
  short tempshort2= 0;

  tempshort = temptest->wave;
  tempshort = tempshort | (temptest->wave_off)<<5;
  tempshort = ByteSwap16(tempshort);
  tempshort2 = tempshort & 0xF800;
  temptest->wave = tempshort2>>11;
  temptest->wave_off = tempshort & 0x7FF;

  tempshort = 0;
  tempshort = temptest->exp;
  tempshort = tempshort | (temptest->dark_flag)<<15;
  tempshort = ByteSwap16(tempshort);
  tempshort2 = tempshort & 0xFFFE;
  temptest->exp = tempshort2>>1;
  temptest->dark_flag = tempshort & 0x1;

  tempshort = 0;
  tempshort = temptest->wscan_npos;
  tempshort = tempshort | (temptest->wscan_step)<<5;
  tempshort = ByteSwap16(tempshort);
  tempshort2 = tempshort & 0xF800;
  temptest->wscan_npos = tempshort2>>11;
  temptest->wscan_step = tempshort & 0x7FF;

}

void spp_op_parameters_fix (spp_op_parameters *temptest)
{
  short tempshort = 0;
  short tempshort2= 0;

  tempshort = temptest->bin_slit;
  tempshort = tempshort | (temptest->scan_step)<<2;
  tempshort = tempshort | (temptest->scan_sum)<<10;
  tempshort = tempshort | (temptest->repeat_flag)<<11;
  tempshort = tempshort | (temptest->extract_table)<<12;
  tempshort = ByteSwap16(tempshort);
  tempshort2 = tempshort & 0xC000;
  temptest->bin_slit = tempshort2>>14;
  tempshort2 = tempshort & 0x3FC0;
  temptest->scan_step = tempshort2>>6;
  tempshort2 = tempshort & 0x20;
  temptest->scan_sum = tempshort2>>5;
  tempshort2 = tempshort & 0x10;
  temptest->repeat_flag = tempshort2>>4;
  temptest->extract_table = tempshort & 0xF;

  tempshort = 0;
  tempshort = temptest->slit_positions;
  tempshort = tempshort | (temptest->CCD_size)<<11;
  tempshort = tempshort | (temptest->cycles)<<12;
  tempshort = ByteSwap16(tempshort);
  tempshort2 = tempshort & 0xFFE0;
  temptest->slit_positions = tempshort2>>5;
  tempshort2 = tempshort & 0x10;
  temptest->CCD_size = tempshort2>>4;
  temptest->cycles = tempshort & 0xF;

  tempshort = 0;
  tempshort = temptest->bad_pixel;
  tempshort = tempshort | (temptest->tt_reset)<<1;
  tempshort = tempshort | (temptest->sparebits)<<2;
  tempshort = ByteSwap16(tempshort);
  tempshort2 = tempshort & 0x8000;
  temptest->bad_pixel = tempshort2>>15;
  tempshort2 = tempshort & 0x4000;
  temptest->tt_reset = tempshort2>>14;
  temptest->sparebits = tempshort & 0x3FFF;

}

void ext_reg_parameters_fix (ext_reg_parameters *temptest)
{
  temptest->center_col = ByteSwap16(temptest->center_col);
  temptest->center_row = ByteSwap16(temptest->center_row);

}

void map_reg_parameters_fix (map_reg_parameters *temptest)
{
  temptest->map_center = ByteSwap16(temptest->map_center);
  temptest->spare = ByteSwap16(temptest->spare);

}

void mdp_obs_table_fix (mdp_obs_table *temptest)
{
  temptest->obsProgramVer = ByteSwap16(temptest->obsProgramVer);
  temptest->seqTableVer = ByteSwap16(temptest->seqTableVer);
  temptest->parameterTableVer = ByteSwap16(temptest->parameterTableVer);
  temptest->reserved1 = ByteSwap16(temptest->reserved1);
}

void fg_macro_command_fix (fg_macro_command *temptest)
{
  short tempshort = 0;
  short tempshort2= 0;

  temptest->main_id = ByteSwap16(temptest->main_id);

  tempshort = temptest->c1_reserved_1;
  tempshort = tempshort | (temptest->c1_bit_compression_mode)<<1;
  tempshort = tempshort | (temptest->c1_image_compression_mode)<<5;
//  tempshort = ByteSwap16(tempshort);
  tempshort2 = tempshort & 0x80;
  temptest->c1_reserved_1 = tempshort2>>7;
  tempshort2 = tempshort & 0x78;
  temptest->c1_bit_compression_mode = tempshort2>>3;
  temptest->c1_image_compression_mode = tempshort & 0x7;
  tempshort = 0;
  tempshort = temptest->c1_reserved_2;
  tempshort = tempshort | (temptest->c1_huffman_ac)<<1;
  tempshort = tempshort | (temptest->c1_huffman_dc)<<3;
  tempshort = tempshort | (temptest->c1_quantization)<<5;
  tempshort2 = tempshort & 0x80;
  temptest->c1_reserved_2 = tempshort2>>7;
  tempshort2 = tempshort & 0x60;
  temptest->c1_huffman_ac = tempshort2>>5;
  tempshort2 = tempshort & 0x18;
  temptest->c1_huffman_dc = tempshort2>>3;
  temptest->c1_quantization = tempshort & 0x7;

  tempshort = temptest->c2_reserved_1;
  tempshort = tempshort | (temptest->c2_bit_compression_mode)<<1;
  tempshort = tempshort | (temptest->c2_image_compression_mode)<<5;
//  tempshort = ByteSwap16(tempshort);
  tempshort2 = tempshort & 0x80;
  temptest->c2_reserved_1 = tempshort2>>7;
  tempshort2 = tempshort & 0x78;
  temptest->c2_bit_compression_mode = tempshort2>>3;
  temptest->c2_image_compression_mode = tempshort & 0x7;
  tempshort = 0;
  tempshort = temptest->c2_reserved_2;
  tempshort = tempshort | (temptest->c2_huffman_ac)<<1;
  tempshort = tempshort | (temptest->c2_huffman_dc)<<3;
  tempshort = tempshort | (temptest->c2_quantization)<<5;
  tempshort2 = tempshort & 0x80;
  temptest->c2_reserved_2 = tempshort2>>7;
  tempshort2 = tempshort & 0x60;
  temptest->c2_huffman_ac = tempshort2>>5;
  tempshort2 = tempshort & 0x18;
  temptest->c2_huffman_dc = tempshort2>>3;
  temptest->c2_quantization = tempshort & 0x7;

  flt_op_parameters_fix( (flt_op_parameters *)&temptest->parameters);
  ext_reg_parameters_fix( (ext_reg_parameters *)&temptest->ext_reg);
  mdp_obs_table_fix( (mdp_obs_table *)&temptest->mdp_obs);

}

void sp_macro_command_fix (sp_macro_command *temptest)
{
  short tempshort = 0;
  short tempshort2= 0;

  temptest->main_id = ByteSwap16(temptest->main_id);

  tempshort = temptest->c1_reserved_1;
  tempshort = tempshort | (temptest->c1_bit_compression_mode)<<1;
  tempshort = tempshort | (temptest->c1_image_compression_mode)<<5;
//  tempshort = ByteSwap16(tempshort);
  tempshort2 = tempshort & 0x80;
  temptest->c1_reserved_1 = tempshort2>>7;
  tempshort2 = tempshort & 0x78;
  temptest->c1_bit_compression_mode = tempshort2>>3;
  temptest->c1_image_compression_mode = tempshort & 0x7;
  tempshort = 0;
  tempshort = temptest->c1_reserved_2;
  tempshort = tempshort | (temptest->c1_huffman_ac)<<1;
  tempshort = tempshort | (temptest->c1_huffman_dc)<<3;
  tempshort = tempshort | (temptest->c1_quantization)<<5;
  tempshort2 = tempshort & 0x80;
  temptest->c1_reserved_2 = tempshort2>>7;
  tempshort2 = tempshort & 0x60;
  temptest->c1_huffman_ac = tempshort2>>5;
  tempshort2 = tempshort & 0x18;
  temptest->c1_huffman_dc = tempshort2>>3;
  temptest->c1_quantization = tempshort & 0x7;

  tempshort = temptest->c2_reserved_1;
  tempshort = tempshort | (temptest->c2_bit_compression_mode)<<1;
  tempshort = tempshort | (temptest->c2_image_compression_mode)<<5;
//  tempshort = ByteSwap16(tempshort);
  tempshort2 = tempshort & 0x80;
  temptest->c2_reserved_1 = tempshort2>>7;
  tempshort2 = tempshort & 0x78;
  temptest->c2_bit_compression_mode = tempshort2>>3;
  temptest->c2_image_compression_mode = tempshort & 0x7;
  tempshort = 0;
  tempshort = temptest->c2_reserved_2;
  tempshort = tempshort | (temptest->c2_huffman_ac)<<1;
  tempshort = tempshort | (temptest->c2_huffman_dc)<<3;
  tempshort = tempshort | (temptest->c2_quantization)<<5;
  tempshort2 = tempshort & 0x80;
  temptest->c2_reserved_2 = tempshort2>>7;
  tempshort2 = tempshort & 0x60;
  temptest->c2_huffman_ac = tempshort2>>5;
  tempshort2 = tempshort & 0x18;
  temptest->c2_huffman_dc = tempshort2>>3;
  temptest->c2_quantization = tempshort & 0x7;

  spp_op_parameters_fix( (spp_op_parameters *)&temptest->parameters);
  map_reg_parameters_fix( (map_reg_parameters *)&temptest->map_reg);
  mdp_obs_table_fix( (mdp_obs_table *)&temptest->mdp_obs);

}

void macro_command_fix (macro_command *temptest)
{
  sp_macro_command_fix( (sp_macro_command *)&temptest->sp);
  fg_macro_command_fix( (fg_macro_command *)&temptest->fg);

}

void mmstat2_fix (struct MMSTAT2 *temptest)
{
  int ii=0;

  temptest->DevStat = ByteSwap32(temptest->DevStat);
  for (ii=0; ii<2; ii++)
  {
    temptest->LM_DevPos[ii] = ByteSwap16(temptest->LM_DevPos[ii]);
    temptest->ExpDur[ii] = ByteSwap16(temptest->ExpDur[ii]);
  }
}

void xrt_packet_info_fix (XRTpacket_info *temptest)
{
  short tempshort=0;
  short tempshort2=0;

  temptest->serial_no = ByteSwap32(temptest->serial_no);

  temptest->id = ByteSwap16(temptest->id);

  tempshort = temptest->main_seq_flag;
  tempshort = tempshort | (temptest->main_seq_count)<<2;
  tempshort = ByteSwap16(tempshort);
  tempshort2 = tempshort & 0xC000;
  temptest->main_seq_flag = tempshort2>>14;
  temptest->main_seq_count = tempshort & 0x3FFF;
  

  tempshort = 0;
  tempshort = temptest->reserved;
  tempshort = tempshort | (temptest->num_packets)<<2;
  tempshort = tempshort | (temptest->num_frames)<<10;
  tempshort = ByteSwap16(tempshort);
  tempshort2 = tempshort & 0xC000;
  temptest->reserved = tempshort2>>14;
  tempshort2 = tempshort & 0x3FC0;
  temptest->num_packets = tempshort2>>6; 
  temptest->num_frames = tempshort & 0x3F;

  //This is put in temporarily
  //When we find out what XRTsubID actually stands
  //for, we will uncomment the lower part and modify it
  //as needed.
  temptest->XRTsubID = ByteSwap16(temptest->XRTsubID);
  /*
  tempshort = 0;
  tempshort = temptest->subIdHdr;
  tempshort = tempshort | (temptest->subIdCCDseg)<<1;
  tempshort = tempshort | (temptest->subIdAmpA)<<2;
  tempshort = tempshort | (temptest->subIdAmpB)<<3;
  tempshort = tempshort | (temptest->subIdSumMode)<<4;
  tempshort = tempshort | (temptest->subIdFGtype)<<6;
  tempshort = tempshort | (temptest->subIdShutterless)<<7;
  tempshort2 = tempshort & 0x80;
  temptest->subIdHdr = tempshort2>>7;
  tempshort2 = tempshort & 0x40;
  temptest->subIdCCDseg = tempshort2>>6;
  tempshort2 = tempshort & 0x20;
  temptest->subIdAmpA = tempshort2>>5;
  tempshort2 = tempshort & 0x10;
  temptest->subIdAmpB = tempshort2>>4;
  tempshort2 = tempshort & 0xC;
  temptest->subIdSumMode = tempshort2>>2;
  tempshort2 = tempshort & 0x2;
  temptest->subIdFGtype = tempshort2>>1;
  temptest->subIdShutterless = tempshort & 0x1;
  tempshort = 0;
  tempshort = temptest->subIdSpare;
  tempshort = tempshort | (temptest->subIdProduct)<<3;
  tempshort2 = tempshort & 0xE0;
  temptest->subIdSpare = tempshort2>>5;
  temptest->subIdProduct = tempshort & 0x1F;
  */

  tempshort = 0;
  tempshort = temptest->sub_seq_flag;
  tempshort = tempshort | (temptest->sub_seq_count)<<2;
  tempshort = ByteSwap16(tempshort);
  tempshort2 = tempshort & 0xC000;
  temptest->sub_seq_flag = tempshort2>>14;
  temptest->sub_seq_count = tempshort & 0x3FFF;

  temptest->nx = ByteSwap16(temptest->nx);

  temptest->ny = ByteSwap16(temptest->ny);

  temptest->x0 = ByteSwap16(temptest->x0);

  temptest->y0 = ByteSwap16(temptest->y0);

  temptest->nxp = ByteSwap16(temptest->nxp);

  temptest->nyp = ByteSwap16(temptest->nyp);

  tempshort = 0;
  tempshort = temptest->reserved_1;
  tempshort = tempshort | (temptest->bit_compression_mode)<<1;
  tempshort = tempshort | (temptest->image_compression_mode)<<5;
  tempshort2 = tempshort & 0x80;
  temptest->reserved_1 = tempshort2>>7;
  tempshort2 = tempshort & 0x78;
  temptest->bit_compression_mode = tempshort2>>3;
  temptest->image_compression_mode = tempshort & 0x7;
  tempshort = 0;
  tempshort = temptest->reserved_2;
  tempshort = tempshort | (temptest->huffman_ac)<<1;
  tempshort = tempshort | (temptest->huffman_dc)<<3;
  tempshort = tempshort | (temptest->quantization)<<5;
  tempshort2 = tempshort & 0x80;
  temptest->reserved_2 = tempshort2>>7;
  tempshort2 = tempshort & 0x60;
  temptest->huffman_ac = tempshort2>>5;
  tempshort2 = tempshort & 0x18;
  temptest->huffman_dc = tempshort2>>3;
  temptest->quantization = tempshort & 0x7;
}

void xrt_mdp_info_fix (xrt_mdp_info *temptest)
{
  short tempshort=0;
  short tempshort2=0;

  tempshort = temptest->imageMode;
  tempshort = tempshort | (temptest->AECflag)<<2;
  tempshort = tempshort | (temptest->AECnum)<<3;
  tempshort = tempshort | (temptest->AECresult)<<4;
  tempshort2 = tempshort & 0xC0;
  temptest->imageMode = tempshort2>>6;
  tempshort2 = tempshort & 0x20;
  temptest->AECflag = tempshort2>>5;
  tempshort2 = tempshort & 0x10;
  temptest->AECnum = tempshort2>>4;
  temptest->AECresult = tempshort & 0xF;
}

void xrt_packet_data_info_fix (XRTpacket_data_info *temptest)
{
  short tempshort=0;
  short tempshort2=0;

  tempshort = temptest->xrte_unused_a;
  tempshort = tempshort | (temptest->xrte_cal_info)<<3;
  tempshort = tempshort | (temptest->xrte_chip_sum)<<4;
  tempshort2 = tempshort & 0xE0;
  temptest->xrte_unused_a = tempshort2>>5;
  tempshort2 = tempshort & 0x10;
  temptest->xrte_cal_info = tempshort2>>4;
  temptest->xrte_chip_sum = tempshort & 0xF;

  tempshort=0;
  tempshort2=0;
  tempshort = temptest->xrte_unused_b;
  tempshort = tempshort | (temptest->xrte_roi_h_size)<<2;
  tempshort2 = tempshort & 0xC0;
  temptest->xrte_unused_b = tempshort2>>6;
  temptest->xrte_roi_h_size = tempshort & 0x3F;

  tempshort=0;
  tempshort2=0;
  tempshort = temptest->xrte_unused_c;
  tempshort = tempshort | (temptest->xrte_roi_v_size)<<2;
  tempshort2 = tempshort & 0xC0;
  temptest->xrte_unused_c = tempshort2>>6;
  temptest->xrte_roi_v_size = tempshort & 0x3F;

  tempshort=0;
  tempshort2=0;
  tempshort = temptest->xrte_unused_d;
  tempshort = tempshort | (temptest->xrte_ccd_read_port)<<7;
  tempshort2 = tempshort & 0xFE;
  temptest->xrte_unused_d = tempshort2>>7;
  temptest->xrte_ccd_read_port = tempshort & 0x1;

  temptest->ec_id = ByteSwap16(temptest->ec_id);

  tempshort=0;
  tempshort2=0;
  tempshort = temptest->ec_eindex;
  tempshort = tempshort | (temptest->ec_cd_mode)<<6;
  tempshort = tempshort | (temptest->ec_imtype)<<7;
  tempshort2 = tempshort & 0xFC;
  temptest->ec_eindex = tempshort2>>2;
  tempshort2 = tempshort & 0x2;
  temptest->ec_cd_mode = tempshort2>>1;
  temptest->ec_imtype = tempshort & 0x1;

  tempshort=0;
  tempshort2=0;
  tempshort = temptest->ec_fw1;
  tempshort = tempshort | (temptest->ec_fw2)<<3;
  tempshort = tempshort | (temptest->ec_vl)<<6;
  tempshort = tempshort | (temptest->ec_reserve)<<7;
  tempshort2 = tempshort & 0xE0;
  temptest->ec_fw1 = tempshort2>>5;
  tempshort2 = tempshort & 0x1C;
  temptest->ec_fw2 = tempshort2>>2;
  tempshort2 = tempshort & 0x2;
  temptest->ec_vl = tempshort2>>1;
  temptest->ec_reserve = tempshort & 0x1;

  tempshort=0;
  tempshort2=0;
  tempshort = temptest->e_wait_a;
  tempshort = tempshort | (temptest->e_wait_b)<<1;
  tempshort = tempshort | (temptest->e_wait_c)<<2;
  tempshort = tempshort | (temptest->e_wait_cw)<<3;
  tempshort = tempshort | (temptest->e_wait_ccw)<<4;
  tempshort = tempshort | (temptest->e_vlo)<<5;
  tempshort = tempshort | (temptest->e_vlc)<<6;
  tempshort = tempshort | (temptest->e_sh_cmd_err)<<7;
  tempshort2 = tempshort & 0x80;
  temptest->e_wait_a = tempshort2>>7;
  tempshort2 = tempshort & 0x40;
  temptest->e_wait_b = tempshort2>>6;
  tempshort2 = tempshort & 0x20;
  temptest->e_wait_c = tempshort2>>5;
  tempshort2 = tempshort & 0x10;
  temptest->e_wait_cw = tempshort2>>4;
  tempshort2 = tempshort & 0x8;
  temptest->e_wait_ccw = tempshort2>>3;
  tempshort2 = tempshort & 0x4;
  temptest->e_vlo = tempshort2>>2;
  tempshort2 = tempshort & 0x2;
  temptest->e_vlc = tempshort2>>1;
  temptest->e_sh_cmd_err = tempshort & 0x1;

  tempshort=0;
  tempshort2=0;
  tempshort = temptest->e_fw1_stat;
  tempshort = tempshort | (temptest->e_fw1_reserve)<<6;
  tempshort2 = tempshort & 0xFC;
  temptest->e_fw1_stat = tempshort2>>2;
  temptest->e_fw1_reserve = tempshort & 0x3;
  
  tempshort=0;
  tempshort2=0;
  tempshort = temptest->e_fw2_stat;
  tempshort = tempshort | (temptest->e_exptime_e)<<6;
  tempshort2 = tempshort & 0xFC;
  temptest->e_fw2_stat = tempshort2>>2;
  temptest->e_exptime_e = tempshort & 0x3;

  tempshort=0;
  tempshort2=0;
  tempshort = temptest->e_ttn;
  tempshort = tempshort | (temptest->e_ttn_reserved)<<4;
  tempshort2 = tempshort & 0xF0;
  temptest->e_ttn = tempshort2>>4;
  temptest->e_ttn_reserved = tempshort & 0xF;
}

void XRTpacketHeader_fix (XRTpacketHeader *temptest)
{
  xrt_packet_info_fix( (XRTpacket_info *)&temptest->info);
  xrt_packet_data_info_fix( (XRTpacket_data_info *)&temptest->data);
}
