/* a home for the getfiles calls and other file related functions */
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>
#include <math.h>
#include <sys/param.h>
#include <sys/mount.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <regex.h>
#if __sgi
#include <sys/statfs.h>
#endif
#if defined(LINUX)
#include <sys/vfs.h>
#endif
#if defined(SOLARIS)
#include <limits.h>
#include <sys/statvfs.h>
#endif
#if __FreeBSD__
#include <sys/dir.h>
#else
#include  <dirent.h>
#endif
#if __APPLE__
/* the G5's have 64 bit file stuff by default */
#define off64_t off_t
#define stat64 stat
#define lstat64 lstat
#endif
 int	nfiles, match_flag, max, recursive_flag;
 char	**pfiles;
 regex_t re;
 extern int errno;
 /*------------------------------------------------------------------------- */
void sort_s(n,ra)
  /* sort a herd of strings */
  /* just moves the pointers around */
  int n;
  char * ra[];
{
  int l,j,ir,i;
  char * rra;
  l = (n/2);
  ir = n-1;
  for (;;) {
    if (l > 0)
      rra = ra[--l];
    else {
      rra = ra[ir];
      ra[ir] = ra[0];
      if (--ir == 0) {
        ra[0] = rra;
        return;
      }
    }
    i = l;
    j = l + l + 1;
    while (j <= ir) {
      if (j < ir && strcmp(ra[j],ra[j+1]) < 0 ) j++;
      if (strcmp(rra, ra[j]) < 0) {
        ra[i] = ra[j];
        j += (i=j) + 1;
      }
      else j = ir + 1;
    }
    ra[i] = rra;
  }
}
/*------------------------------------------------------------------------- */
off64_t filesize64(name)	/* return size of a file */
 char *name;
 /* filesize('name')   returns size of file in bytes */
 {
 off64_t	i = 0;
 struct stat64 statbuf;
 //printf("name in filesize64: %s\n", name);
 if( stat64(name, &statbuf)) { perror("stat"); return 0; }
 i = statbuf.st_size;
 return i;
 }
 /*------------------------------------------------------------------------- */
long filesize(name)	/* return size of a file */
 char *name;
 /* filesize('name')   returns size of file in bytes */
 {
 long	i = 0;
 struct stat statbuf;
 printf("name in filesize: %s\n", name);
 if( stat(name, &statbuf)) { perror("stat"); return 0; }
 i = statbuf.st_size;
 printf("statbuf.st_size = %d\n", statbuf.st_size);
 printf("statbuf.st_blocks = %d\n", statbuf.st_blocks);
 return i;
 }
 /*------------------------------------------------------------------------- */
void extraSlashRemove(char *dir_name)
 /* remove any double slashes in place, does not malloc a new copy
 but changes the end if double slashes are found */
 {
  char *p = dir_name;
  char *q = dir_name;
  while (*p) {
    if (q != p) *q = *p;
    q++;
    if (*p++ =='/') while (*p == '/')  p++;
  }
  *q = NULL;
  return;
 }
 /*------------------------------------------------------------------------- */
int file_get(char *startpath)
 {
 int	mq, iq, matches;
 char	*sq, **p;
 struct stat statbuf;
 DIR	*dirp;
 struct	dirent	*dp;
 int	add_slash = 0, path_size = strlen(startpath), name_size;

 p = pfiles;
 dirp = opendir(startpath);	  /* open directory */
 if (!dirp) {  /* can't read directory or something, not found */
   printf("GETFILES - can't read directory: %s\n", startpath);
   /* closedir(dirp); */
   return 1; }

 while ((dp = readdir(dirp)) != NULL) {
  //printf("dp->d_name: %s\n", dp->d_name);
  if (strcmp(dp->d_name, ".") == 0) continue;
  if (strcmp(dp->d_name, "..") == 0) continue;

  /* we don't stat the file unless we have to, we have to if it is
  a potential match or if we are checking for sub-directories */

  /* are we matching to a regular expression ? */
  matches = 1;		/* everybody a match for get all case */
  if (match_flag) {
  /* apparently, check if we match */
  if(regexec(&re,dp->d_name,0,NULL,0)==0) matches = 1; else matches = 0;
  if (!matches && !recursive_flag) continue;
  }
  
  /* make a full path to file so we can stat it */
  
  if (startpath[path_size-1] != '/') add_slash = 1;
  mq = strlen(dp->d_name) + path_size + 2 + add_slash;
  sq = (char *) malloc(mq);
  /* put in a /, extras are OK if there was one already */
  strncpy(sq, startpath, path_size);
  if (add_slash) sq[path_size] = '/';
  name_size = strlen(dp->d_name);  /* the 1 forces a null at the end */
  strncpy(sq + path_size + add_slash, dp->d_name, name_size + 1);
  
  //printf("full name: %s\n", sq);
  /* printf("checking if %s is a regular file\n", sq); */
  if( stat(sq, &statbuf)) {
   printf("GETFILES - stat error for file: %s\n", sq);
  } else
  /* check if a directory */
  if ( recursive_flag && (statbuf.st_mode & S_IFMT) == S_IFDIR) {
   /* and call ourselves for the next level */
   if (file_get(sq) != 1) {  closedir(dirp);  return 1; }
  } else
  if ( matches && (statbuf.st_mode & S_IFMT) == S_IFREG) {
  nfiles++;
  /* printf("nfiles = %d\n", nfiles); */
  if (nfiles >= max) {
   nfiles--;
   printf("GETFILES - found too many files, max = %d\n", max);
   free(sq); break; }
  *p++ = sq;
  } else free(sq);
  }
 closedir(dirp);
 return 0;
 }
/*------------------------------------------------------------------------- */
int getfiles(char *startpath)
  /* get all file names in directory */
{
  int	ns, mq, iq, malloc_flag = 0, status;
  nfiles = 0;
  /* get space to store pointers to copies of names */
  mq = max * sizeof (char *);
  if ( (pfiles = (char **) malloc(mq)) == NULL ) {
    printf("GETFILES - malloc failure for names array pointer, max = %d\n",max);
    return 1; }


    status = file_get(startpath);
    if (status == 0) 
    {
      printf("nfiles = %d\n", nfiles);
      if (nfiles <= 0) { printf("GETFILES - no files found\n");  return 1; }
      /* Added this 'if' check since, if only one file is found, the sort
         function does not work correctly, and core dumps. Besides, if we only
         have one file, we don't need to sort. */
      if (nfiles > 1)
      {
        /* sort the names */
        sort_s(nfiles, pfiles);
      }
    } else status = 1;	/* error case */
    return status;
}
/*------------------------------------------------------------------------- */
int getmatchedfiles(char *path, char ***names, char *match, int nmax)
 {
 int	stat;
 /* portions taken from the ana file.c source, specialized for files
 containing *tf2.raw, this should obviously be changed if something else
 is used. */
 if (regcomp(&re, match, REG_NOSUB) ) {
 	printf("GETMATCHEDFILES - error in regular expression: %s\n", match);
	regfree(&re);
	return 1; }
 match_flag = 1;
 max = nmax;
 stat = getfiles(path);
 *names = pfiles;
 pfiles = NULL;
 match_flag = 0;
 regfree(&re);
 return nfiles;
 }
 /*------------------------------------------------------------------------- */
int mkdirpath(char *path)
 {
 /* will try to contruct any missing subdirectories in path, but
 first checks if everything is already done for a possible quick
 return. Hardwired for a 0775 mode. This first checks to see if the
 path already exists so we can return quickly for this common case.
 Then it navigates the entire path. A problem that showed up was
 that some path components are links and stay that way even when
 using lstat (maybe they were double links?). So if a component
 is a link, this code lets it pass as if it were a directory. */
 struct stat64 statbuf;
 int mode = 0775;
 int istat;
 //printf("mkdirpath gets: %s\n", path);
 if (path[0] == NULL) return 1;  /* no path to make? */
 errno = 0;
 
 istat = lstat64(path, &statbuf);
 if (istat) perror("mkdirpath");
 /* if all is OK, we just return and don't waste any more time */
 if (istat == 0) { /* printf("already there\n"); */ return 0;} else {
 /* we don't want to mess up path but we do make some temporary changes */
   char *p = path;
   while (*p == '/') p++;  /* skip any leading slashes */
   while (*p) {
     if ( *p == '/') {
       *p = NULL;
       /* first lstat up to here and create if it doesn't exist */
       printf("path so far: %s\n", path);
       if (lstat64(path, &statbuf)) {
         /* stat didn't like it, OK if ENOENT and then we mkdir */
	 if ((errno != ENOENT) || (mkdir(path, mode))) {
	   /* either not ENOENT or mkdir had a problem */
	   *p = '/';  return 1;
	 }
       } else {
         /* lstat was happy, this is OK as long as it was a directory */
	 if (! (S_ISDIR(statbuf.st_mode) || S_ISLNK(statbuf.st_mode))) {
	   /* not good */
	   printf("st_mode: %o\n", statbuf.st_mode);
	   printf("%s is not a directory\n", path); *p = '/';  return 1; }
       }
       *p = '/';
     }
     p++;
   }
 }
 return 0;
 }
 /*------------------------------------------------------------------------- */
