/* various HK (housekeeping) displays for dgui */
#include <stdarg.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <stdio.h>
#include <sys/stat.h>
#include <sys/errno.h>
#include <time.h>
#include <unistd.h>

#include "command.h"
#include "wrfits.h"
#include "reformat.h"
#include "HKformat.h"

 typedef	unsigned char byte;
 extern	int	gui_flag;
 extern void hexdump();
 extern int sdtp_flag;
 extern char *font1,  *font3,  *font4;
 char *fontsmall = {"-*-clean-medium-r-normal--12*"};
 char *fontsmaller = {"-*-clean-medium-r-normal--10*"};
 char linebuf[512];
 void showIscanInfo(IscanPacketHeader *isheader, char * pc, char *mctext, int genId);
#if linux
 typedef struct {
    unsigned	DMA4_op : 2; 
    unsigned	DMA4_scale : 1;
    unsigned	DMA3_op : 2;
    unsigned	DMA3_scale : 1;
    unsigned	DMA2_op : 2;
    unsigned	DMA2_scale : 1;
    unsigned	DMA1_op : 2;
    unsigned	DMA1_scale : 1;
    unsigned	DMA_rw : 1;
    unsigned	DMA_buffer_mode : 1;
    unsigned	DMA_unused : 2;
 } ConfigBits;
#else
 typedef struct {
    unsigned	DMA_unused : 2;
    unsigned	DMA_buffer_mode : 1;
    unsigned	DMA_rw : 1;
    unsigned	DMA1_scale : 1;
    unsigned	DMA1_op : 2;
    unsigned	DMA2_scale : 1;
    unsigned	DMA2_op : 2;
    unsigned	DMA3_scale : 1;
    unsigned	DMA3_op : 2;
    unsigned	DMA4_scale : 1;
    unsigned	DMA4_op : 2; 
 } ConfigBits;
#endif
 
 char *pmustatenames[] = { " OFF ", "SETUP", "SETP2", "PHAS","RUNA",
 	"RNBP","RUNB","RUNC","ENDA","ENDB","DONE","RNB2","SLIT","XXXX"};
 ConfigBits smbits;
 char dmacodes[] = "LC+-";
 char scratch[262144];	/* a large buffer for temporary strings */
 int nscratch = sizeof(scratch);
 /* copies of camera structures taken from CA_status.h */
 /* a combined status/config/mode for telemetry */
 typedef union {
#if linux
  struct {
  unsigned short	Mode       : 3;
  unsigned short	Notused2   : 1;
  unsigned short	PreAmp     : 1;
  unsigned short	Notused    : 1;
  unsigned short	Gain       : 2;
  unsigned short	SerSum     : 2;
  unsigned short   	ParSum     : 2;
  unsigned short	SerClk     : 1;
  unsigned short	Busy       : 1;
  unsigned short	Locked     : 1;
  unsigned short	BadCmd     : 1;
  } bits;
#else
  struct {
  unsigned short	BadCmd     : 1;
  unsigned short	Locked     : 1;
  unsigned short	Busy       : 1;
  unsigned short	SerClk     : 1;
  unsigned short   	ParSum     : 2;
  unsigned short	SerSum     : 2;
  unsigned short	Gain       : 2;
  unsigned short	Notused    : 1;
  unsigned short	PreAmp     : 1;
  unsigned short	Notused2   : 1;
  unsigned short	Mode       : 3;
  } bits;
#endif
  unsigned short   ui16;
 } CONFIG;

 /* the polynomial fits for the thermisters */
 float fpp_prt[3] = {-234.018,0.0481062,5.92147e-6};
 float fpp_therm[5] = {55.1553,-0.0972939,5.86025e-05,-1.73859e-08,1.88050e-12};
 float fpp_thermh[5] = {86.9055,-0.172802,0.000155522,-6.68942e-08,1.03972e-11};
 float fpp_therm1[5] = {91.1719,-0.112614,6.16461e-5,-1.76688e-8,1.81299e-12};
 float fpp_therm1h[6] = {134.795,-0.198212,0.000173163,-8.05994e-08,1.80131e-11,-1.52992e-15};
 float fpp_therm2[5] = {95.1978,-0.0857706,3.95607e-5,-9.54151e-9,8.77853e-13};
 float fpp_therm2h[6] = {120.005,-0.125771,8.21725e-05,-3.06172e-08,5.75007e-12,-4.25224e-16};
 int	nfpp_prt = sizeof(fpp_prt)/sizeof(float);
 int	nfpp_therm = sizeof(fpp_therm)/sizeof(float);
 int	nfpp_thermh = sizeof(fpp_thermh)/sizeof(float);
 int	nfpp_therm1 = sizeof(fpp_therm1)/sizeof(float);
 int	nfpp_therm1h = sizeof(fpp_therm1h)/sizeof(float);
 int	nfpp_therm2 = sizeof(fpp_therm2)/sizeof(float);
 int	nfpp_therm2h = sizeof(fpp_therm2h)/sizeof(float);
 /*--------------------------------------------------------------------------*/
char  *wave_value_string( i)
 /* similar to wave_id_string but jsut returns a 4 digit value for the wavelength */
 int	i;
 {
 char *q;
 q = (char *) malloc(64);	/* enough! */
 switch (i) {
  case BFI_NO_MOVE:
    sprintf(q, "-100 "); break;  /* a code for no move */
  case BFI_3883:
    sprintf(q, "3883 "); break;
  case BFI_3968:
    sprintf(q, "3968 "); break;
  case BFI_4305:
    sprintf(q, "4305 "); break;
  case BFI_4504:
    sprintf(q, "4504 "); break;
  case BFI_5550:
    sprintf(q, "5550 "); break;
  case BFI_6684:
    sprintf(q, "6684 "); break;
  case NFI_NO_MOVE:
    sprintf(q, "-200 "); break;  /* a code for no move */
  case NFI_5172:
    sprintf(q, "5172 "); break;
  case NFI_5250:
    sprintf(q, "5250 "); break;
  case NFI_5576:
    sprintf(q, "5576 "); break;
  case NFI_6302:
    sprintf(q, "6302 "); break;
  case NFI_6563:
    sprintf(q, "6563 "); break;
  case NFI_5896:
    sprintf(q, "5896 "); break;
  case NFI_6328:
    sprintf(q, "6328 "); break;
  case NFI_5430:
    sprintf(q, "5430 "); break;
  case NFI_5940:
    sprintf(q, "5940 "); break;
  case NFI_6117:
    sprintf(q, "6117 "); break;
  case NFI_5172BASE:
    sprintf(q, "5172b"); break;
  case NFI_5250BASE:
    sprintf(q, "5250b"); break;
  case NFI_5576BASE:
    sprintf(q, "5576b"); break;
  case NFI_6302BASE:
    sprintf(q, "6302b"); break;
  case NFI_6563BASE:
    sprintf(q, "6563b"); break;
  case NFI_5896BASE:
    sprintf(q, "5896b"); break;
  case NFI_6328BASE:
    sprintf(q, "6328b"); break;
  case NFI_5430BASE:
    sprintf(q, "5430b"); break;
  case NFI_5940BASE:
    sprintf(q, "5940b"); break;
  case NFI_6117BASE:
    sprintf(q, "6117b"); break;
  case FLT_SPARE2:
    sprintf(q, "-300"); break;
  default: 
    sprintf(q, "invalid wavelength code %d", i);
    break;
 }
 return q;
 /* don't forget to free q in the caller after copying it somehow */
 }
 /*--------------------------------------------------------------------------*/
int shexdump(p, n, buf, len)
 unsigned char	*p;
 char	*buf;
 int	n, len;
 {
 /* dump a set of bytes in hex format 16 per line */
 int	i;
 int	ns, nr, ntot;
 nr = len;
 for (i=0;i<n;i++) {
   if (i%20 == 0) {
   	if (i) { ns = snprintf(buf, nr, "\n"); if (ns < 0) goto reterror; buf+=ns; nr-=ns;} 
	ns = snprintf(buf, nr, "%4d:", i); if (ns < 0) goto reterror; buf+=ns; nr-=ns; }
   ns = snprintf(buf, nr, " %2x", *p++); if (ns < 0) goto reterror; buf+=ns; nr-=ns;
 }
 ns = snprintf(buf, nr, "\n");  if (ns < 0) goto reterror; buf+=ns; nr-=ns;
 ntot = len - nr;
 return ntot;
 reterror:  printf("status overflowed allocated buffer in shexdump\n");
 return -1;
 }
 /*--------------------------------------------------------------------------*/
int scutoff(char *buf, int nr)
 {
 /* just prints a division line */
 int	ns;
 ns = snprintf(buf, nr, "--------------------------------------------------------------------------------\n");
 return ns;
 }
 /*--------------------------------------------------------------------------*/
void cutoff()
 {
 /* just prints a division line */
  printf("------------------------------------------------------------------------------------------\n");
 }
/*--------------------------------------------------------------------------*/
int gethexfg(FGinfo *FGinfoHdr)
 {
 /* try to establish phase offset by looking at PMU motor positions */
 int	hex;
 hex = 999;
 return  hex;
 }
 /*--------------------------------------------------------------------------*/
int gethexsp(SPinfo *SPinfoHdr)
 {
 /* try to establish phase offset by looking at PMU motor positions */
 int	hex;
 hex = 999;
 return  hex;
 }
 /*--------------------------------------------------------------------------*/
void getFirstExposure(FGinfo *FGinfoHdr, float *et, float *edct, float *edct2,
	unsigned int *ctclose)
 {
 FGinfoExpset	FGexpBlock;
 FGinfoExpset_version0	FGexpBlock_v0;
 CONFIG  FGconfig;
 int	n, i, blocksize, iq;
 int	mode, ctbase, ctlast, dct, dct2;
 float	dt;
 char *buffer, *b, *buf, *p;
 int nbuf, ns, nr, dacA, dacB, psum, ssum;
 extern unsigned int	FGtime;

 p = (char *) FGinfoHdr;
 mode = FGinfoHdr->mode;
 //printf("mode = %d, version = %d\n", mode, FGinfoHdr->version);
 /* we return an exposure only if mode is not 0 */
 /* now the per exposure line up */
 p = (p + sizeof(FGinfo));
   if (mode) {
     /* as of 9/13/2003 we have another version with a different format for FGinfoExpset,
     so we need to check the version # here */
     switch (FGinfoHdr->version) {
      case 0: 
        //blocksize = sizeof(FGinfoExpset_version0);
        blocksize = 50;
	/* we want only the very first actual exposure here */
	   bcopy( p, &FGexpBlock_v0, blocksize);
#if linux
           FGinfoExpset_version0_fix( (FGinfoExpset_version0 *) &FGexpBlock_v0);
#endif
	   dt = (float) (FGexpBlock_v0.shutterCloseTime - FGexpBlock_v0.shutterOpenTime) * 0.004;
	   /* note that dt is in milliseconds */
	   dct = FGexpBlock_v0.CTatClose - FGexpBlock_v0.CTatOpen;
	   dct2 = FGexpBlock_v0.CTatRdout - FGexpBlock_v0.CTatOpen;
        break;
      case 1:      
        //blocksize = sizeof(FGinfoExpset);
        blocksize = 54;
	   bcopy( p, &FGexpBlock, blocksize);
#if linux
           FGinfoExpset_fix( (FGinfoExpset *) &FGexpBlock);
#endif
	   dt = (float) (FGexpBlock.shutterCloseTime - FGexpBlock.shutterOpenTime) * 0.004;
	   /* note that dt is in milliseconds */
	   dct = FGexpBlock.CTatClose - FGexpBlock.CTatOpen;
	   dct2 = FGexpBlock.CTatRdout - FGexpBlock.CTatOpen;
        break;
      default:
        dt = dct = dct2 = 0.0;
     }
    }
  *ctclose = FGexpBlock.CTatClose;
  *et = dt * 0.001;  /* convert dt to seconds */
  *edct = dct/580.;  /* convert edct to seconds, depends on exact time of CT ticks */
  *edct2 = dct2/580.;  /* also to seconds */
 }
 /*--------------------------------------------------------------------------*/
void getFirstShutterlessExposure(FGinfo *FGinfoHdr, unsigned int *ctStart, unsigned int *phaseStart)
 {
 FGinfoPMUset	FGpmuBlock;
 char *p;
 int	mode, n, blocksize;
 /* this assumes a shutterless */
 p = (char *) FGinfoHdr;
 mode = FGinfoHdr->mode;
 if (mode) { *ctStart = *phaseStart = 0;  return; }
 p = (p + sizeof(FGinfo));  /* into the FGpmuBlock zone */
 n = FGinfoHdr->n;
 blocksize = sizeof(FGinfoPMUset);  /* if we have a "good" size this will work */
 /* we want the third one, so ... */
 p = p + 2 * blocksize;
 bcopy( p, &FGpmuBlock, blocksize);
#if linux
        FGinfoPMUset_fix( (FGinfoPMUset *) &FGpmuBlock);
#endif
 *ctStart = FGpmuBlock.CTcounter;
 *phaseStart = FGpmuBlock.phase;
 return;
 }
 /*--------------------------------------------------------------------------*/
void showFGimageInfo(FGinfo *FGinfoHdr, char *mctext)
 {
 FGinfoPMUset	FGpmuBlock;
 FGinfoExpset	FGexpBlock;
 FGinfoExpset_version0	FGexpBlock_v0;
 CONFIG  FGconfig;
 int	n, i, blocksize, iq, j;
 int	mode, ctbase, ctlast, dct, dct2;
 float	dt;
 unsigned short smconfig;
 char	sms[16], *q2;
 char	text[256];
 char	*buffer, *b, *buf, *p;
 int	nbuf, ns, nr, dacA, dacB, psum, ssum;
 extern unsigned int	FGtime;
 extern	int	FGCCDixc, FGCCDiyc, mdumpFlag;
 extern FILE *mdumpFile;
 extern fg_macro_command  currentFGmacroCommand;  /* for a copy from packets */
 struct tm *gtest;

 p = (char *) FGinfoHdr;

 /* a trap to catch a v */
 /* don't need anymore, we found one at
 /net/solserv/home/fpptc/sdtp//2004_0313_162701_rt_temp.sci
 */
//  {
//    int	ic;
//    if (FGinfoHdr->v) {
//      printf("v = %d\n", FGinfoHdr->v);
//      /* force a pause */
//      printf("hit a key to go on\n");
//      ic = getchar();
//    }
//  }


 mode = FGinfoHdr->mode;
 //printf("mode = %d, version = %d\n", mode, FGinfoHdr->version);

 nr = nscratch;
   b = buf = scratch;

   if (mode) {
   ns = snprintf(b, nr, "FG data info: side %d, %d exposures, CCD (%d:%d,%d:%d), (%d,%d), v:%d\n",
     FGinfoHdr->side, FGinfoHdr->n, FGinfoHdr->x0,FGinfoHdr->x1,
     FGinfoHdr->y0,FGinfoHdr->y1, FGCCDixc, FGCCDiyc, FGinfoHdr->v);
   } else {
   ns = snprintf(b, nr, "FG data info: side %d, %d PMU phases, CCD (%d:%d,%d:%d), (%d,%d), cycles %d, v:%d\n",
     FGinfoHdr->side, FGinfoHdr->n, FGinfoHdr->x0,FGinfoHdr->x1,
     FGinfoHdr->y0,FGinfoHdr->y1, FGCCDixc, FGCCDiyc, FGinfoHdr->ncycles, FGinfoHdr->v);
   }
   b += ns;  nr = nr - ns;
   /* note - the cameraConfig structure has bit definitions according to the CONFIG
   structure in CA_status.h. This has the configuartion bits in the same places
   as the camera commands and uses the lower 3 opcode bits to stash the mode. The upper
   3 bits are used for BadCmd, Locked, Busy. These are usually off. */
   bcopy(&FGinfoHdr->cameraConfig, &FGconfig, 2);
   dacA = ((FGinfoHdr->dac) >> 5) & 0x1f;   dacB = (FGinfoHdr->dac) & 0x1f;
   psum = 1 << (FGconfig.bits.ParSum);  ssum = 1 << (FGconfig.bits.SerSum);
   ns = snprintf(b, nr, "clock %u, CT %u, PMU %d, cam config:%#6x, delay %d\n",
     FGinfoHdr->MDPclock, FGinfoHdr->CTcounter, FGinfoHdr->PMUcounter,
     FGinfoHdr->cameraConfig, FGinfoHdr->PMUdelay);
   b += ns;  nr = nr - ns;   if (nr < 128) goto reterror;

   ns = snprintf(b, nr,
     "gain:%d, summing:%dX%d, SerClk:%d, dacs:%d:%d, preamp:%d\n",
     FGconfig.bits.Gain, psum, ssum, FGconfig.bits.SerClk,
     dacB, dacA, FGconfig.bits.PreAmp);
   b += ns;  nr = nr - ns;   if (nr < 128) goto reterror;

   /* 11/22/2004 - change time to display UT */
   gtest = gmtime((time_t *) &FGtime);
   strftime(text, 30, "%a, %m/%d/%Y %H:%M:%S UT ", gtest);
   ns = snprintf(b, nr, "clock high %d, ROI %d:%d, woff (or GCU config) %d, %s\n",
     FGinfoHdr->MDPclockHigh, FGinfoHdr->roiStart, FGinfoHdr->roiStop,
     FGinfoHdr->woff, text);
   b += ns;  nr = nr - ns;

   if (mctext) { ns = snprintf(b, nr, "%s", mctext); b += ns;  nr = nr - ns; }

   /* use a base time for better visibility of the CT times */
   ctbase = ctlast = FGinfoHdr->CTcounter;
   /* now the per exposure line up */
   p = (p + sizeof(FGinfo));
   n = FGinfoHdr->n;
   /* check if n is reasonable, don't want to spew millions of lines of nonsense */
   if (n <= 0 || n > 200) {
     ns = snprintf(b, nr, "************* item count exceeds sane limit %d ***********************\n", n);
     goto sfin; }
   ns = scutoff(b, nr); b += ns;  nr = nr - ns;  if (nr < 128) goto reterror;
   //q2 =wave_value_string(currentFGmacroCommand.parameters.wave);
   if (mode) {
     //hexdump(p, sizeof(FGinfoExpset));
     ns = snprintf(b, nr, "   CT       del CT      del CT    ph   ph    shutter shutter    dt     dw     SM          SM\n");
     b += ns;  nr = nr - ns;   if (nr < 128) goto reterror;
     ns = snprintf(b, nr, " at open  close-open  read-open  open close   open    close    (ms)   (mA)   config     status\n");
     b += ns;  nr = nr - ns;   if (nr < 128) goto reterror;
     /* as of 9/13/2003 we have another version with a different format for FGinfoExpset,
     so we need to check the version # here */
     switch (FGinfoHdr->version) {
      case 0: 
        //blocksize = sizeof(FGinfoExpset_version0);
        blocksize = 50;
	for (i=0;i<n;i++) {
	   bcopy( p, &FGexpBlock_v0, blocksize);
#if linux
           FGinfoExpset_version0_fix( (FGinfoExpset_version0 *) &FGexpBlock_v0);
#endif
	   dt = (float) (FGexpBlock_v0.shutterCloseTime - FGexpBlock_v0.shutterOpenTime) * 0.004;
	   /* note that dt is in milliseconds */
	   dct = FGexpBlock_v0.CTatClose - FGexpBlock_v0.CTatOpen;
	   dct2 = FGexpBlock_v0.CTatRdout - FGexpBlock_v0.CTatOpen;
	   ns = snprintf(b, nr, "%10d %5d      %5d       %3d %3d    %5u    %5u%9.3f  %#6.4x %#.8x %#.8x\n",
      	     FGexpBlock_v0.CTatOpen, dct, dct2, FGexpBlock_v0.phaseAtOpen,
	     FGexpBlock_v0.phaseAtClose, FGexpBlock_v0.shutterOpenTime, FGexpBlock_v0.shutterCloseTime, dt,
	     FGexpBlock_v0.smconfig, FGexpBlock_v0.smstat0, FGexpBlock_v0.smstat1);
           b += ns;  nr = nr - ns;   if (nr < 128) goto reterror;
	   p = p + blocksize;
	}
        break;
      case 1:      
        //blocksize = sizeof(FGinfoExpset);
        blocksize = 54;
	//printf("blocksize = %d\n", blocksize);
	for (i=0;i<n;i++) {
	  bcopy( p, &FGexpBlock, blocksize);
#if linux
          FGinfoExpset_fix( (FGinfoExpset *) &FGexpBlock);
#endif
	  dt = (float) (FGexpBlock.shutterCloseTime - FGexpBlock.shutterOpenTime) * 0.004;
	  /* note that dt is in milliseconds */
	  dct = FGexpBlock.CTatClose - FGexpBlock.CTatOpen;
	  dct2 = FGexpBlock.CTatRdout - FGexpBlock.CTatOpen;
	  smconfig = FGexpBlock.smconfig;
	  //printf("smconfig = %#x\n", smconfig);
	  bcopy((char *) &smconfig, (char *) &smbits, 2);
	  /* load the smart memory config into a string of symbols that are hopefully
	  readable */
	    sms[0] = smbits.DMA_buffer_mode ? '1' : '4';
	    sms[1] = smbits.DMA_rw ? 'W' : '.';
	    sms[2] = smbits.DMA1_scale ? '/' : ' ';
	    sms[3] = dmacodes[smbits.DMA1_op];
	    sms[4] = smbits.DMA2_scale ? '/' : ' ';
	    sms[5] = dmacodes[smbits.DMA2_op];
	    sms[6] = smbits.DMA3_scale ? '/' : ' ';
	    sms[7] = dmacodes[smbits.DMA3_op];
	    sms[8] = smbits.DMA4_scale ? '/' : ' ';
	    sms[9] = dmacodes[smbits.DMA4_op];
	  sms[10] = NULL;
	  ns = snprintf(b, nr, "%10d %5d      %5d       %3d %3d    %5u    %5u%9.3f %4d %s %#.8x\n",
      	    FGexpBlock.CTatOpen, dct, dct2, FGexpBlock.phaseAtOpen,
	    FGexpBlock.phaseAtClose, FGexpBlock.shutterOpenTime, FGexpBlock.shutterCloseTime, dt,
	    FGexpBlock.woff, sms, FGexpBlock.smstat);
          b += ns;  nr = nr - ns;   if (nr < 128) goto reterror;
	  p = p + blocksize;
	  if (mdumpFlag) {
	    /* this is a printout to the motor dump file for checking TF motions, etc */
	    int	therms[8], xq;
	    /* items: wave, offset, dw, v, motors(8), therms(8) */
	    //fprintf(mdumpFile, "%s %s %d %4d %4d %5d ", text, q2, mode, FGinfoHdr->woff, FGexpBlock.woff, FGinfoHdr->v);
	    fprintf(mdumpFile, "%s %d %d %4d %4d %5d ", text, currentFGmacroCommand.parameters.wave, mode, FGinfoHdr->woff, FGexpBlock.woff, FGinfoHdr->v);
	    /* the mechs array has 2 fw's, 8 tf's, and the mask positions */
	    for (j=0;j<11;j++) { fprintf(mdumpFile, "%4d ", FGexpBlock.mechs[j]); }
	    /* we have to unpack the 12 bit thermistor entries */
	    for (j=0;j<4 ;j++) {
	      xq = 0;
	      bcopy(&FGexpBlock.temps[3*j], &xq, 3);
	      therms[j*2] = ((xq & 0xfff00000) >> 20) & 0xfff;
	      therms[j*2+1] = (xq & 0x000fff00) >> 8;
            }
	    for (j=0;j<8 ;j++) { fprintf(mdumpFile, "T%4d ", therms[j]); }
	    fprintf(mdumpFile, "\n");
          }
	}
        break;
      default:
           snprintf(linebuf, 500, "unexpected version\nnumber %d", FGinfoHdr->version);
     }
    } else {
     ns = snprintf(b, nr, "del CT  phase state PMU    smconfig      sm0       sm1\n");
     b += ns;  nr = nr - ns;   if (nr < 128) goto reterror;
     /* this still has only one version of the structure */
     blocksize = sizeof(FGinfoPMUset);  /* if we have a "good" size this will work */
     for (i=0;i<n;i++) {
	bcopy( p, &FGpmuBlock, blocksize);
#if linux
        FGinfoPMUset_fix( (FGinfoPMUset *) &FGpmuBlock);
#endif
	dct = FGpmuBlock.CTcounter - ctlast;
	ctlast = FGpmuBlock.CTcounter;
	smconfig = FGpmuBlock.smconfig;
	bcopy((char *) &smconfig, (char *) &smbits, 2);
	/* load the smart memory config into a string of symbols that are hopefully
	readable */
	if (smbits.DMA_unused) {
          sprintf(sms,"..........");
	} else {
	  sms[0] = smbits.DMA_buffer_mode ? '1' : '4';
	  sms[1] = smbits.DMA_rw ? 'W' : '.';
	  sms[2] = smbits.DMA1_scale ? '/' : ' ';
	  sms[3] = dmacodes[smbits.DMA1_op];
	  sms[4] = smbits.DMA2_scale ? '/' : ' ';
	  sms[5] = dmacodes[smbits.DMA2_op];
	  sms[6] = smbits.DMA3_scale ? '/' : ' ';
	  sms[7] = dmacodes[smbits.DMA3_op];
	  sms[8] = smbits.DMA4_scale ? '/' : ' ';
	  sms[9] = dmacodes[smbits.DMA4_op];
	}
	sms[10] = NULL;
	ns = snprintf(b, nr, "%5d   %4d %4d   %3u  %s   %#.8x %#.8x\n",
           dct, FGpmuBlock.phase, FGpmuBlock.state,
	   FGpmuBlock.PMUposition, sms, FGpmuBlock.smstat0,
	   FGpmuBlock.smstat1);
        b += ns;  nr = nr - ns;   if (nr < 128) goto reterror;
	p = p + blocksize;
	  if (mdumpFlag) {
	    /* this is a printout to the motor dump file for checking TF motions, etc */
	    int	therms[8], xq;
	    /* items: wave, offset, dw, v, motors(8), therms(8) */
	    //fprintf(mdumpFile, "%s %s %d %4d    0 %5d ", text, q2, mode, FGinfoHdr->woff, FGinfoHdr->v);
	    fprintf(mdumpFile, "%s %d %d %4d    0 %5d ", text, currentFGmacroCommand.parameters.wave, mode, FGinfoHdr->woff, FGinfoHdr->v);
	    /* the mechs array has 2 fw's, 8 tf's, and the mask positions */
	    for (j=0;j<11;j++) { fprintf(mdumpFile, "%4d ", FGpmuBlock.mechs[j]); }
	    /* we have to unpack the 12 bit thermistor entries */
	    for (j=0;j<4 ;j++) {
	      xq = 0;
	      bcopy(&FGpmuBlock.temps[3*j], &xq, 3);
	      therms[j*2] = ((xq & 0xfff00000) >> 20) & 0xfff;
	      therms[j*2+1] = (xq & 0x000fff00) >> 8;
            }
	    for (j=0;j<8 ;j++) { fprintf(mdumpFile, "T%4d ", therms[j]); }
	    fprintf(mdumpFile, "\n");
          }
     }
   }
 //free(q2);  /* or suffer a leak */
 if (!gui_flag) {
   ns = scutoff(b, nr); b += ns;  nr = nr - ns;  if (nr < 128) goto reterror;
 }
 sfin:
 { printf("%s", buf); }
 return;
 reterror:  printf("status overflowed allocated buffer\n"); return;
 }
 /*--------------------------------------------------------------------------*/
void showIscanInfo(IscanPacketHeader *isheader, char * pc, char *mctext, int genId)
 {
 int	nwave, nwave2, i, j, nr, ns, mcheck;
 unsigned int	FGtime;
 char *pdata, *buf, *b;
 IscanData scan;
 float	dt;
 int	motor_remap[8] = {5, 4, 1, 0, 7, 6, 3, 2};
 int	motor_remap_back[8] = {3, 2, 7, 6, 1, 0, 5, 4};
 extern unsigned int timeRef, FPPccsdsti;
 time_t fileTime;
 char	text[256];
 struct tm *gtest;
 double sbtime_pkt;
 extern double sb_time_0;

 nwave = isheader->data.nwave;
 nwave2 = isheader->info.ny;
 printf("showIscanInfo, nw = %d, nw2 = %d\n", nwave, nwave2);
 printf("packet_time %#x, MDPclockHigh %#x\n", isheader->data.packet_time,
 	isheader->data.MDPclockHigh);
 if (sdtp_flag) {
   FGtime = timeRef + ((FPPccsdsti >> 5) & 0x07ffffff);
   sb_time_0 = FGtime/32.0;
   sb_time_0 = sb_time_0 - sb_time_0*6.95263888075869e-06 + 212176146.475454;
   sbtime_pkt = SB_Time_Convert(FPPccsdsti, sb_time_0);
   sbtime_pkt = SB2UT(sbtime_pkt); /* sbtime_pkt is now UTC */
   FGtime = sbtime_pkt;
 } else {
   FGtime = ((isheader->data.packet_time) >> 9 ) & 0x007fffff;
   if (isheader->data.MDPclockHigh == 0) {
      time_t fileTime;
      int  dt;
      fileTime = getFileCalendarTime();
      FGtime = FGtime | ( fileTime & 0xff800000);
      /* if this time is more than 1000s less than fileCalendarTime,
      consider a rollover */
      dt = FGtime - fileTime;
      printf("Iscan: dt, FGtime, fileCalendarTime %d %d %d\n", dt, FGtime, fileTime);
      if (dt < -1000) {
	/* rollovers occur every 90 days, check if reasonable */
	unsigned int iq, FGbumped;
	iq = (fileTime & 0xff800000) + 0x00800000;
	FGbumped = (((isheader->data.packet_time) >> 9 ) & 0x007fffff) | fileTime;
	dt = FGbumped - FGtime;
      printf("dt, FGtime, CTbumped %d %d %d\n", dt, FGtime, FGbumped);
	if (dt < 10000) FGtime = FGbumped; else {
	  printf("a problem with the Iscan times, %s vs %s\n", ctime((time_t *) &FGtime),
      	    ctime((time_t *) &FGbumped));
	}
      }
   } else {
      FGtime = FGtime | ( (unsigned int) (isheader->data.MDPclockHigh) << 23);
   }
 }
 //printf("FGtime: %#x\n", FGtime);
 nr = nscratch;
 b = buf = scratch;
 if (!gui_flag) {
   ns = scutoff(b, nr); b += ns;  nr = nr - ns;
 }

 gtest = gmtime((time_t *) &FGtime);
 strftime(text, 30, "%a, %m/%d/%Y %H:%M:%S UT ", gtest);
 ns = snprintf(b, nr, "Intensity/laser scan, %d entries, wcorr %d, packet time: %s\n",
 	nwave, isheader->data.wcorr, text);
 b += ns;  nr = nr - ns;
 ns = snprintf(b, nr, "%s", mctext);
 b += ns;  nr = nr - ns;

 ns = scutoff(b, nr); b += ns;  nr = nr - ns;  if (nr < 128) goto reterror;

 if (nwave > 2048 || nwave < 8) {
     ns = snprintf(b, nr, "************* wave count out of legal range %d ***********************\n", nwave);
     goto sfin; }
 
 /* if the first thermistor is < 168, assume these are really motor checks */
 bcopy(pc, &scan, 64);  /* just for the check below */
 if (scan.therm[0] < 168) {
   mcheck = 1;
   if (genId == 14 )
    ns = snprintf(b, nr, "   CT       ph   ph    shutter shutter     dt   motor      I        I             motors                motor check\n");
   else
    ns = snprintf(b, nr, "   CT       ph   ph    shutter shutter     dt    dw        I        I             motors                motor check\n");
 } else {
   mcheck = 0;
   if (genId == 14 )
     ns = snprintf(b, nr, "   CT       ph   ph    shutter shutter     dt   motor      I        I             motors                thermistors\n");
   else
     ns = snprintf(b, nr, "   CT       ph   ph    shutter shutter     dt    dw        I        I             motors                thermistors\n");
 }
 b += ns;  nr = nr - ns;   if (nr < 128) goto reterror;
 ns =   snprintf(b, nr, " at open   open close   open    close     (ms)   #        LHS      RHS            (0-8)                   (0-8)\n");
 b += ns;  nr = nr - ns;   if (nr < 256) goto reterror;
 for (i=0;i<nwave;i++) {
   /* packdata1 is not necessarily I*4 aligned so a copy is prudent */
   bcopy(pc, &scan, 64);
#if linux
   IscanData_fix((IscanData *) &scan );
#endif
   dt = (float) (scan.shutterCloseTime - scan.shutterOpenTime) * 0.004;
   ns = snprintf(b, nr, "%10d  %3d %3d    %5u    %5u%9.3f %5d %10u %10u  ",
     scan.CTatOpen, scan.phaseAtOpen, scan.phaseAtClose, scan.shutterOpenTime, scan.shutterCloseTime,
     dt, scan.woff, scan.sums[0], scan.sums[1]);
   b += ns;  nr = nr - ns;
   pc = pc + sizeof(IscanData);
   for (j=0;j<8;j++) {
     ns = snprintf(b, nr, "%2d ", scan.mtr[j]); b += ns;  nr = nr - ns; }
   if (mcheck) {
     for (j=0;j<8;j++) {
       ns = snprintf(b, nr, "%3d ", scan.mtr[j]-scan.therm[motor_remap[j]]); b += ns;  nr = nr - ns;
     }
   } else {
     for (j=0;j<8;j++) {
       //ns = snprintf(b, nr, "%5.2f ", (float) (scan.eltemp[j])*.001); b += ns;  nr = nr - ns;
       ns = snprintf(b, nr, "%5d ", scan.therm[j]); b += ns;  nr = nr - ns;
     }
   }
   /* put an average of the eltemps at the end, this is especially useful if they are not
   printed in favor of the thermistors */
   {  float  avgt = 0.0;
      for (j=0;j<8;j++) { avgt += (float) (scan.eltemp[j])*.001; }
      avgt = avgt*.125;
      ns = snprintf(b, nr, ":%5.2f\n", avgt); b += ns;  nr = nr - ns;
   }
   if (nr < 256) goto reterror;
 }

 sfin:
 { printf("%s", buf); }
 return;
 reterror:  printf("status overflowed allocated buffer\n"); return;
 }
 /*--------------------------------------------------------------------------*/
void getFirstSPintegration(SPinfo *SPinfoHdr, unsigned int *ctStart, unsigned int *phaseStart)
 {
 SPinfoPMUset	SPpmuBlock;
 char *p;
 int	mode, n, blocksize;
 p = (char *) SPinfoHdr;
 n = SPinfoHdr->n;
 blocksize = 18;
 /* we want the second one */
 p = (p + sizeof(SPinfo));
 p = p + blocksize;
 bcopy( p, &SPpmuBlock, blocksize);
#if linux
 SPinfoPMUset_fix( (SPinfoPMUset *) &SPpmuBlock);
#endif
 *ctStart = SPpmuBlock.CTcounter;
 *phaseStart = (int) (((p[0] & 0xf0) >> 4) & 0x0f);
 return;
 }
 /*--------------------------------------------------------------------------*/
void showSPimageInfo(SPinfo *SPinfoHdr, char *mctext)
 {
 SPinfoPMUset	SPpmuBlock;
 CONFIG  SPconfig;
 int	n, i, blocksize, iq;
 int	ctbase, ctlast, dct, dct2;
 unsigned int	phase, state, PMUposition, smstat0, smstat1, CTcounter;
 short  slitPosition;
 unsigned short smconfig;
 char sms[16];
 char *buffer, *b, *buf, *p;
 int nbuf, ns, nr, dacA, dacB, psum, ssum;
 extern unsigned int	SPtime;
 char	text[256];
 struct tm *gtest;

 p = (char *) SPinfoHdr;
 
   nr = nscratch;
   b = buf = scratch;

 if (!gui_flag) {
   ns = scutoff(b, nr); b += ns;  nr = nr - ns;  if (nr < 128) goto reterror;
 }
   ns = snprintf(b, nr, "SP data info: side %d, %d PMU phases, mode %d, slit %d, ny %d, y0 %d, cycles %d\n",
     SPinfoHdr->side, SPinfoHdr->n, SPinfoHdr->mode, SPinfoHdr->slitPosition,
     SPinfoHdr->nspace, SPinfoHdr->spaceOffset, SPinfoHdr->ncycles);
   b += ns;  nr = nr - ns;   if (nr < 128) goto reterror;

   bcopy(&SPinfoHdr->cameraConfig, &SPconfig, 2);
   dacA = ((SPinfoHdr->dac) >> 5) & 0x1f;   dacB = (SPinfoHdr->dac) & 0x1f;
   psum = 1 << (SPconfig.bits.ParSum);  ssum = 1 << (SPconfig.bits.SerSum);
   ns = snprintf(b, nr, "clock %u, CT %u, PMU %d, cam config:%#6x, delay %d\n",
     SPinfoHdr->MDPclock, SPinfoHdr->CTcounter, SPinfoHdr->PMUcounter,
     SPinfoHdr->cameraConfig, SPinfoHdr->PMUdelay);
   b += ns;  nr = nr - ns;

   ns = snprintf(b, nr,
     "gain:%d, summing:%dX%d, SerClk:%d, dacs:%d:%d, preamp:%d\n",
     SPconfig.bits.Gain, psum, ssum, SPconfig.bits.SerClk,
     dacB, dacA, SPconfig.bits.PreAmp);
   b += ns;  nr = nr - ns;   if (nr < 128) goto reterror;

   /* 11/22/2004 - use UT rather than local time here */
   gtest = gmtime((time_t *) &SPtime);
   strftime(text, 30, "%a, %m/%d/%Y %H:%M:%S UT ", gtest);

   ns = snprintf(b, nr, "clock high %d, ROI %d:%d, GCU config %d, %s\n",
     SPinfoHdr->MDPclockHigh, SPinfoHdr->roiStart, SPinfoHdr->roiStop,
     SPinfoHdr->gcuconfig, text);
   b += ns;  nr = nr - ns;

   if (mctext) { ns = snprintf(b, nr, "%s", mctext); b += ns;  nr = nr - ns; }

   ns = scutoff(b, nr); b += ns;  nr = nr - ns;  if (nr < 128) goto reterror;

   /* now the individual PMU exposures, because the blocks don't follow structure
   alignment rules, we copy the correct byte count into a properly aligned array
   for each one. This requires knowledge of the unpadded structure size. */
   blocksize = 18;
   p = (p + sizeof(SPinfo));
   n = SPinfoHdr->n;
   /* check if n is reasonable, don't want to spew millions of lines of nonsense */
   if (n <= 0) {
     ns = snprintf(b, nr, "************* no PMU listing ***********************\n", n);
     goto sfin; }
   if (n > 100) {
     ns = snprintf(b, nr, "************* item count exceeds sane limit %d ***********************\n", n);
     goto sfin; }
   /* use a base time for better visibility of the CT times */
   ctbase = ctlast = SPinfoHdr->CTcounter;
   ns = snprintf(b, nr, "del CT  phase state slit PMU   smconfig       sm0        sm1\n\n");
   b += ns;  nr = nr - ns;  if (nr < 128) goto reterror;
   for (i=0;i<n;i++) {
     bcopy( p, &SPpmuBlock, blocksize);
#if linux
     SPinfoPMUset_fix( (SPinfoPMUset *) &SPpmuBlock);
#endif
    /* because of alignment rules, we sometimes have to do this the hard way */
    /* also I'm changing the structures, trying to find one that works on most
    machines */
    phase = (int) (((p[0] & 0xf0) >> 4) & 0x0f);
    state = (int) ( p[0] & 0x0f);
    PMUposition = p[1] & 0xff;
    bcopy( &p[2], &smconfig, 2); 
#if linux
    swapb((char *) &smconfig, 2);
#endif
    smconfig = smconfig & 0xffff;
    bcopy((char *) &smconfig, (char *) &smbits, 2);
    bcopy( &p[4], &smstat0, 4);
    bcopy( &p[8], &smstat1, 4);
    bcopy( &p[12], &CTcounter, 4);
    bcopy( &p[16], &slitPosition, 2);
#if linux
    swapl((char *) &smstat0, 1);
    swapl((char *) &smstat1, 1);
    swapl((char *) &CTcounter, 1);
    swapb((char *) &slitPosition, 2);
#endif
    dct = SPpmuBlock.CTcounter - ctlast;
    ctlast = SPpmuBlock.CTcounter;
    /* load the smart memory config into a string of symbols that are hopefully
    readable */
    if (smbits.DMA_unused) {
          sprintf(sms,"..........");
    } else {
      sms[0] = smbits.DMA_buffer_mode ? '1' : '4';
      sms[1] = smbits.DMA_rw ? 'W' : '.';
      sms[2] = smbits.DMA1_scale ? '/' : ' ';
      sms[3] = dmacodes[smbits.DMA1_op];
      sms[4] = smbits.DMA2_scale ? '/' : ' ';
      sms[5] = dmacodes[smbits.DMA2_op];
      sms[6] = smbits.DMA3_scale ? '/' : ' ';
      sms[7] = dmacodes[smbits.DMA3_op];
      sms[8] = smbits.DMA4_scale ? '/' : ' ';
      sms[9] = dmacodes[smbits.DMA4_op];
    }
    sms[10] = NULL;
    ns = snprintf(b, nr, "%5d  %4d  %4d %5d  %3u %s   %#.8x %#.8x\n",
  //      SPpmuBlock.CTcounter, SPpmuBlock.phase, SPpmuBlock.state,
  //      SPpmuBlock.slitPosition, SPpmuBlock.PMUposition, SPpmuBlock.smconfig,
  //      SPpmuBlock.smstat0, SPpmuBlock.smstat1);
    dct, phase, state, slitPosition, PMUposition,sms,smstat0,smstat1);
   b += ns;  nr = nr - ns;  if (nr < 128) goto reterror;
    p = p + blocksize;
   }
 if (!gui_flag) {
   ns = scutoff(b, nr); b += ns;  nr = nr - ns;  if (nr < 128) goto reterror;
 }
sfin: 
 { printf("%s", buf); }
 return;
 reterror:  printf("status overflowed allocated buffer\n"); return;
 }
 /*--------------------------------------------------------------------------*/
float poly(cfbase, npow, xq)
 float	*cfbase, xq;
 int	npow;
 {
 float *cf, sum;
 int	m;
 switch (npow) {
   case 0:	sum = *cfbase;	break;
   default:
     cf = cfbase + npow;  /*point to last coeff. */
     sum = (*cf--) * xq;	m = npow - 1;
     while (m-- > 0) sum = ( sum + *cf--) * xq;
     sum += *cf;
 }
 return sum;
 }
 /*--------------------------------------------------------------------------*/
void getTemperatures(char *status3)
 {
 extern float alltemps[36];
 unsigned short temps[36];
 /* there actually only 35 thermistors but we unpack a phantom at the
 end. The first 32 have a hi/low range bit that must be used to convert
 to temperature. The last 3 are the CCD header temperatures. */
 unsigned char *ptherm, *p;
 unsigned short *ptouts;
 unsigned int iq;
 int	loFlag[32], thermalSelect;
 int	nt = 36, n, i;
 n = nt/2;
 /* the 136 is the offset to the T section */
 ptherm = (unsigned char *) status3+136;
 ptouts = temps;
 while (n--) {
   /* load 3 bytes into a 32 bit word */
   iq = (*ptherm++);
   iq += ((*ptherm++)<<8);
   iq += ((*ptherm++)<<16);

   *ptouts++ = (unsigned short) (iq & 0xfff);
   *ptouts++ = (unsigned short) (iq >> 12);
 }
 /* now have all 35 thermistor readouts in temps, now get the range bits */
 p = (unsigned char *) status3+190;
 bcopy(p + 190, &thermalSelect, 4);
 /* the CCD's don't have high/low ranges and all use the fpp_prt calibration */
 for (i=32;i<35;i++) {
   alltemps[i] = poly(fpp_prt, nfpp_prt - 1, (float) temps[i]);
 }
 /* also want the first 3, these are more complicated, first get the H/L
 indicator */
 {
   unsigned char ts = * ((unsigned char *) status3 + 193);
   /* the SP, FG, CT camera electronics box T's are the first 3 bits in
   ts (lower 3). We probably should just do all the T's eventually but just
   the ones for keywords for this release. The flag is set if we should use the
   low range. */
   loFlag[0] = ts & 0x1;
   loFlag[1] = (ts >> 1) & 0x1;
   loFlag[2] = (ts >> 2) & 0x1;
   for (i=0;i<3;i++) {
     if (loFlag[i]) alltemps[i] = poly(fpp_therm1, nfpp_therm1 - 1, (float) temps[i]);
        else alltemps[i] = poly(fpp_therm1h, nfpp_therm1h - 1, (float) temps[i]);
   }
 }
 return;
 }
 /*--------------------------------------------------------------------------*/
