/* image display widgets for dgui */
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
//#include  <malloc.h>
#include <stdio.h>
#include <sys/stat.h>
#include <time.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Xatom.h>
#include <X11/cursorfont.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xm/MwmUtil.h>
#include <Xm/Xm.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/Command.h>
#include <Xm/CascadeB.h>
#include <Xm/CascadeBG.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/MessageB.h>
#include <Xm/List.h>
#include <Xm/Form.h>
#include <Xm/Text.h>
#include <Xm/Scale.h>
#include <Xm/ScrolledW.h>
#include <Xm/ScrollBar.h>
#include <Xm/DrawingA.h>
#include <Xm/Frame.h>
#include <Xm/RowColumn.h>
#include <Xm/TextF.h>
#include <Xm/ArrowB.h>
#include <Xm/ToggleBG.h>
#include <Xm/ToggleB.h>
#include <Xm/SelectioB.h>
#include <Xm/Separator.h>
#include <Xm/FileSB.h>
#include <time.h>
#include "command.h"

#define ABS(x) ((x)>=0?(x):-(x))
#define MINOF(a,b) (((a)<(b))?(a):(b))
#define MAXOF(a,b) (((a)>(b))?(a):(b))
 typedef struct	Warray {
   int		n;
   Widget	*array;} Warray;
 extern int	screen_depth, auto_erase_flag;
 extern char *font1,  *font3,  *font4;
 extern Widget idrawtop, idrawtopCT, idrawtopSP, idrawtopXRT;
 extern Widget toplevel, xmboard(), xmlabel(),  xmtext(), xmtextfield();
 extern Widget xmform(), xmseparator(),  xmbutton(), xmdialog_form();
 extern Widget xmlist(), xmscrolledwindow();
 void	xmsetlabel();
 extern Widget  xmdrawingarea(), xmtoplevel_form(), xmgettopshell();
 extern	char *xmtextfieldgetstring();
 extern	Display	*disp;
 extern Pixel red_pixel;
 extern Pixel green_pixel;
 extern Pixel white_pixel;
 extern Pixel black_pixel, yellow_pixel, blue_pixel, sea_green_pixel, gray_pixel;
 extern Pixel GetColor();
 static	int	nxidraw, nyidraw, nxidrawCT, nyidrawCT, nxidrawSP, nyidrawSP;
 static	int	nxidrawXRT, nyidrawXRT;
 int	fgscalemin=0, fgscalemax=4095;
 int	spscalemin=0, spscalemax=4095;
 int	xrtscalemin=0, xrtscalemax=4095;
 int	fgMax = -100000, fgMin = 100000, spMax = -100000, spMin = 100000;
 int	fgMaxFlag, spMaxFlag, spAutoScaleFlag, fgAutoScaleFlag;
 int	xrtMax = -100000, xrtMin = 100000;
 int	xrtMaxFlag, xrtAutoScaleFlag;
 static	XFontStruct     *font_draw;
 static GC	gcidraw, gcidrawCT, gcidrawSP, gcidrawXRT;
 static Pixmap	pixmap_idraw, pixmapCTref_idraw, pixmapCTlive_idraw, pixmapSP_idraw;
 static Pixmap	pixmapXRT_idraw;
 Widget idraw, idrawCTref, idrawCTlive, idrawtopCT, ref_mask_text, live_mask_text;
 Widget idrawtopXRT, idrawXRT;
 Widget idrawSP, mechLabel, SPtimeLabel, CTtimeLabel, XRTtimeLabel;
 Widget ctlabels_live[4], ctlabels_ref[4], lq_live;
 Widget fglabels[3], fgtext[3];
 Widget splabels[3], sptext[3];
 Widget xrtlabels[3], xrttext[3];
 Warray *FGmaxcheck, *SPmaxcheck, *XRTmaxcheck;
 short	ref_mask, live_mask;
 char linebuf[512];	/* for scratch only ! */
 /*--------------------------------------------------------------------------*/
void fgmax_cb(w, ptq, state)
 Widget	w;
 XtPointer	ptq;
 XmToggleButtonCallbackStruct	*state;
 {
 fgMaxFlag = state->set;
 return;
 }
 /*--------------------------------------------------------------------------*/
void spmax_cb(w, ptq, state)
 Widget	w;
 XtPointer	ptq;
 XmToggleButtonCallbackStruct	*state;
 {
 spMaxFlag = state->set;
 return;
 }
 /*--------------------------------------------------------------------------*/
void xrtmax_cb(w, ptq, state)
 Widget	w;
 XtPointer	ptq;
 XmToggleButtonCallbackStruct	*state;
 {
 xrtMaxFlag = state->set;
 return;
 }
 /*--------------------------------------------------------------------------*/
void idrawFGscale_cb()
 {
 /* called by both the min and max text fields, just reads both and
 sets the internal parameters, may want to rescale the current image
 in the future but for now it just affects subsequent images */
 char *s;
 s = xmtextfieldgetstring(fgtext[0]);
 fgscalemin = (int) strtol(s, NULL, 0);
 s = xmtextfieldgetstring(fgtext[1]);
 fgscalemax = (int) strtol(s, NULL, 0);
 //printf("new min and max = %d %d\n", fgscalemin, fgscalemax);
 }
 /*--------------------------------------------------------------------------*/
void idrawSPscale_cb()
 {
 /* called by both the min and max text fields, just reads both and
 sets the internal parameters, may want to rescale the current image
 in the future but for now it just affects subsequent images */
 char *s;
 s = xmtextfieldgetstring(sptext[0]);
 spscalemin = (int) strtol(s, NULL, 0);
 s = xmtextfieldgetstring(sptext[1]);
 spscalemax = (int) strtol(s, NULL, 0);
 //printf("new min and max = %d %d\n", spscalemin, spscalemax);
 }
 /*--------------------------------------------------------------------------*/
void idrawXRTscale_cb()
 {
 /* called by both the min and max text fields, just reads both and
 sets the internal parameters, may want to rescale the current image
 in the future but for now it just affects subsequent images */
 char *s;
 s = xmtextfieldgetstring(xrttext[0]);
 xrtscalemin = (int) strtol(s, NULL, 0);
 s = xmtextfieldgetstring(xrttext[1]);
 xrtscalemax = (int) strtol(s, NULL, 0);
 //printf("new min and max = %d %d\n", xrtscalemin, xrtscalemax);
 }
 /*--------------------------------------------------------------------------*/
void idraw_popup()
 {
 if (idrawtop) XtPopup(xmgettopshell(idrawtop), XtGrabNone);
 }
 /*--------------------------------------------------------------------------*/
void idraw_dismiss_cb()
 {
 XtPopdown(xmgettopshell(idrawtop));
 }
 /*--------------------------------------------------------------------------*/
void idraw_input_cb(w, ptq, call_data)
 Widget	w;
 XmDrawingAreaCallbackStruct *call_data;
 {
 XEvent  *report = call_data->event;
 char	buffer[16];
 KeySym	keysym;
 int	fg_xcoord, fg_ycoord, fg_root_x, fg_root_y, fg_keystate, fg_button;
 int	fg_keysym, fg_keycode, nc;
 /*assume no key and no button down until we find different */
 fg_keycode = fg_button = fg_keysym = fg_keystate = 0;
 //printf("idrawfg_input_cb called\n");
 /* check type of input */
 switch (report->xany.type) {
  case ButtonPress:
    fg_button = report->xbutton.button;
  case ButtonRelease:
    /* note that a release has a button of 0 */
    fg_xcoord = report->xbutton.x;
    fg_ycoord = report->xbutton.y;
    fg_root_x = report->xbutton.x_root;
    fg_root_y = report->xbutton.y_root;
    fg_keystate = report->xbutton.state;
    break;
  case KeyPress:
    fg_keycode = report->xkey.keycode;
    /* note that keycode can be used to distinquish between press and release */
  case KeyRelease:
    fg_xcoord = report->xkey.x;
    fg_ycoord = report->xkey.y;
    fg_root_x = report->xkey.x_root;
    fg_root_y = report->xkey.y_root;
    fg_keystate = report->xkey.state;
    nc = XLookupString(&(report->xkey), buffer, 15, &keysym, NULL);
    buffer[nc] = NULL;
    //printf("nc = %d, string = %s\n", nc, buffer);
    fg_keysym = (int) keysym;
    break;
 }
 //printf("x,y = (%d, %d), root, x,y = (%d, %d), button %d, keystate %d\n",
 //	fg_xcoord, fg_ycoord, fg_root_x, fg_root_y, fg_button, fg_keysym);
 //printf("keycode = %d\n", fg_keycode);
 if (fg_button == 1) {
    printf("on FG CCD (%d, %d)\n", fg_xcoord*4,fg_ycoord*4);
 }
 }
 /*--------------------------------------------------------------------------*/
void idraw_resize_cb()
 {
 printf("idraw_resize_cb called\n");
 }
 /*--------------------------------------------------------------------------*/
void idraw_ex_cb()
 {
 int	stat;
 //printf("copying pixmap\n");
 stat = XCopyArea(XtDisplay(idraw), pixmap_idraw, XtWindowOfObject(idraw),
 	gcidraw, 0, 0, nxidraw, nyidraw, 0, 0);
 //printf("stat = %d\n", stat);
 }
 /*--------------------------------------------------------------------------*/
void idraw_erase_cb()
 {
 /* hard wired for the target drawing area */
 XSetForeground(disp, gcidraw, WhitePixelOfScreen(XtScreen(idraw)));
 XFillRectangle(disp, pixmap_idraw, gcidraw, 0,0, nxidraw, nyidraw);
 XSetForeground(disp, gcidraw, BlackPixelOfScreen(XtScreen(idraw)));
 XCopyArea(XtDisplay(idraw), pixmap_idraw, XtWindowOfObject(idraw),
 	gcidraw, 0, 0, nxidraw, nyidraw, 0, 0);
 }
 /*--------------------------------------------------------------------------*/
void idrawCT_popup()
 {
 if (idrawtopCT) XtPopup(xmgettopshell(idrawtopCT), XtGrabNone);
 }
 /*--------------------------------------------------------------------------*/
void idrawCT_dismiss_cb()
 {
 XtPopdown(xmgettopshell(idrawtopCT));
 }
 /*--------------------------------------------------------------------------*/
void idrawCT_input_cb(w, ptq, call_data)
 Widget	w;
 XmDrawingAreaCallbackStruct *call_data;
 {
 XEvent  *report = call_data->event;
 char	buffer[16];
 KeySym	keysym;
 int	xcoord, ycoord, root_x, root_y, keystate, button;
 int	keysymbol, keycode, nc;
 /*assume no key and no button down until we find different */
 keycode = button = keysymbol = keystate = 0;
 //printf("idrawinput_cb called\n");
 /* check type of input */
 switch (report->xany.type) {
  case ButtonPress:
    button = report->xbutton.button;
  case ButtonRelease:
    /* note that a release has a button of 0 */
    xcoord = report->xbutton.x;
    ycoord = report->xbutton.y;
    root_x = report->xbutton.x_root;
    root_y = report->xbutton.y_root;
    keystate = report->xbutton.state;
    break;
  case KeyPress:
    keycode = report->xkey.keycode;
    /* note that keycode can be used to distinquish between press and release */
  case KeyRelease:
    xcoord = report->xkey.x;
    ycoord = report->xkey.y;
    root_x = report->xkey.x_root;
    root_y = report->xkey.y_root;
    keystate = report->xkey.state;
    nc = XLookupString(&(report->xkey), buffer, 15, &keysym, NULL);
    buffer[nc] = NULL;
    //printf("nc = %d, string = %s\n", nc, buffer);
    keysymbol = (int) keysym;
    break;
 }
 //printf("x,y = (%d, %d), root, x,y = (%d, %d), button %d, keystate %d\n",
 //	xcoord, ycoord, root_x, root_y, button, keysymbol);
 //printf("keycode = %d\n", keycode);
 if (button == 1) {
    printf("on CT CCD (%d, %d)\n", xcoord/5,ycoord/5);
 }
 }
 /*--------------------------------------------------------------------------*/
void idrawCT_resize_cb()
 {
 printf("idraw_resize_cb called\n");
 }
 /*--------------------------------------------------------------------------*/
void idrawCT_ex_cb()
 {
 int	stat;
 stat = XCopyArea(XtDisplay(idrawCTref), pixmapCTref_idraw,
  XtWindowOfObject(idrawCTref), gcidraw, 0, 0, nxidrawCT, nyidrawCT, 0, 0);
 stat = XCopyArea(XtDisplay(idrawCTlive), pixmapCTlive_idraw,
  XtWindowOfObject(idrawCTlive), gcidraw, 0, 0, nxidrawCT, nyidrawCT, 0, 0);
 }
 /*--------------------------------------------------------------------------*/
void idrawCT_erase_cb()
 {
 /* hard wired for the 2 CT drawing areas */
 XSetForeground(disp, gcidrawCT, WhitePixelOfScreen(XtScreen(idrawCTref)));
 XSetForeground(disp, gcidrawCT, WhitePixelOfScreen(XtScreen(idrawCTlive)));
 XFillRectangle(disp, pixmapCTref_idraw, gcidrawCT, 0,0, nxidrawCT, nyidrawCT);
 XFillRectangle(disp, pixmapCTlive_idraw, gcidrawCT, 0,0, nxidrawCT, nyidrawCT);
 XSetForeground(disp, gcidrawCT, BlackPixelOfScreen(XtScreen(idrawCTref)));
 XSetForeground(disp, gcidrawCT, BlackPixelOfScreen(XtScreen(idrawCTlive)));
 XCopyArea(XtDisplay(idrawCTref), pixmapCTref_idraw, XtWindowOfObject(idrawCTref),
 	gcidrawCT, 0, 0, nxidrawCT, nyidrawCT, 0, 0);
 XCopyArea(XtDisplay(idrawCTlive), pixmapCTlive_idraw, XtWindowOfObject(idrawCTlive),
 	gcidrawCT, 0, 0, nxidrawCT, nyidrawCT, 0, 0);
 }
 /*--------------------------------------------------------------------------*/
void idrawSP_popup()
 {
 printf("idrawSP_popup called, idrawtopSP = %d\n");
 if (idrawtopSP) XtPopup(xmgettopshell(idrawtopSP), XtGrabNone);
 }
 /*--------------------------------------------------------------------------*/
void idrawSP_dismiss_cb()
 {
 XtPopdown(xmgettopshell(idrawtopSP));
 }
 /*--------------------------------------------------------------------------*/
void idrawSP_input_cb(w, ptq, call_data)
 Widget	w;
 XmDrawingAreaCallbackStruct *call_data;
 {
 XEvent  *report = call_data->event;
 char	buffer[16];
 KeySym	keysym;
 int	sp_xcoord, sp_ycoord, sp_root_x, sp_root_y, sp_keystate, sp_button;
 int	sp_keysym, sp_keycode, nc;
 /*assume no key and no button down until we find different */
 sp_keycode = sp_button = sp_keysym = sp_keystate = 0;
 //printf("idrawSP_input_cb called\n");
 /* check type of input */
 switch (report->xany.type) {
  case ButtonPress:
    sp_button = report->xbutton.button;
  case ButtonRelease:
    /* note that a release has a button of 0 */
    sp_xcoord = report->xbutton.x;
    sp_ycoord = report->xbutton.y;
    sp_root_x = report->xbutton.x_root;
    sp_root_y = report->xbutton.y_root;
    sp_keystate = report->xbutton.state;
    break;
  case KeyPress:
    sp_keycode = report->xkey.keycode;
    /* note that keycode can be used to distinquish between press and release */
  case KeyRelease:
    sp_xcoord = report->xkey.x;
    sp_ycoord = report->xkey.y;
    sp_root_x = report->xkey.x_root;
    sp_root_y = report->xkey.y_root;
    sp_keystate = report->xkey.state;
    nc = XLookupString(&(report->xkey), buffer, 15, &keysym, NULL);
    buffer[nc] = NULL;
    //printf("nc = %d, string = %s\n", nc, buffer);
    sp_keysym = (int) keysym;
    break;
 }
 //printf("x,y = (%d, %d), root, x,y = (%d, %d), button %d, keystate %d\n",
 //	sp_xcoord, sp_ycoord, sp_root_x, sp_root_y, sp_button, sp_keysym);
 //printf("keycode = %d\n", sp_keycode);
 if (sp_button == 1) {
    printf("RAW (%d, %d) -- ", sp_xcoord,sp_ycoord);
    if (sp_xcoord < 226) printf("LHS (%d, %d) on CCD\n", sp_xcoord,sp_ycoord);
      else printf("RHS (%d, %d) on CCD\n", sp_xcoord-226,sp_ycoord);
 }
 }
 /*--------------------------------------------------------------------------*/
void idrawSP_resize_cb()
 {
 printf("idrawSP_resize_cb called\n");
 }
 /*--------------------------------------------------------------------------*/
void idrawSP_ex_cb()
 {
 int	stat;
 //printf("copying pixmap\n");
 stat = XCopyArea(XtDisplay(idrawSP), pixmapSP_idraw, XtWindowOfObject(idrawSP),
 	gcidrawSP, 0, 0, nxidrawSP, nyidrawSP, 0, 0);
 //printf("stat = %d\n", stat);
 }
 /*--------------------------------------------------------------------------*/
void idrawSP_erase_cb()
 {
 /* hard wired for the target drawing area */
 XSetForeground(disp, gcidrawSP, WhitePixelOfScreen(XtScreen(idrawSP)));
 XFillRectangle(disp, pixmapSP_idraw, gcidrawSP, 0,0, nxidrawSP, nyidrawSP);
 XSetForeground(disp, gcidrawSP, BlackPixelOfScreen(XtScreen(idrawSP)));
 setlinewidth(1, gcidrawSP);
 XDrawRectangle(disp, pixmapSP_idraw, gcidrawSP, 224, 0, 1, 1023);
 XCopyArea(XtDisplay(idrawSP), pixmapSP_idraw, XtWindowOfObject(idrawSP),
 	gcidrawSP, 0, 0, nxidrawSP, nyidrawSP, 0, 0);
 }
 /*--------------------------------------------------------------------------*/
void idrawXRT_popup()
 {
 printf("idrawXRT_popup called, idrawtopXRT = %d\n");
 if (idrawtopXRT) XtPopup(xmgettopshell(idrawtopXRT), XtGrabNone);
 }
 /*--------------------------------------------------------------------------*/
void idrawXRT_dismiss_cb()
 {
 XtPopdown(xmgettopshell(idrawtopXRT));
 }
 /*--------------------------------------------------------------------------*/
void idrawXRT_input_cb(w, ptq, call_data)
 Widget	w;
 XmDrawingAreaCallbackStruct *call_data;
 {
 XEvent  *report = call_data->event;
 char	buffer[16];
 KeySym	keysym;
 int	xrt_xcoord, xrt_ycoord, xrt_root_x, xrt_root_y, xrt_keystate, xrt_button;
 int	xrt_keysym, xrt_keycode, nc;
 /*assume no key and no button down until we find different */
 xrt_keycode = xrt_button = xrt_keysym = xrt_keystate = 0;
 //printf("idrawXRT_input_cb called\n");
 /* check type of input */
 switch (report->xany.type) {
  case ButtonPress:
    xrt_button = report->xbutton.button;
  case ButtonRelease:
    /* note that a release has a button of 0 */
    xrt_xcoord = report->xbutton.x;
    xrt_ycoord = report->xbutton.y;
    xrt_root_x = report->xbutton.x_root;
    xrt_root_y = report->xbutton.y_root;
    xrt_keystate = report->xbutton.state;
    break;
  case KeyPress:
    xrt_keycode = report->xkey.keycode;
    /* note that keycode can be used to distinquish between press and release */
  case KeyRelease:
    xrt_xcoord = report->xkey.x;
    xrt_ycoord = report->xkey.y;
    xrt_root_x = report->xkey.x_root;
    xrt_root_y = report->xkey.y_root;
    xrt_keystate = report->xkey.state;
    nc = XLookupString(&(report->xkey), buffer, 15, &keysym, NULL);
    buffer[nc] = NULL;
    //printf("nc = %d, string = %s\n", nc, buffer);
    xrt_keysym = (int) keysym;
    break;
 }
 //printf("x,y = (%d, %d), root, x,y = (%d, %d), button %d, keystate %d\n",
 //	xrt_xcoord, xrt_ycoord, xrt_root_x, xrt_root_y, xrt_button, xrt_keysym);
 //printf("keycode = %d\n", xrt_keycode);
 if (xrt_button == 1) {
    printf("on XRT CCD (%d, %d)\n", xrt_xcoord*4,xrt_ycoord*4);
 }
 }
 /*--------------------------------------------------------------------------*/
void idrawXRT_resize_cb()
 {
 printf("idrawXRT_resize_cb called\n");
 }
 /*--------------------------------------------------------------------------*/
void idrawXRT_ex_cb()
 {
 int	stat;
 //printf("copying pixmap\n");
 stat = XCopyArea(XtDisplay(idrawXRT), pixmapXRT_idraw, XtWindowOfObject(idrawXRT),
 	gcidrawXRT, 0, 0, nxidrawXRT, nyidrawXRT, 0, 0);
 //printf("stat = %d\n", stat);
 }
 /*--------------------------------------------------------------------------*/
void idrawXRT_erase_cb()
 {
 /* hard wired for the target drawing area */
 XSetForeground(disp, gcidrawXRT, WhitePixelOfScreen(XtScreen(idrawXRT)));
 XFillRectangle(disp, pixmapXRT_idraw, gcidrawXRT, 0,0, nxidrawXRT, nyidrawXRT);
 XSetForeground(disp, gcidrawXRT, BlackPixelOfScreen(XtScreen(idrawXRT)));
 setlinewidth(1, gcidrawXRT);
 XDrawRectangle(disp, pixmapXRT_idraw, gcidrawXRT, 544, 0, 1, 528);
 XCopyArea(XtDisplay(idrawXRT), pixmapXRT_idraw, XtWindowOfObject(idrawXRT),
 	gcidrawXRT, 0, 0, nxidrawXRT, nyidrawXRT, 0, 0);
 }
 /*------------------------------------------------------------------------- */
void drawCT(data, flag, cth)
 /* show the current focus */
 /* displays either a live or ref CT image, also used for redisplays of data
 already read (e.g., with a mask applied). flag%2 determines live or ref
 and data == NULL indicates redisplay */
 int	flag;
 short *data;  /* data should be a 56 x 56 array */
 CTpacketHeader *cth;
 {
 static	short	ref_save[56*56], live_save[56*56];
 Window	w;
 Pixmap	wmap;
 Widget *labels;
 int	nx, ny, n, dmax, dmin, mm, nn, m5, bmin, nx5, ny5, i, focus;
 int	lc, lcc, bad_lc;
 short	*p, *dbase, *psave, tmp, mask;
 float	fsum, fac, dminf, xq, bot, scmax, scmin;
 unsigned char *image, *pb, *pbase, pix;
 char	text[256];
 extern int scalemin, scalemax;
 
 focus = cth->data.focus;
 /* flag tells us whether ref or live and whether a redisplay */
 if (flag%2 == 1) {
  /* the ref case */
  w = XtWindowOfObject(idrawCTref);
  wmap = pixmapCTref_idraw;
  labels = ctlabels_ref;
  mask = ref_mask;
  lcc = 0x40;
  /* save the data for possible rescale */
  p = ref_save;
 } else {
  /* the live case */
  w = XtWindowOfObject(idrawCTlive);
  wmap = pixmapCTlive_idraw;
  p = live_save;
  labels = ctlabels_live;
  mask = live_mask;
  lcc = 0x80;
 }
 /* save each live and ref in case we want to do some comparison of a live with the
 previous ref */
 psave = p;
 if (data != NULL) {
  /* new data to load, not a redisplay */
  n = 56*56;
  dbase = data;
  while (n--) { *p++ = *dbase++; }
 }
 /* dump for check */
 // p = psave;
 // n = 56; i = 0;
  
 // while (n--) {
 //   i = 0;  printf("%2d: ");
 //   m = 56;
 //   while (m--) {
 //   printf("%6d",*p++); i++; if (i%20 == 0) printf("\n");
 //   }
 //   printf("\n");
 //   }

 nx = 49;	ny = 50;
 nx5 = nx*5;	ny5 = ny*5;
 image = malloc(nx5*ny5);
 /* the data in p has the line count as the first element of each row and also
 is padded in both dimensions. We want a 49x50 subset of what is in the 56x56
 array. */
 //mm = ny;
 mm = 39;
 p = psave + 7 + 56*7;
 /* assume auto scale for now and find the min and max in the 49x50 array */
 /* 3/24/2002, scale only for the 42x39 currently used for the sums */
 dmax = dmin = *p;
 fsum = 0.0;
 /* remove bad lc check */
 //bad_lc = 0;
 while (mm--) {
   //nn = nx;
   nn = 42;
   //lc = *p++;
   p++;
   //if (lc != lcc++) bad_lc++;
   while (nn--) {
	if ((tmp = (*p++) & mask) > dmax) dmax = tmp; else if (tmp < dmin) dmin = tmp;
        fsum = fsum + (float) tmp;
	}
	//p = p + 6;	/* to skip over the next line count and pad of 6 */
	p = p + 13;	/* to skip over the next line count and pad of 6 */
 }
 //fsum = fsum/(49*50);
 fsum = fsum/(42*39);
 // if (bad_lc) printf("warning: %d invalid line counts\n");
 // printf("CT max = %d, min = %d, mean = %g\n", dmax, dmin, fsum);
 sprintf(text,"subarea min    %d", dmin);
 xmsetlabel(labels[0], text);
 sprintf(text,"subarea max    %d", dmax);
 xmsetlabel(labels[1], text);
 sprintf(text,"subarea mean   %g", fsum);
 xmsetlabel(labels[2], text);
 sprintf(text,"raw focus %d, wrt center %d", focus, focus-2048);
 xmsetlabel(labels[3], text);
 //if (flag%2 == 0) { 
 //  sprintf(text,"LIVE (%d, %d)", cth->data.LiveErrX, cth->data.LiveErrY);
 //  xmsetlabel(lq_live, text); }
 dminf  = (float) dmin;
 xq = dmax - dmin;
 if (xq > 0) fac = (float) (scalemax - scalemin)/((float) xq); else fac = 0.0;
 if (fac == 0.0) bot = 0.5*(float) (scalemax - scalemin); else bot = (float) scalemin;

 /* scale to our expanded window */
 pb = image;
 /* skip over the first line count */
 p = psave + 1;
 scmax = (float) scalemax;
 scmin = (float) scalemin;
 mm = ny;
 while (mm--) {
   nn = nx;
   while (nn--) {
    xq = (float) ((*p++) & mask);
    xq = fac * (xq - dminf) + bot;
    if (xq > scmax) xq = scmin;
    if (xq < scmin) xq = scmax;
    pix = (unsigned char) xq;
    
    *pb++ = pix; *pb++ = pix; *pb++ = pix; *pb++ = pix; *pb++ = pix;
    pb = pb + 240; /* to next image line */
    *pb++ = pix; *pb++ = pix; *pb++ = pix; *pb++ = pix; *pb++ = pix;
    pb = pb + 240; /* to next image line */
    *pb++ = pix; *pb++ = pix; *pb++ = pix; *pb++ = pix; *pb++ = pix;
    pb = pb + 240; /* to next image line */
    *pb++ = pix; *pb++ = pix; *pb++ = pix; *pb++ = pix; *pb++ = pix;
    pb = pb + 240; /* to next image line */
    *pb++ = pix; *pb++ = pix; *pb++ = pix; *pb++ = pix; *pb++ = pix;
    pb = pb - 4*245; /* back */

    }
    p = p + 7;	/* to skip over the next line count and pad of 6 */
    pb = pb + 245*4;
 }
 //printf("image loaded\n");
 //printf("first and last element of image %d %d\n", *image, *(image + 250*245-1));
 /* put on screen */
 xtv(w, gcidrawCT, image, 245, 250, 0, 0);
 xtv(wmap, gcidrawCT, image, 245, 250, 0, 0);
 idrawCT_popup();  
 }
 /*------------------------------------------------------------------------- */
void idrawCTref_mask_cb()
 {
 /* input the current mask and apply to the current ref image */
 char *s;
 s = xmtextfieldgetstring(ref_mask_text);
 ref_mask = (short) strtol(s, NULL, 0);
 printf("mask = %d, %#x\n", ref_mask, ref_mask);
 XtFree(s);
 drawCT(NULL, 1);
 return;
 }
 /*------------------------------------------------------------------------- */
void idrawCTlive_mask_cb()
 {
 /* input the current mask and apply to the current ref image */
 char *s;
 s = xmtextfieldgetstring(live_mask_text);
 live_mask = (short) strtol(s, NULL, 0);
 printf("mask = %d, %#x\n", live_mask, live_mask);
 XtFree(s);
 drawCT(NULL, 0);
 return;
 }
 /*------------------------------------------------------------------------- */
void drawFGbox(ix0, ix1, iy0, iy1, color)
 /* uses the HK packet to draw the full cutout for the FG product or
 a data packet to show the area of the specific packet */
 int	iy0, iy1, ix0, ix1;
 /* note that x and y are reversed wrt to usage in data_update */
 Pixel	color;
 {
 Window	w;
 //printf("drawFGbox called, %d %d %d %d\n", ix0, ix1, iy0, iy1);
 
 w = XtWindowOfObject(idraw);
 setlinewidth(1, gcidraw);
 setforecolor(color,  gcidraw);
 /* scale to our small window */
 ix0 = ix0/4;  ix1 = ix1/4;  iy0 = iy0/4;  iy1 = iy1/4;
 XDrawRectangle(disp, w, gcidraw, ix0, iy0, ix1-ix0, iy1-iy0);
 XDrawRectangle(disp, pixmap_idraw, gcidraw, ix0, iy0, ix1-ix0, iy1-iy0);
 }
 /*------------------------------------------------------------------------- */
void drawSPbox(ix0, ix1, iy0, iy1, color)
 /* uses the HK packet to draw the full cutout for the SP product or
 a data packet to show the area of the specific packet */
 int	iy0, iy1, ix0, ix1;
 /* note that x and y are reversed wrt to usage in data_update */
 Pixel	color;
 {
 Window	w;
 //printf("drawSPbox called, %d %d %d %d\n", ix0, ix1, iy0, iy1);
 
 w = XtWindowOfObject(idrawSP);
 setlinewidth(1, gcidrawSP);
 setforecolor(color,  gcidrawSP);
 ix0 = ix0;  ix1 = ix1;  iy0 = iy0;  iy1 = iy1;
 XDrawRectangle(disp, w, gcidrawSP, ix0, iy0, ix1-ix0, iy1-iy0);
 XDrawRectangle(disp, pixmapSP_idraw, gcidrawSP, ix0, iy0, ix1-ix0, iy1-iy0);
 /* if raw then just one image, otherwise we have 8 presets for IQUV
 on each side. These are fixed for now since the max size is not too
 brutal and we avoid malloc hassles */
 }
  /*------------------------------------------------------------------------- */
void SPresetMinMax()
 {
 spMin = 100000;
 spMax = -100000;
 }
  /*------------------------------------------------------------------------- */
void FGresetMinMax()
 {
 fgMin = 100000;
 fgMax = -100000;
 }
  /*------------------------------------------------------------------------- */
void XRTresetMinMax()
 {
 xrtMin = 100000;
 xrtMax = -100000;
 }
  /*------------------------------------------------------------------------- */
void drawSPseg(ix0, ix1, iy0, iy1, data, side, subIdProduct)
 /* uses the HK packet to draw the full cutout for the SP product or
 a data packet to show the area of the specific packet */
 int	ix0, ix1, iy0, iy1, side, subIdProduct;
 short *data;
 {
 Window	w;
 char	text[32];
 int	nx, ny, n, nn, mm, xq, base, maxlimit, dmax, dmin;
 short	*p, *j0, tmp, xstride, *dbase;
 unsigned short *dbaseuns, *j0uns;
 float	sum, fac;
 unsigned char *image, *pb, *pbase;
 extern int scalemin, scalemax;
 
 w = XtWindowOfObject(idrawSP);
 nx = ix1-ix0+1;  ny = iy1-iy0+1;
 /* don't do it if the cutout is bad */
 if (nx < 0 || ny < 0 || ix0 < 0 || ix1 < 0) {
   printf("bad cutout in drawSPseg\n");  return; }
 /* if getting min/max and/or scaling, go through the data here first */
 if (spMaxFlag) {
   if (subIdProduct == DPC_STOKES_I) {
     dbaseuns = (unsigned short *) data;
     n = nx*ny;
     while (n--) {
       xq = (int) *dbaseuns++;
       spMax = MAXOF(spMax, xq);
       spMin = MINOF(spMin, xq);
     }
   } else {
     dbase = data;
     n = nx*ny;
     while (n--) {
       xq = *dbase++;
       spMax = MAXOF(spMax, xq);
       spMin = MINOF(spMin, xq);
     }
   }
 }
 /* if scaling, also reset the scalemax, scalemin values now */
 if (spAutoScaleFlag) {
    spscalemax = spMax;  spscalemin = spMin;
 } else idrawSPscale_cb();
 
 /* if not auto scaling, the min/max can be changed via GUI */
 fac = (float) (scalemax - scalemin)/( (float) (spscalemax - spscalemin) );
 base = (int) spscalemin;
 maxlimit = (int) spscalemax;

 n = nx*ny;
 image = malloc(n);
 /* scale */
 mm = ny;
 
 /* if the LHS, we load as a transpose, if RHS we offset in this
 SP window by 226 in spectral direction, note that RHS is not reversed
 as it is for FG so all we have different is the offset here */
 if (side)  { xstride = 1; pbase = image; iy0 = iy0 + 224; }
 	else { xstride =1; pbase = image; }
 if (subIdProduct == DPC_STOKES_I) {
   dbaseuns = (unsigned short *) data;
   j0uns = dbaseuns;
   while (mm--) {
    nn = nx;
    pb = pbase;
    pbase = pbase + xstride;
    while (nn--) {
      xq = (int) *j0uns++;
      /* scale it */
      if (xq > base) {
    	  if (xq < maxlimit) {
	     sum = ( (float) xq - base)* fac + (float) scalemin;
    	     /* pop it where it belongs */
    	     *pb = (unsigned char) sum;
	  } else {
    	     *pb = (unsigned char) scalemax;
	  } } else *pb = (unsigned char) scalemin; 	
      pb += ny;
     }
   }
 } else {
   dbase = data;
   j0 = dbase;
   while (mm--) {
    nn = nx;
    pb = pbase;
    pbase = pbase + xstride;
    while (nn--) {
      xq = (int) *j0++;
      /* scale it */
      if (xq > base) {
    	  if (xq < maxlimit) {
	     sum = ( (float) xq - base)* fac + (float) scalemin;
    	     /* pop it where it belongs */
    	     *pb = (unsigned char) sum;
	  } else {
    	     *pb = (unsigned char) scalemax;
	  } } else *pb = (unsigned char) scalemin; 	
      pb += ny;
     }
   }
 }

 if (spMaxFlag) {
   sprintf(text, "min: %5d", spMin); xmsetlabel(splabels[0], text);
   sprintf(text, "max: %5d", spMax); xmsetlabel(splabels[1], text);
 }
 /* put on screen */
 xtv(w, gcidrawSP, image, ny, nx, iy0, ix0);
 xtv(pixmapSP_idraw, gcidrawSP, image, ny, nx, iy0, ix0);
 free(image);
 }
  /*------------------------------------------------------------------------- */
void drawFGseg(ix0, ix1, iy0, iy1, data, side, sfac)
 /* uses the HK packet to draw the full cutout for the FG product or
 a data packet to show the area of the specific packet */
 int	ix0, ix1, iy0, iy1, side, sfac;
 /* sfac added to do summing and binning */
 short *data;
 {
 Window	w;
 char	text[32];
 int	nx, ny, n, nxd4, nyd4, n4, mm, nn, xq;
 short	*p, tmp, *j0, *j1, *j2, *j3, xstride, *dbase;
 float	sum, fac, base, maxlimit, fq;
 unsigned char *image, *pb, *pbase;
 extern int scalemin, scalemax;
 //printf("drawFGseg called, %d %d %d %d\n", ix0, ix1, iy0, iy1);
 
 nx = ix1-ix0+1;  ny = iy1-iy0+1;
 if (fgMaxFlag) {
   /* scan the data for min and max before loading image */
   nn = nx * ny/(sfac*sfac);
   p = data;
   while (nn--) {
     xq = *p++;
     fgMax = MAXOF(fgMax, xq);
     fgMin = MINOF(fgMin, xq);
   }
 }
 /* if scaling, also reset the scalemax, scalemin values now */
 if (fgAutoScaleFlag) {
    fgscalemax = fgMax;  fgscalemin = fgMin;
 } else idrawFGscale_cb();

 w = XtWindowOfObject(idraw);
 /* if not auto scaling, the min/max can be changed via GUI */
 /* the # of data pixels per screen pixels depends on sfac */
 fq = 16./(sfac*sfac);
 fac = (float) (scalemax - scalemin)/(fq * (float) (fgscalemax - fgscalemin) );
 base = fq * (float) fgscalemin;
 maxlimit = fq * (float) fgscalemax;
 /* scale to our small window, the size doesn't depend on sfac because
 nx and ny are for full CCD already */
 nxd4 = nx/4;	nyd4 = ny/4;
 n4 = nxd4 * nyd4;
 //printf("sfac, nxd4, nyd4, n4 = %d %d %d %d\n", sfac, nxd4, nyd4, n4);
 /* now convert nx and ny to data size */
 nx = nx / sfac;	ny = ny / sfac;
 image = malloc(n4);
 /* scale and compress */
 dbase = data;
 mm = nyd4;
 
 //printf("side = %d\n", side);
 /* if the LHS, we load as a transpose, if RHS we also reverse x */
 if (side)  { xstride = -1; pbase = image + nyd4 - 1; }
 	else { xstride =1; pbase = image; }
 switch (sfac) {
 
 case 1:
   while (mm--) {
    j0 = dbase;
    j1 = j0 + nx;
    j2 = j1 + nx;
    j3 = j2 + nx;
    dbase = dbase + 4*nx;
    nn = nxd4;
    pb = pbase;
    pbase = pbase + xstride;
    while (nn--) {
      sum = 0;
      sum += (float) *j0++; sum += (float) *j0++; sum += (float) *j0++; sum += (float) *j0++;
      sum += (float) *j1++; sum += (float) *j1++; sum += (float) *j1++; sum += (float) *j1++;
      sum += (float) *j2++; sum += (float) *j2++; sum += (float) *j2++; sum += (float) *j2++;
      sum += (float) *j3++; sum += (float) *j3++; sum += (float) *j3++; sum += (float) *j3++;
      /* scale it */
      if (sum > base) {
    	  if (sum < maxlimit) {
	     sum = (sum - base)* fac + (float) scalemin;
    	     /* pop it where it belongs */
    	     *pb = (unsigned char) sum;
	  } else {
    	     *pb = (unsigned char) scalemax;
	  } } else *pb = (unsigned char) scalemin; 	
      pb += nyd4;
     }
   }
   break;
 case 2:
   while (mm--) {
    //printf("mm = %d\n", mm);
    //printf("pbase = %d\n", pbase);
    j0 = dbase;
    j1 = j0 + nx;
    dbase = dbase + 2*nx;
    nn = nxd4;
    pb = pbase;
    pbase = pbase + xstride;
    while (nn--) {
      //printf("nn = %d\n", nn);
      sum = 0;
      sum += (float) *j0++; sum += (float) *j0++;
      sum += (float) *j1++; sum += (float) *j1++;
      /* scale it */
      if (sum > base) {
    	  if (sum < maxlimit) {
	     sum = (sum - base)* fac + (float) scalemin;
    	     /* pop it where it belongs */
    	     *pb = (unsigned char) sum;
	  } else {
    	     *pb = (unsigned char) scalemax;
	  } } else *pb = (unsigned char) scalemin; 	
      pb += nyd4;
     }
   }
   break;
  case 4:
   while (mm--) {
    //printf("mm = %d\n", mm);
    //printf("pbase = %d\n", pbase);
    j0 = dbase;
    dbase = dbase + nx;
    nn = nxd4;
    pb = pbase;
    pbase = pbase + xstride;
    while (nn--) {
      //printf("nn = %d\n", nn);
      sum = (float) *j0++;
      /* scale it */
      if (sum > base) {
    	  if (sum < maxlimit) {
	     sum = (sum - base)* fac + (float) scalemin;
    	     /* pop it where it belongs */
    	     *pb = (unsigned char) sum;
	  } else {
    	     *pb = (unsigned char) scalemax;
	  } } else *pb = (unsigned char) scalemin; 	
      pb += nyd4;
     }
   }
   break;
 default:
   snprintf(linebuf, 500, "can't display with a scale factor of %d\n", sfac);
   xmmessage(toplevel, linebuf, font4, "red", 400,400);
   return;

 }
 
 if (fgMaxFlag) {
   sprintf(text, "min: %5d", fgMin); xmsetlabel(fglabels[0], text);
   sprintf(text, "max: %5d", fgMax); xmsetlabel(fglabels[1], text);
 }
 /* put on screen */
 xtv(w, gcidraw, image, nyd4, nxd4, iy0/4, ix0/4);
 xtv(pixmap_idraw, gcidraw, image, nyd4, nxd4, iy0/4, ix0/4);
 free(image);
 }
  /*------------------------------------------------------------------------- */
void drawXRTseg(ix0, ix1, iy0, iy1, data)
 /* uses the HK packet to draw the full cutout for the XRT product or
 a data packet to show the area of the specific packet */
 int	ix0, ix1, iy0, iy1;
 /* sfac added to do summing and binning */
 short *data;
 {
 Window	w;
 char	text[32];
 int	sfac=1;
 int	nx, ny, n, nxd4, nyd4, n4, mm, nn, xq;
 short	*p, tmp, *j0, *j1, *j2, *j3, xstride, *dbase;
 float	sum, fac, base, maxlimit, fq;
 unsigned char *image, *pb, *pbase;
 extern int scalemin, scalemax;
 //printf("drawXRTseg called, %d %d %d %d\n", ix0, ix1, iy0, iy1);
 
 nx = ix1-ix0+1;  ny = iy1-iy0+1;
 if (xrtMaxFlag) {
   /* scan the data for min and max before loading image */
   nn = nx * ny/(sfac*sfac);
   p = data;
   while (nn--) {
     xq = *p++;
     xrtMax = MAXOF(xrtMax, xq);
     xrtMin = MINOF(xrtMin, xq);
   }
 }
 /* if scaling, also reset the scalemax, scalemin values now */
 if (xrtAutoScaleFlag) {
    xrtscalemax = xrtMax;  xrtscalemin = xrtMin;
 } else idrawXRTscale_cb();

 w = XtWindowOfObject(idrawXRT);
 /* if not auto scaling, the min/max can be changed via GUI */
 /* the # of data pixels per screen pixels depends on sfac */
 fq = 16./(sfac*sfac);
 fac = (float) (scalemax - scalemin)/(fq * (float) (xrtscalemax - xrtscalemin) );
 base = fq * (float) xrtscalemin;
 maxlimit = fq * (float) xrtscalemax;
 /* scale to our small window, the size doesn't depend on sfac because
 nx and ny are for full CCD already */
 nxd4 = nx/4;	nyd4 = ny/4;
 n4 = nxd4 * nyd4;
 //printf("nxd4, nyd4, n4 = %d %d %d\n", nxd4, nyd4, n4);
 /* now convert nx and ny to data size */
 nx = nx / sfac;	ny = ny / sfac;
 image = malloc(n4);
 /* scale and compress */
 dbase = data;
 mm = nyd4;
 
 /* only one side for XRT */
 xstride =1; pbase = image;
 /* sfac can only be 1 at present, I don't know if XRT supports CCD summing */
 switch (sfac) {
 
 case 1:
   while (mm--) {
    j0 = dbase;
    j1 = j0 + nx;
    j2 = j1 + nx;
    j3 = j2 + nx;
    dbase = dbase + 4*nx;
    nn = nxd4;
    pb = pbase;
    pbase = pbase + xstride;
    while (nn--) {
      sum = 0;
      sum += (float) *j0++; sum += (float) *j0++; sum += (float) *j0++; sum += (float) *j0++;
      sum += (float) *j1++; sum += (float) *j1++; sum += (float) *j1++; sum += (float) *j1++;
      sum += (float) *j2++; sum += (float) *j2++; sum += (float) *j2++; sum += (float) *j2++;
      sum += (float) *j3++; sum += (float) *j3++; sum += (float) *j3++; sum += (float) *j3++;
      /* scale it */
      if (sum > base) {
    	  if (sum < maxlimit) {
	     sum = (sum - base)* fac + (float) scalemin;
    	     /* pop it where it belongs */
    	     *pb = (unsigned char) sum;
	  } else {
    	     *pb = (unsigned char) scalemax;
	  } } else *pb = (unsigned char) scalemin; 	
      pb += nyd4;
     }
   }
   break;
 case 2:
   while (mm--) {
    //printf("mm = %d\n", mm);
    //printf("pbase = %d\n", pbase);
    j0 = dbase;
    j1 = j0 + nx;
    dbase = dbase + 2*nx;
    nn = nxd4;
    pb = pbase;
    pbase = pbase + xstride;
    while (nn--) {
      //printf("nn = %d\n", nn);
      sum = 0;
      sum += (float) *j0++; sum += (float) *j0++;
      sum += (float) *j1++; sum += (float) *j1++;
      /* scale it */
      if (sum > base) {
    	  if (sum < maxlimit) {
	     sum = (sum - base)* fac + (float) scalemin;
    	     /* pop it where it belongs */
    	     *pb = (unsigned char) sum;
	  } else {
    	     *pb = (unsigned char) scalemax;
	  } } else *pb = (unsigned char) scalemin; 	
      pb += nyd4;
     }
   }
   break;
  case 4:
   while (mm--) {
    //printf("mm = %d\n", mm);
    //printf("pbase = %d\n", pbase);
    j0 = dbase;
    dbase = dbase + nx;
    nn = nxd4;
    pb = pbase;
    pbase = pbase + xstride;
    while (nn--) {
      //printf("nn = %d\n", nn);
      sum = (float) *j0++;
      /* scale it */
      if (sum > base) {
    	  if (sum < maxlimit) {
	     sum = (sum - base)* fac + (float) scalemin;
    	     /* pop it where it belongs */
    	     *pb = (unsigned char) sum;
	  } else {
    	     *pb = (unsigned char) scalemax;
	  } } else *pb = (unsigned char) scalemin; 	
      pb += nyd4;
     }
   }
   break;
 default:
   snprintf(linebuf, 500, "can't display with a scale factor of %d\n", sfac);
   xmmessage(toplevel, linebuf, font4, "red", 400,400);
   return;

 }
 
 if (xrtMaxFlag) {
   sprintf(text, "min: %5d", xrtMin); xmsetlabel(xrtlabels[0], text);
   sprintf(text, "max: %5d", xrtMax); xmsetlabel(xrtlabels[1], text);
 }
 /* put on screen */
 xtv(w, gcidrawXRT, image, nyd4, nxd4, iy0/4, ix0/4);
 xtv(pixmapXRT_idraw, gcidrawXRT, image, nyd4, nxd4, iy0/4, ix0/4);
 free(image);
 }
 /*------------------------------------------------------------------------- */
void testimage()
 {
 /* load a test pattern */
 unsigned char *p, *image;
 int	n, i=0, j=0, iq, jq, rq;
 Window	w;
 n = 1024*512;
 p = image = malloc(n);
 while (n--) {
  	iq = (i-512);	jq = (j-256); rq = iq*iq + jq*jq;
	*p++ = rq%256;  i = (i+1)%1024;  if (i ==0) j++; }
 w = XtWindowOfObject(idraw);
 xtv(w, gcidraw, image, 1024, 512, 0, 0);
 xtv(pixmap_idraw, gcidraw, image, 1024, 512, 0, 0);
 free(image);
 /* also for the SP */
  n = 450*1024;
  i=0;  j = 0;
  p = image = malloc(n);
  while (n--) {
   	iq = (i-225);	jq = (j-512); rq = iq*iq + jq*jq;
	*p++ = rq%256;  i = (i+1)%450;  if (i ==0) j++; }
  w = XtWindowOfObject(idrawSP);
  xtv(w, gcidrawSP, image, 450, 1024, 0, 0);
  xtv(pixmapSP_idraw, gcidrawSP, image, 450, 1024, 0, 0);
  free(image);
 
 /* also for the XRT */
  n = 544*528;
  i=0;  j = 0;
  p = image = malloc(n);
  while (n--) {
   	iq = (i-544/2);	jq = (j-528/2); rq = iq*iq + jq*jq;
	*p++ = rq%256;  i = (i+1)%528;  if (i ==0) j++; }
  w = XtWindowOfObject(idrawXRT);
  xtv(w, gcidrawXRT, image, 528, 544, 0, 0);
  xtv(pixmapXRT_idraw, gcidrawXRT, image, 528, 544, 0, 0);
  free(image);
 }
 /*------------------------------------------------------------------------- */
void display_area()
 {
 /* the 3 display_area routines probably should be done in C++ style as a
 class, this would reduce the code here significantly */
 /* create a toplevel form with a drawing area for displaying FG images */
 char *title, *fontname;
 char	text[32];
 char *max_label[] = { "do min/max"};
 int	nx, ny;
 Widget	bb, button1, sc, lq, tq;
 void	idraw_dismiss_cb(), idraw_input_cb(), idraw_resize_cb(), idraw_ex_cb();
 void	idraw_erase_cb();
 if ( idrawtop == NULL) {
 title = "FPP FG full CCD at 1/4 scale";
 nx = 1024;	ny = 512;
 printf("mark 0\n");
 idrawtop = xmtoplevel_form(nx, ny, title, 0,0,0,0);
 bb = xmboard(idrawtop, 0, 0, 10, 10);

 button1 = xmbutton(bb, "Dismiss", font4, "gray", idraw_dismiss_cb);
 xmsize(button1, 80,30);
 xmposition(button1, 10,10);

 button1 = xmbutton(bb, "erase", font4, "gray", idraw_erase_cb);
 xmsize(button1, 80,30); xmposition(button1, 100,10);

 lq = xmlabel(bb, "scale min", font4, "", 1);
 xmposition(lq, 190, 14);
 fgtext[0] = tq = xmtextfield(bb, "0", 20, font3, "white"); 
 xmsize(tq, 70,30); xmposition(tq, 260, 10);
 /* add a callback */
 XtAddCallback(tq, XmNactivateCallback, idrawFGscale_cb, NULL); 
 sprintf(text, "%d", fgscalemin); xmtextfieldsetstring(tq, text, 0);

 lq = xmlabel(bb, "scale max", font4, "", 1);
 xmposition(lq, 358, 14);
 fgtext[1] = tq = xmtextfield(bb, "4095", 20, font3, "white"); 
 xmposition(tq, 430, 10);
 xmsize(tq, 70,30);
 XtAddCallback(tq, XmNactivateCallback, idrawFGscale_cb, NULL);
 sprintf(text, "%d", fgscalemax); xmtextfieldsetstring(tq, text, 0);

 /* add a check box to allow min/max scans */
 FGmaxcheck = xmcheckbox(bb, font3, "red", max_label, 1, 1, fgmax_cb);
 xmposition(FGmaxcheck->array[0], 530, 8);
 fglabels[0] = lq = xmlabel(bb, "min:", font4, "", 1);
 xmposition(lq, 650, 14);
 fglabels[1] = lq = xmlabel(bb, "max:", font4, "", 1);
 xmposition(lq, 750, 14);

 /* also in the top bb section, add a label with mech positions */ 
 lq = xmlabel(bb, "mech status from last FG header:", font4, "", 1);
 xmposition(lq, 10, 43);
 mechLabel = lq;

 nxidraw = 1024;	nyidraw = 512;
 sc = xmscrolledwindow(idrawtop, 1050, 530);
 xmattach(bb, NULL, 1,1,1,0);
 xmattach(sc, bb,  0,0,1,0);
 //xmattach(sc, NULL, 1,1,0,0);
 xmattach(sc, NULL, 1,1,0,1);
 idraw = xmdrawingarea(sc, nxidraw, nyidraw, idraw_input_cb,
 	idraw_resize_cb, idraw_ex_cb);
 /* we have to get the window managed before we can setup the GC and all
 using this window. The older code used the default depth so it could
 use the root window. But if are using a non-default we have to be sure
 to do the GC with the proper depth. */
 idraw_popup();
 /* the gc */
 gcidraw = XCreateGC(disp, XtWindowOfObject(idraw), 0,NULL);
 /* because we may not be using the default visual, don't use BlackPixel
 or WhitePixel */
 //XSetForeground(disp, gcidraw, WhitePixelOfScreen(XtScreen(idrawtop)));
 setforecolor(black_pixel,  gcidraw);
 setbackcolor(white_pixel,  gcidraw);
 /* also must do this because some erases (partials) use Clears */
 XSetWindowBackground(disp,XtWindowOfObject(idraw), white_pixel);

 fontname = font3;
 if ( (font_draw = XLoadQueryFont(disp, fontname)) == NULL)
  { printf("font does not exist: %s\n"); }
  else  XSetFont( disp, gcidraw, font_draw->fid);
 /* create a pixmap and erase it, this will be used to redraw the area */
 printf("screen_depth = %d\n", screen_depth);
 pixmap_idraw = XCreatePixmap(disp,XtWindowOfObject(idraw), nxidraw, nyidraw,
	screen_depth);
 XFillRectangle(disp, pixmap_idraw, gcidraw, 0,0, nxidraw, nyidraw);
 //XSetForeground(disp, gcidraw, BlackPixelOfScreen(XtScreen(idrawtop)));
 printf("done in FG display_area\n");

 } else idraw_popup();
 /* but popdown until we need it */
 //XtPopdown(xmgettopshell(idrawtop));  
 return;
 }
 /*------------------------------------------------------------------------- */
void display_areaSP()
 {
 /* create a toplevel form with a drawing area for displaying SP images */
 char *title, *fontname;
 char	text[32];
 char *max_label[] = { "do min/max"};
 int	nx, ny;
 Widget	bb, button1, sc, lq, tq;
 void	idrawSP_dismiss_cb(), idrawSP_input_cb(), idrawSP_resize_cb(), idrawSP_ex_cb();
 void	idrawSP_erase_cb();
 if ( idrawtopSP == NULL) {
 title = "FPP SP full CCD";
 nx = 448;	ny = 1024;
 idrawtopSP = xmtoplevel_form(nx, ny, title, 0,0,0,0);
 bb = xmboard(idrawtopSP, 0, 0, 10, 10);

 button1 = xmbutton(bb, "Dismiss", font4, "gray", idrawSP_dismiss_cb);
 xmsize(button1, 80,30);
 xmposition(button1, 10,10);

 button1 = xmbutton(bb, "erase", font4, "gray", idrawSP_erase_cb);
 xmsize(button1, 80,30);
 xmposition(button1, 100,10);
 lq = xmlabel(bb, "scale min", font4, "", 1);
 xmposition(lq, 190, 14);
 sptext[0] = tq = xmtextfield(bb, "0", 20, font3, "white"); 
 xmsize(tq, 70,30);
 xmposition(tq, 260, 10);
 /* add a callback */
 XtAddCallback(tq, XmNactivateCallback, idrawSPscale_cb, NULL); 
 sprintf(text, "%d", spscalemin);
 xmtextfieldsetstring(tq, text, 0);  
 lq = xmlabel(bb, "scale max", font4, "", 1);
 xmposition(lq, 330, 14);
 sptext[1] = tq = xmtextfield(bb, "4095", 20, font3, "white"); 
 xmposition(tq, 400, 10);
 xmsize(tq, 70,30);
 XtAddCallback(tq, XmNactivateCallback, idrawSPscale_cb, NULL); 
 sprintf(text, "%d", spscalemax);
 xmtextfieldsetstring(tq, text, 0);  

 /* add a check box to allow min/max scans */
 SPmaxcheck = xmcheckbox(bb, font3, "red", max_label, 1, 1, spmax_cb);
 xmposition(SPmaxcheck->array[0], 0, 40);
 /* and label fields for the min/max values */
 splabels[0] = lq = xmlabel(bb, "min:", font4, "", 1);
 xmposition(lq, 190, 45);
 splabels[1] = lq = xmlabel(bb, "max:", font4, "", 1);
 xmposition(lq, 330, 45);

 /* also in the top bb section, add a label for time */ 
 lq = xmlabel(bb, "Once upon a time ...", font4, "", 1);
 xmposition(lq, 10, 43);
 SPtimeLabel = lq;
 xmposition(lq, 0, 70);
 
 nxidrawSP = 450;	nyidrawSP = 1024;
 sc = xmscrolledwindow(idrawtopSP, nxidrawSP, nyidrawSP);
 xmattach(bb, NULL, 1,1,1,0);
 xmattach(sc, bb,  0,0,1,0);
 //xmattach(sc, NULL, 1,1,0,0);
 xmattach(sc, NULL, 1,1,0,1);
 idrawSP = xmdrawingarea(sc, nxidrawSP, nyidrawSP, idrawSP_input_cb,
 	idrawSP_resize_cb, idrawSP_ex_cb);
 /* we have to get the window managed before we can setup the GC and all
 using this window. The older code used the default depth so it could
 use the root window. But if are using a non-default we have to be sure
 to do the GC with the proper depth. */
 idrawSP_popup();

 /* the gc */
 gcidrawSP = XCreateGC(disp, XtWindowOfObject(idrawSP),0,NULL);
 /* because we may not be using the default visual, don't use BlackPixel
 or WhitePixel */
 //XSetForeground(disp, gcidrawSP, WhitePixelOfScreen(XtScreen(idrawtopSP)));
 setforecolor(black_pixel,  gcidrawSP);
 setbackcolor(white_pixel,  gcidrawSP);
 /* also must do this because some erases (partials) use Clears */
 XSetWindowBackground(disp,XtWindowOfObject(idrawSP), white_pixel);

 fontname = font3;
 if ( (font_draw = XLoadQueryFont(disp, fontname)) == NULL)
  { printf("font does not exist: %s\n"); }
  else  XSetFont( disp, gcidrawSP, font_draw->fid);
 /* create a pixmap and erase it, this will be used to redraw the area */
 pixmapSP_idraw = XCreatePixmap(disp,
 	RootWindowOfScreen(XtScreen(idrawtopSP)), nxidrawSP, nyidrawSP,
	screen_depth);
 XFillRectangle(disp, pixmapSP_idraw, gcidrawSP, 0,0, nxidrawSP, nyidrawSP);
 //XSetForeground(disp, gcidrawSP, BlackPixelOfScreen(XtScreen(idrawtopSP)));
 setlinewidth(1, gcidrawSP);
 XDrawRectangle(disp, pixmapSP_idraw, gcidrawSP, 224, 0, 1, 1023);
 } else idrawSP_popup();
 /* but popdown until we need it */
 //XtPopdown(xmgettopshell(idrawtopSP));  
 return;
 }
 /*------------------------------------------------------------------------- */
void display_areaXRT()
 {
 /* create a toplevel form with a drawing area for displaying XRT images */
 char *title, *fontname;
 char	text[32];
 char *max_label[] = { "do min/max"};
 int	nx, ny;
 Widget	bb, button1, sc, lq, tq;
 void	idrawXRT_dismiss_cb(), idrawXRT_input_cb(), idrawXRT_resize_cb(), idrawXRT_ex_cb();
 void	idrawXRT_erase_cb();
 if ( idrawtopXRT == NULL) {
 title = "XRT full CCD at 1/4 scale";
 ny = 544;	nx = 528;
 idrawtopXRT = xmtoplevel_form(nx, ny, title, 0,0,0,0);
 bb = xmboard(idrawtopXRT, 0, 0, 10, 10);

 button1 = xmbutton(bb, "Dismiss", font4, "gray", idrawXRT_dismiss_cb);
 xmsize(button1, 80,30);
 xmposition(button1, 10,10);

 button1 = xmbutton(bb, "erase", font4, "gray", idrawXRT_erase_cb);
 xmsize(button1, 80,30);
 xmposition(button1, 100,10);
 lq = xmlabel(bb, "scale min", font4, "", 1);
 xmposition(lq, 190, 14);
 xrttext[0] = tq = xmtextfield(bb, "0", 20, font3, "white"); 
 xmsize(tq, 70,30);
 xmposition(tq, 260, 10);
 /* add a callback */
 XtAddCallback(tq, XmNactivateCallback, idrawXRTscale_cb, NULL); 
 sprintf(text, "%d", xrtscalemin);
 xmtextfieldsetstring(tq, text, 0);  
 lq = xmlabel(bb, "scale max", font4, "", 1);
 xmposition(lq, 330, 14);
 xrttext[1] = tq = xmtextfield(bb, "4095", 20, font3, "white"); 
 xmposition(tq, 400, 10);
 xmsize(tq, 70,30);
 XtAddCallback(tq, XmNactivateCallback, idrawXRTscale_cb, NULL); 
 sprintf(text, "%d", xrtscalemax);
 xmtextfieldsetstring(tq, text, 0);  

 /* add a check box to allow min/max scans */
 XRTmaxcheck = xmcheckbox(bb, font3, "red", max_label, 1, 1, xrtmax_cb);
 xmposition(XRTmaxcheck->array[0], 0, 40);
 /* and label fields for the min/max values */
 xrtlabels[0] = lq = xmlabel(bb, "min:", font4, "", 1);
 xmposition(lq, 190, 45);
 xrtlabels[1] = lq = xmlabel(bb, "max:", font4, "", 1);
 xmposition(lq, 330, 45);

 /* also in the top bb section, add a label for time */ 
 lq = xmlabel(bb, "Once upon a time ...", font4, "", 1);
 xmposition(lq, 10, 43);
 XRTtimeLabel = lq;
 xmposition(lq, 0, 70);
 
 nxidrawXRT = 528;	nyidrawXRT = 544;
 sc = xmscrolledwindow(idrawtopXRT, nxidrawXRT, nyidrawXRT);
 xmattach(bb, NULL, 1,1,1,0);
 xmattach(sc, bb,  0,0,1,0);
 //xmattach(sc, NULL, 1,1,0,0);
 xmattach(sc, NULL, 1,1,0,1);
 idrawXRT = xmdrawingarea(sc, nxidrawXRT, nyidrawXRT, idrawXRT_input_cb,
 	idrawXRT_resize_cb, idrawXRT_ex_cb);
 /* we have to get the window managed before we can setup the GC and all
 using this window. The older code used the default depth so it could
 use the root window. But if are using a non-default we have to be sure
 to do the GC with the proper depth. */
 idrawXRT_popup();

 /* the gc */
 gcidrawXRT = XCreateGC(disp, XtWindowOfObject(idrawXRT),0,NULL);
 /* because we may not be using the default visual, don't use BlackPixel
 or WhitePixel */
 //XSetForeground(disp, gcidrawXRT, WhitePixelOfScreen(XtScreen(idrawtopXRT)));
 setforecolor(black_pixel,  gcidrawXRT);
 setbackcolor(white_pixel,  gcidrawXRT);
 /* also must do this because some erases (partials) use Clears */
 XSetWindowBackground(disp,XtWindowOfObject(idrawXRT), white_pixel);

 fontname = font3;
 if ( (font_draw = XLoadQueryFont(disp, fontname)) == NULL)
  { printf("font does not exist: %s\n"); }
  else  XSetFont( disp, gcidrawXRT, font_draw->fid);
 /* create a pixmap and erase it, this will be used to redraw the area */
 pixmapXRT_idraw = XCreatePixmap(disp,
 	RootWindowOfScreen(XtScreen(idrawtopXRT)), nxidrawXRT, nyidrawXRT,
	screen_depth);
 XFillRectangle(disp, pixmapXRT_idraw, gcidrawXRT, 0,0, nxidrawXRT, nyidrawXRT);
 //XSetForeground(disp, gcidrawXRT, BlackPixelOfScreen(XtScreen(idrawtopXRT)));
 setlinewidth(1, gcidrawXRT);
 XDrawRectangle(disp, pixmapXRT_idraw, gcidrawXRT, 528, 0, 1, 544);
 } else idrawXRT_popup();
 /* but popdown until we need it */
 //XtPopdown(xmgettopshell(idrawtopXRT));  
 return;
 }
 /*------------------------------------------------------------------------- */
void display_areaCT()
 {
 /* create a toplevel form with a drawing area for displaying CT images */
 char *title, *fontname;
 int	nx, ny;
 Widget	bb, bb2, button1, sc, lq, bq;
 void	idrawCT_dismiss_cb(), idrawCT_input_cb(), idrawCT_resize_cb();
 void	idrawCT_erase_cb(), idrawCT_ex_cb();
 if ( idrawtopCT == NULL) {
 title = "FPP CT images";
 nx = 520;	ny = 430;
 idrawtopCT = xmtoplevel_form(nx, ny, title, 0,0,0,0);
 bb = xmboard(idrawtopCT, 0, 0, 10, 10);

 button1 = xmbutton(bb, "Dismiss", font4, "gray", idrawCT_dismiss_cb);
 xmsize(button1, 80,30);
 xmposition(button1, 10,10);

 /* also in the top bb section, add a label for time */ 
 lq = xmlabel(bb, "Once upon a time ...", font4, "", 1);
 xmposition(lq, 10, 43);
 CTtimeLabel = lq;
 xmposition(lq, 190, 15);

 button1 = xmbutton(bb, "erase", font4, "gray", idrawCT_erase_cb);
 xmsize(button1, 80,30);
 xmposition(button1, 100,10);
 
 lq = xmlabel(bb, "REF",  font4, "", 0);
 xmposition(lq, 100, 45);
 lq_live = xmlabel(bb, "LIVE", font4, "", 1);
 xmposition(lq_live, 330, 45);

 nxidrawCT = 245;	nyidrawCT = 250;
 /* for these CT displays, just put fixed drawing areas into another bb */
 bb2 = xmboard(idrawtopCT, 520, 310, 10, 2);
 xmattach(bb, NULL, 1,1,1,0);
 xmattach(bb2, bb,  0,0,1,0);
 xmattach(bb2, NULL, 1,1,0,1);
 idrawCTref = xmdrawingarea(bb2, nxidrawCT, nyidrawCT, idrawCT_input_cb,
 	idrawCT_resize_cb, idrawCT_ex_cb);
 xmposition(idrawCTref, 10,10);
 idrawCTlive = xmdrawingarea(bb2, nxidrawCT, nyidrawCT, idrawCT_input_cb,
 	idrawCT_resize_cb, idrawCT_ex_cb);
 xmposition(idrawCTlive, 265,10);
 /* setup some labels for image info */
 ctlabels_ref[0] = lq = xmlabel(bb2, "subarea min", font4, "", 1);
 xmposition(lq, 20, 260);
 ctlabels_ref[1] = lq = xmlabel(bb2, "subarea max", font4, "", 1);
 xmposition(lq, 20, 277);
 ctlabels_ref[2] = lq = xmlabel(bb2, "subarea mean", font4, "", 1);
 xmposition(lq, 20, 294);
 ctlabels_ref[3] = lq = xmlabel(bb2, "focus", font4, "", 1);
 xmposition(lq, 20, 311);
 ctlabels_live[0] = lq = xmlabel(bb2, "subarea min", font4, "", 1);
 xmposition(lq, 275, 260);
 ctlabels_live[1] = lq = xmlabel(bb2, "subarea max", font4, "", 1);
 xmposition(lq, 275, 277);
 ctlabels_live[2] = lq = xmlabel(bb2, "subarea mean", font4, "", 1);
 xmposition(lq, 275, 294);
 ctlabels_live[3] = lq = xmlabel(bb2, "focus", font4, "", 1);
 printf("ctlabels_live[3] = %d\n", ctlabels_live[3]);
 xmposition(lq, 275, 311);
 /* a mask button and text field for each */
 bq = xmbutton(bb2, "mask", font4, "gray", idrawCTref_mask_cb);
 xmsize(bq, 80,30);
 ref_mask_text = xmtextfield(bb2, "0xffff", 20, font3, "white"); 
 /* add a callback */
 XtAddCallback(ref_mask_text, XmNactivateCallback, idrawCTref_mask_cb, NULL); 
 xmsize(ref_mask_text, 90,30);
 xmposition(bq, 20, 332);
 xmposition(ref_mask_text, 110, 332);
 ref_mask = 0xffff;  

 bq = xmbutton(bb2, "mask", font4, "gray", idrawCTlive_mask_cb);
 xmsize(bq, 80,30);
 live_mask_text = xmtextfield(bb2, "0xffff", 20, font3, "white"); 
 XtAddCallback(live_mask_text, XmNactivateCallback, idrawCTlive_mask_cb, NULL); 
 xmsize(live_mask_text, 90,30);
 xmposition(bq, 275, 332);
 xmposition(live_mask_text, 365, 332);
 xmtextfieldsetstring(live_mask_text, "0xffff", 0);  
 live_mask = 0xffff;  

 /* we have to get the window managed before we can setup the GC and all
 using this window. The older code used the default depth so it could
 use the root window. But if are using a non-default we have to be sure
 to do the GC with the proper depth. */
 idrawCT_popup();
 /* the gc */
 gcidrawCT = XCreateGC(disp, XtWindowOfObject(idrawtopCT),0,NULL);
 /* because we may not be using the default visual, don't use BlackPixel
 or WhitePixel (the color may not be what you expected) */
 //XSetForeground(disp, gcidrawCT, WhitePixelOfScreen(XtScreen(idrawtopCT)));
 setforecolor(black_pixel,  gcidrawCT);
 setbackcolor(white_pixel,  gcidrawCT);
 /* also must do this because some erases (partials) use Clears */
 XSetWindowBackground(disp,XtWindowOfObject(idrawtopCT), white_pixel);

 fontname = font3;
 if ( (font_draw = XLoadQueryFont(disp, fontname)) == NULL)
  { printf("font does not exist: %s\n"); }
  else  XSetFont( disp, gcidrawCT, font_draw->fid);
 /* create a pixmap and erase it, this will be used to redraw the area */
 pixmapCTref_idraw = XCreatePixmap(disp,XtWindowOfObject(idrawtopCT), nxidrawCT, nyidrawCT,
	screen_depth);
 XFillRectangle(disp, pixmapCTref_idraw, gcidrawCT, 0,0, nxidrawCT, nyidrawCT);
 pixmapCTlive_idraw = XCreatePixmap(disp,XtWindowOfObject(idrawtopCT), nxidrawCT, nyidrawCT,
	screen_depth);
 XFillRectangle(disp, pixmapCTlive_idraw, gcidrawCT, 0,0, nxidrawCT, nyidrawCT);
 //XSetForeground(disp, gcidrawCT, black_pixel);
 } else idrawCT_popup();
 /* but popdown until we need it */
 XtPopdown(xmgettopshell(idrawtopCT));  
 return;
 }
 /*--------------------------------------------------------------------------*/
