/* various functions to generate the files names for Solar B FITS files,
the idea was to have these in a separate module for easier testing
and use in several other programs. Also has some modules to generate
some of the calendar key words. */
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <stdio.h>
#include <sys/stat.h>
#include <sys/errno.h>
#include <time.h>
#include "command.h"
#include "wrfits.h"
#include "reformat.h"
#define ABS(x) ((x)>=0?(x):-(x))
#define MINOF(a,b) (((a)<(b))?(a):(b))
#define MAXOF(a,b) (((a)>(b))?(a):(b))
#define SUCCESS_RETURN	0
#define ERROR_RETURN	1
 double SB_Time_Convert( unsigned int In_tim, double In_SBsec);
 double SB2UT(double SolarBtimeSec); /* Subtr leap sec, add SB UT offset */
 static	char *prefix[] = {"FG","SP","CR","CL","DD","D2","MD"};
 static char *subids[] = {"I","Q","U","V","RAW","MG","DG","XX"};
 extern FGfitsImage	FGimage;	/* a structure for one FG image */
 extern SPfitsImage	SPimage;	/* a structure for one SP image */
 extern XRTfitsImage	XRTimage;	/* a structure for one SP image */
 char	text[50];
 char	ctnameout[256];
 struct tm packetFileTime;
 time_t fileCalendarTime;
 int	checkRefTimeFlag, lastHdrTime, timeCorr;
 unsigned int Ftime;
 /* some results for diagnostic packets are saved here, these have
 one packet per product and only one is processed at a time */
 int	CTms;
 struct tm *CTtimeobs;
 extern int sdtp_flag;
 /*------------------------------------------------------------------------- */
void timeRefCheck(unsigned int *t)
 /* called by nugu for each header packet, the very first call
 for a new file checks the time against fileCalendarTime if this is
 a EGSE file (SDTP's are done differently and don't call this routine)
 and sets a refTimeOffset if we suspect a problem. After that we
 monitor to check that the time is increasing. If not, we assume that
 the MDP clock was reset and try to reduce the damage by modifying
 refTimeOffset to ensure time goes forward at least. */
 {
 int dt;
 if (checkRefTimeFlag) {
   timeCorr = 0;
   /* if the time t is "unreasonable", we use the fileCalendarTime
   for the first header. This process could go awry in several ways.
   We allow a large margin in case the first data didn't get started for
   while. Both t and fileCalendarTime are 32 bit Unix times. */
   dt = *t - (int) fileCalendarTime;
   printf("dt = %d s\n", dt);
   /* a negative is a bad sign, but allow a little slack, a modest
   positive is OK but more than 10 hours seems excessive and we
   assume a bad MDP clock. */
   if (dt < -300. || dt > 36000.) {
     printf("bad time in first header, dt = %d s, adjusting  ...\n", dt);
     timeCorr = -dt;
     printf("t was %#x, fileCalendarTime was %#x\n", *t, fileCalendarTime);
     printf("ctime was            %s\n", ctime((time_t *) t));
     printf("fileCalendarTime was %s\n", ctime(&fileCalendarTime));
     *t = (int) *t + timeCorr;
   }
   checkRefTimeFlag = 0;  /* newfile will reset this when a new file is started */
   /* to avoid problems with user moving the slide bar or rewinding, checkRefTimeFlag
   can also be reset via those actions */
   lastHdrTime = (int) *t;
 } else {
   if (timeCorr) *t = (int) *t + timeCorr;
   /* also check if our time has decreased since our last one, this is a
   sign that the FEP was reset, allow a 1000 s slack */
   dt = *t - lastHdrTime;
   if (dt < -1000) {
     printf("bad time flow, dt = %d s\n", dt);
     printf("t was %#x, lastHdrTime was %#x\n", *t, lastHdrTime);
     printf("ctime was            %s\n", ctime((time_t *) t));
     printf("fileCalendarTime was %s\n", ctime((time_t *) &fileCalendarTime));
     
     /* not a good situation, we adjust the new time to be 10 s plus lastHdrTime */
     timeCorr = lastHdrTime + 10 - (int) *t;
     *t = lastHdrTime + 10;
   }
   lastHdrTime = (int) *t;
 }
 }
 /*------------------------------------------------------------------------- */
void setPacketFileTime(char *p1, char *p2)
 {
 /* both the SGI and the Sun don't seem to have timegm, maybe only
 the Apple G5 of the ones I use this on and perhaps Linux and FreeBSD */
#if __APPLE__
 struct tm *gtest;
 printf("p1, p2: %s, %s\n", p1,p2);
 sscanf(p1, "%4d%2d%2d", &packetFileTime.tm_year, &packetFileTime.tm_mon,
 	&packetFileTime.tm_mday);
 packetFileTime.tm_year -= 1900;
 packetFileTime.tm_mon -= 1;
 /* and p2 is hhmmss */
 sscanf(p2, "%2d%2d%2d", &packetFileTime.tm_hour, &packetFileTime.tm_min,
	&packetFileTime.tm_sec);
 fileCalendarTime = timegm(&packetFileTime);
 //printf("fileCalendarTime = %d\n",fileCalendarTime);
#else
 extern time_t timezone, altzone, _altzone;
 extern int daylight, _daylight;
 struct tm *gtest;
 /* The SGI doesn't have a timegm function so we try to do
 the same thing with some difficulty. We have
 /* here we expect p1 to have the year/month/dom */
 printf("p1, p2: %s, %s\n", p1,p2);
 sscanf(p1, "%4d%2d%2d", &packetFileTime.tm_year, &packetFileTime.tm_mon,
 	&packetFileTime.tm_mday);
 packetFileTime.tm_year -= 1900;
 packetFileTime.tm_mon -= 1;
 /* and p2 is hhmmss */
 sscanf(p2, "%2d%2d%2d", &packetFileTime.tm_hour, &packetFileTime.tm_min,
	&packetFileTime.tm_sec);
 packetFileTime.tm_isdst = 0;
 fileCalendarTime = mktime(&packetFileTime);
 //printf("timezone, altzone = %d, %d\n", timezone, altzone);
 //printf("daylight, _daylight %d, %d\n", daylight, _daylight);
 //printf("fileCalendarTime = %d\n",fileCalendarTime);
 fileCalendarTime -= timezone;
#endif
 printf("time check for packet: %s\n", ctime(&fileCalendarTime));
 gtest = gmtime(&fileCalendarTime);
 strftime(text, 30, "%Y%m%d_%H%M%S", gtest);
 printf("UTC back: %s\n", text);
 return;
 }
 /*------------------------------------------------------------------------- */
time_t getSdtpCalendarTime(char *buf)
 {
 struct tm *gtest;
#if __APPLE__
#else
 extern time_t timezone, altzone, _altzone;
#endif
 extern int daylight, _daylight;
 extern int cnv_year;
 /* get a calendar time from a sdtp log entry, we assume a very specific
 format */
 sscanf(buf,"CCSDS pkt, TIME [%4d/%4d %d:%2d:%2d", &packetFileTime.tm_year,
   &packetFileTime.tm_mday, &packetFileTime.tm_hour, &packetFileTime.tm_min,
   &packetFileTime.tm_sec);
 cnv_year = packetFileTime.tm_year;
 packetFileTime.tm_mon = 0;
 packetFileTime.tm_year = packetFileTime.tm_year - 1900;
 packetFileTime.tm_hour = packetFileTime.tm_hour;
#if __APPLE__
#else
 packetFileTime.tm_isdst = 0;
#endif
 fileCalendarTime = mktime(&packetFileTime);
 if (fileCalendarTime < 1154304000) fileCalendarTime -= 32400;
  printf("time check for packet: %s\n", ctime(&fileCalendarTime));
 printf("packetFileTime.tm_gmtoff = %d\n", packetFileTime.tm_gmtoff);
 gtest = gmtime(&fileCalendarTime);
 printf("packetFileTime.tm_gmtoff = %d\n", packetFileTime.tm_gmtoff);
 strftime(text, 30, "%m/%d/%Y_%H:%M:%S", gtest);
 printf("UTC: %s\n", text);
 return fileCalendarTime;
 }
 /*------------------------------------------------------------------------- */
time_t getFileCalendarTime()
 {
 /* used to get a calender time from the current file name, similar logic
 in format_setup. This is used in cases that don't have a valid MDPclockHigh
 in their packets but we want to know the time. */
 extern char *name_in;
 extern	int file_flag;
 char *p1, *p2, *p3;
 int	mq, mode, stat;
 if (!file_flag) {
   printf("no file open\n");
   return (time_t) 0;  /* no file open */
   }
 p2 = strrchr(name_in, '/');
 if (p2) { p2++; mq = strlen(p2); } else { mq = strlen(name_in);  p2 = name_in; }
 p3 = (char *) malloc(mq+1);
 if (mq > 0)  bcopy( p2, p3, mq );
 *(p3 + mq) = 0;
 printf("stripped file name: %s\n", p3);
 /* if this is a standard egse file we expect a form like
 20020220_233507tf2.raw
 */
 p1 = strtok( p3, "_");
 printf("part 1: %s\n", p1);
 /* allow for the new sci files which have a different scheme */
 if (strncmp(p1, "fpp", 3) == 0) {
   p1 = strtok( NULL, "_");
   p2 = strtok( NULL, ".");
 } else {
   p2 = strtok( NULL, "t");
 }
 printf("part 1: %s\n", p1);
 printf("part 2: %s\n", p2);
 /* p1 has YYYYMMDD and p2 has HHMMSS */
 /* get the year/month and all to make a calendar time */
 setPacketFileTime(p1, p2);
 return fileCalendarTime;
 }
 /*------------------------------------------------------------------------- */
FITSkey *loadCalendarKeys(struct tm *timeobs, int ms, FITSkey *nextKey)
 {
 /* note that %F is not supported in Sun's, so use equilvalent %Y-%m-%d */
 //strftime(text, 20, "%FT%T", timeobs);
 strftime(text, 20, "%Y-%m-%dT%T", timeobs);
 sprintf(&text[19],".%03dZ", ms);
 nextKey = code_key_s("DATE_OBS", text, nextKey);
 strftime(text, 11, "%Y/%m/%d", timeobs);
 //nextKey = code_key_s("DATE_END", "", nextKey);
 strftime(text, 9, "%T", timeobs);
 sprintf(&text[8],".%03d", ms);
 nextKey = code_key_s("TIME-OBS", text, nextKey);
 sprintf(text,"%s", asctime(timeobs));
 text[24] = 0;
 nextKey = code_key_s("CTIME", text, nextKey);
 return nextKey;
 }
 /*------------------------------------------------------------------------- */
FITSkey *CTloadCalendarKeys(FITSkey *nextKey)
 {
 nextKey = loadCalendarKeys(CTtimeobs, CTms, nextKey);
 return nextKey;
 }
 /*------------------------------------------------------------------------- */
void SPname(struct tm *timeobs, int ms, char *dir_name, char *packetpath)
 {
 /* uses the time, side, and subID to generate a name */
  char *subid, *SPprefix, *SPside;
  int	n;
  int   tenths = ms/100;

  if (tenths > 9) tenths = 9;
  SPprefix = "SP4D";
//  SPprefix = "SP";
//   if (SPimage.side) SPside = "R"; else SPside = "L";
//   switch (SPimage.subId) {
//     case DPC_STOKES_I: subid = subids[0]; break;
//     case DPC_STOKES_Q: subid = subids[1]; break;
//     case DPC_STOKES_U: subid = subids[2]; break;
//     case DPC_STOKES_V: subid = subids[3]; break;
//     case DPC_SP_RAW: subid = subids[4]; SPprefix = "S"; SPside = ""; break;
//     default: subid = subids[5]; break;
  if (SPimage.subId == DPC_SP_RAW) SPprefix = "SRAW";
  //n = strftime(text, 40, "%YD%j_%H%M%S", timeobs);
  n = strftime(text, 40, "%Y%m%d_%H%M%S", timeobs);
//  sprintf(SPimage.name_out,"%s/%s%s%s%s.%03d.fits", dir_name, SPprefix, subid,
//       SPside, text, ms);
  /* the SDTP and older forms differ here also */
  if (sdtp_flag) {
    char textdir[64];
    n = strftime(textdir, 14, "/%Y/%m/%d/", timeobs);
    /* also insert an hourly directory using packetpath */
    n = strftime(packetpath, 14, "/H%H00/", timeobs);
    sprintf(SPimage.name_out,"%s/%s%s/%s", dir_name, textdir, SPprefix, packetpath);
    mkdirpath(SPimage.name_out);
    sprintf(SPimage.name_out,"%s/%s%s/%s%s%s.%01d.fits", dir_name, textdir, SPprefix,
  	  packetpath, SPprefix, text, tenths);
  } else {
    /* first just the path part so we can ensure the path is created */
    sprintf(SPimage.name_out,"%s/%s/%s/", dir_name, SPprefix, packetpath);
    mkdirpath(SPimage.name_out);
    sprintf(SPimage.name_out,"%s/%s/%s/%s%s.%03d.fits", dir_name, SPprefix,
  	  packetpath, SPprefix, text, ms);
  }
  extraSlashRemove(SPimage.name_out);
  printf("SP file name: %s\n", SPimage.name_out);
  return;
 }
 /*------------------------------------------------------------------------- */
void FGname(struct tm *timeobs, int ms, char *dir_name, char *packetpath, char **ptype)
 {
 /* uses the time, side, and subID to generate a name */
 /* 7/20/2004 - add ptype to arg list, this is a returned string for the
 PRODUCT keyword */
 static char *fgTypes[] = {"FG raw output, intensity", "FG Intensity",
    "FG shuttered I and V", "FG shuttered I, Q, U, and V",
    "FG shuttered MG using 4 wavelengths",
    "FG shuttered MG with I and V using 4 wavelengths",
    "FG shuttered MG using 2 wavelengths",
    "FG shuttered  MG with I and V using 2 wavelengths",
    "FG shuttered MG using 1 wavelength", "FG shuttered DG using 4 wavelengths",
    "FG shuttered DG with A and B using 4 wavelengths",
    "FG shuttered DG using 2 wavelengths",
    "FG Intensity, part of a focus scan set", "FG integrated intensity scan",
    "FG integrated intensity scan with line update", "FG EMI test",
    "FG shutterless I and V", "FG shutterless I, Q, U, and V",
    "FG shutterless I and Q", "FG shutterless I and U",
    "FG shutterless I, U, and V", "FG shutterless I and V, 0.2s exposures",
    "FG shutterless I and V, 0.1s exposures","FG shuttered I and V with 4 exposures",
    "FG Unknown Type" };
  char *subid, *FGprefix, *FGpath;
  int	n;
  int   tenths = ms/100;
  if (tenths > 9) tenths = 9;
  FGprefix = "FG";
  FGpath = "FGIMG";
  /* 7/18/2004 - modify to do arrays for many observables and subdirects
  based on obs ID */
  printf("FGimage.subId = %d, genId = %d\n", FGimage.subId, FGimage.genId);
  /* check if raw */
  if (FGimage.subId == DPC_FG_RAW) {
    FGpath = "FGRAW";		FGprefix = "FGRAW";
    	*ptype = fgTypes[0];  } else {
  switch (FGimage.genId) {
    case FGmaskless:		FGpath = "FG";		FGprefix = "FG";
    	*ptype = fgTypes[1];
    	break;
    case FGshutteredIV:		FGpath = "FGIV";	FGprefix = "FGIV";
    	*ptype = fgTypes[2];
    	break;
    case FGshutteredStokes:	FGpath = "FGIQUV";	FGprefix = "FGIQUV";
    	*ptype = fgTypes[3];
    	break;
    case FGshutteredMG4:	FGpath = "FGMG";	FGprefix = "FGMG4_";
    	*ptype = fgTypes[4];
    	break;
    case FGshutteredMG4IV:	FGpath = "FGMG";	FGprefix = "FGMG4IV";
    	*ptype = fgTypes[5];
    	break;
    case FGshutteredMG2:	FGpath = "FGMG";	FGprefix = "FGMG2_";
    	*ptype = fgTypes[6];
    	break;
    case FGshutteredMG2IV:	FGpath = "FGMG";	FGprefix = "FGMG2IV";
    	*ptype = fgTypes[7];
    	break;
    case FGshutteredMG1:	FGpath = "FGMG";	FGprefix = "FGMG1_";
    	*ptype = fgTypes[8];
    	break;
    case FGshutteredDG4:	FGpath = "FGDG";	FGprefix = "FGDG4_";
    	*ptype = fgTypes[9];
    	break;
    case FGshutteredDG4_A_B:	FGpath = "FGDG";	FGprefix = "FGDG4_A_B";
    	*ptype = fgTypes[10];
    	break;
    case FGshutteredDG2:	FGpath = "FGDG";	FGprefix = "FGDG2_";
    	*ptype = fgTypes[11];
    	break;
    case FGshutteredFocusScan:	FGpath = "FGFOCUS";	FGprefix = "FG";
    	*ptype = fgTypes[12];
    	break;
    /* the integrated wave scans are actually done in CTnames but may want to
    move to here eventually */
    case FGintegratedWaveScan:	FGpath = "ISCAN";	FGprefix = "ISCAN";
    	*ptype = fgTypes[13];
    	break;
    case FGintegratedWaveScanUpdate: FGpath = "ISCANU";	FGprefix = "ISCANU";
    	*ptype = fgTypes[14];
    	break;
    case FGemiTest:		FGpath = "EMI";		FGprefix = "FGEMI";
    	*ptype = fgTypes[15];
    	break;
    case FGshutterlessIV:	FGpath = "FGSIV";	FGprefix = "FGSIV";
    	*ptype = fgTypes[16];
    	break;
    case FGshutterlessIQUV:	FGpath = "FGSIQUV";	FGprefix = "FGSIQUV";
    	*ptype = fgTypes[17];
    	break;
    case FGshutterlessIQ:	FGpath = "FGSIQ";	FGprefix = "FGSIQ";
    	*ptype = fgTypes[18];
    	break;
    case FGshutterlessIU:	FGpath = "FGSIU";	FGprefix = "FGSIU";
    	*ptype = fgTypes[19];
    	break;
    case FGshutterlessIUV:	FGpath = "FGSIUV";	FGprefix = "FGSIUV";
    	*ptype = fgTypes[20];
    	break;
    case FGshutterlessIV2:	FGpath = "FGSIV200";	FGprefix = "FGSIV200";
    	*ptype = fgTypes[21];
    	break;
    case FGshutterlessIV3:	FGpath = "FGSIV100";	FGprefix = "FGSIV100";
    	*ptype = fgTypes[22];
    	break;
    case FGshutteredIV2:		FGpath = "FGIV2";	FGprefix = "FGIV2";
    	*ptype = fgTypes[23];
    	break;
    default:			FGpath = "FGUNK";		FGprefix = "FGUNK";
    	*ptype = fgTypes[24];
    	break;
  }
  }
//   switch (FGimage.subId) {
//     case DPC_STOKES_I:
//     case DPC_INTENSITY:
//     case DPC_FILTERGRAM:
//     	subid = subids[0]; break;
//     case DPC_STOKES_Q: subid = subids[1]; break;
//     case DPC_STOKES_U: subid = subids[2]; break;
//     case DPC_STOKES_V: subid = subids[3]; break;
//     case DPC_FG_RAW: subid = subids[4]; FGprefix = "F";break;
//     case DPC_MAGNETOGRAM: subid = subids[5]; break;
//     case DPC_DOPPLERGRAM: subid = subids[6]; break;
//     default: subid = subids[7]; break;
//   }
//  n = strftime(text, 40, "%YD%j_%H%M%S", timeobs);
  n = strftime(text, 40, "%Y%m%d_%H%M%S", timeobs);
//  sprintf(FGimage.name_out,"%s/%s%s%s.%03d.fits", dir_name, FGprefix, subid,
//       text, ms);
  /* the SDTP and older forms differ here also */
  if (sdtp_flag) {
    char textdir[64];
    n = strftime(textdir, 14, "/%Y/%m/%d/", timeobs);
    /* also insert an hourly directory using packetpath */
    n = strftime(packetpath, 14, "/H%H00/", timeobs);
    sprintf(FGimage.name_out,"%s/%s%s/%s", dir_name, textdir, FGpath, packetpath);
    mkdirpath(FGimage.name_out);
    sprintf(FGimage.name_out,"%s/%s%s/%s%s%s.%01d.fits", dir_name, textdir, FGpath,
  	  packetpath, FGprefix, text, tenths);
  } else {
    /* note that packetpath already has slashes on both sides */
    sprintf(FGimage.name_out,"%s/%s%s", dir_name, FGpath, packetpath);
    mkdirpath(FGimage.name_out);
    sprintf(FGimage.name_out,"%s/%s%s%s%s.%03d.fits", dir_name, FGpath,
  	  packetpath, FGprefix, text, ms);
  }
  extraSlashRemove(FGimage.name_out);
  printf("FG file name: %s\n", FGimage.name_out);
  return;
 }
 /*------------------------------------------------------------------------- */
char *CTname(int rftype, unsigned int packet_time, char *dir_name,
	char *packetpath, int subId, unsigned char MDPclockHigh)
 {
  /* early CT packets don't have the MDPclockHigh so we try to
  construct it from the raw packet name. This was stored in
  fileCalendarTime. */
  /* note that the CTtimeobs and CTms are used by CTloadCalendarKeys
  which must be called after CTname */
  unsigned int CTtime;
  extern unsigned int timeRef, FPPccsdsti, pkt_ti_time;
  extern double sb_time_0;
  int	dt, n;
  float  xq;
  char *CTprefix;
  double sbtime_pkt;
  
  /* the SDTP name construction is a bit different, first the CTtime is computed
  differently */
  if (sdtp_flag) {
    CTtime = timeRef + ((FPPccsdsti >> 5) & 0x07ffffff);
printf("CTtime is: %d, ccsdsti: %d (old timeRef method)\n", CTtime, FPPccsdsti);
    /* ISAS time method (use in production) */
    sb_time_0 = FPPccsdsti/32.0;
    sb_time_0 = sb_time_0 - sb_time_0*6.95263888075869e-06 + 212176146.475454;
    sbtime_pkt = SB_Time_Convert(FPPccsdsti, sb_time_0); /* + 946684800.0; */
    sbtime_pkt = SB2UT(sbtime_pkt); /* sbtime_pkt is now UTC */
    CTtime = sbtime_pkt;
printf("CTtime is: %d, ccsdsti: %d (new SB time method)\n", CTtime, FPPccsdsti);
printf("sb_time_0: %lf\n", sb_time_0);
    /* also compute milli seconds from ccsdsti (resolution is just 1/32 though) */
    xq = (float) ( (FPPccsdsti) & 0x1f ) *(1000./32.);
    CTms = (int) (xq + 0.5);
    /* ISAS time method (use in production) */
    CTms = (int) (1000.0*(sbtime_pkt - CTtime) );
  } else {
    CTtime = ((packet_time) >> 9 ) & 0x007fffff;
    if (MDPclockHigh == 0) {
      CTtime = CTtime | ( fileCalendarTime & 0xff800000);
      printf("CTtime %d, ctime: %s\n", CTtime, ctime((time_t *)&CTtime));
      /* if this time is more than 1000s less than fileCalendarTime,
      consider a rollover */
      dt = CTtime - fileCalendarTime;
      printf("dt, CTtime, fileCalendarTime %d %d %d\n", dt, CTtime, fileCalendarTime);
      if (dt < -1000) {
	/* rollovers occur every 90 days, check if reasonable */
	unsigned int iq, CTbumped;
	iq = (fileCalendarTime & 0xff800000) + 0x00800000;
	CTbumped = (((packet_time) >> 9 ) & 0x007fffff) | fileCalendarTime;
	dt = CTbumped - CTtime;
      printf("dt, CTtime, CTbumped %d %d %d\n", dt, CTtime, CTbumped);
	if (dt < 10000) CTtime = CTbumped; else {
	  printf("a problem with the CT times, %s vs %s\n", ctime((time_t *)&CTtime),
      	    ctime((time_t *)&CTbumped));
	}
      }
    } else {
      CTtime = CTtime | ( (unsigned int) (MDPclockHigh) << 23);
      timeRefCheck(&CTtime);
    }
    /* also compute milli seconds from MDPclock (resolution is just 1/512 though) */
    xq = (float) ( (packet_time) & 0x1ff ) *(1000./512.);
    CTms = (int) (xq + 0.5);
  }
  printf("ctime: %s\n", ctime((time_t *)&CTtime));
  CTtimeobs = gmtime((time_t *)&CTtime);  /* used in keywords and below */
  //n = strftime(text, 40, "%YD%j_%H%M%S", CTtimeobs);
  n = strftime(text, 40, "%Y%m%d_%H%M%S", CTtimeobs);
  switch (subId) {
    case DPC_ANALOG_DUMP: CTprefix = "AC"; break;
    case DPC_FG_ENGG_FR:
      {
      /* we need the obs ID from the macro command to figure whether an I scan
      or a laser tune */
      extern fg_macro_command  currentFGmacroCommand;
      if (currentFGmacroCommand.parameters.obs_id == 14)
        CTprefix = "LASER";
      else
        CTprefix = "ISCAN";
      }
      break;
    default:  CTprefix = prefix[rftype]; break;
  }
  /* 1/28/2004 - add a path for the type, but still keep the packetpath
  component until we can be sure of the time. */
  /* the SDTP and older forms differ here also */
  if (sdtp_flag) {
    char textdir[64];
    n = strftime(textdir, 14, "/%Y/%m/%d/", CTtimeobs);
    /* also insert an hourly directory using packetpath */
    n = strftime(packetpath, 14, "/H%H00/", CTtimeobs);
    sprintf(ctnameout,"%s/%s%s/%s", dir_name, textdir, CTprefix, packetpath);
    mkdirpath(ctnameout);
    sprintf(ctnameout,"%s/%s%s/%s%s%s.%02d.fits", dir_name, textdir, CTprefix, packetpath,
	 CTprefix, text, CTms/10);
  } else {
    sprintf(ctnameout,"%s/%s%s", dir_name, CTprefix, packetpath);
    mkdirpath(ctnameout);
    sprintf(ctnameout,"%s/%s%s%s%s.%03d.fits", dir_name, CTprefix, packetpath,
	 CTprefix, text, CTms);
  }
  extraSlashRemove(ctnameout);
  printf("CT file name: %s\n", ctnameout);
  return ctnameout;
 }
 /*------------------------------------------------------------------------- */
void XRTname(struct tm *timeobs, int ms, char *dir_name, char *packetpath,
     int isdark)
 {
 /* uses the time to generate a name */
  char *subid, *XRTprefix, *XRTpath, *suffix;
  int	n;
  XRTprefix = "XRT";
  XRTpath = "XRT";
  XRTpath = "";
  if(isdark) suffix = "d.fits"; else suffix = ".fits";
  //n = strftime(text, 40, "%YD%j_%H%M%S", timeobs);
  n = strftime(text, 40, "%Y%m%d_%H%M%S", timeobs);
  if (sdtp_flag) {
    char textdir[64];
    n = strftime(textdir, 14, "/%Y/%m/%d/", timeobs);
    /* also insert an hourly directory using packetpath */
    n = strftime(packetpath, 14, "/H%H00/", timeobs);
    sprintf(XRTimage.name_out,"%s/%s%s/%s", dir_name, textdir, XRTpath, packetpath);
//  sprintf(XRTimage.name_out,"%s/%s/%s", dir_name, textdir, packetpath);
    mkdirpath(XRTimage.name_out);
    sprintf(XRTimage.name_out,"%s/%s%s/%s%s%s.%01d%s", dir_name, textdir, XRTpath,
  	  packetpath, XRTprefix, text, ms/100, suffix);
  } else {
    /* note that packetpath already has slashes on both sides */
    sprintf(XRTimage.name_out,"%s/%s%s", dir_name, XRTpath, packetpath);
    mkdirpath(XRTimage.name_out);
    sprintf(XRTimage.name_out,"%s/%s%s%s%s.%03d%s", dir_name, XRTpath,
  	  packetpath, XRTprefix, text, ms, suffix);
  }
  extraSlashRemove(XRTimage.name_out);
  printf("XRT file name: %s\n", XRTimage.name_out);
  return;
 }
 /*------------------------------------------------------------------------- */
