/* 8/29/2002 - structures to simplify reformatting of Solar B packets */
typedef struct {
	int	id, serial_no, obsId, subId, genId, frameId;
	int	nx, ny, ix0, ix1, iy0, iy1, sumx, sumy, binx, biny;
	int	num_frames, num_packets, nimages, rframes, rpackets;
	float	pixscale;
	char	name_out[512];
	char	packsdone[256]; /* 256 is max # of packets in a frame */
	FITSkey *fitsKeys;
	/* 7/17/2004, allowing for multi-D arrays, the limit should
	still be 16Mbytes but some illegal data was higher and we may
	want to look at it, so allow 32 Mbytes */
	short	image[4096*2064*2+2048];
 } FGfitsImage;

typedef struct {
	int	id, serial_no, obsId, subId, side, nsides;
	int	nw, ny, ix0, ix1, iy0, iy1;
	int	num_frames, num_packets, rframes, rpackets;
	float	pixscale;
	int	slit_positions, bin_slit, scan_step, scan_sum, repeat_flag;
	int	CCD_size, extract_table, cycles;
	char	name_out[512];
	char	packsdone[256]; /* 256 is max # of packets in a frame */
	FITSkey *fitsKeys;
	/* allowing for 4D images, we need more */
	short	image[1040*448*2*4+2048];
	//short	image[1040*448+2048];
 } SPfitsImage;

typedef struct {
	int	id, serial_no;
	int	nx, ny, ix0, ix1, iy0, iy1, sumx, sumy, binx, biny;
	int	num_frames, num_packets, rframes, rpackets;
	float	pixscale;
	char	name_out[512];
	char	packsdone[256]; /* 256 is max # of packets in a frame */
	FITSkey *fitsKeys;
	short	image[2176*2112*2+2048];
 } XRTfitsImage;
