/* structures and definitions for status requests and friends */
#define STATUS1_REQUEST 0x01
#define STATUS2_REQUEST 0x02
#define STATUS3_REQUEST 0x03
#define STATUS4_REQUEST 0x04
#define STATUS1_PACKET_ID 0x48
#define STATUS2_PACKET_ID 0x4a
#define STATUS3_PACKET_ID 0x4c
#define STATUS4_PACKET_ID 0x4e

#if SOLARIS
 typedef unsigned int UINT32;
#endif
#if __FreeBSD__
 typedef unsigned int UINT32;
#endif
#if __sgi
 typedef unsigned int UINT32;
#endif

 typedef struct {
	unsigned char	command_id;
	unsigned char	command_length;
	unsigned short	MDP_clock_HI;
	unsigned short	MDP_clock_LO;
	unsigned short	doppler;
 } StatusCommand;

 /* the headers for the status packets have the same beginning as the
 data packets -- 4 bytes of ID and size. Remember that the compiler
 rounds up all structures to a multiple of 4 bytes. */
 typedef struct {
	unsigned char type;
	unsigned char size[3];  /* packet length in bytes */
 } StatusHead;

 /* using Mathur's status structures, 5/31/2001 */
 typedef struct
 {
   unsigned fg_ready : 1;
   unsigned fg_id    : 7; 
 } typeFgStatus1; 

 typedef struct {
   short	DopVel;
   char		FPP_FG_state;
   char		FPP_pic_state;
   int		obs_count;	/* # observing programs run */
   int		frame_count;	/* exposures with FG camera */
   int		product_count;	/* FG products */
   short	obs_id;		/* current or last obs_id */
   short	fdb_id;		/* current or last frame descriptor id */
   char		obs_frame_count; /* exposures in current obs */
   char		junk[3];	/* round up to a multiple of 4 bytes */
 } typeFgStatus2;

 typedef struct
 {
   unsigned sp_ready : 1;
   unsigned sp_id    : 7; 
 } typeSpStatus1; 

 typedef struct {
  char		FPP_SP_state;
  char		SP_pic_state;
  short		obs_id;
  int 		map_count;
  int		frame_count;
  char		map_id;
  char		map_stokes;
  short		map_numpos;
  short		slit_position;
  char		junk[2];	/* round up to a multiple of 4 bytes */
   } typeSpStatus2;

 typedef struct {
  unsigned  char  modulator_position_1;
  unsigned  char  modulator_delay_1;
  unsigned  char  modulator_position_2;
  unsigned  char  modulator_delay_2;
  unsigned  char  modulator_position_3;
  unsigned  char  modulator_delay_3;
} typeMMStatus1;

 /* this is the common block for all, the 0.25 is just this + header */
 typedef struct {
	unsigned  fg_ready : 1;
	unsigned  fg_id : 7;
	unsigned  sp_ready : 1;
	unsigned  sp_id : 7;
	unsigned  char	modulator_position_1;
	unsigned  char	modulator_delay_1;
	unsigned  char	modulator_position_2;
	unsigned  char	modulator_delay_2;
	unsigned  char	modulator_position_3;
	unsigned  char	modulator_delay_3; 
 } Stat_Block;

 /* Mathur's structure for the 13 byte memory dump info area, modified to
 ensure alignment on most machines, the original uses "packed" structures,
 the mods make it harder to get the desired values but probably about as fast
 as the bit field decoding, this assumes bigendian */
typedef struct
 {
  unsigned  char Fixed;
  unsigned  char MemValidFlag;
  unsigned  PktSeqFlag   : 2;
  unsigned  Const        : 6;
  unsigned  char DumpSeqCount[2]; /* a short would be nice here but gets misaligned */
  unsigned  char DumpLength[3];	/* Mathur has a 24 bit field here but misaligns */
  unsigned  char	Const2;
  unsigned  char MemTblNum;
  unsigned  char DumpAddress[3]; /* Mathur has a 24 bit field here but that misaligns */
  char		junk[3];	/* round up to a multiple of 4 bytes */
 } MEM_DMP_HDR;
 
 /* these status areas should be replaced with Mathur's scheme now,
 but need to address a few issues first so just try to make consistent
 so we can use these with status monitors, etc */
 /* complete 0.25 status packet */
 typedef struct {
	StatusHead	head;
	Stat_Block	stat;
 } Status_250;

#define SP_STATE_RUN_BIT	0x0001
#define SP_STATE_PAUSE_BIT	0x0002
 /* this should be obsolete */
 typedef struct {
	UINT32	packet_time;
	unsigned  char  FPP_state;
	unsigned  char  FPP_mode;
	unsigned  char  FPP_FG_state;
	/* for early testing, lets make the low bit of FPP_SP_state a pause
	state indicator */
	unsigned  char  FPP_SP_state;
	unsigned  char  FPP_CMD_count;
	unsigned  char  FPP_CMD_status;
	unsigned  char  FPP_CMD_opcode;
	unsigned  char  FPP_CMD_length;
	unsigned  char  spacer1[72];
	unsigned  short	slit_position;
	unsigned  char	spacer2[274];
 } Status_10000;
	
