#include        <elf.h>

/*! Initialize the time conversion library (= load data base file)
 * @param fname ...
 * @param In_SBsec ...
 * @retval
 */
int SB_Time_Init(char *fname, double In_SBsec);

/*! perform time conversion from TI to Solar-B time
 * @param In_tim ...
 * @param In_SBsec ...
 * @retval
 */
double SB_Time_Convert(uint32_t In_tim, double In_SBsec);

/*! Initialize the conversion between UT ant Solar-B time
 * @param fname
 * @retval
 */
int UtTt_Init(char *fname );

/*! Convert Solar-B time to UT
 * @param Ttsec
 * @param Ut
 * @retval
 */
int TttoUt( double Ttsec, char *Ut );

/*! Convert UT to Solar-B time
 * @param read_item
 * @retval
 */
double UttoTt(char *read_item );
