/**********************************************************                     
 *                                                                              
 *          * GEOTAIL SATELLITE TRANSMIT SYSTEM *                               
 *                                                                              
 *      P.NAME      : ascbcd                                                    
 *                                                                              
 *      FUNCTION    : ASCII-CODE TO BCD-CODE                                    
 *                                                                              
 *      CALLING SEQUENCE                                                        
 *          ascbcd( asc , bcd , leng , ir , ispos , iepos )                     
 *                                                                              
 *      RETURN VALUE                                                            
 *          int     :  0 normal end                                             
 *                  : -1 error  end                                             
 *                                                                              
 *      ARGUMENT                                                                
 *          asc     : (IN) (*char) data start pointer(ascii)                    
 *          bcd     : (OUT)(*int)  output bcd data                              
 *          leng    : (IN) (*inT)  change character length                      
 *          ir      : (OUT)(*int)  return                                       
 *                      0 : normal                                              
 *                     -1 : error                                               
 *          ispos   : (IN) (*int)  input  data start pointer (ascii)            
 *          iepos   : (IN) (*int)  output data start pointer (bcd)              
 *                                                                              
 *      DATE        : 90.10.18 S.OGATA                                          
 *                                                                              
 *********************************************************/                     
#include        <ctype.h>                                                      
#include        "com_ascbcd.h" 
#include        "bcd_ch.str"                                                    
static int loc_atoi( int data );

int                                                                             
com_ascbcd_( asc , bcd , leng , ir , ispos ,iepos )                                  
char asc[] , bcd[] ;                                                            
int  *leng , *ir , *ispos , *iepos ;                                            
{                                                                               
    union uni un;                                                               
    int   start_point , end_point , asc_point , w1 , w2 , i ;                   
                                /* ERROR CHECK */                               
    if( *leng < 1 || *ispos < 1 || *iepos < 1 )                                 
    {                                                                           
        *ir = -1 ;                                                              
        return( -1 ) ;                                                          
    }                                                                           
                                /* DATA SET */                                  
    asc_point   = *ispos + *leng - 2 ;                                          
    start_point = *iepos - 1 ;                                                  
    end_point   = *leng / 2 + start_point - 1 ;                                 
                                /* 4BIT DATA */                                 
    if( *leng % 2 != 0 )                                                        
    {                                                                           
        un.bit               = bcd[ end_point + 1 ] ;                           
        if( ( w1 = loc_atoi( (int)asc[ asc_point-- ] ) ) == -1  )               
        {                                                                       
            *ir = -1 ;                                                          
            return( -1 ) ;                                                      
        }                                                                       
        un.st.bit_high = w1 ;                                                   
        bcd[ end_point + 1 ] = un.bit ;                                         
    }                                                                           
                                /* LENGTH = 1 : END */                          
    if( end_point < 0 )                                                         
    {                                                                           
        *ir = 0 ;                                                               
        return( 0 ) ;                                                           
    }                                                                           
                                /* DATA CHANGE */                               
    for( i=end_point ; i>=start_point ; i-- )                                   
    {                                                                           
        if( ( w2 = (int)loc_atoi( (int)asc[ asc_point-- ] ) ) == -1 ||          
            ( w1 = (int)loc_atoi( (int)asc[ asc_point-- ] ) ) == -1 )           
        {                                                                       
            *ir = -1 ;                                                          
            return( -1 ) ;                                                      
        }                                                                       
        un.st.bit_high = w1 ;                                                   
        un.st.bit_low  = w2 ;                                                   
        bcd[ i ]       = un.bit ;                                               
    }                                                                           
    *ir = 0 ;                                                                   
    return( 0 ) ;                                                               
}                                                                               
                                /* ASCII TO BINARY */                           
static int                                                                      
loc_atoi( data )                                                                
int data ;                                                                      
{                                                                               
    if( isdigit(data) == 0 )                                                    
    {                                                                           
        return( -1 ) ;                                                          
    }                                                                           
    return( data - '0' ) ;                                                      
}                                                                               
