/**********************************************************
 *
 *          * GEOTAIL SATELLITE TRANSMIT SYSTEM *
 *
 *      P.NAME      : aschex
 *
 *      FUNCTION    : ASCII-CODE(HEX) TO BINARY
 *
 *      CALLING SEQUENCE
 *          aschex( asc , hex , leng , ir , ispos , iepos )
 *
 *      RETURN VALUE
 *          int     :  0 normal end
 *                  : -1 error  end
 *
 *      ARGUMENT
 *          asc     : (IN) (*char) data start pointer(ascii)
 *          hex     : (OUT)(*int)  output binary data
 *          leng    : (IN) (*inT)  change character length
 *          ir      : (OUT)(*int)  return
 *                      0 : normal
 *                     -1 : error
 *          ispos   : (IN) (*int)  input  data start pointer (ascii)
 *          iepos   : (IN) (*int)  output data start pointer (hex-bcd)
 *
 *      DATE        : 90.10.03 S.OGATA
 *
 *********************************************************/
#include        <ctype.h>
#include        "bcd_ch.str"
#include        "com_aschex.h"

static int htoi (int data);

int
com_aschex_ (asc, hex, leng, ir, ispos, iepos)
    char            asc[], hex[];
int            *leng, *ir, *ispos, *iepos;

{
    union uni       un;
    int             start_point, end_point, asc_point, w1, w2, i;

    /* ERROR CHECK */
    if (*leng < 1 || *ispos < 1 || *iepos < 1) {
	*ir = -1;
	return (-1);
    }
    /* DATA SET */
    asc_point = *ispos + *leng - 2;
    start_point = *iepos - 1;
    end_point = *leng / 2 + start_point - 1;
    /* 4BIT DATA */
    if (*leng % 2 != 0) {
	un.bit = hex[end_point + 1];
	if ((w1 = htoi ((int) asc[asc_point--])) == -1) {
	    *ir = -1;
	    return (-1);
	}
	un.st.bit_high = w1;
	hex[end_point + 1] = un.bit;
    }
    /* LENGTH = 1 : END */
    if (end_point < 0) {
	*ir = 0;
	return (0);
    }
    /* DATA CHANGE */
    for (i = end_point; i >= start_point; i--) {
	if ((w2 = (int) htoi ((int) asc[asc_point--])) == -1 ||
	    (w1 = (int) htoi ((int) asc[asc_point--])) == -1) {
	    *ir = -1;
	    return (-1);
	}
	un.st.bit_high = w1;
	un.st.bit_low = w2;
	hex[i] = un.bit;
    }
    *ir = 0;
    return (0);
}
static int
htoi (data)
    int             data;
{
    if (isxdigit (data) == 0) {
	return (-1);
    }
    if (isdigit (data) != 0) {
	return (data - '0');
    }
    if (islower (data) != 0) {
	return (data - 'a' + 10);
    }
    return (data - 'A' + 10);
}
