#include <stdio.h>
#include <time.h>

double SB_Time_Convert( unsigned int In_tim, double In_SBsec);
double UttoTt(char* ut);
int TttoUt(double SBt, unsigned char *tbcd);
int UtTt_Init(char* filnam);

main(int argc, char **argv)
{
  double SB0, SBsec, In_SBsec, In_SBsec2;
  time_t t0, t1;
  unsigned int ti_tim, old_ti=0;
  struct tm tm0, *tmpkt, *ltm;
  char line[128];
  unsigned char utbcd[10];
  int i;

  tm0.tm_year = 2006 - 1900;
  tm0.tm_mon = 0;
  tm0.tm_mday = 216;
  tm0.tm_hour = 2;
  tm0.tm_min = 37;
  tm0.tm_sec = 8;
  tm0.tm_wday = 0;
  tm0.tm_yday = 0;
  tm0.tm_isdst = 0;
  t0 = mktime(&tm0);
  SB0 = t0 - 946684800.0;
  printf("t0: %u, SB0: %lf\n", t0, SB0);

  if (SB_Time_Init( "/data/SOLAR-B/TIMSET/CNV_FILE_2006", SB0))
    fprintf(stderr, "Initial SB_Time_Init failed\n");
  if (UtTt_Init("/data/SOLAR-B/TIMSET/Lepasec.dat"))
    fprintf(stderr, "Initial UtTt_Init failed\n");
  printf("#ti_time SolarB time Date\n");
  while (fgets(line, 128, stdin)) {
    sscanf(line, "%u", &ti_tim);
    if (ti_tim < old_ti) {
      tm0.tm_year = 2006 - 1900;
      tm0.tm_mon = 0;
      tm0.tm_mday = 217;
      tm0.tm_hour = 0;
      tm0.tm_min = 43;
      tm0.tm_sec = 9;
      tm0.tm_wday = 0;
      tm0.tm_yday = 0;
      tm0.tm_isdst = 0;
      t0 = mktime(&tm0);
      SB0 = t0 - 946684800.0;
      if (SB_Time_Init( "/home/jps/data/SOLAR-B/TIMSET/CNV_FILE_2006", SB0))
        fprintf(stderr, "SB_Time_Init failed\n");
    }
    SBsec = SB_Time_Convert(ti_tim, SB0);
    t1 = SBsec + 946684800;
    tmpkt = gmtime(&t1);
    if (TttoUt(SBsec, utbcd)) fprintf(stderr, "TttoUt failed\n");;
    printf("%f %lf ", ti_tim/32.0, SBsec);
    for (i=0; i<8; i++) printf("%2.2x", utbcd[i]);
    printf(asctime(tmpkt));
    ltm = localtime(&t1);
//  printf(asctime(ltm));
    old_ti = ti_tim;
  }
}
