/**********************************
 *     
 *      TIME CHECK TEST MAIN
 *
 **********************************/
#include        <stdio.h>
#include        <string.h>
#include        "SBTCA_com.h"
#include        "UtTt.h"

double SB_Time_Convert( unsigned int In_tim, double In_SBsec);
double UttoTt(char* ut);
int UtTt_Init(char* filnam);

void    main()
{

	unsigned char  year[5], filnam[80], wk[30];

	int i,rtn,tid;
	unsigned int In_tim;
	double SBsec, In_SBsec, In_SBsec2;
	double dret;
	unsigned char cUtbcd[32];
	unsigned char cWork[32];
	int leng;
	int ispos;
	int iepos;
	int ir;

	union {
		unsigned int iIn_tim;
		unsigned char cIn_tim[4];
	}b4;


	/*--------------------------------------------------------------*/
	tid = 0;
	memset( b4.cIn_tim, 0x00, sizeof( b4.cIn_tim ));
	memset( cUtbcd, 0x00, sizeof( cUtbcd ));
	memset( cWork, 0x00, sizeof( cWork ));
	/*--------------------------------------------------------------*/


	/*--------------------------------------------------------------*/
	/* SB_Time_Init() ¹					*/
	/*--------------------------------------------------------------*/
	printf( "SB_Time_Init START    \n" ) ;
	strcpy( year , "2005" );
	//strcpy( filnam , "../file/CNV_FILE_2005" );
        strcpy(filnam, "/data/SOLAR-B/TIMSET/CNV_FILE_2005");
	/*+++++++++++++++++++++++++++++++++++++++++++++++*/
	/*   Ϥ TI , SOLAR-B         */
	/*+++++++++++++++++++++++++++++++++++++++++++++++*/
	b4.iIn_tim =0x000d3010;
	b4.iIn_tim =0x0001D710 / 16;
	b4.iIn_tim =0x00035F10 / 16;
	b4.iIn_tim =0x00020710/ 16;
	b4.iIn_tim =0x00F06F2C/ 16;
	In_SBsec   =  173271497.723976;
	In_SBsec   =  173271498.723976;
	In_SBsec   =  175793943.885976;
	In_SBsec   =  173395206.820976;
        In_SBsec   =  181097472.000000;
        In_SBsec   =  181011072.000000;
	/****************************************************************/
	rtn = SB_Time_Init( filnam, In_SBsec);
	/****************************************************************/
	printf( "SB_Time_Init RTN[%d]\n",  rtn ) ;
	printf( "SBTCA_cnv_rdcnt [%d]\n",  SBTCA_cnv_rdcnt ) ;
	printf( "In_SBsec 7 2      [%lf] \n",  In_SBsec ) ;
	printf( "No  flg  TI(4.5Byte Data)  SOLAR-B       ١ \n" ) ;
	for(i = 0; i < SBTCA_cnv_rdcnt; i++){
		printf( "[%02d] [%s] [%lf] [%lf] [%lf]\n", 
			i, SBTCA_cnv_tbl[i].quality_flag, SBTCA_cnv_tbl[i].dhuti,
			SBTCA_cnv_tbl[i].dhutiSB,
			SBTCA_cnv_tbl[i].Tdhu  );
	}
	printf( "SB_Time_Init END   rtn[%d]    \n", rtn ) ;

	/*--------------------------------------------------------------*/
	/* SB_Time_Convert() ¹					*/
	/*--------------------------------------------------------------*/
	printf( "SB_Time_Convert START    \n" ) ;

	printf( "In_tim 0x[%02X%02X%02X%02X] [%d] (dec)  In_tim * 16 = [%d]\n",
		b4.cIn_tim[0], b4.cIn_tim[1], b4.cIn_tim[2], b4.cIn_tim[3],
		b4.iIn_tim, (b4.iIn_tim * 16 )
				) ;
	printf( "In_SBsec  [%lf] \n", In_SBsec ) ;
	/****************************************************************/
	SBsec = SB_Time_Convert( b4.iIn_tim, In_SBsec);
	/****************************************************************/
	printf( "In_tim[%d](10) = b4.cIn_tim 0x[%02X%02X%02X%02X] \n",
		In_tim,
		b4.cIn_tim[0],
		b4.cIn_tim[1],
		b4.cIn_tim[2],
		b4.cIn_tim[3] );
	printf( "In_SBsec[%lf] RTN[%lf]   \n", In_SBsec, SBsec) ;
	printf( "SB_Time_Convert END \n") ;

	/*--------------------------------------------------------------*/
	/* UtTt_Init() ¹						*/
	/*--------------------------------------------------------------*/
	printf( "UtTt_Init START    \n" ) ;
	//strcpy( filnam , "../file/Lepasec.dat" );
        strcpy(filnam, "/data/SOLAR-B/TIMSET/Lepasec.dat");
	/****************************************************************/
	rtn = UtTt_Init(filnam);
	/****************************************************************/
	printf( "UtTt_Init END   rtn[%d]    \n", rtn ) ;

	/*--------------------------------------------------------------*/
	/* TttoUt() ¹						*/
	/*--------------------------------------------------------------*/
	printf( "TttoUt START    \n" ) ;
	/****************************************************************/
	rtn = TttoUt( SBsec,wk);
	/****************************************************************/
	printf( "TttoUt END   rtn[%d]    \n",  rtn ) ;
	printf( "SB_Time[%lf] TIME[%02x%02x.%02x%02x %02x:%02x:%02x.%02x%02x%02x]\n",
		SBsec, wk[0],wk[1],wk[2], wk[3],wk[4],wk[5], wk[6],wk[7],wk[8], wk[9]);
	/*--------------------------------------------------------------*/

}
