/* FPP Data Monitor */
 /* 6/2/2003 change interface, eliminate the detailed packet boxes (this is also
 in the list when -l is specified so no loss), add a file selection
 area and generally try to make it easier to use. Also remove some of the
 socket options. See dgui.c.2jun2003 for the older version. */
 /* 10/28/2002 - modify to use a sequence of input files rather than just one
 for the file input mode */
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <stdio.h>
#include <sys/stat.h>
#include <sys/errno.h>
#include <time.h>
#include <unistd.h>
#include <fcntl.h>
#include "command.h"
#include "xrt.h"
#include "HKformat.h"
#include "wrfits.h"
#include "reformat.h"
#include "analogchans.h"
#include "endianfix.h"

#if __APPLE__
/* the G5's have 64 bit file stuff by default */
#define off64_t off_t
#define stat64 stat
#define lstat64 lstat
#define lseek64  lseek
#endif

#define ABS(x) ((x)>=0?(x):-(x))
#define MINOF(a,b) (((a)<(b))?(a):(b))
#define MAXOF(a,b) (((a)>(b))?(a):(b))
#define SUCCESS_RETURN	0
#define ERROR_RETURN	1

#define	DATATYPE0	0x42
#define	DATATYPE1	0x43
#define	DATATYPE2	0x44
#define	DATATYPE3	0x45
#define	DATAMEMDUMP	0x5e
#define	DATACTREF	0x52
#define	DATACTLIVE	0x54
#define	DATADIAGNOSTIC	0x56
#define	DATADIAGNOSTIC2	0x58
#define DATATYPEXRT     0xA2
#define DATATYPEXRT2    0xA3

#define NPASTFRAMES	20000

 typedef	unsigned char byte;
 /* copies of camera structures taken from CA_status.h */
 /* a combined status/config/mode for telemetry */
 typedef union {
#if linux | LITTLEENDIAN
  struct {
  unsigned short	Mode       : 3;
  unsigned short	Notused2   : 1;
  unsigned short	PreAmp     : 1;
  unsigned short	Notused    : 1;
  unsigned short	Gain       : 2;
  unsigned short	SerSum     : 2;
  unsigned short   	ParSum     : 2;
  unsigned short	SerClk     : 1;
  unsigned short	Busy       : 1;
  unsigned short	Locked     : 1;
  unsigned short	BadCmd     : 1;
  } bits;
#else
  struct {
  unsigned short	BadCmd     : 1;
  unsigned short	Locked     : 1;
  unsigned short	Busy       : 1;
  unsigned short	SerClk     : 1;
  unsigned short   	ParSum     : 2;
  unsigned short	SerSum     : 2;
  unsigned short	Gain       : 2;
  unsigned short	Notused    : 1;
  unsigned short	PreAmp     : 1;
  unsigned short	Notused2   : 1;
  unsigned short	Mode       : 3;
  } bits;
#endif
  unsigned short   ui16;
 } CONFIG;

 char *rf0_ver = "1.23devel";

 /* functions */
 int main();
 void getBaseTime();
 char	*progname;
 extern	int xminit(), dribble();
 extern off64_t filesize64();

 int SB_Time_Init(char *filnam, double approx_SBseconds);
 int UtTt_Init(char* filnam); /* Leap second initialization */
 double SB_Time_Convert( unsigned int In_tim, double In_SBsec);
 double SB2UT(double SolarBtimeSec); /* Subtr leap sec, add SB UT offset */
 double xrt_tdelt, xrt_lclk0, sc_clk_tmp, xrt_lclk_tmp;
 unsigned int e_lclock24, e_shopenlocal24, e_shcloselocal24;

 extern double ana_systime();
 /* data header from data_stuff.c */
 extern	int	datatype, comptype;
 extern unsigned char rawbuf[];
 extern int	rawbufsize;
 extern int apid, ccsdssize, scount;
 typedef union {
 PacketHeader pheader;
 CTpacketHeader ctheader;
 DIAGpacketHeader acheader;
 IscanPacketHeader isheader;
 XRTpacketHeader xrtheader;
 } Ph;
 extern Ph ph;
 extern int pheadsize;
 extern unsigned char *packdata1;
 unsigned char FGheaderpackdata1[131584];  /* oversized but should handle all cases */
 unsigned char SPheaderpackdata1[131584];  /* oversized but should handle all cases */
 /* for the image header extensions */
 char *FGextension, *SPextension;
 int    FGextensionSize, SPextensionSize, FGxalloc=0, SPxalloc=0;
 int	FGheaderSize, SPheaderSize;
 
 /* some structure pointers for the HK packets */
 HKstatusData	*hkStat;

 static	int	n;		/* arg counter */
 static	int	nfiles, max, recursive_flag = 0, get_type_flag, npack_offset=0;
 extern int wrfitsNS(unsigned char *x, char *name, int ndim, int dimen[], FITSkey *keys, int dtype, char *, int);
 /* below is the FG copy of some keys used in more than one function,
 the SP's are static in SPreformat as are the XRT and others */
 FITSkey *FGkeyNUM_PCKS, *FGkeyPCK_SN1, *FGkeyPRODUCT;
 FITSkey *XRTkeyNUM_PCKS, *XRTkeyPCK_SN1, *XRTkeyFW1s, *XRTkeyFW2s;
 FITSkey *SPkeyPCK_SN1, *SPkeyNUM_PCKS;
 FITSkey *packetCompressionKeys(PacketHeader *pheader, FITSkey *nextKey);
 char *itemset1[] = { "serial number", "MDP Clock", "# SP packets", "# FG packets",
 	"# CT packets", "rate, Mbits/s"};
 char	*open_time, *close_time, *name_in;
 char	**flist, **goodfiles, **lastfiles;
 long long *filesizes, *lastfilesizes, *goodsizes;
 int	*filetimes, *goodtimes;
 int  cnv_year;
 char linebuf[512];	/* for scratch only ! */
 char reformatPath[512], reformatPathXRT[512];
 char cnvfile_path[512], leapsec_path[512];
 char *nameFilter = NULL;
 char sourceFile[256];
 FILE *fin, *fout, *FGout, *SPout, *RAWout, *slitFile, *mdumpFile;
 FILE	*posfile;  /* handle this one as a stream */
 char *name_pos = "peek.pos";

 /* set default socket_flag and raw_write to 0, since no way to turn on, this
 effectively removes these as options in this version */
 int	infile, socket_flag = 0, test_flag = 0;
 int	format_flag = 1, badshow_flag = 0, status_buf_dump_flag = 0, data_product_dump_flag = 0;
 int	showMC = 0, mdumpFlag = 1;
 int	ntry = 10000000;  /* can be changed via command line */
 int	port_flag = 0, data_port, connect_flag = 0, display_flag = 1, file_flag;
 int	gui_flag = 1, list_flag = 1, append_flag = 0;
 int	packet_cnt, numSP, numFG, nbytes, currentSerial=-1, gap_count = 0;
 int    XRTgap_count = 0;
 int    XRTcurrentSerial=-1;
 int	numXRT;
 int	numMEM, numCTref, numCTlive, numDIAG, numCHAN, numISCAN;
 long long file_position, totalbytes, all_totalbytes, current_position;
 int	verify_macro_synch = 1, pause_state, quit_state, frame_pause_state, frame_trip_flag;
 int	restart_flag, end_flag, head_flag, nfilesread, auto_next_file_flag;
 int	all_packet_cnt, FGmallocFlag, SPmallocFlag, sdtp_flag = 1, decomp_flag = 1;
 int	auto_erase_flag = 1, chan_show_flag = 1, iscan_show_flag = 1, stopOnBad = 1;
 off64_t  fsize64;
 off64_t ipos64 = 0;
 char	*tf2_defpath = "/net/solserv/home/fpptc/packets";
 char	*tf2_path;
 SPinfo		*SPinfoHdr;
 FGinfo		*FGinfoHdr;
 void newfile();
 extern void timeRefCheck(unsigned int *t);
 FGinfo		fakeFGinfoHdr;
 SPinfo		fakeSPinfoHdr;
 HKstatusData	fakeHKstatusData;
 time_t	sdtpbasetime;
 unsigned int	timeRef, SPtime, FGtime, CTtime;
 int do_ti_time = 1; /* flag. not used yet. */
 int sirius_pkts;
 extern int unsigned FPPccsdsti, SBccsdsti, XRTccsdsti;
 extern int unsigned pkt_ti_time;
 extern unsigned int old_ti_time; /* for TI time conversion */
 double sb_time_0;
 /* reformat items */
 int	key_flag, single_flag;
 int	fg_in_progress, sp_in_progress, sp_start_exists, fg_header_exists, xrt_in_progress;
 FGfitsImage	FGimage;	/* a structure for one FG image */
 SPfitsImage	SPimage;	/* a structure for one SP image */
 XRTfitsImage	XRTimage;	/* a structure for one XRT image */
 FITSkey *CTfitsKeys, *FGfitsKeys, *SPfitsKeys, *XRTfitsKeys;
 FITSkey *FGimageParams(FITSkey *nextKey);
 FITSkey *CTloadCalendarKeys(FITSkey *nextKey);
 FITSkey *loadCalendarKeys(struct tm *timeobs, int ms, FITSkey *nextKey);
 FITSkey *packetCompressionKeys(PacketHeader *pheader, FITSkey *nextKey);
 void getFirstExposure(FGinfo *FGinfoHdr, float *et, float *edct, float *edct2,unsigned int *ctclose);
 void getFirstShutterlessExposure(FGinfo *FGinfoHdr, unsigned int *ctStart, unsigned int *phaseStart);
 void getFirstSPintegration(SPinfo *SPinfoHdr, unsigned int *ctStart, unsigned int *phaseStart);

 double	 t0, t1, t2;
 float	totalGbytes;
 fg_macro_command  currentFGmacroCommand;  /* for a copy from packets */
 sp_macro_command  currentSPmacroCommand;  /* for a copy from packets */
 fg_expanded_parameters	fg_p;   /* partially computed from packet header */
 int	FGCCDixc, FGCCDiyc;
 sp_expanded_parameters	obsSP;   /* partially computed from packet header */
 /* note that we don't keep the first byte (the macro ID) in fg_macro_command */
 off64_t *past_frames;
 int	iframe, *past_frames_pc, iframe_max, frame_end, last_iframe = -1;
 int	ready_for_new_fits, processing_fits;
 char  dir_name[512], packetpath[512], dir_name_XRT[512];
 /* the frame descriptor block table, keep in synch with ObsGen.cpp, eventually
 this has to be a loadable table */
fbd_flt FDBarray[256] = {
  { 1, 0, NOMASK, 0, 0, 0, 0, 127, 255, 0, 0, 0},	/* full size, no summing, no binning */
  { 2, 0, NOMASK, 1, 1, 0, 0, 127, 255, 0, 0, 0},	/* full size, 2x2 summing */
  { 3, 0, NOMASK, 0, 0, 0, 0, 127, 127, 0, 0, 0},	/* 2048x2048 cutout */
  { 4, 0, NOMASK, 0, 0, 0, 0,  63,  63, 0, 0, 0},	/* 1024x1024 cutout */
  { 5, 0, NOMASK, 0, 0, 0, 0,  31,  31, 0, 0, 0},	/* 512x512 cutout */
  { 6, 0, NOMASK, 0, 0, 0, 0,  15,  15, 0, 0, 0},	/* 256x256 cutout */
  /* be conservative with the shutterless width for early tests, use 64 even though
  80 works, consider using 80 after things are more stable */
  { 7, 0, MASK4,  0, 0, 1, 0, 127,   3, 0, 0, 0},	/* shutterless, full height, 64 wide */
  { 8, 0, MASK1,  0, 0, 1, 0, 127,   3, 0, 0, 0},	/* shutterless, full height, 64 wide, wider mask */
  { 9, 0, MASK3,  0, 0, 1, 0, 127,  11, 0, 0, 0},	/* 0.2s shutterless, full height, 192 wide */
  {10, 0, NOMASK, 1, 1, 0, 0, 127, 255, 0, 0, 0},	/* full size, 2x2 summing, no binning */
  {11, 0, NOMASK, 0, 0, 0, 0, 127, 255, 1, 1, 0},	/* full size, 2x2 binning, no summing */
  {12, 0, NOMASK, 1, 1, 0, 0, 127, 127, 0, 0, 0},	/* 2048x2048 cutout, 2x2 summing */
  {13, 0, NOMASK, 2, 2, 0, 0, 127, 127, 0, 0, 0},	/* 2048x2048 cutout, 4x4 summing */
  {14, 0, MASK2,  0, 0, 1, 0, 127,  24, 0, 0, 0},	/* shutterless, full height, 400 wide */
  /* 10/7/2004 - correct FID 15, it caused 100 wide images */
  {15, 0, MASK2,  1, 1, 1, 0, 127,  23, 0, 0, 0},	/* shutterless, 2x2, full height, 384 wide */
  {16, 0, MASK1,  1, 1, 1, 0, 127,  49, 0, 0, 0},	/* shutterless, 2x2, full height, 800 wide */
  /* 144 and 288 below are conservative, could get more width, e.g., 192 and 384 or 176 and 352
  to keep the times below 94 ms */
  /* 10/7/2004 - correct FID's 17 and 18, they caused 36 wide images */
  {17, 0, MASK3,  1, 1, 1, 0, 127,  9, 0, 0, 0},	/* shutterless, 2x2, full height, 160 wide */
  //{17, 0, MASK3,  1, 1, 1, 0, 127,  8, 0, 0, 0},	/* shutterless, 2x2, full height, 144 wide */
  {18, 0, MASK2,  2, 2, 1, 0, 127,  19, 0, 0, 0},	/* shutterless, 4x4, full height, 320 wide */
  //{18, 0, MASK2,  2, 2, 1, 0, 127,  17, 0, 0, 0},	/* shutterless, 4x4, full height, 288 wide */
  /* 11/9/2004 - missed the next one, similar problem, change 800 to 768 */
  {19, 0, MASK1,  2, 2, 1, 0, 127,  47, 0, 0, 0},	/* shutterless, 4x4, full height, 768 wide */
  //{19, 0, MASK1,  2, 2, 1, 0, 127,  49, 0, 0, 0},	/* shutterless, 4x4, full height, 800 wide */
  {20, 0, MASK1,  2, 2, 1, 0, 127,  99, 0, 0, 0},	/* shutterless, 4x4, full height, 1600 wide */
  {21, 0, MASK1,  0, 0, 0, 0, 127, 255, 0, 0, 0},	/* 21 - 24 are full size with the 4 masks for */
  {22, 0, MASK2,  0, 0, 0, 0, 127, 255, 0, 0, 0},	/* testing the masked area */
  {23, 0, MASK3,  0, 0, 0, 0, 127, 255, 0, 0, 0},
  {24, 0, MASK4,  0, 0, 0, 0, 127, 255, 0, 0, 0},
  {25, 0, NOMASK, 0, 0, 0, 0, 127, 127, 1, 1, 0},	/* 2048x2048, 2x2 binning, no summing */
  {26, 0, NOMASK, 0, 0, 0, 0, 127, 127, 2, 2, 0},	/* 2048x2048, 4x4 binning, no summing */
  {27, 0, MASK1, 0, 0, 0, 0, 127, 63, 0, 0, 0},		/* 1024x2048 */
  {28, 0, MASK1, 1, 1, 0, 0, 127, 63, 0, 0, 0},		/* 1024x2048, 2x2 summing */
  {29, 0, MASK1, 2, 2, 0, 0, 127, 63, 0, 0, 0},		/* 1024x2048, 4x4 summing */
  {30, 0, NOMASK, 0, 0, 0, 0, 127, 31, 0, 0, 0},	/* 512x2048, 1x1 summing */
  {31, 0, NOMASK, 0, 0, 0, 0, 15, 255, 0, 0, 0},	/* 4096x256, 1x1 summing */
  {32, 0, NOMASK, 0, 0, 0, 0, 31, 255, 0, 0, 0},	/* 4096x512, 1x1 summing */
  {33, 0, NOMASK, 1, 1, 0, 0, 15, 255, 0, 0, 0},	/* 4096x256, 2x2 summing */
  {34, 0, NOMASK, 2, 2, 0, 0, 15, 255, 0, 0, 0},	/* 4096x256, 4x4 summing */
  {35, 0, NOMASK, 0, 0, 0, 0, 63, 127, 0, 0, 0},	/* 2048x1024, 1x1 summing */
  {36, 0, NOMASK, 2, 2, 0, 0, 127, 255, 0, 0, 0},	/* 4096x2048, 4x4 summing */
  {37, 0, NOMASK, 0, 0, 0, 0,  31, 63, 0, 0, 0},	/* 1024x512, 1x1 summing */
  {38, 0, NOMASK, 1, 1, 0, 0, 63, 127, 0, 0, 0},	/* 2048x1024, 2x2 summing */
  {39, 0, NOMASK, 1, 1, 0, 0, 63,  63, 0, 0, 0},	/* 1024x1024, 2x2 summing */

 /* next 5 are narrow shutterless with a wider mask to use for cascaded ROI's */
  {40, 0, MASK1,  0, 0, 1, 0, 127,  11, 0, 0, 0},	/* 0.2s shutterless, full height, 192 wide, like 9 but wider mask */
  {41, 0, MASK1,  0, 0, 1, 0, 127,  24, 0, 0, 0},	/* shutterless, full height, 400 wide, like 14 but wider mask */
  {42, 0, MASK1,  1, 1, 1, 0, 127,  23, 0, 0, 0},	/* shutterless, 2x2, full height, 384 wide, like 15 but wider mask */
  {43, 0, MASK1,  1, 1, 1, 0, 127,  9, 0, 0, 0},	/* shutterless, 2x2, full height, 160 wide, like 17 but wider mask */
  {44, 0, MASK1,  2, 2, 1, 0, 127,  19, 0, 0, 0},	/* shutterless, 4x4, full height, 320 wide, like 18 but wider mask */

 /* next 12 are shutterless that are half height */

  {45, 0, MASK4,  0, 0, 1, 0, 63,   3, 0, 0, 0},	/* shutterless, half height, 64 wide */
  {46, 0, MASK1,  0, 0, 1, 0, 63,   3, 0, 0, 0},	/* shutterless, half height, 64 wide, wider mask */

  {47, 0, MASK3,  0, 0, 1, 0, 63,  11, 0, 0, 0},	/* 0.2s shutterless, half height, 192 wide */
  {48, 0, MASK1,  0, 0, 1, 0, 63,  11, 0, 0, 0},	/* 0.2s shutterless, half height, 192 wide, like 47 but wider mask */

  {49, 0, MASK2,  0, 0, 1, 0, 63,  24, 0, 0, 0},	/* shutterless, half height, 400 wide */
  {50, 0, MASK1,  0, 0, 1, 0, 63,  24, 0, 0, 0},	/* shutterless, half height, 400 wide, like 49 but wider mask */

  {51, 0, MASK2,  1, 1, 1, 0, 63,  23, 0, 0, 0},	/* shutterless, 2x2, half height, 384 wide */
  {52, 0, MASK1,  1, 1, 1, 0, 63,  23, 0, 0, 0},	/* shutterless, 2x2, half height, 384 wide, like 51 but wider mask */

  {53, 0, MASK3,  1, 1, 1, 0, 63,  9, 0, 0, 0},		/* shutterless, 2x2, half height, 160 wide */
  {54, 0, MASK1,  1, 1, 1, 0, 63,  9, 0, 0, 0},		/* shutterless, 2x2, half height, 160 wide, like 53 but wider mask */

  {55, 0, MASK2,  2, 2, 1, 0, 63,  19, 0, 0, 0},	/* shutterless, 4x4, half height, 320 wide */
  {56, 0, MASK1,  2, 2, 1, 0, 63,  19, 0, 0, 0},	/* shutterless, 4x4, half height, 320 wide, like 55 but wider mask */
  {57, 0, MASK0, 0, 0, 0, 0, 127, 63, 0, 0, 0},		/* 1024x2048 w/o a mask to better de-center */

   2388 * 0						/* end of list, 199 empties */
};
#define MAX_FRAMES sizeof(FDBarray)/sizeof(fbd_flt)
 /* the SP spatial extract tables are below. There are 16 entries, just 2 bytes
 each for a total table size of 32 bytes. This will be at a specific location
 in memory and is intended to be loadable. It is defined below as a byte
 array of 32 bytes with each pair of bytes representing the start position
 and width of a table entry, each in units of 8 pixels. I did this just to
 be sure of the memory organization. */
 
 unsigned char SPextractSpatialTable[32] = {
   /* note that the spatial height for the SP is 1024 */
   32, 63,	/* 512 pixels centered */
   0, 127,	/* full fov, 1024 high */
   64, 63,	/* top half */
   0, 63,	/* bottom half */
   48, 31,	/* 256 pixels centered */
   0, 31,	/* this and next 3 are quarter fov at 4 positions */
   32, 31,
   64, 31,
   96, 31,
   0, 127,	/* full fov, filler */
   0, 127,	/* full fov, filler */
   0, 127,	/* full fov, filler */
   0, 127,	/* full fov, filler */
   0, 127,	/* full fov, filler */
   0, 127,	/* full fov, filler */
   0, 127	/* full fov, filler */
   };
 int	sp_ix0,sp_ix1,sp_iy0,sp_iy1;
 /* temperatures kept here */
 float alltemps[36];
 /* we need to convert Obs ID to gen func, this depends on the Obs ID tables
 but the current relationship is given in the obs2genFunc array below */
 int obs2genFunc[256] = {
   0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,0,0,0,1,1,1,1,1,1,1,0,0,0,
   0,32,33,34,35,36,0,38,39,2,2,2,33,32,34,35,36,11,11,9,9,10,10,33,38,39,3,3};
   /* and the rest are 0 */
 /* genFunNimages is used for shuttered FG modes, set to 0 for shutterless */
 int genFunNimages[256] = {1,1,2,4,8,8,4,4,2,4,4,2,1,1,1,1,1,4,0,0,0,0};
   /* and the rest are 0 */
 char kw_origin[] =
 "JAXA/ISAS\0                                                          ";
 char kw_obstitle[] =
 "post-launch cal data\0                                               ";
 char kw_target[] =
 "engineering\0                                                        ";
 char kw_sci_obj[] =
 "NONE\0                                                               ";
 char kw_obs_dec[] =
 "TBD\0                                                                ";
 char kw_join_sb[] =
 "TBD\0                                                                ";
 char kw_obs_num[] =
 "42\0                                                                 ";
 char kw_jop_id[] =
 "9999\0                                                               ";
 char kw_noaa_num[] =
 "-1\0                                                               ";
 char kw_observer[] =
 "anonymous\0                                                          ";
 char kw_planner[] =
 "committee\0                                                          ";
 char kw_tohbans[] =
 "na\0                                                                 ";
 char kw_datatype[] =
 "SCI\0                                                                ";

 int dkw=0;
 int oldAspect = 0;	/* set to 1 to do the old image orientation */
 int fg_comp_choice, sp_comp_choice;
 int FGbyteCountI, FGpixelCountQUV, SPbyteCountI, SPpixelCountQUV, XRTbyteCount, XRTpixelCount;
 int SPpixelCountI, SPbyteCountQUV, FGpixelCountI, FGbyteCountQUV;
 int	XRTflipFlag;
 XRT0x5a4 hk0x5a4;	/* 12/17/2006 - now a global */
 XRT0x584 hk0x584;
 unsigned int e_sclock32;
 extern int psizeCompressed;
 extern unsigned short FPPcompIDS[4], XRTcompIDS[4];
 /*--------------------------------------------------------------------------*/
unsigned int getTI(unsigned int MDP, unsigned int ccsdsti, int *timeErrFlag)
 {
 unsigned int IMti, ccsds28;
 int dt;
 IMti = ((MDP) >> 4 ) & 0x0fffffff;
 /* we want the upper 4 bits from ccsdsti but there is a slim
 chance of a rollover between the times. We expect ccsdsti to be the later
 time so if IMti > ccsds28 we suspect a rollover. */
 ccsds28 = ccsdsti & 0x0fffffff;
 printf("getTI - MDP TI and ccsds28 = %d, %d\n", IMti, ccsds28);
 if (IMti > ccsds28) {
   /* probably a rollover but do a sanity check */
   dt = IMti - ccsds28;  /* dt should be a fairly large + value */
   printf("**** getTI - rollover between ccsdsti and IMti, dt = %d\n", dt);
   if (dt > 0x00ffffff) {
     IMti = IMti | (ccsdsti & 0xf0000000) + 0x10000000;
     /* this will rollover in 4 years so please figure out what to do
     in that case before then! */
     *timeErrFlag = 0;
   } else {
     /* this is unreasonable, just take the  ccsdsti time and set
     the bad exposure time flag */
     IMti = ccsdsti;
     *timeErrFlag = 1;
   }
 } else {
   /* this is expected situation, take the upper bits from ccsdsti */
   IMti = IMti | (ccsdsti & 0xf0000000);
   /* dt should be small here, if it is very large we might have
   something weird going on. Check for weirdness. */
   dt = ccsds28 - IMti;
   if (dt > 0x00ffffff) {
     printf("**** getTI - strange dt = ccsds28 - IMti = %d\n", dt);
     *timeErrFlag = 1;
   } else *timeErrFlag = 0;
 }
 return IMti;
 }
 /*--------------------------------------------------------------------------*/
void hexdump(p,n)
 unsigned char	*p;
 int	n;
 {
 /* dump a set of bytes in hex format 16 per line */
 int	i;
 for (i=0;i<n;i++) {
   if (i%20 == 0) { if (i) printf("\n");  printf("%4d:", i); }
   printf(" %2x", *p++);
 }
 printf("\n");
 }
 /*--------------------------------------------------------------------------*/
char  *product_string( i)
 int	i;
 {
 char *q;
 q = (char *) malloc(64);	/* enough! */
 /* use the mnemonic codes for the product codes in case they get changed */
 switch (i) {
  case DPC_STOKES_I:
    sprintf(q, "STOKES I"); break;
  case DPC_STOKES_Q:
    sprintf(q, "STOKES Q"); break;
  case DPC_STOKES_U:
    sprintf(q, "STOKES U"); break;
  case DPC_STOKES_V:
    sprintf(q, "STOKES V"); break;
  case DPC_SP_RAW:
    sprintf(q, "SP raw"); break;
  case DPC_FG_RAW:
    sprintf(q, "FG raw"); break;
  case DPC_SPARE_2:
  case DPC_SPARE_3:
  case DPC_SPARE_4:
  case DPC_SPARE_5:
  case DPC_SPARE_6:
    sprintf(q, "spare code"); break;
  case DPC_INTENSITY:
    sprintf(q, "FG Intensity"); break;
  case DPC_MAGNETOGRAM:
    sprintf(q, "FG Magnetogram"); break;
  case DPC_DOPPLERGRAM:
    sprintf(q, "FG Dopplergram"); break;
  case DPC_FILTERGRAM:
    sprintf(q, "Filtergram"); break;
  case DPC_DARK:
    sprintf(q, "Dark"); break;
  case DPC_CT_FRAME_REF:
    sprintf(q, "CT reference frame"); break;
  case DPC_CT_FRAME_LIVE:
    sprintf(q, "CT live frame"); break;
  case DPC_DIAGNOSTIC:
    sprintf(q, "jitter diagnostic"); break;
  case DPC_CALIBRATION_1:
    sprintf(q, "Calibration 1"); break;
  case DPC_SP_ENGG_FR:
    sprintf(q, "SP engineering"); break;
  case DPC_FG_ENGG_FR:
    sprintf(q, "FG engineering"); break;
  case DPC_ANALOG_DUMP:
    sprintf(q, "AC analog channel readout"); break;
  case DPC_MEMORY_DUMP:
    sprintf(q, "memory dump"); break;
  case DPC_TEST:
    sprintf(q, "test"); break;

  default: 
    sprintf(q, "invalid product code %d", i);
    break;
 }
 return q;
 /* don't forget to free q in the caller after copying it somehow */
 }
  /*--------------------------------------------------------------------------*/
char  *genFunc_string(i)
 int	i;
 {
 char *q;
 int	genFunc;
 q = (char *) malloc(64);	/* enough! */
 /* use the mnemonic codes for the product codes in case they get changed */
 genFunc = obs2genFunc[i];
 switch (genFunc) {
  case FGmaskless:
    sprintf(q, "FG (simple)"); break;
  case FGshutteredIV:
    sprintf(q, "FG shuttered I and V"); break;
  case FGshutteredStokes:
    sprintf(q, "FG shuttered Stokes"); break;
  case FGshutteredMG4:
    sprintf(q, "FG MG4 V/I"); break;
  case FGshutteredMG4IV:
    sprintf(q, "FG MG4 V and I"); break;
  case FGshutteredMG2:
    sprintf(q, "FG MG2 V/I"); break;
  case FGshutteredMG2IV:
    sprintf(q, "FG MG2 V and I"); break;
  case FGshutteredMG1:
    sprintf(q, "FG MG1 V/I"); break;
  case FGshutteredDG4:
    sprintf(q, "FG DG4 vel"); break;
  case FGshutteredDG4_A_B:
    sprintf(q, "FG DG4 2v's"); break;
  case FGshutteredDG2:
    sprintf(q, "FG DG2"); break;
  case FGshutteredFocusScan:
    sprintf(q, "FG focus scan"); break;
  case FGshutterlessIV:
    sprintf(q, "FG shutterless I and V"); break;
  case FGshutterlessIQUV:
    sprintf(q, "FG shutterless Stokes"); break;
  case FGshutterlessIQ:
    sprintf(q, "FG shutterless I and Q"); break;
  case FGshutterlessIU:
    sprintf(q, "FG shutterless I and U"); break;
  case FGshutterlessIQV:
    sprintf(q, "FG shutterless IQV"); break;
  case FGshutterlessIUV:
    sprintf(q, "FG shutterless IUV"); break;

  case FGintegratedWaveScan:
    sprintf(q, "FG Intensity Scan"); break;
  case FGlaserTune:
    sprintf(q, "FG Laser Tune"); break;
  case FGemiTest:
    sprintf(q, "FG EMI test"); break;

 /* new modes added in Jan 2006 */
  case FGshutteredIV2:
    sprintf(q, "FG shuttered I and V with 0.1s intervals"); break;
  case FGshutterlessIV2:
    sprintf(q, "FG shutterless I and V with 0.2s intervals"); break;
  case FGshutterlessIV3:
    sprintf(q, "FG shutterless I and V with 0.1s intervals"); break;

  case FGintegratedWaveScanUpdate:
    sprintf(q, "FG Intensity Scan with update"); break;
  default: 
    sprintf(q, "invalid Obs ID code %d", i);
    break;
 }
 return q;
 /* don't forget to free q in the caller after copying it somehow */
 }
 /*--------------------------------------------------------------------------*/
char  *wave_id_string( i)
 int	i;
 {
 char *q;
 q = (char *) malloc(64);	/* enough! */
 switch (i) {
  case BFI_NO_MOVE:
    sprintf(q, "BFI no move"); break;
  case BFI_3883:
    sprintf(q, "CN bandhead 3883"); break;
  case BFI_3968:
    sprintf(q, "Ca II H line"); break;
  case BFI_4305:
    sprintf(q, "G band 4305"); break;
  case BFI_4504:
    sprintf(q, "blue cont 4504"); break;
  case BFI_5550:
    sprintf(q, "green cont 5550"); break;
  case BFI_6684:
    sprintf(q, "red cont 6684"); break;
  case NFI_NO_MOVE:
    sprintf(q, "NFI no move"); break;
  case NFI_5172:
    sprintf(q, "TF Mg I 5172"); break;
  case NFI_5250:
    sprintf(q, "TF Fe I 5250"); break;
  case NFI_5576:
    sprintf(q, "TF Fe I 5576"); break;
  case NFI_6302:
    sprintf(q, "TF Fe I 6302"); break;
  case NFI_6563:
    sprintf(q, "TF H I 6563"); break;
  case NFI_5896:
    sprintf(q, "TF Na I 5896"); break;
  case NFI_6328:
    sprintf(q, "laser line 6328"); break;
  case NFI_5430:
    sprintf(q, "laser line 5430"); break;
  case NFI_5940:
    sprintf(q, "laser line 5940"); break;
  case NFI_6117:
    sprintf(q, "laser line 6117"); break;
  case NFI_5172BASE:
    sprintf(q, "TF Mg I 5172 base"); break;
  case NFI_5250BASE:
    sprintf(q, "TF Fe I 5250 base"); break;
  case NFI_5576BASE:
    sprintf(q, "TF Fe I 5576 base"); break;
  case NFI_6302BASE:
    sprintf(q, "TF Fe I 6302 base"); break;
  case NFI_6563BASE:
    sprintf(q, "TF H I 6563 base"); break;
  case NFI_5896BASE:
    sprintf(q, "TF Na I 5896 base"); break;
  case NFI_6328BASE:
    sprintf(q, "laser line 6328 base"); break;
  case NFI_5430BASE:
    sprintf(q, "laser line 5430 base"); break;
  case NFI_5940BASE:
    sprintf(q, "laser line 5940 base"); break;
  case NFI_6117BASE:
    sprintf(q, "laser line 6117 base"); break;
  case FLT_SPARE2:
    sprintf(q, "spare 2"); break;
  default: 
    sprintf(q, "invalid wavelength code %d", i);
    break;
 }
 return q;
 /* don't forget to free q in the caller after copying it somehow */
 }
 /*--------------------------------------------------------------------------*/
int fg_get_ccd_center(fg_macro_command *mc)
 {
 int	ixc, iyc, tf_flag, iscale, dx, dy, dxm1, dym1;
 int	ix0, ix1, iy0, iy1, nx, ny, seg, i;
 int	sumy, sumx, biny, binx, nxCCD, nyCCD, fdb_pixel_unit, rq, rqd2;
 /* if we have a FG raw, there is no valid macro command and we assume
 centered on CCD and use the packet dx, dy for the size */
 if (DPC_FG_RAW == ph.pheader.info.subIdProduct) {
   /* offset to center (actually a half pixel beyond) */
   ixc = 1024;
   iyc = 2048;
   /* we assume that the image size in the packet header is correct */
   dx = ph.pheader.info.nx;	/* this is N/S on sun */
   dy = ph.pheader.info.ny;
   if (dx > 2048 || dy > 4096 || dx < 0 || dy < 0) {
     printf("illegal image size in header - %d x %d\n", dx, dy);
     return 1;
   }
   ix0 = ixc - dx/2;	iy0 = iyc - dy/2;
   ix0 = MAXOF(ix0, 0);	/* clamp at 0 */
   iy0 = MAXOF(iy0, 0);	/* clamp at 0 */
   /* also round to nearest multiple of 16 */
   /* removed 7/31/2002, but put it back in because fillcell (used for the
   test pattern) assumes zero mod 8, this may be the only place needing this
   so we  can relax this (probably) in the near future */
   ix0 = 16 * ((ix0 + 8)/16);
   iy0 = 16 * ((iy0 + 8)/16);
   dxm1 = dx - 1;
   dym1 = dy - 1;
   ix1 = ix0 + dxm1;
   iy1 = iy0 + dym1;
   /* clip the max but don't clip the size (butt, don't crop) */
   if (ix1 > 2047) { ix1= 2047;  ix0 = ix1 - dxm1; }
   if (iy1 > 4095) { iy1= 4095;  iy0 = iy1 - dym1; }
   /* put these in the structure */
   fg_p.ix0 = ix0; fg_p.ix1 = ix1; fg_p.iy0 = iy0; fg_p.iy1 = iy1;
   ny = iy1 - iy0 + 1;
   nx = ix1 - ix0 + 1;
   fg_p.nx = nx;
   fg_p.ny = ny;
   /* no binning for raw and assume no summing (we could get it from
   camera state), this only affects the nugu image */
   fg_p.sumx = fg_p.binx = 0;
 } else {
   /* using the macro command, figure out the CCD center and cutout */
   /* it is important that this algorithm for computing the center be the
   same as the onboard s/w, otherwise chaos! */
   ixc = FGCCDixc = mc->ext_reg.center_row;
   iyc = FGCCDiyc = mc->ext_reg.center_col;
   /* printf("ext reg offsets = %d (EW), %d (NS)\n", iyc, ixc); */
   fg_p.wave = mc->parameters.wave;
   /* need to get some parameters from the frame table */
   i = mc->parameters.frame_def_id - 1;
   //printf("frame ID index = %d\n", i);
   fg_p.sumy = sumy = FDBarray[i].col_sum;  fg_p.sumx = sumx = FDBarray[i].row_sum;
   fg_p.biny = biny = FDBarray[i].col_bin;  fg_p.binx = binx = FDBarray[i].row_bin;
   fdb_pixel_unit = FDB_PIXEL_UNIT;
   fg_p.nxCCD = nxCCD = ((FDBarray[i].width + 1)* fdb_pixel_unit);
   fg_p.nyCCD = nyCCD = ((FDBarray[i].height + 1)* fdb_pixel_unit);
   fg_p.nx = nx = (nxCCD >> (sumx + binx));
   fg_p.ny = ny = (nyCCD >> (sumy + biny));
   //printf("nx, ny, nxCCD, nyCCD = %d %d %d %d\n", nx, ny, nxCCD, nyCCD);

   tf_flag = (fg_p.wave >= NFI_NO_MOVE);
   if (tf_flag) iscale = NFI_SCALE; else iscale = BFI_SCALE;
   seg = ph.pheader.info.subIdCCDseg;
   /* printf("iscale = %d, segment = %d\n", iscale, seg); */
   ixc = (1000 * ixc) / iscale;
   iyc = (1000 * iyc) / iscale;
   /* offset to center (actually a half pixel beyond) */
   ixc = ixc + 1024;
   iyc = iyc + 2048;
   /* we assume that the image size in the packet header is correct */
   /* the nx and ny above are the image size we expect for this FDB,
   compare with packet version */
   dx = ph.pheader.info.nx;	/* this is N/S on sun */
   dy = ph.pheader.info.ny;
   if (dx > 2048 || dy > 4096 || dx < 0 || dy < 0) {
     printf("illegal image size in header - %d x %d\n", dx, dy);
     return 1;
   }
   if (dx != nx || dy != ny) {
     /* if this is a special mode, the FDB doesn't apply and we don't
     want the error message below (it is not appropiate) */
     if (datatype != DATADIAGNOSTIC && datatype != DATADIAGNOSTIC2)
     printf("disagreement about image size\npacket has - %d x %d\nFDB has    - %d x %d\n",
       dx, dy, nx, ny);
     /* we have to use the packet value for the image size */
     fg_p.nx = dx;  fg_p.ny = dy;
     /* the CCD size is going to be messed up, take it to be the packet size */
     fg_p.nxCCD = nxCCD = dx;  fg_p.nyCCD = nyCCD = dy;
   }
   /* use the FDB value in any case (this could be wrong if the tables get
   changed so a more thorough strategy may be required) */
   ix0 = ixc - fg_p.nxCCD/2;	iy0 = iyc - fg_p.nyCCD/2;
   ix0 = MAXOF(ix0, 0);	/* clamp at 0 */
   iy0 = MAXOF(iy0, 0);	/* clamp at 0 */
   /* 2/25/2003 - round to at least nearest multiple of 8, this allows using fillcell
   for testing and covers all possible summing modes. When fillcell is not needed
   (or is modified), we can relax this to the summing size only. */
   rq = MAXOF(8, (0x1 << (fg_p.sumx + fg_p.binx)));
   rq = MAXOF(rq, (0x1 << (fg_p.sumy + fg_p.biny)));
   rqd2 = rq/2;
   ix0 = rq * ((ix0 + rqd2)/rq);
   iy0 = rq * ((iy0 + rqd2)/rq);
   dxm1 = fg_p.nxCCD - 1;
   dym1 = fg_p.nyCCD - 1;
   ix1 = ix0 + dxm1;
   iy1 = iy0 + dym1;
   /* clip the max but don't clip the size (butt, don't crop) */
   if (ix1 > 2047) { ix1= 2047;  ix0 = ix1 - dxm1; }
   if (iy1 > 4095) { iy1= 4095;  iy0 = iy1 - dym1; }
   /* put these in the structure */
   fg_p.ix0 = ix0; fg_p.ix1 = ix1; fg_p.iy0 = iy0; fg_p.iy1 = iy1;
 }
 return 0;

 }
 /*--------------------------------------------------------------------------*/
int sp_get_ccd_center(sp_macro_command *mc)
 {
 int i, dx, dy, sum;
 
 /* avoid some bad packets by a sanity check here */
 if (ph.pheader.info.x0 < 0 || ph.pheader.info.y0 < 0) {
   printf("illegal image offset in header - %d, %d\n", ph.pheader.info.x0, ph.pheader.info.y0);
   return 1;
 }

 /* we assume that the image size in the packet header is correct */
 dx = ph.pheader.info.nx;	/* this is N/S on sun */
 dy = ph.pheader.info.ny;
 /* avoid some bad packets by a sanity check here */
 if (dx > 1050 || dy > 448 || dx < 0 || dy < 0) {
   printf("illegal image size in header - %d x %d\n", dx, dy);
   return 1;
 }

 /* check if raw data, these don't use a cutout table */
 if (ph.pheader.info.subIdProduct == DPC_SP_RAW) {
   sp_ix0 = 0;
   sp_iy0 = 0;
 } else {
   /* we don't have enough info in the telemetry yet to do this, we will have
   to put the CCD cutout in the housekeeping, in the meantime we'll just assume
   a centered cutout to test this s/w */
   /* 9/22/2003 - we can do the spatial cutout from the MC but the ROI is
   available only from the image header in the ROI members. Those are set only
   if we read a header and then remain. In case a header is not the first packet,
   sp_iy0 defaults to 0. */
   i = mc->parameters.extract_table;
   obsSP.spaceOffset = (unsigned short) SPextractSpatialTable[2*i];
   obsSP.spaceOffset = (obsSP.spaceOffset)*8;
   //printf("obsSP.spaceOffset = %d\n", obsSP.spaceOffset);
   sp_ix0 = obsSP.spaceOffset;
   /* 9/12/2006 - forgot to adjust for summing along the slit */
   sum =  1 << ((int) (mc->parameters.bin_slit));
 }
 sp_ix1 = sp_ix0 + dx * sum - 1;
 sp_iy1 = sp_iy0 + dy - 1;
 /* should check against table as we get more info */
 return 0;
 }
 /*--------------------------------------------------------------------------*/
void sp_get_spec_offset(SPinfo *SPinfoHdr)
 {
  obsSP.roi_start = SPinfoHdr->roiStart;
  obsSP.roi_stop  = SPinfoHdr->roiStop;
  obsSP.specOffset = obsSP.roi_start;
  obsSP.nspect = obsSP.roi_stop - obsSP.roi_start;  /* note no +1 */
  sp_iy0 = obsSP.roi_start;
  //printf("sp_iy0 = %d\n", sp_iy0);
 }
 /*--------------------------------------------------------------------------*/
char  *compress_string(fg_macro_command *mc)
 /* a string with both sets of compression parameters */
 {
 char *q, *p;
 byte *praw;
 int	n;
 static  char *cmode[] = { "none", "reserved 1", "8bit DPCM", "12bit DCPM",
        "reserved 4", "reserved 5", "8bit JPEG", "12bit JPEG" };
 static char    *lut_labels[] = {"none","16U  ->12","14U  ->12",
        "16S  ->12","14.5S->12","13S -> 12","12U low","EIS",
        "8","9","10","11","12","13",
        "14","15"};
 q = p = (char *) malloc(256);	/* enough? */
 praw = (byte *) mc;
 n = sprintf(p,"compression 1: bit LUT %d (%s), C type is %s, AC %d, DC %d, Q %d, raw: %#x %#x\n",
   mc->c1_bit_compression_mode, lut_labels[mc->c1_bit_compression_mode],
   cmode[mc->c1_image_compression_mode],
   mc->c1_huffman_ac, mc->c1_huffman_dc, mc->c1_quantization,*(praw+4),*(praw+5));
 p = p + n;
 n = sprintf(p,"compression 2: bit LUT %d (%s), C type is %s, AC %d, DC %d, Q %d, raw: %#x %#x\n",
   mc->c2_bit_compression_mode, lut_labels[mc->c2_bit_compression_mode],
   cmode[mc->c2_image_compression_mode],
   mc->c2_huffman_ac, mc->c2_huffman_dc, mc->c2_quantization,*(praw+6),*(praw+7));
 return q;
 /* don't forget to free q in the caller after copying it somehow */
 }
 /*--------------------------------------------------------------------------*/
int get_comp_choice(fg_macro_command *mc, PacketHeader *pheader)
 /* note that since we use only the compression parts of the macro command structure,
 we can just specify fg for both the fg and sp case */
 {
 /* both might be the same, we return the first one in that case, if neither
 match a zero is returned */
 /* 10/18/2006 - this could be simplified and speeded up */
 if (mc->c1_bit_compression_mode == pheader->info.bit_compression_mode &&
     mc->c1_image_compression_mode == pheader->info.image_compression_mode &&
     mc->c1_huffman_ac == pheader->info.huffman_ac &&
     mc->c1_huffman_dc == pheader->info.huffman_dc &&
     mc->c1_quantization == pheader->info.quantization &&
     mc->c1_reserved_1 == pheader->info.reserved_1 &&
     mc->c1_reserved_2 == pheader->info.reserved_2) return 1;
 if (mc->c2_bit_compression_mode == pheader->info.bit_compression_mode &&
     mc->c2_image_compression_mode == pheader->info.image_compression_mode &&
     mc->c2_huffman_ac == pheader->info.huffman_ac &&
     mc->c2_huffman_dc == pheader->info.huffman_dc &&
     mc->c2_quantization == pheader->info.quantization &&
     mc->c2_reserved_1 == pheader->info.reserved_1 &&
     mc->c2_reserved_2 == pheader->info.reserved_2) return 2;

 {
   int	ic;	
   byte	*pb = (byte *) pheader;
   printf("bad compression choice, doesn't match 1 or 2\n");
   printf("got: %#x %#x, C1: %#x %#x, C2: %#x %#x\n", *(pb+30), *(pb+31), *(pb+41), *(pb+42), *(pb+43), *(pb+44));
   /* force a pause */
   if (stopOnBad) {
     printf("hit a key to go on (Q to cancel these)\n");
     ic = getchar();
     if ( (char) ic == 'Q') stopOnBad = 0;
   }
 }
 return 0;
 }
 /*--------------------------------------------------------------------------*/
char   *showSPmacro(sp_macro_command *mc, unsigned char c_id)
 /* returns a multi-line string with the SP parameters in a macro command */
 {
 char	*s, *p, *q, *q2, *offon[2] = {"OFF", " ON"};
 int	sbin, sum, ins_id, data_id, m_flag;
 p = s = malloc(2048); /* enough for a few lines, be careful though if adding */
 /* extract a few things */
 ins_id = ((mc->type & 0xe0) >> 5 ) &0x07;
 data_id = ((mc->type & 0x1e) >> 1 ) &0x0f;
 m_flag = (mc->type & 0x01);
 n = sprintf(p, "Main ID %#x, len. %d, instr. ID %d, data ID %d, monitor %d, Macro type %#x\n",
   mc->main_id, mc->len, ins_id, data_id, m_flag, c_id);
 p = p + n;
 sbin = mc->parameters.bin_slit;
 sbin = 1 << sbin;
 sum = mc->parameters.scan_sum;
 sum = 1 << sum;
 n = sprintf(p, "spatial binning %d, step %d, sum %d, repeat %s, ",
   sbin, mc->parameters.scan_step + 1, sum,  offon[mc->parameters.repeat_flag]);
 p = p + n;
 n = sprintf(p, "table %d, positions %d, CCD ",
   mc->parameters.extract_table, mc->parameters.slit_positions);
 p = p + n;
 if (mc->parameters.CCD_size) n = sprintf(p, "double width");
    else n = sprintf(p, "single width"); 
 p = p + n;
 n = sprintf(p, "\ncycles (0.8s each) %d, map center %d, TT reset %d, ",
   mc->parameters.cycles + 1, mc->map_reg.map_center, mc->parameters.tt_reset);
 p = p + n;
 n = sprintf(p, "bad pixel correction %s\n",
   offon[mc->parameters.bad_pixel]);
 p = p + n;

 q = compress_string( (fg_macro_command *) mc);
 n = sprintf(p, "%s", q);
 free(q);   /* or suffer a leak */ 
 return s;
 }
 /*--------------------------------------------------------------------------*/
char   *showFGmacro(fg_macro_command *mc, unsigned char c_id)
 /* returns a multi-line string with the FG parameters in a macro command */
 {
 char	*s, *p, *q, *q2;
 int	woff, obs_id, ins_id, data_id, m_flag;
 p = s = malloc(2048); /* enough for a few lines, be careful though if adding */
 /* extract a few things */
 ins_id = ((mc->type & 0xe0) >> 5 ) &0x07;
 data_id = ((mc->type & 0x1e) >> 1 ) &0x0f;
 m_flag = (mc->type & 0x01);
 n = sprintf(p, "Main ID %#x, len. %d, instr. ID %d, data ID %d, monitor %d, Macro type %#x\n",
   mc->main_id, mc->len, ins_id, data_id, m_flag, c_id);
 p = p + n;
 obs_id = mc->parameters.obs_id;
 q = genFunc_string(obs_id);
 q2 =wave_id_string(mc->parameters.wave);
 woff = (int) mc->parameters.wave_off;
 /* the offset wavelength is actually a signed quantity */
 if (woff & (short) 0x0400) woff = woff | (short) 0xf800;
 /* must also multiply by 4 */
 woff = 4 * woff;
 n = sprintf(p, "Obs ID %d, gen ID %d (%s), FID %d, %s offset %d\n",
   obs_id, obs2genFunc[obs_id], q, mc->parameters.frame_def_id, q2, woff);
 free(q);   /* or suffer a leak */
 free(q2);  /* or suffer a leak */
 p = p + n;
 n = sprintf(p, "exp time = %dms, dark flag %d, wscan: npos = %d, step = %d\n",
    mc->parameters.exp, mc->parameters.dark_flag, mc->parameters.wscan_npos,
    mc->parameters.wscan_step);
 p = p + n;
 q = compress_string(mc);
 n = sprintf(p, "%s", q);
 free(q);   /* or suffer a leak */ 
 return s;
 }
 /*--------------------------------------------------------------------------*/
int data_update()
 {
 static float	rate;
 static	int	last_type, first_sp_flag = 1;
 static	char *flags[] = {"     M","     S","     E","     U"};
 static	char *flags2 = "MSEU";
 char	*flagmain, *flagsub, *p, *q, *q2;
 int	psize, ndata, cmain, csub, frame_start_flag;
 int	ix2, iy, dy, ix1, ix3, n;
 int	fg_flag, sp_flag, memdump_flag, ct_flag, diag_flag, xrt_flag;
 int	serial_gap_flag = 0, gapsize;
 char	text[256], text2[32], *mctext = NULL;
 double	dt;
 short commandedSlitPosition;
 double sbtime_pkt;
 /* we expect psize = size of packet, packdata1 = address of data in packet */
 /* zero all type flags */
 fg_flag = sp_flag = memdump_flag = ct_flag = diag_flag = xrt_flag = 0;
 /* 11/17/2004 - we have a choice now */
 /* 1/10/2007 - only SDTP now */
 //if (sdtp_flag) psize = get_sdtp_packet(); else psize = get_data_packet();
 psize = get_sdtp_packet();
 /* for stdp, a psizeCompressed is also available */
 if ( psize <= 0 ) return 1;
 nbytes += psize; /* used for rate and gets zeroed after each rate shown*/
 totalbytes += (long long) psize;  /* accumulates forever */
 ndata = psize - pheadsize;
 //sprintf(text, "%5d", packet_cnt);
 sprintf(text, "%5d", ph.pheader.info.serial_no);
 packet_cnt++;
 /* 6/28/2001 - handle more diverse sets of packets */
 switch (datatype) {
   case DATATYPE0:
   case DATATYPE1: fg_flag = 1; numFG++;
    if (showMC) {
       byte *pb = &ph.pheader.data.macro_copy[1], *plast = (byte *)&currentFGmacroCommand;
       int nb = 40;
       printf("MC: ");  while (nb--)  printf("%3x", *pb++);
       /* also check with last and note if this is a change */
       pb = &ph.pheader.data.macro_copy[1];
       nb = 40;  while (nb--) { if ( *pb++ != *plast++) { printf("CHANGED\n"); break; }}
       if (nb <=0) printf("\n"); }
    /* copy the macro command */
    bcopy( (char *) &ph.pheader.data.macro_copy[1], (char *) &currentFGmacroCommand, 40);
#if linux | LITTLEENDIAN
    fg_macro_command_fix( (fg_macro_command *) &currentFGmacroCommand);
#endif
    /* always get the image center from macro command, though we may want
    to get CCD cutout from housekeeping when we have real housekeeping */
    if (fg_get_ccd_center(&currentFGmacroCommand)) { printf("FG center error\n"); return 0;}
    break;
   case DATATYPE2:
   case DATATYPE3: sp_flag = 1; numSP++;
    /* copy the macro command */
    bcopy( (char *) &ph.pheader.data.macro_copy[1], (char *) &currentSPmacroCommand, 40);
#if linux | LITTLEENDIAN
    sp_macro_command_fix( (sp_macro_command *) &currentSPmacroCommand);
#endif
    if (sp_get_ccd_center(&currentSPmacroCommand)) { printf("SP center error\n");  return 0;}
    
    break;
   case DATAMEMDUMP:     memdump_flag = 1; numMEM++; break;
   /* note that the header "data" area is different (and longer) for the CT type
   packets, we can use the info structures though via pheader but later we
   have to use ctheader */
   case DATACTREF:       ct_flag = 1; numCTref++; break;
   case DATACTLIVE:      ct_flag = 2; numCTlive++; break;
   case DATADIAGNOSTIC2:
   case DATADIAGNOSTIC:
   	diag_flag = 1;
	if (ph.pheader.info.subIdProduct == DPC_ANALOG_DUMP) numCHAN++;
		else
	if (ph.pheader.info.subIdProduct == DPC_FG_ENGG_FR) {
	  numISCAN++;
	  /* iscan's are really FG data products, copy the macro command */
	  bcopy( (char *) &ph.isheader.data.macro_copy[1], (char *) &currentFGmacroCommand, 40);
#if linux | LITTLEENDIAN
          fg_macro_command_fix( (fg_macro_command *) &currentFGmacroCommand);
#endif
          if (fg_get_ccd_center(&currentFGmacroCommand)) { printf("FG center error\n"); return 0;}
	}
		else numDIAG++;
	
	break;
   case DATATYPEXRT:
   case DATATYPEXRT2:
     xrt_flag = 1; numXRT++;
     /* we don't do a XRT center calculation for each packet */
     break;
   default: printf("bad packet type passed to data_update = %d, %x\n", datatype, datatype);
     break;
 }
 if (xrt_flag) {
   head_flag = 0;
    /* also check the XRT serial number here */
   if ((ph.pheader.info.serial_no - XRTcurrentSerial) != 1) {
    if (XRTcurrentSerial != -1) {  /* if beginning, ignore */
      serial_gap_flag = 1;  gapsize = ph.pheader.info.serial_no - XRTcurrentSerial - 1;
      /* sometimes we get a mixup so don't count really outrageous gapsizes */
      if (ABS(gapsize) < 5) XRTgap_count += gapsize;  } }
   XRTcurrentSerial = ph.pheader.info.serial_no;
 } else {
   head_flag =  (int) ph.pheader.info.subIdHdr;
   if (head_flag == 1) head_flag = 0; else head_flag = 1;
   /* check the FPP serial number here */
   /* check serial number for a gap, 4/26/2005 - change to ensure we don't miss
   a backwards gap */
   if ((ph.pheader.info.serial_no - currentSerial) != 1) {
    if (currentSerial != -1) {  /* if beginning, ignore */
      serial_gap_flag = 1;  gapsize = ph.pheader.info.serial_no - currentSerial - 1;
      /* sometimes we get a mixup so don't count really outrageous gapsizes */
      if (ABS(gapsize) < 5) gap_count += gapsize;  } }
   currentSerial = ph.pheader.info.serial_no;
 }
 /* a frame start whenever we see a U or S in the packet sub seq */
 frame_start_flag = (ph.pheader.info.sub_seq_flag%2 == 1);

 /* display always does a list also */
 if (list_flag || display_flag || format_flag) {
  /* list some things about each packet */
  char	c1, c2;
  int	ixp0, ixp1, iyp0, iyp1;
  /* first a gap warning if any */
  if (serial_gap_flag) {
    if (xrt_flag) printf("**** serial number gap for XRT of %d *******\n", gapsize);
    else printf("**** serial number gap for FPP of %d *******\n", gapsize);
  }
  //printf("APID: 0x%x, Packet sequence #: %d\n", apid, scount);
  //if (head_flag) n = sprintf(text, "\nH%6d %7d", psize, packet_cnt);
  //printf("head_flag, datatype, serial # %d %d %d\n", head_flag, datatype,ph.pheader.info.serial_no);
  if (head_flag) n = sprintf(text, "\nH %7d", packet_cnt);
    else n = sprintf(text, "%9d", packet_cnt);
  p = text + n;
  switch (datatype) {
   case DATATYPE0:
    n = sprintf(p, " FG0");
    break;
   case DATATYPE1:
    n = sprintf(p, " FG1");
    break;
   case DATATYPE2:
    n = sprintf(p, " SP0");
    break;
   case DATATYPE3:
    n = sprintf(p, " SP1");
    break;
   case DATAMEMDUMP:
    n = sprintf(p, " MD ");
    break;
   case DATACTREF:
    n = sprintf(p, " CR ");
    break;
   case DATACTLIVE:
    n = sprintf(p, " CL ");
    break;
   case DATADIAGNOSTIC:
    if (ph.pheader.info.subIdProduct == DPC_ANALOG_DUMP) 
      n = sprintf(p, " AC ");
    else if (ph.pheader.info.subIdProduct == DPC_FG_ENGG_FR) 
      n = sprintf(p, " ISC");
    else
      n = sprintf(p, " DD ");
    break;
   case DATADIAGNOSTIC2:
    n = sprintf(p, " D2 ");
    break;
   case DATATYPEXRT:
    n = sprintf(p, " XRT");
    break;
   case DATATYPEXRT2:
    n = sprintf(p, " XR2");
    break;
   default:
    n = sprintf(p, " UNK");
    break;
    }
  /* add the serial # */
  p = p + n;
  n = sprintf(p, "%7d", ph.pheader.info.serial_no);
  p = p + n;

  /* tack on the main and sub flags and counts */
  c1 = flags2[ph.pheader.info.main_seq_flag];
  c2 = flags2[ph.pheader.info.sub_seq_flag];
  /* note that c2 is used later to test for a frame pause */
  n = sprintf(p, " %c %5d/%-5.1d %c %3d/%-3.1d",
  	c1, ph.pheader.info.main_seq_count, ph.pheader.info.num_frames,
 	c2, ph.pheader.info.sub_seq_count, ph.pheader.info.num_packets);
  p = p + n;  
  /* look at sub-ID, if a header, show some items common for the frames */
  
  if (head_flag) {
    /* header case */
    n = sprintf(p, " %4dx%-4.1d", ph.pheader.info.nx, ph.pheader.info.ny);
    /* for the header, show the Obs ID and Frame ID */
    p = p + n;

    if (fg_flag) {
      /* set up pointer to FG info block, some old data sets don't have this
      so be careful, use a fake one */
      if (psize > (sizeof(HKstatusData) + 100)) {
	char *p;
	/* we copy the whole packet to keep the header around */
	bcopy((char *) packdata1, (char *) FGheaderpackdata1, psize);
	/* 1/10/2007 - use FGheaderSize for this, we were resetting FGextensionSize */
	FGheaderSize = psize;
#if linux | LITTLEENDIAN
        FGinfo_fix((FGinfo *) (FGheaderpackdata1 + sizeof(HKstatusData) ) );
#endif
	FGinfoHdr = (FGinfo *) (FGheaderpackdata1 + sizeof(HKstatusData));
	/* load the calendar time */
// 	if (sdtp_flag) {
// 	  FGtime = timeRef + ((FPPccsdsti >> 5) & 0x07ffffff);
// printf("FGtime is: %d, ccsdsti: %d (old timeRef method)\n", FGtime, FPPccsdsti);
//           /* ISAS time method (use in production) */
// printf("sb_time_0: %lf\n", sb_time_0);
//           sbtime_pkt = SB_Time_Convert(FPPccsdsti, sb_time_0);/* +946684800.0;*/
//           sbtime_pkt = SB2UT(sbtime_pkt); /* sbtime_pkt is now UTC */
//           FGtime = sbtime_pkt;
// printf("FGtime is: %d, ccsdsti: %d (new SB_time method)\n", FGtime, FPPccsdsti);
// printf("sb_time_0: %lf\n", sb_time_0);
// 	} else {
// 	  FGtime = ((FGinfoHdr->MDPclock) >> 9 ) & 0x007fffff;
// 	  FGtime = FGtime | ( (unsigned int) (FGinfoHdr->MDPclockHigh) << 23);
// 	  /* note that FGtime is a 32 bit int and top bit should always be clear */
// 	  timeRefCheck(&FGtime);
// 	}
      } else {
        FGinfoHdr = &fakeFGinfoHdr;
        printf("no FGinfoHdr, beware\n");
      }
      if (DPC_FG_RAW == ph.pheader.info.subIdProduct) {
        n = sprintf(p, "FG raw"); p = p + n;
      } else {
	/* get a little table of the macro command parameters, we will print
	it later (and free it) */
	mctext = showFGmacro(&currentFGmacroCommand, (unsigned char) *ph.pheader.data.macro_copy);
	/* these are for FG case */
	q = genFunc_string(currentFGmacroCommand.parameters.obs_id);
	q2 =wave_id_string(currentFGmacroCommand.parameters.wave);
	n = sprintf(p, " %s, FID = %d, %s",
	    q,
    	    currentFGmacroCommand.parameters.frame_def_id,
	    q2);
	free(q);   /* or suffer a leak */
	free(q2);  /* or suffer a leak */
	p = p + n;
	/* get CCD cutout */
	n = sprintf(p," CCD (%d:%d, %d:%d), (%d,%d)",fg_p.ix0,fg_p.ix1,fg_p.iy0,fg_p.iy1,FGCCDixc,FGCCDiyc);
	p = p + n;
      }
    } else if (sp_flag) {
       /* SP case */
       /* set up pointer to SP info block, also used later for HK call */
      if (psize > (sizeof(HKstatusData) + 100)) {
	char *p;
	/* we copy the whole packet to keep the header around */
	bcopy((char *) packdata1, (char *) SPheaderpackdata1, psize);
	/* 1/10/2007 - see note about FGheaderSize */
	SPheaderSize = psize;
#if linux | LITTLEENDIAN
        SPinfo_fix((SPinfo *) (SPheaderpackdata1 + sizeof(HKstatusData) ) );
#endif
	SPinfoHdr = (SPinfo *) (SPheaderpackdata1 + sizeof(HKstatusData));
	/* load the calendar time */
	/* 11/20/2004 - differently for sdtp data from Japan tests */
// 	if (sdtp_flag) {
// 	  SPtime = timeRef + ((FPPccsdsti >> 5) & 0x07ffffff);
// printf("SPtime is: %d, ccsdsti: %d (old timeRef method)\n", SPtime, FPPccsdsti);
//           /* ISAS time method (use in production) */
//           sbtime_pkt = SB_Time_Convert(FPPccsdsti, sb_time_0);/* +946684800.0;*/
//           sbtime_pkt = SB2UT(sbtime_pkt); /* sbtime_pkt is now UTC */
//           SPtime = sbtime_pkt;
// printf("SPtime is: %d, ccsdsti: %d (new SB_time method)\n", SPtime, FPPccsdsti);
// 	} else {
// 	  SPtime = ((SPinfoHdr->MDPclock) >> 9 ) & 0x007fffff;
// 	  SPtime = SPtime | ( (unsigned int) (SPinfoHdr->MDPclockHigh) << 23);
// 	  timeRefCheck(&SPtime);
// 	}
	sp_get_spec_offset(SPinfoHdr);
	/* also get commanded slit position from first PMU cycle, only works
	if we have PMU cycles of course */
	if (SPinfoHdr->n > 0) {
	  short *p;
	  p = ( (short *) SPinfoHdr + sizeof(SPinfo));
          commandedSlitPosition = p[8];
	} else {
	  /* if no PMU cycles, take the other value */
          commandedSlitPosition = SPinfoHdr->slitPosition;
	}
      } else {
        SPinfoHdr = &fakeSPinfoHdr;
        printf("no SPinfoHdr, beware!\n");
	sp_iy0 = 0;
      }
      /* don't want this for raw packets */
      if (DPC_SP_RAW == ph.pheader.info.subIdProduct) {
	n = sprintf(p, "SP raw"); p = p + n;
      } else {

	 /* get a little table of the macro command parameters, we will print
	 it later (and free it) but only if this is the first H packet for a set
	 or the first SP packet we see */
	 if ((ph.pheader.info.main_seq_count == 0 && ph.pheader.info.sub_seq_count == 0)
     		    || first_sp_flag )
	   {
	   mctext = showSPmacro(&currentSPmacroCommand,
               (unsigned char) *ph.pheader.data.macro_copy);
	    first_sp_flag = 0;
	    }
	 n = sprintf(p, "x%d slit %d, %d cycles, repeat ",
     	    currentSPmacroCommand.parameters.slit_positions, SPinfoHdr->slitPosition,
     	    currentSPmacroCommand.parameters.cycles+1);
	 p = p + n;
	 if (currentSPmacroCommand.parameters.repeat_flag) n = sprintf(p, " ON");
     	    else n = sprintf(p, "OFF"); 
	 p = p + n;
	 /* get CCD cutout */
	 n = sprintf(p, " CCD (%d:%d, %d:%d)", sp_ix0,sp_ix1,sp_iy0,sp_iy1);
	 p = p + n;

       }
     }
   
   } else {
   if (sp_flag || fg_flag || ct_flag || diag_flag) {
     /* not a header, so get packet cutout info and product ID */
    if (ph.pheader.info.subIdProduct != DPC_ANALOG_DUMP) {
      n = sprintf(p, " %4dx%-4.1d", ph.pheader.info.nxp, ph.pheader.info.nyp);
      p = p + n;
    }

    if (sp_flag || fg_flag) {
    n = sprintf(p, " (%4d,%4d)", ph.pheader.info.x0, ph.pheader.info.y0);
    p = p + n;
    q = product_string( (int) ph.pheader.info.subIdProduct);
    n = sprintf(p, " %s", q);
    free(q);  /* or suffer a leak */
    p = p + n;


/* 7/24/2005 - not sure if the swapb below is needed, check with Ankur */
#if linux | LITTLEENDIAN
    /* added to swap bytes of image data for correct display purposes */
/* remove this block after everything works
    if (!sdtp_flag)
    {
      swapb((char *)packdata1,psize);
    }
   no display, no gui, and wrfits does not swap */
#endif

    /* check which compression set we used, sp and fg are different structures
    so we need to branch on which one we have (again)  */     
     
    if (fg_flag) {
     /* need to know if there was any summing or binning, and
     expand the packet sizes if there was */
     int fac;
     fac = 1 << (fg_p.sumx + fg_p.binx);
     ixp0 = fg_p.ix0 + fac * ph.pheader.info.x0;
     ixp1 = ixp0 + fac * ph.pheader.info.nxp - 1;
     iyp0 = fg_p.iy0 + fac * ph.pheader.info.y0;
     iyp1 = iyp0 + fac * ph.pheader.info.nyp - 1;
     fg_comp_choice = get_comp_choice(&currentFGmacroCommand, (PacketHeader *) &ph);
     n = sprintf(p, " CCD (%d:%d, %d:%d) seg %d, C%d", ixp0, ixp1, iyp0, iyp1,
     		ph.pheader.info.subIdCCDseg, fg_comp_choice);
     p = p + n;
    } else {
     /* SP case */
     ixp0 = sp_ix0+ph.pheader.info.x0;
     ixp1 = ixp0 + ph.pheader.info.nxp - 1;
     iyp0 = sp_iy0+ph.pheader.info.y0;
     iyp1 = iyp0 + ph.pheader.info.nyp - 1;
     /* check for illegal cutout */
     //printf("ixp0, ixp1, iyp0, iyp1 = %d %d %d %d\n", ixp0, ixp1, iyp0, iyp1);
     sp_comp_choice = get_comp_choice((fg_macro_command *) &currentSPmacroCommand, (PacketHeader *) &ph);
     n = sprintf(p, " CCD (%d:%d, %d:%d) seg %d, C%d", ixp0, ixp1, iyp0, iyp1,
     ph.pheader.info.subIdCCDseg, sp_comp_choice);
     p = p + n;
    }
   }

  if (diag_flag) {
    if (ph.pheader.info.subIdProduct == DPC_ANALOG_DUMP) {
       /* get the channel count */
       int i, nc;
       UINT16	*ps;
       //hexdump( (char *) &ph.acheader.data.packet_time, 64);
       nc = ph.acheader.data.nchan;
       ps = &ph.acheader.data.devices[0];
       n = sprintf(p, " %d channels, %d ticks, %d times, [", nc,
         ph.acheader.data.nticks, ph.acheader.data.ntimes);
       p = p + n;
       for (i=0;i<nc;i++) {
         n = sprintf(p, "%4d", *ps++); p = p + n;
       }
       n = sprintf(p, "]");
    } else
    if (ph.pheader.info.subIdProduct == DPC_FG_ENGG_FR) {
       int	nwave, nw, obsId;
       nwave = ph.isheader.data.nwave;
       nw = ph.isheader.info.ny;
       n = sprintf(p, " %d wavelengths or %d", nwave, nw);
       p = p + n;
       /* an iscan packet */
       mctext = showFGmacro(&currentFGmacroCommand, (unsigned char) *ph.isheader.data.macro_copy);
       obsId = currentFGmacroCommand.parameters.obs_id;
       /* really want gen function # so use obs2genFunc */
       showIscanInfo(&ph.isheader, packdata1, mctext, obs2genFunc[obsId]);
    } else {
       n = sprintf(p, " jitter mode"); }
       p = p + n;
   }
 
  if (ct_flag) {
    n = sprintf(p, "fc:%5d e:%#x,%d,%d s:",
     ph.ctheader.data.CTFrmNum, ph.ctheader.data.CTstatus, ph.ctheader.data.LiveErrX,
     ph.ctheader.data.LiveErrY);
    p = p + n;
    { int i =13; unsigned short *psum = ph.ctheader.data.sums;
      while (i--) { n = sprintf(p, " %d", *psum++); p = p + n; }
    }
  }
  } else if (xrt_flag) {
     ixp0 = ph.xrtheader.info.x0;
     ixp1 = ph.xrtheader.info.x0 + ph.xrtheader.info.nxp - 1;
     iyp0 = ph.xrtheader.info.y0;
     iyp1 = ph.xrtheader.info.y0 + ph.xrtheader.info.nyp - 1;
     n = sprintf(p, " image %4dx%-4.1d", ph.xrtheader.info.nx, ph.xrtheader.info.ny);
     p = p + n;
     n = sprintf(p, " (%d:%d, %d:%d) ctype %d", ixp0, ixp1, iyp0, iyp1, comptype);
     p = p + n;
     n = sprintf(p, "\n   ID %d, FWs %d %d, einx %d", ph.xrtheader.data.ec_id, ph.xrtheader.data.ec_fw1,
     	ph.xrtheader.data.ec_fw2, ph.xrtheader.data.ec_eindex);
     p = p + n;
     {
       unsigned int em = (unsigned int) ph.xrtheader.data.e_exptime_m[0]*256 + (unsigned int) ph.xrtheader.data.e_exptime_m[1];
       n = sprintf(p, " exp m/e %d %d, FW pos %d %d mode %d dark %d", em, ph.xrtheader.data.e_exptime_e,
     	  ph.xrtheader.data.e_fw1_pos, ph.xrtheader.data.e_fw2_pos, ph.xrtheader.data.ec_cd_mode,
	  ph.xrtheader.data.ec_imtype);
       p = p + n;
     }
     n = sprintf(p, " cal %d, sum %d h v %d %d, sizes %#x %#x", ph.xrtheader.data.xrte_cal_info,
       ph.xrtheader.data.xrte_chip_sum, ph.xrtheader.data.xrte_roi_h_sta_pos,
       ph.xrtheader.data.xrte_roi_h_sta_pos, ph.xrtheader.data.xrte_roi_h_size,
       ph.xrtheader.data.xrte_roi_v_size);
     p = p + n;
     n = sprintf(p, " port %d, temp %d", ph.xrtheader.data.xrte_ccd_read_port,
       ph.xrtheader.data.xrte_ccd_temp);
     p = p + n;
    }
 }
  /* check for subIdSumMode (only if not XRT) */
  if (!xrt_flag) {
    n = sprintf(p, " sum:%d", ph.pheader.info.subIdSumMode);
    p = p + n;
  }
  printf("%s\n", text);
  if (mctext) { printf("%s\n", mctext);  }
  /* need to know if this is the last packet of a frame for several reasons */
  if (c2 == 'U' || c2 == 'E')  {
   /* if we are frame stepping, set pause */
   if (frame_pause_state) {  pause_state = 1; frame_trip_flag = 1;}
   /* if we are formatting we need to know about the end, set a flag here
   to indicate that we found the end of this one */
   frame_end = 1;
  }
 /* if a header packet (or HK packet), check for HK dumps */
  if (head_flag) {
    /* dump the status block if requested */
    if (status_buf_dump_flag) {
       /* some very old data don't have a real HK section, to avoid crashes
       point to a fake one */
       if (psize > sizeof(HKstatusData) ) { 
         hkStat = (HKstatusData *) packdata1;
       } else {
         hkStat = &fakeHKstatusData;
	 printf("no real HKstatusData, beware!\n");
       }
       {
       printf("status 1 dump:\n");
       n = STATUS1_SIZE;  hexdump( &hkStat->status1[0], n);
       printf("status 2 dump:\n");
       n = STATUS2_SIZE;  hexdump( &hkStat->status2[0], n);
       printf("status 3 dump:\n");
       n = STATUS3_SIZE;  hexdump( &hkStat->status3[0], n); }}
    if (data_product_dump_flag) {
       /* note that these will check if gui_flag is on */
       //printf("psize = %d\n", psize);
       if (sp_flag) {
         /* we suppressed the mctext for all but the first of a slit scan, but
	 here we want it, so gen mctext if it is null */
	 if (mctext == NULL) mctext = showSPmacro(&currentSPmacroCommand,
               (unsigned char) *ph.pheader.data.macro_copy);
	 showSPimageInfo(SPinfoHdr, mctext);
       }
       if (fg_flag) { showFGimageInfo(FGinfoHdr, mctext); }
    }
  }
  if (mctext) {   free(mctext); }
  
  /* we may also be dumping channel data from diagnostic packets, check here */
  /* note that the iscan case was handled earlier */
  if (diag_flag) {
   if (chan_show_flag && ph.pheader.info.subIdProduct == DPC_ANALOG_DUMP) {
    int i, j, nc, nt, nb;
    unsigned int ct;
    UINT16	*ps, val[16];
    char *pc;
    nc = ph.acheader.data.nchan;
    ps = &ph.acheader.data.devices[0];
    nt = ph.acheader.data.ntimes;
    printf("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
    printf("CT cnt/channel   ");
    for (i=0;i<nc;i++)  printf("%7d", ps[i]);
    printf("\n");
    pc = (char *) packdata1;
    nb = nc * 2;
    /* now all the times for a table */
    /* actually cut off at 200 */
    nt = MINOF(nt, 200);
    for (i=0;i<nt;i++)  {
      bcopy(pc, &ct, 4);  /* because these aren't necessarily I*4 aligned */
/* 7/24/2005 - swap's from Ankur's version */
#if linux | LITTLEENDIAN
      swapl((char *) &ct, 1);
#endif
      pc += 4;
      bcopy(pc, (char *) val, nb);
      pc += nb;
      printf("%10u       ", ct);
      for (j=0;j<nc;j++) 
      {
#if linux | LITTLEENDIAN
        swapb((char *) &val[j], 2);
#endif
        printf("%7d", val[j]);
      }
      printf("\n");
    }  
    printf("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
  }
 }

 } /* end of list option */

 /* formatting an output file ? */
 if (format_flag) {
  /* 9/24/2003 - the latest SP images (LHS and RHS) may already be setup by drawSPbox
  so be sure to check for reformat after the display option */
  reformat();
 }

  return 0;
 }
 /*------------------------------------------------------------------------- */
int format_setup(name)
 char *name;
 {
 char *p1, *p2, *p3;
 int	mq, mode, stat;
 extern void setPacketFileTime(char *p1, char *p2);
 if (socket_flag) {
    printf("re-formatting not supported for sockets\n");
    exit(0);   }
 /* remove any leading paths from the input file name */
 if (!file_flag) return;  /* no file open */
 /* for the sci files used during EGSE testing, we had one file per day and
 it was named for the UT day. For sdtp files, the name is the time the file was
 made and always closely related to the time the data was taken. Hence we can't
 use the file name in the sdtp case and the date parts of the path are re-done
 for every file (the only safe way). Hence most of the dir_name construction
 is bypassed here. It is just set to reformatPath */
 p2 = strrchr(name, '/');
 if (p2) { p2++; mq = strlen(p2); } else { mq = strlen(name);  p2 = name; }
 p3 = (char *) malloc(mq+1);
 if (mq > 0)  bcopy( p2, p3, mq );
 *(p3 + mq) = 0;
 printf("stripped file name: %s\n", p3);
 /* we want to save p3 for a keyword, so copy into a fixed place */
 if (mq > 255) mq = 255; bcopy(p2, sourceFile, mq);

 /* only SDTP now */
//  if (sdtp_flag) {
   sprintf(dir_name, "%s", reformatPath);
   sprintf(dir_name_XRT, "%s", reformatPathXRT);
   sprintf(packetpath, "");  /* nothing, gets hour put in later */
//  } else {
//    /* continue with p3 from above */
//    /* if this is a standard egse file we expect a form like
//    20020220_233507tf2.raw
//    */
//    p1 = strtok( p3, "_");
//    printf("part 1: %s\n", p1);
//    /* allow for the new sci files which have a different scheme */
//    if (strncmp(p1, "fpp", 3) == 0) {
//      p1 = strtok( NULL, "_");
//      p2 = strtok( NULL, ".");
//    } else {
//      p2 = strtok( NULL, "t");
//    }
//    printf("part 1: %s\n", p1);
//    printf("part 2: %s\n", p2);
//    /* p1 has YYYYMMDD and p2 has HHMMSS */
//    /* get the year/month and all to make a calendar time */
//    setPacketFileTime(p1, p2);
//    /* make more components for easier selection, save the packet name
//    portion separately, want to use it while times are still uncertain but
//    plan to drop it eventually */
//    sprintf(dir_name, "%s/%4.4s/%2.2s/%2.2s/",
//  	  reformatPath, p1, p1+4, p1+6);
//    /* 1/31/2004 - use just the hour part for packet path, this can cause some
//    problems for older data w/o correct times */
//    //sprintf(packetpath, "/%2.2s/", p2);
//    /* revert to the time part of the sci file and just use one for each
//    sci file. The hour scheme above also just used the same hour for everything
//    which was unintended and wrong. Also put an fpp_ in front of it to make
//    sure the user understands it is from the sci file */
// 
//    //sprintf(packetpath, "/fpp_%8.8s_%6.6s/", p1, p2);
//    /* Ted suggested a shorter scheme */
//    sprintf(packetpath, "/H%4.4s/", p2);
//    free(p3);
 //}
 /* remove any double slashes, they look untidy */
 extraSlashRemove(dir_name);
 stat = mkdirpath(dir_name);
 extraSlashRemove(dir_name_XRT);
 stat = mkdirpath(dir_name_XRT);
 ready_for_new_fits = 1;
 /* also initialize the FITS keyword lists, we have 4 so far */
 CTfitsKeys = newKeyList();
 FGfitsKeys = newKeyList();
 XRTfitsKeys = newKeyList();
 SPfitsKeys = newKeyList();
 return 0;
 }
 /*------------------------------------------------------------------------- */
int CTreformat(int rftype)
 {
 /* this gets CT images (live and ref), CT jitter (2 types), analog
 channel data (AC), and I scan data (ISC) which has 2 types) */
 int	nx, ny, nkeys, lcc, mm, nn, i, nc, dtype;
 char	hexsums[100], *pstr;
 char	*name_out, *tmpdata;
 unsigned char *pout, MDPclockHigh;
 extern char *CTname(int rftype, unsigned int time, char *dir_name,
 	char *packetpath, int subId, unsigned char MDPclockHigh);
 short	*ps, *p;
 FITSkey *nextKey;
 static	short	ctimage[50*50];
 char *kw_str;
 MDP0x428 hk0x428;

 /* get latest MDP HK data */
 get_mdp_hk(&hk0x428);
 
 nx = ph.pheader.info.nx;	ny = ph.pheader.info.ny;
 //printf("rftype, nx, ny = %d, %d, %d\n", rftype, nx, ny);
 clearKeyList(CTfitsKeys);
 nextKey = CTfitsKeys;
 //printf("CTfitsKeys: %#x, nextKey: %#x\n", CTfitsKeys, nextKey);
 nextKey = code_key_s("TELESCOP", "SOLAR-B", nextKey);
 nextKey = code_key_s("INSTRUME", "SOT/CT", nextKey);
 nextKey = code_key_u("MDP_CLK", ph.pheader.data.packet_time, nextKey);
 nextKey = code_key_s("FILEORIG", sourceFile, nextKey);
 
 /* different types of data have different keywords here */
 switch (ph.pheader.info.subIdProduct) {
    case DPC_ANALOG_DUMP:
     /* these are analog channel dumps */
     dtype = 1;
     MDPclockHigh = ph.acheader.data.MDPclockHigh;
     nc = ph.acheader.data.nchan;  ny = ph.acheader.data.ntimes;
     if (nc > 16) { printf("illegal channel count for AC data = %d\n", nc);
     			return 1; }
     /* we have some special and important keys for the analog dumps that
     let us relate CT counter to MDP time, these were intended to be for
     the first sample but turned out to be the last (a flight s/w goof)  */
     nextKey = code_key_i("MDPLAST", ph.acheader.data.start_time, nextKey);
     nextKey = code_key_i("CTLAST", ph.acheader.data.startCTcounter, nextKey);
     nextKey = code_key_i("MDPHIGH", MDPclockHigh, nextKey);
     /* this was corrected 1/26/2006, so data taken after that has the intended
     first sample times, note that MDPclockHigh can be a problem since it is
     loaded when the packet is sent so it could have a bit rollover */
     nextKey = code_key_i("MDPFIRST", ph.acheader.data.start_time, nextKey);
     nextKey = code_key_i("CTFIRST", ph.acheader.data.startCTcounter, nextKey);


     nextKey = code_key_i("AC NCHAN", nc, nextKey);
     nextKey = code_key_i("AC NTIME", ny, nextKey);
     nextKey = code_key_i("AC DTICK", ph.acheader.data.nticks, nextKey);
     /* and a key for each device in the table, the # is variable */
     {
       int  i, j, ncdes, ichanin, mchan, achan;
       char text[16], text2[80], *sq;
       for (i=0; i<nc;i++) {
	 ichanin = ph.acheader.data.devices[i];
         printf("AC CH%02d", i);
         sprintf(text, "AC CH%02d", i);
	 /* more complicated than I originally thought, the first 74 are
	 mechanism reads, after that the analog channel reads */
	 if (73 >= ichanin) {
	   /* get the mechanism channel for this ichanin */
	   mchan = mechdescs[ichanin].n;
	   sq = mechdescs[ichanin].s;
	   snprintf(text2, 70, "%d, mech %#x00, %s", ichanin, mchan, sq);
	 } else if (159 >= ichanin) {
	   /* get the analog channel for this ichanin */
	   achan = acchandescs[ichanin - 74].n;
	   sq = acchandescs[ichanin - 74].s;
	   snprintf(text2, 70, "%d, analog %#x, %s", ichanin, achan, sq);
	 } else {
	   switch (ichanin - 159) {
             case 1: sq = "IfcStatusAnalog1";  break;
             case 2: sq = "IfcStatusAnalog2";  break;
             case 3: sq = "getAnalogdt";  break;
             case 4: sq = "getAnalogCnt";  break;
             case 5: sq = "nreads";  break;

	     default: sq = "something else"; break;
	   }
	   snprintf(text2, 70, "%d, memory, %s", ichanin, sq);
	   
	 }
	 nextKey = code_key_s(text, text2, nextKey);
       }
     }
     nextKey = code_key_i("SUB_ID", ph.pheader.info.subIdProduct, nextKey);
     /* also give these a PRODUCT and an OBS_TYPE (but not an OBS_ID) */
     { char *q1 = product_string(ph.pheader.info.subIdProduct);
       /* 6/3/2005 - remove PRODUCT as a keyword */
       //nextKey = code_key_s("PRODUCT", q1, nextKey);
       nextKey = code_key_s("OBS_TYPE", q1, nextKey);
       free(q1); }
     break;
    case DPC_FG_ENGG_FR:
     /* these are I scans, we need to decode the macro command copy, it
     was put in currentFGmacroCommand, these i scans are really FG observations
     so we have a lot of FG parameters to load in keywords, also can't
     be in the middle of another FG */
     if (fg_in_progress) {
       printf("new FG, closing the last one\n");
       if ( FGclose() ) printf("problem closing FG file"); }
     /* we don't need to set fg_in_progress because this is a single
     packet product */
     dtype = 2;
     /* note that the isheader.info members are the same as pheader.info 
     but not the .data members, all packets have the same info structure.
     Also, the macro copy part of the data part is the same for image and laser
     tune headers, they differ after that however */
     MDPclockHigh = ph.isheader.data.MDPclockHigh;
     //nextKey = FGimageParams(nextKey);  /* this will set some FG keywords */
     nextKey = code_key_s("INSTRUME", "SOT/NB", nextKey);
     /* MACROID, from the MDP */
     nextKey = code_key_i("MACROID", ph.pheader.info.id, nextKey);
     //nextKey = code_key_i("MAINID", ph.pheader.info.id, nextKey);
     nextKey = code_key_i("SUB_ID", ph.pheader.info.subIdProduct, nextKey);
     nextKey = code_key_i("OBS_ID", currentFGmacroCommand.parameters.obs_id, nextKey);
     { char *q1 = genFunc_string(currentFGmacroCommand.parameters.obs_id);
       nextKey = code_key_s("OBS_TYPE", q1, nextKey);
       free(q1); }
     nextKey = code_key_i("WAVEID", fg_p.wave, nextKey);
     nextKey = code_key_g("EXPTIME",
       ((float) currentFGmacroCommand.parameters.exp)*1.024E-3, nextKey);
     { char *q1 = wave_id_string(fg_p.wave);
       nextKey = code_key_s("WAVE", q1, nextKey);
       free(q1); }
     /* 7/20/2004 - change product keyword */
     /* 6/3/2005 - remove product keyword */
//      switch (currentFGmacroCommand.parameters.obs_id) {
//        case FGintegratedWaveScan:
// 	 nextKey = code_key_s("PRODUCT", "FG integrated intensity scan", nextKey);
// 	 break;
//        case FGintegratedWaveScanUpdate:
// 	 nextKey = code_key_s("PRODUCT", "FG integrated intensity scan with line update", nextKey);
// 	 break;
//        case FGlaserTune:
// 	 nextKey = code_key_s("PRODUCT", "FG Laser Scan", nextKey);
// 	 break;
//      }
     break;
    default: 
     dtype = 1;
     MDPclockHigh = ph.ctheader.data.MDPclockHigh;
     nextKey = code_key_g("XCEN", get_xhelio(), nextKey);
     nextKey = code_key_g("YCEN", get_yhelio(), nextKey);
 if (dkw) nextKey = code_key_x("UFSS_AB", hk0x428.byte211, nextKey);
     nextKey = code_key_g("XSCALE", 0.22, nextKey);
     nextKey = code_key_g("YSCALE", 0.22, nextKey);
     nextKey = code_key_i("CT_REFF", ph.ctheader.data.RefFrmCnt, nextKey);
     nextKey = code_key_i("CT_FRAME", ph.ctheader.data.CTFrmNum, nextKey);
     nextKey = code_key_i("CT_FWRT", ph.ctheader.data.CTfn_write, nextKey);
     nextKey = code_key_i("CT_MODE", ph.ctheader.data.CTmode, nextKey);
     nextKey = code_key_i("CT_MAD", ph.ctheader.data.CTMAD, nextKey);
     nextKey = code_key_i("CT_MEANC", ph.ctheader.data.CTmeanCurrent, nextKey);
     nextKey = code_key_i("CT_MEANN", ph.ctheader.data.CTmeanNext, nextKey);
     nextKey = code_key_i("CT_REFC", ph.ctheader.data.ref_count, nextKey);
     nextKey = code_key_i("CTSTATUS", ph.ctheader.data.CTstatus, nextKey);
     nextKey = code_key_i("CTERRX", ph.ctheader.data.LiveErrX, nextKey);
     nextKey = code_key_i("CTERRY", ph.ctheader.data.LiveErrY, nextKey);

     switch (hk0x428.tr_mode) {
       case 0: kw_str = "FIX"; break;
       case 1: kw_str = "TR1"; break;
       case 2: kw_str = "TR2"; break;
       case 3: kw_str = "TR3"; break;
       case 4: kw_str = "TR4"; break;
       default: kw_str = "INVALID"; break;
     }
     nextKey = code_key_s("TR_MODE", kw_str, nextKey);

     nextKey = code_key_i("CTMESTAT", ph.ctheader.data.CTMEstatus, nextKey);
     nextKey = code_key_i("CTMEX", ph.ctheader.data.CTMEangleX, nextKey);
     nextKey = code_key_i("CTMEY", ph.ctheader.data.CTMEangleY, nextKey);

     nextKey = code_key_i("FOCUS", ph.ctheader.data.focus, nextKey);
     /* this is a bit bizarre, put all 13 sums in a hex string, fits in a line */
     pstr = hexsums;
     mm = 12;  p = (short *) ph.ctheader.data.sums;
     while(mm--) { nn = sprintf(pstr,"%4hx,",*p++); pstr += nn; }
     sprintf(pstr,"%4hx",*p); /* no comma for the last one */
     nextKey = code_key_s("CT_SUMS", hexsums, nextKey);
     nextKey = code_key_i("SUB_ID", ph.pheader.info.subIdProduct, nextKey);
     /* also give these a PRODUCT and an OBS_TYPE (but not an OBS_ID), depends
     on the data product code */
     { char *q1 = product_string(ph.pheader.info.subIdProduct);
       //nextKey = code_key_s("PRODUCT", q1, nextKey);
       nextKey = code_key_s("OBS_TYPE", q1, nextKey);
       free(q1); }
     break;
 }
 /* construct file name now, we waited to get type dependent MDPclockHigh */
 /* note - older CT data and diagnostic does not have MDPclockHigh in the CT packets, we
 try to deduce it from the time of the packet file if MDPclockHigh is zero */
 name_out = CTname(rftype, ph.pheader.data.packet_time, dir_name, packetpath,
 	ph.pheader.info.subIdProduct, MDPclockHigh );

 nextKey = code_key_i("PCK_SN", ph.pheader.info.serial_no, nextKey);
 nextKey = code_key_i("NUM_PCKS", 1, nextKey);  /* always 1 here */


 //nextKey = code_key_s("COMMENT", "test data before flight", nextKey);
 //nextKey = code_key_s("FPPKEY", xmtextfieldgetstring(fitskey_text), nextKey);
 /* load the calendar time */
 
 nextKey = CTloadCalendarKeys(nextKey);

 ps = (short *) packdata1;
 /* for the CR and CL's, extract the 49x50 valid area and check the line counts,
 if the line counts are bad, keep them which makes for a 50x50 array */
 lcc = 0;
 if (rftype == 2) lcc = 0x40;
 if (rftype == 3) lcc = 0x80;
 if (lcc) {
  /* must be a ref or a live */
  int bad_lc = 0, dx;
  short *p = ps;
  /* a byte pointer to use for an endian independent version */
  unsigned char *c = packdata1;
/* remove this block after everything works
#if linux | LITTLEENDIAN
  swapb(packdata1, 56*50*2);
#endif
   no display, no gui, and wrfits does not swap 
*/
  /* check all the line counts first */
  mm = 50;
/*  while (mm--) { if (*p != lcc++) bad_lc++;  p = p + 56; } */
  /* (c[0] << 8) | c[1]) is an endian independent value for line count */
  while (mm--) { if ((((unsigned int) c[0] << 8) | (unsigned int) c[1]) != lcc++) bad_lc++; c+= 112; }
  if (bad_lc) {
    printf("warning: %d invalid line counts\n");
    nx = 50;  dx = 6;
    p = ps;
    } else {
    nx = 49;  dx = 7;
    p = ps + 1;
   }
  ps = ctimage;
  ny = 50;
  mm = ny;
  while (mm--) {
   nn = nx;
   while (nn--) *ps++ = *p++;
   p = p + dx;
  }
  pout = (unsigned char *) ctimage;
 } else {
  /* jitter, AC, or I scan types. The AC require some re-organizing and
  new dimensions. The packets may be padded. */
 switch (ph.pheader.info.subIdProduct) {
    case DPC_ANALOG_DUMP: {
//       char *pc;
//       short val[16], *ps;
//       int nb, i, j;
//       unsigned int *p;
//       pc = (char *) packdata1;
//       nb = nc * 2;
//       nx = nc + 1;
//       tmpdata = (char *) malloc(nx * ny * sizeof(int));
//       p = (unsigned int *) tmpdata;
//       if (p == NULL) { printf("malloc failure for AC temporary\n"); return 1; }
//       for (i=0;i<ny;i++)  {
//         bcopy(pc, p, 4);  /* because these aren't necessarily I*4 aligned */
//         pc += 4;  p++;
//         /* the channel values are I*2 in the packet but need to be upgraded for
// 	our FITS array here to I*4 because CT was I*4 */
// 	bcopy(pc, val, nb);
//         pc += nb;
//         for (j=0;j<nc;j++)  *p++ = (unsigned int) val[j];
//       }  
//       pout = (unsigned char *) tmpdata;
      /* 1/23/2004 - instead of upgrading the channels to I*4, allow 2 I*2 entries
      for the CT_Counter item. Either way is a hassle for the user to decode.
      Storing the CT as a F*8 in a separate file might be another way to go if
      end user simplicity is desired (and the end user doesn't mind having 2
      files). */
      nx = nc + 2;
      pout = (unsigned char *) packdata1;
      break; }
    case DPC_FG_ENGG_FR:
      /* we upgrade all of the 32 parameters to I*4 and convert the structure
      in the packet. This results in a 32 x nw array. It is twice the size of
      the original. Another method would be to use a FITS binary table and
      just copy the packet data to the FITS data area. */

      {

      /* JPS has made an endian independent code to do this, does not need
      the copy to IscanData structure */
//      { superfluous brace so vi brace match doesn't get confused

      unsigned char *pc;
      int	i, j;
//      IscanData scanset;
//       tmpdata = (char *) malloc(32 * ny * sizeof(int));
//       pc = (char *) packdata1;
//       p = (int *) tmpdata;
//       for (i=0;i<ny;i++)  {
//         bcopy(pc, &scanset, sizeof(IscanData)); /* in case not I*4 aligned */
//      pc = pc + sizeof(IscanData);
//      *p++ = scanset.CTatOpen;
//      *p++ = scanset.shutterOpenTime;
//      *p++ = scanset.shutterCloseTime;
//      *p++ = (int) scanset.woff;
//      *p++ = (int) scanset.phaseAtOpen;
//      *p++ = (int) scanset.phaseAtClose;
//      *p++ = scanset.sums[0];
//      *p++ = scanset.sums[1];
//      for (j=0;j<8;j++) *p++ = (int) scanset.mtr[j];
//      for (j=0;j<8;j++) *p++ = (int) scanset.therm[j];
//      for (j=0;j<8;j++) *p++ = (int) scanset.eltemp[j];
//       }
//       }
//      pout = (unsigned char *) tmpdata;
      pout = (unsigned char *) calloc(32 * ny * sizeof(int), 1);
      pc = packdata1;
      for (i=0;i<ny;i++)  {
        /* first 3 parameters are I*4 CTatOpen, shutterOpenTime, 
        shutterCloseTime; these are just passed through (12 bytes) */
        for (j=0; j<12; j++) pout[128*i + j] = pc[j];
        /* woff is a signed 16 bit value, put into int with sign extension */
	if (pc[12] & 0x80) pout[128*i+12] = pout[128*i+13] = 0xFF; /* woff<0 */
	pout[128*i + 14] = pc[12];               /* woff high byte */
        pout[128*i + 15] = pc[13];               /* woff low  byte */
        /* the 2 phases are 4 bits each */
	pout[128*i + 19] = (pc[14] >> 4) & 0x0F; /* phaseAtOpen */
	pout[128*i + 23] = pc[14] & 0x0F;        /* phaseAtClose */
        /* skip the spare 8 bit field, next are 2 I*4 fields for the sums
           (these are the actual measurements for this mode)  */
	for (j=16; j<24; j++) pout[128*i + 8 + j] = pc[j]; /* sums */
        /* the motor positions are 8 bit unsigned */
	for (j=0;j<8;j++) pout[128*i + 32 + 4*j + 3] = pc[24 + j]; /* mtr */
        /* the raw thermistor values and the onboard computed element T's
           are all 16 bit unsigned */
	for (j=0;j<8;j++) {
          pout[128*i + 64 + 4*j + 2] = pc[32 + 2*j]; /* therm hi byte */
          pout[128*i + 64 + 4*j + 3] = pc[33 + 2*j]; /* therm lo byte */
          pout[128*i + 96 + 4*j + 2] = pc[48 + 2*j]; /* eltemp hi byte */
          pout[128*i + 96 + 4*j + 3] = pc[49 + 2*j]; /* eltemp lo byte */
        }
	pc = pc + sizeof(IscanData);
      }
      }
      break;
    default: {
      /* should be a DD or a D2, check the jitter count in case it is short */
      int jcount = ph.ctheader.data.jitter_count;
      pout = (unsigned char *) packdata1;
      //printf(" jitter count = %d\n", jcount);
      if (rftype == 4) {
       /* change to 7x8700 if it looks OK */
       if ( (nx == 56) && (ny == 1088)) { nx = 7;  ny = 8700; } else {
	printf("unexpected dimension for DD packet unchanged: %d x %d\n",nx,ny); }
      }
      if (rftype == 5) {
       /* change to 28x2175 if it looks OK */
       if ( (nx == 56) && (ny == 1088)) { nx = 28;  ny = 2175; } else {
	printf("unexpected dimension for DD packet unchanged: %d x %d\n",nx,ny); }
      }
      break; }

 }
 }

/* compression is not used for any of these but we do have formal parameters
   in the packet header that we can use to populate the keywords */
 
 /* 9/6/2006 - the compression keys from the packet header */
 
 nextKey = packetCompressionKeys(&ph.pheader ,nextKey);
 
 printf("CT file out: %s\n", name_out);
 //printf("nx, ny = %d, %d\n", nx, ny);
 {
   int	dimen[2];
   dimen[0] = nx;	dimen[1] = ny;
   wrfitsNS((unsigned char *) pout, name_out, 2, dimen, CTfitsKeys, dtype, 0, 0);
 }
printf("CT write done\n");
 /* clean up anything we malloc'ed */
  switch (ph.pheader.info.subIdProduct) {
     case DPC_FG_ENGG_FR: free(pout); break;
  }
 return 0;
 }
 /*------------------------------------------------------------------------- */
int error_exit(char *s)
 {
 fprintf(stderr, "%s\n", s);
 exit(1);
 }
 /*------------------------------------------------------------------------- */
int FGclose()
 {
 /* wrap up the current FG reformat and write the image file, but we may have
 more images with this header so we can't free the keywords or the image */
 int	i;
 int	dimen[3], ndim;
 dimen[0] = FGimage.nx;	dimen[1] = FGimage.ny;
 /* try updating these here to guarantee we get the last one since
 we may terminate on start of a new image in many cases */
 if (modKey_i("PCK_SN1", FGimage.serial_no, FGkeyPCK_SN1)) {
   printf("error modifying PCK_SN1 keyword\n");
 }
 /* also update the packet count */
 if (modKey_i("NUM_PCKS", FGimage.num_packets, FGkeyNUM_PCKS)) {
   printf("error modifying NUM_PCKS keyword\n");
 }

  if (FGimage.nimages > 1) {
   ndim = 3;
   dimen[2] = FGimage.nimages;
 } else {
   ndim = 2;
 }
 if (FGimage.nx > 4096 || FGimage.ny > 2048) {
    printf("problem with nx, ny in FGclose, %d, %d\n", FGimage.nx, FGimage.ny);
    return 1;
 }
 printf("writing %s, nx, ny = %d %d\n", FGimage.name_out, FGimage.nx, FGimage.ny);
 fg_in_progress = 0;	fg_header_exists = 0;
 return wrfitsNS((unsigned char *) FGimage.image, FGimage.name_out, ndim, dimen,
	 FGfitsKeys, 1, FGextension, FGextensionSize);
 }
 /*------------------------------------------------------------------------- */
int SPclose()
 {
 /* wrap up the current SP reformat and write the file */
 int	i, dimen[4], ndim;
 sp_in_progress = 0;
 dimen[0] = SPimage.nw;
 dimen[1] = SPimage.ny;
 if (SPimage.subId == DPC_SP_RAW) {
   ndim = 2; dimen[2] = dimen[3] = 1;
 } else {
   ndim = 4;
   dimen[2] = SPimage.CCD_size + 1;
   /* there was a bug that made num_frames 8 rather than 9 in SP's
   before the fix, so don't do SPimage.num_frames - 1 to get both cases */
   dimen[3] = (SPimage.num_frames)/dimen[2];
   /* some sanity checks */
   //printf("SPimage.num_frames = %d, dimen[2] = %d\n", SPimage.num_frames,dimen[2]);
   if (dimen[3] != 4) {
      /* but check if OK with SPimage.num_frames - 1 which is the real criteria
      anyhow */
      dimen[3] = (SPimage.num_frames - 1)/dimen[2];
      /* still a problem */
      if (dimen[3] != 4) {
      printf("unlikely 4th dimension for an SP file %d\n", dimen[3]);
      printf("dimensions 0, 1, 2, 3 = %d, %d,%d,%d\n", dimen[0],dimen[1],dimen[2],dimen[3]);
      /* we have cases where a bit in the macro command got clobbered that caused
      this. There is a fix elsewhere but here we can also make sense of the data
      if dimen[3] is 8 (or 9). So ... */
      if (dimen[3] >= 8) { dimen[3] = 4;  dimen[2] = 2; } else {
        printf("unusual corruption, no file written\n");  return 1; }
   } }
 }
 printf("writing %s, nx, ny = %d %d\n", SPimage.name_out, SPimage.nw, SPimage.ny);
 return wrfitsNS((unsigned char *) SPimage.image, SPimage.name_out, ndim, dimen,
	 SPfitsKeys, 1, SPextension, SPextensionSize);
 }
 /*------------------------------------------------------------------------- */
int XRTclose()
 {
 /* wrap up the current XRT reformat and write the image file */
 int	dimen[2], ndim;
 dimen[0] = XRTimage.nx;	dimen[1] = XRTimage.ny;
 /* try updating these here to guarantee we get the last one since
 we may terminate on start of a new image in many cases */
 if (modKey_i("PCK_SN1", XRTimage.serial_no, XRTkeyPCK_SN1)) {
   printf("error modifying PCK_SN1 keyword\n");
 }
 /* also update the packet count */
 if (modKey_i("NUM_PCKS", XRTimage.num_packets, XRTkeyNUM_PCKS)) {
   printf("error modifying NUM_PCKS keyword\n");
 }
 /* XRT always has one image per file */
 ndim = 2;
 if (XRTimage.nx > 2176 || XRTimage.ny > 2112) {
    printf("problem with nx, ny in XRTclose, %d, %d\n", XRTimage.nx, XRTimage.ny);
    return 1;
 }
 printf("writing %s, nx, ny = %d %d\n", XRTimage.name_out, XRTimage.nx, XRTimage.ny);
 return wrfitsNS((unsigned char *) XRTimage.image, XRTimage.name_out, ndim, dimen,
	 XRTfitsKeys, 1, 0, 0);
 }
 /*------------------------------------------------------------------------- */
FITSkey * SPwrapup(FITSkey *nextKey)
 {
 /* because there are 3 places where it gets called */
 float	fac;
 /* this will be last serial # so reset the key */
 if (modKey_i("PCK_SN1", ph.pheader.info.serial_no, SPkeyPCK_SN1)) {
   printf("error modifying PCK_SN1 keyword\n");
 }
 /* also update the packet count */
 if (modKey_i("NUM_PCKS", SPimage.num_packets, SPkeyNUM_PCKS)) {
   printf("error modifying NUM_PCKS keyword\n");
 }
 /* and the compression fields */
 nextKey = code_key_i("BYTECNTI", SPbyteCountI, nextKey);
 nextKey = code_key_i("PIXCNTI", SPpixelCountI, nextKey);
 if (SPpixelCountI > 0) fac = 8.0 * (float) SPbyteCountI/ (float) SPpixelCountI;
   else fac = 0.0;
 //printf("SP bpp I = %g\n", fac);
 nextKey = code_key_g("BITSPPI", fac, nextKey);
 nextKey = code_key_i("BYTECNTQ", SPbyteCountQUV, nextKey);
 nextKey = code_key_i("PIXCNTQ", SPpixelCountQUV, nextKey);
 if (SPpixelCountQUV > 0) fac = 8.0 * (float) SPbyteCountQUV/ (float) SPpixelCountQUV;
   else fac = 0.0;
 //printf("SP bpp Q = %g\n", fac);
 nextKey = code_key_g("BITSPPQ", fac, nextKey);
 return nextKey;
 }
 /*------------------------------------------------------------------------- */
FITSkey *obsPlanKeys(FITSkey *nextKey, mdp_obs_table *mdp_obs)
 {
   int i;
 /* the address of the mdp_obs part of the structure must also be included to allow
 for different cases */
// nextKey = code_key_s("ORIGIN", "JAXA/ISAS", nextKey);   /* LMSAL, JAXA/ISAS or as needed */
 if (!strstr(kw_origin, ",")) if (sirius_pkts) {
   strcat(kw_origin, ", SIRIUS");
 } else {
   strcat(kw_origin, ", Data Distributor Quick Look");
 }
 nextKey = code_key_s("ORIGIN", kw_origin, nextKey); /* LMSAL, JAXA/ISAS or as needed */
 nextKey = code_key_i("DATA_LEV", 0, nextKey);   /* LMSAL, JAXA/ISAS or as needed */
 nextKey = code_key_s("ORIG_RF0", kw_origin, nextKey);   /* LMSAL, JAXA/ISAS or as needed */
 nextKey = code_key_s("VER_RF0", rf0_ver, nextKey);
 /* next 3 are level 1, don't need ? */
// nextKey = code_key_s("DATE_RF1", "", nextKey);
// nextKey = code_key_s("ORIG_RF1", "", nextKey);
// nextKey = code_key_s("VER_RF1", "", nextKey);
 /* next 3 are level 1, don't need ? */
// nextKey = code_key_s("T_FIRST", "", nextKey);
// nextKey = code_key_s("T_LAST", "", nextKey);
// nextKey = code_key_g("CADENCE", 0.0, nextKey);
 /* the MDP observing table keywords, these come from the mdp_obs member of the
 MC, not every item becomes a keyword */
 /* change some names to be compatible with XRT */
 nextKey = code_key_i("PROG_VER", mdp_obs->obsProgramVer, nextKey);
 nextKey = code_key_i("SEQN_VER", mdp_obs->seqTableVer, nextKey);
 nextKey = code_key_i("PARM_VER", mdp_obs->parameterTableVer, nextKey);
 nextKey = code_key_i("PROG_NO", mdp_obs->obsProgramNum, nextKey);
 nextKey = code_key_i("SUBR_NO", mdp_obs->subRoutineNum, nextKey);
 nextKey = code_key_i("SEQN_NO", mdp_obs->seqTableNum, nextKey);
 nextKey = code_key_i("MAIN_CNT", mdp_obs->mainRoutineCurrentCount, nextKey);
 nextKey = code_key_i("MAIN_RPT", mdp_obs->mainRoutineNrepeats, nextKey);
 nextKey = code_key_i("MAIN_POS", mdp_obs->mainRoutinePosition, nextKey);
 nextKey = code_key_i("SUBR_CNT", mdp_obs->subRoutineCurrentCount, nextKey);
 nextKey = code_key_i("SUBR_RPT", mdp_obs->subRoutineNrepeats, nextKey);
 nextKey = code_key_i("SUBR_POS", mdp_obs->subRoutinePosition, nextKey);
 nextKey = code_key_i("SEQN_CNT", mdp_obs->seqTableCurrentCount, nextKey);
 nextKey = code_key_i("SEQN_RPT", mdp_obs->seqTableNrepeats, nextKey);
 nextKey = code_key_i("SEQN_POS", mdp_obs->seqTablePosition, nextKey);
 /* the observing plan keys are lumped together here, most are just
 fillers for now */
// nextKey = code_key_s("OBSTITLE", "pre-launch test data", nextKey);
 nextKey = code_key_s("OBSTITLE", kw_obstitle, nextKey);
// nextKey = code_key_s("TARGET", "engineering", nextKey);
 nextKey = code_key_s("TARGET", kw_target, nextKey);
// nextKey = code_key_s("SCI_OBJ", "NONE", nextKey);
 nextKey = code_key_s("SCI_OBJ", kw_sci_obj, nextKey);
 nextKey = code_key_s("SCI_OBS", "TBD", nextKey);
// nextKey = code_key_s("OBS_DEC", "TBD", nextKey);
 nextKey = code_key_s("OBS_DEC", kw_obs_dec, nextKey);
// nextKey = code_key_s("JOIN_SB", "S", nextKey);
 nextKey = code_key_s("JOIN_SB", kw_join_sb, nextKey);
// nextKey = code_key_i("OBS_NUM", 42, nextKey);
 i = atoi(kw_obs_num);
 nextKey = code_key_i("OBS_NUM", i, nextKey);
// nextKey = code_key_i("JOP_ID", 999, nextKey);
 i = atoi(kw_jop_id);
 nextKey = code_key_i("JOP_ID", i, nextKey);
 i = atoi(kw_noaa_num);
 nextKey = code_key_i("NOAA_NUM", i, nextKey);
// nextKey = code_key_s("OBSERVER", "anonymous", nextKey);
 nextKey = code_key_s("OBSERVER", kw_observer, nextKey);
// nextKey = code_key_s("PLANNER", "committee", nextKey);
 nextKey = code_key_s("PLANNER", kw_planner, nextKey);
// nextKey = code_key_s("TOHBANS", "na", nextKey);
 nextKey = code_key_s("TOHBANS", kw_tohbans, nextKey);
 /* next is a section for data type information including compression */
// nextKey = code_key_s("DATATYPE", "SCI", nextKey);   /* SCI or ENG */
 nextKey = code_key_s("DATATYPE", kw_datatype, nextKey);   /* SCI or ENG */
 nextKey = code_key_s("COMPMOD", "JPEG12", nextKey); /* JPEG8 or JPEG12 */
 nextKey = code_key_s("SAA", "OUT", nextKey);   /* IN or OUT */
 nextKey = code_key_s("HLZ", "OUT", nextKey);   /* IN or OUT */
 nextKey = code_key_s("FLFLG", "NON", nextKey);   /* NON or FLR */
 return nextKey;
 }
 /*------------------------------------------------------------------------- */
FITSkey *compressionKeys(fg_macro_command *mc, FITSkey *nextKey)
 /* note that since we use only the compression parts of the macro command structure,
 we can just specify fg_macro_command structure for both the fg and sp case */
 {
 nextKey = code_key_i("BITCOMP1", mc->c1_bit_compression_mode, nextKey);
 nextKey = code_key_i("IMGCOMP1", mc->c1_image_compression_mode, nextKey);
 nextKey = code_key_i("QTABLE1", mc->c1_quantization, nextKey);

 nextKey = code_key_i("BITCOMP2", mc->c2_bit_compression_mode, nextKey);
 nextKey = code_key_i("IMGCOMP2", mc->c2_image_compression_mode, nextKey);
 nextKey = code_key_i("QTABLE2", mc->c2_quantization, nextKey);
 return nextKey;
 }
 /*------------------------------------------------------------------------- */
FITSkey *packetCompressionKeys(PacketHeader *pheader, FITSkey *nextKey)
 /* this is used for cases that require getting a single compression
 code from the packet header, should work for both FPP and XRT since
 it uses the info section */
 {
 nextKey = code_key_i("BITCOMP1", pheader->info.bit_compression_mode, nextKey);
 nextKey = code_key_i("IMGCOMP1", pheader->info.image_compression_mode, nextKey);
 nextKey = code_key_i("QTABLE1",  pheader->info.quantization, nextKey);

 /* note that the table versions (BITC_VER, etc) are not in the telemetry
 and are set in the section from the planning  tool. They are used when
 the onboard tables are re-loaded (which  should not be often). */
 return nextKey;
 }
 /*------------------------------------------------------------------------- */
FITSkey *FGimageParams(FITSkey *nextKey)
 {
 int tf_flag, iscale;
 int ixc, iyc, nb, i, fac;
 char *kw_str;
 MDP0x428 hk0x428;
 float xsun, ysun, crpix1, crpix2, xcen, ycen, sat_rot, ftmp;

 /* get latest MDP HK data */
 get_mdp_hk(&hk0x428);
 /* used for FG and I scan reformatting, assumes that fg_get_ccd_center
 has been run to extract info from the FG macro command copy */
 FGimage.nx = fg_p.ny;	/* note x/y interchange */
 FGimage.ny = fg_p.nx;
 //printf("fg_p.ny, fg_p.nx = %d, %d\n", fg_p.ny, fg_p.nx);
 if (FGimage.nx > 4096 || FGimage.ny > 2048) {
    printf("problem with nx, ny in FGimageParams, %d, %d\n", FGimage.nx, FGimage.ny);
    exit(2);
 }
 FGimage.ix0 = fg_p.iy0;	/* note x/y reversal here, CCD x is Solar N/S */
 FGimage.ix1 = fg_p.iy1;
 FGimage.iy0 = fg_p.ix0;
 FGimage.iy1 = fg_p.ix1;
 FGimage.sumy = 1 << fg_p.sumx;  /* note x/y interchange although we always have the */
 FGimage.sumx = 1 << fg_p.sumy;  /* same summing and binning in x and y anyhow */
 FGimage.biny = 1 << fg_p.binx;
 FGimage.binx = 1 << fg_p.biny;
 tf_flag = (fg_p.wave >= NFI_NO_MOVE);
 if (tf_flag) iscale = NFI_SCALE; else iscale = BFI_SCALE;
 /* take into account any summing or binning */
 fac = 1 << (fg_p.sumx + fg_p.binx);
 FGimage.pixscale = (float) (fac * iscale)/1000.;
 ixc = currentFGmacroCommand.ext_reg.center_row;
 iyc = currentFGmacroCommand.ext_reg.center_col;
 /* no image data to load from the header */
 FGimage.id = ph.pheader.info.id;
 FGimage.obsId = currentFGmacroCommand.parameters.obs_id;
 FGimage.frameId = currentFGmacroCommand.parameters.frame_def_id;
 FGimage.genId = obs2genFunc[FGimage.obsId];
 /* the genId refers to the internal generating function, these do not
 change with time. For the shuttered multi-image modes, we need the base
 # of images for each product to compute FGNINT. This is obtained from a
 table */
 
 /* we drop the FGimage.subId since we no longer use it since we put multiple
 products in a single file */
 //FGimage.subId = ph.pheader.info.subIdProduct;
 FGimage.serial_no = ph.pheader.info.serial_no;
 FGimage.num_frames = ph.pheader.info.num_frames;
 nextKey = code_key_s("TIMESYS", "UTC", nextKey);
 /* we use the wave # to establish if NB or WB */
 if (fg_p.wave < 7) 
    nextKey = code_key_s("INSTRUME", "SOT/WB", nextKey);
 else
    nextKey = code_key_s("INSTRUME", "SOT/NB", nextKey);
 
 /* obsPlanKeys is used for all data products */
 nextKey = obsPlanKeys(nextKey, &currentFGmacroCommand.mdp_obs);
 /* use OBS_ID for the macro command obs_id keyword */
 nextKey = code_key_i("OBS_ID", FGimage.obsId, nextKey);
 nextKey = code_key_i("GEN_ID", FGimage.genId, nextKey);
 nextKey = code_key_i("FRM_ID", FGimage.frameId, nextKey);
 nextKey = code_key_i("WAVEID", fg_p.wave, nextKey);
 if (FGimage.obsId ) {
   char *q1 = genFunc_string(FGimage.obsId);
   nextKey = code_key_s("OBS_TYPE", q1, nextKey);
   free(q1);
 } else {
   nextKey = code_key_s("OBS_TYPE", "FG raw", nextKey);
 }

 nextKey = code_key_i("MACROID", FGimage.id, nextKey);
 nextKey = code_key_i("XOFFSET", currentFGmacroCommand.ext_reg.center_col, nextKey);
 nextKey = code_key_i("YOFFSET", currentFGmacroCommand.ext_reg.center_row, nextKey);
 nextKey = code_key_g("XSCALE", FGimage.pixscale, nextKey);
 nextKey = code_key_g("YSCALE", FGimage.pixscale, nextKey);
 nextKey = code_key_i("FGXOFF", ixc, nextKey);
 nextKey = code_key_i("FGYOFF", iyc, nextKey);
 nextKey = code_key_i("FGCCDIX0", FGimage.ix0, nextKey);
 nextKey = code_key_i("FGCCDIX1", FGimage.ix1, nextKey);
 nextKey = code_key_i("FGCCDIY0", FGimage.iy0, nextKey);
 nextKey = code_key_i("FGCCDIY1", FGimage.iy1, nextKey);
 /* 9/30/2006 - keywords here reordered to better match some other documents, also
 evaluate the positional values assuming both CCD axis are reversed wrt solar */
 /* the CRPIX1 and 2 are the location of the "counting index (starts with 1)" center
 for the cutout image here. For ix0 = 0, this is 2048.5 in x and 1024.5 in y for iy0 = 0.
 We just have to subtract the distance from the east and south sides of the
 CD to the start of the cutout. Currently (9/30/2006) we think these directions are
 opposite from the pixel order for the LHS so we use complements. */
 crpix1 = (float) (fg_p.iy1 - 2047)/ ((float) fac) + 0.5;
 /* the crpix1 is 2048/fac + 0.5 - (4095-fg_p.iy1)/fac which is simplified above */
 crpix2 = (float) (fg_p.ix1 - 1023)/ ((float) fac) + 0.5;
 nextKey = code_key_g("CRPIX1", crpix1, nextKey);
 nextKey = code_key_g("CRPIX2", crpix2, nextKey);
 /* CRVAL1 and 2 are the location of our reference pixel (taken to be the center
 of the CCD) on the Sun, presently this is just the S/C position. A correction
 may have to be added when in orbit data is available. */
 xsun = get_xhelio();	ysun = get_yhelio();  /* we need these more than once */
 
 if (dkw) nextKey = code_key_x("UFSS_AB", hk0x428.byte211, nextKey);
 nextKey = code_key_g("CRVAL1", xsun, nextKey);
 nextKey = code_key_g("CRVAL2", ysun, nextKey);
 nextKey = code_key_g("CDELT1", FGimage.pixscale, nextKey);
 nextKey = code_key_g("CDELT2", FGimage.pixscale, nextKey);
 nextKey = code_key_s("CUNIT1", "arcsec", nextKey);
 nextKey = code_key_s("CUNIT2", "arcsec", nextKey);
 nextKey = code_key_s("CTYPE1", "Solar-X", nextKey);
 nextKey = code_key_s("CTYPE2", "Solar-Y", nextKey);
 /* SAT_ROT will reguire MDP data, check the use bits? */
 sat_rot = get_att_z();
 nextKey = code_key_g("SAT_ROT", sat_rot, nextKey);
 nextKey = code_key_g("INST_ROT", 0.0, nextKey);
 ftmp = sat_rot + 0.0;
 nextKey = code_key_g("CROTA1", ftmp, nextKey);
 nextKey = code_key_g("CROTA2", ftmp, nextKey);
 /* XCEN and YCEN are the solar coordinates of the center of the image, these
 are computed from the solar position for our reference pixel (the CCD center)
 which is presently just the S/C position plus any offset in our CCD. Note that
 the final offsets will depend on WB vs NB and may even vary slightly with the
 filter. */
 xcen = ((float) FGimage.nx/2 + 0.5 - crpix1) * FGimage.pixscale + xsun;
 ycen = ((float) FGimage.ny/2 + 0.5 - crpix2) * FGimage.pixscale + ysun;
 nextKey = code_key_g("XCEN", xcen, nextKey);
 nextKey = code_key_g("YCEN", ycen, nextKey);

 /* the fov is computed */
 nextKey = code_key_g("FOVX", FGimage.pixscale * FGimage.nx, nextKey);
 nextKey = code_key_g("FOVY", FGimage.pixscale * FGimage.ny, nextKey);
 switch (hk0x428.tr_mode) {
   case 0: kw_str = "FIX"; break;
   case 1: kw_str = "TR1"; break;
   case 2: kw_str = "TR2"; break;
   case 3: kw_str = "TR3"; break;
   case 4: kw_str = "TR4"; break;
   default: kw_str = "INVALID"; break;
 }
 nextKey = code_key_s("TR_MODE", kw_str, nextKey);
 
 nextKey = code_key_i("FGBINX", FGimage.binx, nextKey);
 nextKey = code_key_i("FGBINY", FGimage.biny, nextKey);
 /* some code that depended on the presence of an image header was removed since
 FGimageParams is not intended for iamge header info. It does not verify the
 presence of an image header. This is done only in FGreformat. */
 nextKey = code_key_i("OBT_TIME", 9999, nextKey);
 nextKey = code_key_i("OBT_END", 9999, nextKey);
 /* don't do EXPTIME for shutterless, note that this is requested
 exposure time, the actual is in the image header and done in FGreformat */
 if (FGimage.obsId < 32 ) {
   nextKey = code_key_g("EXPTIME",
     ((float) currentFGmacroCommand.parameters.exp)*1.024E-3, nextKey);
 }
 { char *q1 = wave_id_string(fg_p.wave);
   nextKey = code_key_s("WAVE", q1, nextKey);
   free(q1); }
 nextKey = code_key_i("DARKFLAG", currentFGmacroCommand.parameters.dark_flag, nextKey);

 /* 9/6/2006 - the compression parameters are taken from the MC, we use a common module for
 both FG and SP by passing the MC structure appropiate to each */
 
 nextKey = compressionKeys(&currentFGmacroCommand, nextKey);
 
 return nextKey;
 }
 /*------------------------------------------------------------------------- */
char *binfac(int n)
{
  switch(n) {
    case 1: return "1x1"; break;
    case 2: return "2x2"; break;
    case 4: return "4x4"; break;
    case 8: return "8x8"; break;
    default: return "Invalid bin factor";
  }
}
 /*------------------------------------------------------------------------- */
int XRTfixFWkey(unsigned int xrTime)
{
  if (xrTime < 1165051326 || xrTime > 1166394090) return 1;
  if (xrTime < 1165051525 ) {
    if (modKey_s("EC_FW1_", "Be_med-Be_thin", XRTkeyFW1s)) {
      printf("error modifying EC_FW1_ keyword\n");
      fprintf(stderr, "error modifying EC_FW1_ keyword\n");
    }
    if (modKey_s("EC_FW2_", "Al_mesh", XRTkeyFW2s)) {
      printf("error modifying EC_FW2_ keyword\n");
      fprintf(stderr, "error modifying EC_FW2_ keyword\n");
    }
  } else if ((1165223067 < xrTime) && (xrTime < 1165223270)) {
    if (modKey_s("EC_FW1_", "Be_med-Be_thin", XRTkeyFW1s)) {
      printf("error modifying EC_FW1_ keyword\n");
      fprintf(stderr, "error modifying EC_FW1_ keyword\n");
    }
    if (modKey_s("EC_FW2_", "Open", XRTkeyFW2s)) {
      printf("error modifying EC_FW2_ keyword\n");
      fprintf(stderr, "error modifying EC_FW2_ keyword\n");
    }
  } else if ((1165478960 < xrTime) && (xrTime < 1165478965)) {
    if (modKey_s("EC_FW1_", "Be_med-Be_thin", XRTkeyFW1s)) {
      printf("error modifying EC_FW1_ keyword\n");
      fprintf(stderr, "error modifying EC_FW1_ keyword\n");
    }
    if (modKey_s("EC_FW2_", "Open", XRTkeyFW2s)) {
      printf("error modifying EC_FW2_ keyword\n");
      fprintf(stderr, "error modifying EC_FW2_ keyword\n");
    }
  } else if ((1165482835 < xrTime) && (xrTime < 1165482839)) {
    if (modKey_s("EC_FW1_", "Be_med-Be_thin", XRTkeyFW1s)) {
      printf("error modifying EC_FW1_ keyword\n");
      fprintf(stderr, "error modifying EC_FW1_ keyword\n");
    }
    if (modKey_s("EC_FW2_", "Open", XRTkeyFW2s)) {
      printf("error modifying EC_FW2_ keyword\n");
      fprintf(stderr, "error modifying EC_FW2_ keyword\n");
    }
  } else if ((1165483240 < xrTime) && (xrTime < 1165483345)) {
    if (modKey_s("EC_FW1_", "Be_thin", XRTkeyFW1s)) {
      printf("error modifying EC_FW1_ keyword\n");
      fprintf(stderr, "error modifying EC_FW1_ keyword\n");
    }
    if (modKey_s("EC_FW2_", "Open", XRTkeyFW2s)) {
      printf("error modifying EC_FW2_ keyword\n");
      fprintf(stderr, "error modifying EC_FW2_ keyword\n");
    }
  } else if ((1165654350 < xrTime) && (xrTime < 1165701105)) {
    if (modKey_s("EC_FW1_", "Be_thin", XRTkeyFW1s)) {
      printf("error modifying EC_FW1_ keyword\n");
      fprintf(stderr, "error modifying EC_FW1_ keyword\n");
    }
    if (modKey_s("EC_FW2_", "Open", XRTkeyFW2s)) {
      printf("error modifying EC_FW2_ keyword\n");
      fprintf(stderr, "error modifying EC_FW2_ keyword\n");
    }
  } else if ((1165709630 < xrTime) && (xrTime < 1165795165)) {
    if (modKey_s("EC_FW1_", "Be_thin", XRTkeyFW1s)) {
      printf("error modifying EC_FW1_ keyword\n");
      fprintf(stderr, "error modifying EC_FW1_ keyword\n");
    }
    if (modKey_s("EC_FW2_", "Open", XRTkeyFW2s)) {
      printf("error modifying EC_FW2_ keyword\n");
      fprintf(stderr, "error modifying EC_FW2_ keyword\n");
    }
  } else if ((1165795220 < xrTime) && (xrTime < 1165881600)) {
    if (modKey_s("EC_FW1_", "Be_thin", XRTkeyFW1s)) {
      printf("error modifying EC_FW1_ keyword\n");
      fprintf(stderr, "error modifying EC_FW1_ keyword\n");
    }
    if (modKey_s("EC_FW2_", "Open", XRTkeyFW2s)) {
      printf("error modifying EC_FW2_ keyword\n");
      fprintf(stderr, "error modifying EC_FW2_ keyword\n");
    }
  } else if ((1165881655 < xrTime) && (xrTime < 1165967955)) {
    if (modKey_s("EC_FW1_", "Be_thin", XRTkeyFW1s)) {
      printf("error modifying EC_FW1_ keyword\n");
      fprintf(stderr, "error modifying EC_FW1_ keyword\n");
    }
    if (modKey_s("EC_FW2_", "Open", XRTkeyFW2s)) {
      printf("error modifying EC_FW2_ keyword\n");
      fprintf(stderr, "error modifying EC_FW2_ keyword\n");
    }
  } else if ((1165968010 < xrTime) && (xrTime < 1166054355)) {
    if (modKey_s("EC_FW1_", "Be_thin", XRTkeyFW1s)) {
      printf("error modifying EC_FW1_ keyword\n");
      fprintf(stderr, "error modifying EC_FW1_ keyword\n");
    }
    if (modKey_s("EC_FW2_", "Open", XRTkeyFW2s)) {
      printf("error modifying EC_FW2_ keyword\n");
      fprintf(stderr, "error modifying EC_FW2_ keyword\n");
    }
  } else if ((1166054405 < xrTime) && (xrTime < 1166140755)) {
    if (modKey_s("EC_FW1_", "Be_thin", XRTkeyFW1s)) {
      printf("error modifying EC_FW1_ keyword\n");
      fprintf(stderr, "error modifying EC_FW1_ keyword\n");
    }
    if (modKey_s("EC_FW2_", "Open", XRTkeyFW2s)) {
      printf("error modifying EC_FW2_ keyword\n");
      fprintf(stderr, "error modifying EC_FW2_ keyword\n");
    }
  } else if ((1166140805 < xrTime) && (xrTime < 1166169530)) {
    if (modKey_s("EC_FW1_", "Be_thin", XRTkeyFW1s)) {
      printf("error modifying EC_FW1_ keyword\n");
      fprintf(stderr, "error modifying EC_FW1_ keyword\n");
    }
    if (modKey_s("EC_FW2_", "Open", XRTkeyFW2s)) {
      printf("error modifying EC_FW2_ keyword\n");
      fprintf(stderr, "error modifying EC_FW2_ keyword\n");
    }
  } else if ((1166174950 < xrTime) && (xrTime < 1166227195)) {
    if (modKey_s("EC_FW1_", "C_poly", XRTkeyFW1s)) {
      printf("error modifying EC_FW1_ keyword\n");
      fprintf(stderr, "error modifying EC_FW1_ keyword\n");
    }
    if (modKey_s("EC_FW2_", "Open", XRTkeyFW2s)) {
      printf("error modifying EC_FW2_ keyword\n");
      fprintf(stderr, "error modifying EC_FW2_ keyword\n");
    }
  } else if ((1166227250 < xrTime) && (xrTime < 1166256965)) {
    if (modKey_s("EC_FW1_", "C_poly", XRTkeyFW1s)) {
      printf("error modifying EC_FW1_ keyword\n");
      fprintf(stderr, "error modifying EC_FW1_ keyword\n");
    }
    if (modKey_s("EC_FW2_", "Open", XRTkeyFW2s)) {
      printf("error modifying EC_FW2_ keyword\n");
      fprintf(stderr, "error modifying EC_FW2_ keyword\n");
    }
  } else if ((1166257773 < xrTime) && (xrTime < 1166313510)) {
    if (modKey_s("EC_FW1_", "Al_poly", XRTkeyFW1s)) {
      printf("error modifying EC_FW1_ keyword\n");
      fprintf(stderr, "error modifying EC_FW1_ keyword\n");
    }
    if (modKey_s("EC_FW2_", "Open", XRTkeyFW2s)) {
      printf("error modifying EC_FW2_ keyword\n");
      fprintf(stderr, "error modifying EC_FW2_ keyword\n");
    }
  } else if ((1166313620 < xrTime) && (xrTime < 1166394090)) {
    if (modKey_s("EC_FW1_", "Al_poly", XRTkeyFW1s)) {
      printf("error modifying EC_FW1_ keyword\n");
      fprintf(stderr, "error modifying EC_FW1_ keyword\n");
    }
    if (modKey_s("EC_FW2_", "Open", XRTkeyFW2s)) {
      printf("error modifying EC_FW2_ keyword\n");
      fprintf(stderr, "error modifying EC_FW2_ keyword\n");
    }
  }
  return 0;
}
 /*------------------------------------------------------------------------- */
FITSkey *XRTimageParams(FITSkey *nextKey)
 /* for XRT images, some similarities to FG */
 {
 int ixc, iyc, nb, i, j, k, fac, nx, ny, sum, iscale, ityp;
 int s_instrument_id, s_data_id, s_data_mon, s_sp_size;
 int sizes[] = { 64, 128, 192, 256, 384, 512, 768, 1024, 1536, 2048};
 int matches[] = { 1, 2,   3,   4,   6,   8,   0xc,0x10, 0x18, 0x20};
 int nsizes = (sizeof(sizes)/sizeof(int));
 unsigned int  iq, iq2;
 float tempccd, xcen, ycen, crpix1, crpix2, xsun, ysun, sat_rot, ftmp;
 char key_val_str[32];
 char *kw_str;
 MDP0x428 hk0x428;
 /* 12/17/2006 - note that XRT0x584 hk0x584 and XRT0x5a4 hk0x5a4 were made global since we
 use some members in XRTreformat */
 mdp_obs_table  mdp_obs;
 /* XRT documents claim that x is E/W and y is N/S, lots of luck! */
 XRTimage.nx = ph.xrtheader.info.nx;
 XRTimage.ny = ph.xrtheader.info.ny;
 if (XRTimage.nx > 2176 || XRTimage.ny > 2112) {
    printf("problem with nx, ny in XRTimageParams, %d, %d\n", XRTimage.nx, XRTimage.ny);
    exit(2);
 }
 /* get latest MDP HK data */
 get_mdp_hk(&hk0x428);
 /* get latest XRT HK data */
 get_xrt_hk(&hk0x584, &hk0x5a4);
 /* We have the synchronization between S/C and local clock here based on the
 last HK data. We might have problems if the data stream doesn't have HK
 and image data together. The 2 clocks that are synchronized are hk0x584.t_sc_clock
 and hk0x584.t_lo_clock. The TI time for the HK packet is in hk0x584.ptime. We
 use all 3 of these later to check and determine the exposure command time. */
 // xrt_tdelt = hk0x584.t_sc_clock/512.0 - (hk0x584.t_lo_clock & 0xffffff)/1.0e4;
 //sc_clk_tmp = hk0x584.t_sc_clock/512.0;
 //xrt_lclk_tmp = (hk0x584.t_lo_clock & 0xffffff)/1.0e4;
 //xrt_tdelt = sc_clk_tmp - xrt_lclk_tmp;
 //xrt_tdelt = (double) hk0x584.t_sc_clock/512.0 - (double) hk0x584.t_lo_clock/1.0e4;
 //if (xrt_tdelt < 0.0) xrt_tdelt += 8388608.0;

 printf("0x584: xrt_tdelt\tS/C clk\tlocal clk\tpacket time\n");
 printf("%f\t%u\t%u\t%u\n", xrt_tdelt, hk0x584.t_sc_clock, hk0x584.t_lo_clock, hk0x584.ptime);
 /* the image cutout and summing information is in every XRT packet, here we are
 just using the first one encountered for an image. If there are problems, we
 may have to check each one for consistency. */
 XRTimage.sumx = ph.xrtheader.data.xrte_chip_sum;	/* direct value, 1,2,4,8,16 have been spotted */
 sum = XRTimage.sumy = XRTimage.sumx;	/* always square */
 /* we have a size in the XRT-E section that we can compare with the other */
 i = (int) ph.xrtheader.data.xrte_roi_h_size;
 j = (int) ph.xrtheader.data.xrte_roi_v_size;
 nx = ny = 0;
 for (k=0;k<nsizes;k++) { if (i == matches[k] ) { nx = sizes[k]; break; } }
 for (k=0;k<nsizes;k++) { if (j == matches[k] ) { ny = sizes[k]; break; } }
 if (nx ==0 || ny ==0) {
   printf("**** error in XRT image size parameter(s) %d %d sum %d\n", i,j,sum );
   fprintf(stderr, "**** error in XRT image size parameter(s) %d %d sum %d\n", i,j, sum);
   /* a second chance if a 2048x2048 since we know the sum must be 1 */
   if (XRTimage.nx == 2048 && XRTimage.ny == 2048) {
     nx = XRTimage.nx; ny = XRTimage.ny;
     sum = XRTimage.sumy = XRTimage.sumx = 1;
   } else {
     return NULL;
   }
   //nx = 2176;  ny = 2112;
 }
 /* nx, ny are in pixels, compare to XRTimage.nx by using sum */
 if (XRTimage.nx * sum != nx || XRTimage.ny * sum != ny) {
   /* but the 2176x2112 can also match 2048x2048, so just accept anything with
   a 2176 or a 2112 */
   if (XRTimage.nx != 2176 && XRTimage.ny != 2112) {
     printf("error in XRT image size (%d, %d) vs packet image size (%d, %d)\n", nx, ny,
   	XRTimage.nx * sum, XRTimage.ny * sum);
     return NULL;
   }
 }
 XRTimage.ix0 = (int) ph.xrtheader.data.xrte_roi_h_sta_pos * 8;
 XRTimage.iy0 = (int) ph.xrtheader.data.xrte_roi_v_sta_pos * 8;

 XRTimage.ix1 = XRTimage.ix0 + nx - 1;
 XRTimage.iy1 = XRTimage.iy0 + ny - 1;

 iscale = XRT_SCALE;
 XRTimage.pixscale = (float) (sum * iscale)/1000.;
 /* no image data to load from the header */
 XRTimage.id = ph.xrtheader.info.id;
 
 XRTimage.serial_no = ph.xrtheader.info.serial_no;
 XRTimage.num_frames = ph.xrtheader.info.num_frames;
 nextKey = code_key_i("P1ROW", XRTimage.ix0, nextKey);
 nextKey = code_key_i("P2ROW", XRTimage.ix1, nextKey);
 nextKey = code_key_i("P1COL", XRTimage.iy0, nextKey);
 nextKey = code_key_i("P2COL", XRTimage.iy1, nextKey);
 switch (hk0x428.tr_mode) {
   case 0: kw_str = "FIX"; break;
   case 1: kw_str = "TR1"; break;
   case 2: kw_str = "TR2"; break;
   case 3: kw_str = "TR3"; break;
   case 4: kw_str = "TR4"; break;
   default: kw_str = "INVALID"; break;
 }
 /* need to compute these */
 nextKey = code_key_s("TR_MODE", kw_str, nextKey);
 
 /* the CRPIX1 and 2 are the location of the "counting index (starts with 1)" center
 for the cutout image here. When the base point is (0,0), it is (1024.5,1024.5).
 If (0,0) is in the SW corner, then we get (1024.5 - ix0, 1024.4 - iy0). Assuming
 this for now. SOT images do not have (0,0) in the SW corner for example. */
 crpix1 = 1024.5 - (float) XRTimage.ix0;
 crpix2 = 1024.5 - (float) XRTimage.iy0;
 nextKey = code_key_g("CRPIX1", crpix1, nextKey);
 nextKey = code_key_g("CRPIX2", crpix2, nextKey);
 xsun = get_xhelio();	ysun = get_yhelio();  /* we need these more than once */
 nextKey = code_key_g("CRVAL1", xsun, nextKey);
 nextKey = code_key_g("CRVAL2", ysun, nextKey);
 nextKey = code_key_g("CDELT1", XRTimage.pixscale, nextKey);
 nextKey = code_key_g("CDELT2", XRTimage.pixscale, nextKey);
 //nextKey = code_key_g("CDELT3", 9999.0, nextKey);
 nextKey = code_key_s("CUNIT1", "arcsec", nextKey);
 nextKey = code_key_s("CUNIT2", "arcsec", nextKey);
 nextKey = code_key_s("CTYPE1", "Solar-X", nextKey);
 nextKey = code_key_s("CTYPE2", "Solar-Y", nextKey);
 sat_rot = get_att_z();
 ftmp = sat_rot + 0.0;
 nextKey = code_key_g("SAT_ROT", sat_rot, nextKey);
 nextKey = code_key_g("INST_ROT", 0.0, nextKey);
 nextKey = code_key_g("CROTA1", ftmp, nextKey);
 nextKey = code_key_g("CROTA2", ftmp, nextKey);
 /* XCEN and YCEN are the solar coordinates of the center of the image, these
 are computed from the solar position for our reference pixel (the CCD center)
 which is presently just the S/C position plus any offset in our CCD. */
 xcen = ((float) (XRTimage.nx * sum)/2 + 0.5 - crpix1) * XRT_SCALE + xsun;
 ycen = ((float) (XRTimage.ny * sum)/2 + 0.5 - crpix2) * XRT_SCALE + ysun;
 
 nextKey = code_key_g("XCEN", xcen, nextKey);
 nextKey = code_key_g("YCEN", ycen, nextKey);
 if (dkw) nextKey = code_key_x("UFSS_AB", hk0x428.byte211, nextKey);
 nextKey = code_key_g("XSCALE", XRTimage.pixscale, nextKey);
 nextKey = code_key_g("YSCALE", XRTimage.pixscale, nextKey);
 nextKey = code_key_g("FOVX", XRTimage.pixscale * XRTimage.nx, nextKey);
 nextKey = code_key_g("FOVY", XRTimage.pixscale * XRTimage.ny, nextKey);
 nextKey = code_key_g("PLATESCL", XRTimage.pixscale, nextKey);
 int aec_info = ph.xrtheader.data.mdp_obs_raw[0] & 0xFF;
 nextKey = code_key_i("IMG_MODE", (aec_info >> 6) & 0x03, nextKey);
 if ((aec_info >> 5) & 0x01) nextKey = code_key_s("AEC_FLG", "on", nextKey);
 else nextKey = code_key_s("AEC_FLG", "off", nextKey);
 nextKey = code_key_i("AEC_TNUM", (aec_info >> 4) & 0x01, nextKey);
 nextKey = code_key_i("AEC_RSLT", aec_info & 0x0F, nextKey);
 /* the MDP observing table keywords, we have to copy into a XRT mdp_obs_table because of
 alignment problems. */
 bcopy(&ph.xrtheader.data.mdp_obs_raw[1], &mdp_obs, 20);
unsigned char mdpobsr[21];
int mdprawi[21];
bcopy(&ph.xrtheader.data.mdp_obs_raw[0], mdpobsr, 21);
printf("ph.xrtheader.data.mdp_obs_raw values (hex):\n");
for (k=0; k<21; k++) { printf("%2.2x ", ph.xrtheader.data.mdp_obs_raw[k]); }
printf("\n");
for (k=0; k<21; k++) { mdprawi[k] = mdpobsr[k]; printf("%x ", mdprawi[k]); }
printf("\n");
#if linux | LITTLEENDIAN
 mdp_obs_table_fix(&mdp_obs);
#endif
 nextKey = obsPlanKeys(nextKey, &mdp_obs);

 ityp = ph.xrtheader.info.type;
 s_instrument_id = (ityp >> 5) & 0x07;
 /* note type E data should be 5 */
//  if (s_instrument_id != 4) {
//    fprintf(stderr, "Bad s_instrument_id: %d for XRT (!= 4)\n", s_instrument_id);
//    printf("**** Bad s_instrument_id: %d for XRT (!= 4) ***\n", s_instrument_id);
//  }
 s_data_id = (ityp >> 1) & 0x0F;
 s_data_mon = ityp & 0x01;
 s_sp_size = (ph.xrtheader.info.size[0] << 16) |
            (ph.xrtheader.info.size[1] << 8) | ph.xrtheader.info.size[2];
 nextKey = code_key_i("S_INSTRU", 4, nextKey);
 nextKey = code_key_i("S_DAT_ID", s_data_id, nextKey);
 nextKey = code_key_i("S_DAT_M", s_data_mon, nextKey);
 nextKey = code_key_i("S_SP_SIZ", s_sp_size, nextKey);

 nextKey = code_key_i("EC_ID", (unsigned int) ph.xrtheader.data.ec_id, nextKey);
 nextKey = code_key_i("EC_INDEX", (unsigned int) ph.xrtheader.data.ec_eindex, nextKey);
 nextKey = code_key_i("EC_EINDE", (unsigned int) ph.xrtheader.data.ec_eindex, nextKey);
 nextKey = code_key_i("EC_CD_MO", (unsigned int) ph.xrtheader.data.ec_cd_mode, nextKey);
 nextKey = code_key_s("EC_CD_M_", ph.xrtheader.data.ec_cd_mode ? "fast" : "safe", nextKey);
 nextKey = code_key_i("EC_IMTYP", (unsigned int) ph.xrtheader.data.ec_imtype, nextKey);
 nextKey = code_key_s("EC_IMTY_", ph.xrtheader.data.ec_imtype ? "dark" : "normal", nextKey);
 nextKey = code_key_i("EC_FW1", (unsigned int) ph.xrtheader.data.ec_fw1, nextKey);
 {
   char *text;
   switch (ph.xrtheader.data.ec_fw1) {
     case 0: text = "Open";  break;
     case 1: text = "Al_poly";  break;
     case 2: text = "C_poly";  break;
     case 3: text = "Be_thin";  break;
     case 4: text = "Be_med";  break;
     case 5: text = "Al_med";  break;
     default: text = "illegal filter position"; break;
   }
   XRTkeyFW1s = nextKey = code_key_s("EC_FW1_", text, nextKey);
 }
 nextKey = code_key_i("EC_FW2", ph.xrtheader.data.ec_fw2, nextKey);
 {
   char *text;
   switch (ph.xrtheader.data.ec_fw2) {
     case 0: text = "Open";  break;
     case 1: text = "Al_mesh";  break;
     case 2: text = "Ti_poly";  break;
     case 3: text = "Gband";  break;
     case 4: text = "Al_thick";  break;
     case 5: text = "Be_thick";  break;
     default: text = "illegal filter position"; break;
   }
   XRTkeyFW2s = nextKey = code_key_s("EC_FW2_", text, nextKey);
 }
 nextKey = code_key_i("EC_VL", (unsigned int) ph.xrtheader.data.ec_vl, nextKey);
 nextKey = code_key_s("EC_VL_", ph.xrtheader.data.ec_vl ? "open" : "closed", nextKey);
 {
   double sc_clock_0, l_clock0, loclk_ope, loclk_clo;
   unsigned char *pb = &ph.xrtheader.data.e_sclock[0];
   /* 12/16/2006 - the sc_clock_0 was being done as a 24 bit value, it is 32 */
   //iq = (((unsigned int) pb[0]) << 16) + (((unsigned int) pb[1]) << 8) + ((unsigned int) pb[2]);
   iq = (((unsigned int) pb[0]) << 24) + (((unsigned int) pb[1]) << 16)
   	+ (((unsigned int) pb[2]) << 8) + ((unsigned int) pb[3]);
   e_sclock32 = iq;
   sc_clock_0 = iq/512.0;
   /* 12/16/2006 - change some code_key_i's to code_key_u */
   nextKey = code_key_u("E_SCLOCK", iq, nextKey);
   pb = &ph.xrtheader.data.e_lclock[0];
   iq = (((unsigned int) pb[0]) << 16) + (((unsigned int) pb[1]) << 8) + ((unsigned int) pb[2]);
   e_lclock24 = iq;
   xrt_lclk0 = l_clock0 = iq/1.0e4;
   nextKey = code_key_u("E_LCLOCK", 100*iq, nextKey);
   pb = &ph.xrtheader.data.e_sh_opening[0];
   iq = (((unsigned int) pb[0]) << 16) + (((unsigned int) pb[1]) << 8) + ((unsigned int) pb[2]);
   e_shopenlocal24 = iq;
   loclk_ope = iq/1.0e4;
   nextKey = code_key_u("E_SH_OPE", 100 * iq, nextKey);
   pb = &ph.xrtheader.data.e_sh_closed[0];
   iq2 = (((unsigned int) pb[0]) << 16) + (((unsigned int) pb[1]) << 8) + ((unsigned int) pb[2]);
   e_shcloselocal24 = iq2;
   loclk_clo = iq2/1.0e4;
   nextKey = code_key_u("E_SH_CLO", 100 * iq2, nextKey);
   pb = &ph.xrtheader.data.e_sh_closed[0];
   iq2 = (((unsigned int) pb[0]) << 16) + (((unsigned int) pb[1]) << 8) + ((unsigned int) pb[2]);
   nextKey = code_key_i("EXCCDEX", 100 * (iq2 -iq), nextKey);
   iq = (sc_clock_0 + loclk_ope - l_clock0)*512.0 + 0.5;
   nextKey = code_key_i("OBT_TIME", iq, nextKey);
   iq = (sc_clock_0 + loclk_clo - l_clock0)*512.0 + 0.5;
   nextKey = code_key_i("OBT_END", iq, nextKey);
 }
 nextKey = code_key_i("E_SH_POS", ph.xrtheader.data.e_sh_pos, nextKey);
 nextKey = code_key_i("E_SH_WA", ph.xrtheader.data.e_wait_a, nextKey);
 nextKey = code_key_i("E_SH_WB", ph.xrtheader.data.e_wait_b, nextKey);
 nextKey = code_key_i("E_SH_WC", ph.xrtheader.data.e_wait_c, nextKey);
 nextKey = code_key_i("E_SH_CW", ph.xrtheader.data.e_wait_cw, nextKey);
 nextKey = code_key_i("E_SH_CCW", ph.xrtheader.data.e_wait_ccw, nextKey);
 nextKey = code_key_i("E_VLO", ph.xrtheader.data.e_vlo, nextKey);
 nextKey = code_key_s("E_VLO_", ph.xrtheader.data.e_vlo ? "fully open" : "not fully open", nextKey);
 nextKey = code_key_i("E_VLC", ph.xrtheader.data.e_vlc, nextKey);
 nextKey = code_key_s("E_VLC_", ph.xrtheader.data.e_vlc ? "fully closed" : "not fully closed", nextKey);
 nextKey = code_key_i("E_SH_ERR", ph.xrtheader.data.e_sh_cmd_err, nextKey);
 nextKey = code_key_i("E_FW1_PO", ph.xrtheader.data.e_fw1_pos, nextKey);
 nextKey = code_key_i("E_FW1_ST", ph.xrtheader.data.e_fw1_stat, nextKey);
 nextKey = code_key_i("E_FW2_PO", ph.xrtheader.data.e_fw2_pos, nextKey);
 nextKey = code_key_i("E_FW2_ST", ph.xrtheader.data.e_fw2_stat, nextKey);
 nextKey = code_key_i("E_ETIM_E", ph.xrtheader.data.e_exptime_e, nextKey);
 {
   unsigned char *pb = &ph.xrtheader.data.e_exptime_m[0];
   iq = (((unsigned int) pb[0]) << 8) + (((unsigned int) pb[1]) << 0);
   nextKey = code_key_i("E_ETIM_M", iq, nextKey);
   /* iq is used just below for exptime calculation */
 }
 {
   /* compute the exposure time in seconds, note that e_exptime_e is a 2 bit
   field and is limited to values of 0,1,2,3 so the maximum mulitplier is
   512, e_exptime_m is a 16 unsigned, the count is 4 micro seconds
   Note that the e_exptime_e and e_exptime_m fields are sometimes 0. */
   iq = 4 * ( 1 << (3 * (unsigned int) ph.xrtheader.data.e_exptime_e)) * iq;
   nextKey = code_key_i("E_ETIM", iq, nextKey);
   float xq = 1.0e-6 * iq;
   nextKey = code_key_g("EXPTIME", xq, nextKey);  /* this is in seconds */
 }
 nextKey = code_key_i("E_TTN", ph.xrtheader.data.e_ttn, nextKey);
 nextKey = code_key_s("EXPMPAS", "", nextKey);
 nextKey = code_key_s("E_FW1_P", "", nextKey);
 nextKey = code_key_s("E_FW2_P", "", nextKey);
 nextKey = code_key_i("CCD_TEMP",  ph.xrtheader.data.xrte_ccd_temp, nextKey);
 if (dkw) nextKey = code_key_i("CCDTMPHK", hk0x5a4.ccd_temp, nextKey);
 tempccd = ph.xrtheader.data.xrte_ccd_temp;
// tempccd = hk0x5a4.ccd_temp;
// if (hk0x5a4.ccd_temp != ph.xrtheader.data.xrte_ccd_temp) fprintf(stderr,
//    "ccd_temp mismatch between HK and data telemetry\n");
 tempccd = ((tempccd * 5.9941e-5) + 0.55376) * tempccd - 95.853;
 nextKey = code_key_g("CCD_TMPC", tempccd, nextKey);
 nextKey = code_key_i("CCD_READ", ph.xrtheader.data.xrte_ccd_read_port, nextKey);
 nextKey = code_key_s("READPORT", ph.xrtheader.data.xrte_ccd_read_port ? "L" : "R", nextKey);
 XRTflipFlag = ph.xrtheader.data.xrte_ccd_read_port;  /* used for possible flip later */
 nextKey = code_key_i("CHIP_SUM", ph.xrtheader.data.xrte_chip_sum, nextKey);
 /* CHIP_BIN is a debugging aid, not an actual keyword, delete when done */
if (dkw) nextKey = code_key_s("CHIP_BIN", binfac(hk0x5a4.chip_sum), nextKey);
 nextKey = code_key_i("CAL_INFO", ph.xrtheader.data.xrte_cal_info, nextKey);
 nextKey = code_key_s("CALIMAGE", ph.xrtheader.data.xrte_cal_info ? "CAL" : "OBS", nextKey);
if (dkw)
 nextKey = code_key_s("CALIMGHK", hk0x5a4.cal_info ? "CAL" : "OBS", nextKey);
// if (hk0x5a4.cal_info != ph.xrtheader.data.xrte_cal_info) fprintf(stderr,
//    "cal_info mismatch between HK and data telemetry\n");
 nextKey = code_key_i("POS_COL", XRTimage.ix0, nextKey);
 if (dkw) nextKey = code_key_i("POSCOLHK", hk0x5a4.roi_h_sta_pos*8, nextKey);
 nextKey = code_key_i("POS_ROW", XRTimage.iy0, nextKey);
 if (dkw) nextKey = code_key_i("POSROWHK", hk0x5a4.roi_v_sta_pos*8, nextKey);
/*
 if (hk0x5a4.roi_v_size != ph.xrtheader.data.xrte_roi_v_size) fprintf(stderr,
    "roi_v_size mismatch between HK and data telemetry\n");
 if (hk0x5a4.roi_h_size != ph.xrtheader.data.xrte_roi_h_size) fprintf(stderr,
    "roi_h_size mismatch between HK and data telemetry\n");
*/
 if (dkw) nextKey = code_key_i("ROIHSIHK", hk0x5a4.roi_h_size, nextKey);
 nextKey = code_key_i("ROI_H_SI", ph.xrtheader.data.xrte_roi_h_size, nextKey);
 switch (ph.xrtheader.data.xrte_roi_h_size) {
   case 0x1:
   case 0x2:
   case 0x3:
   case 0x4:
   case 0x6:
   case 0x8:
   case 0xC:
   case 0x10:
   case 0x18:
   case 0x20: iq = ph.xrtheader.data.xrte_roi_h_size*64; break;
   default: iq = 0;
 }
 nextKey = code_key_i("SIZ_COL", iq, nextKey);
 if (dkw) nextKey = code_key_i("ROIVSIHK", hk0x5a4.roi_v_size, nextKey);
 nextKey = code_key_i("ROI_V_SI", ph.xrtheader.data.xrte_roi_v_size, nextKey);
 switch (ph.xrtheader.data.xrte_roi_v_size) {
   case 0x1:
   case 0x2:
   case 0x3:
   case 0x4:
   case 0x6:
   case 0x8:
   case 0xC:
   case 0x10:
   case 0x18:
   case 0x20: iq2 = ph.xrtheader.data.xrte_roi_v_size*64; break;
   default: iq2 = 0;
 }
 nextKey = code_key_i("SIZ_ROW", iq2, nextKey);
 nextKey = code_key_i("RECTIFY", ph.xrtheader.data.xrte_ccd_read_port, nextKey);
 if (ph.xrtheader.data.xrte_ccd_read_port) { /* Left */
   nextKey = code_key_i("RPOS_COL", 2047 - XRTimage.ix0, nextKey);
 } else {                     /* Right */
   nextKey = code_key_i("RPOS_COL", XRTimage.ix0, nextKey);
 }
 nextKey = code_key_i("RPOS_ROW", XRTimage.iy0, nextKey);
 nextKey = code_key_i("RSIZ_COL", iq, nextKey);
 nextKey = code_key_i("RSIZ_ROW", iq2, nextKey);
 nextKey = code_key_s("EFFPORT", "Right", nextKey);

 /* 9/6/2006 - the compression keys, only one set for XRT */

 nextKey = packetCompressionKeys(&ph.pheader, nextKey);
 /* 10/18/2006 - XRT doesn't use the VERn style because only one type, uses _VER style
 according to SB_MW_Key09a.pdf */
 /* note that the lower 4 bits of each are the table # and only the upper 12 bits
 the serial # as far as I can figure out, so we may have to mask these based on fveedback */
 nextKey = code_key_i("BITC_VER", XRTcompIDS[0], nextKey);
 nextKey = code_key_i("ACHF_VER", XRTcompIDS[1], nextKey);
 nextKey = code_key_i("DCHF_VER", XRTcompIDS[2], nextKey);
 nextKey = code_key_i("QTAB_VER", XRTcompIDS[3], nextKey);

 return nextKey;
 }
 /*------------------------------------------------------------------------- */
int FGreformat(int mode)
 /* mode is 1 for start and 0 for continuing, 2 is for a header packet */
 {
 void *FGname(struct tm *timeobs, int ms, char *dir_name, char *packetpath,
 	char **ptype);
 short	*ps, *FGlimit;
 int	ixp0, iyp0, nb, nframes;
 int	nxp, nyp, nn, side, xstride, ystride;
 short	*pp, *pbase;
 static FITSkey *nextKey;
 struct tm *timeobs;
 static int ms, FGtime;
 static	int needVer1, needVer2;
 char *ptype;
 double sbtime_pkt;
 float	fac;
 //printf("FGreformat, mode = %d\n", mode);
 /* a change in the ID should also be a good indicator of a new product
 and works for non-image test packets (which don't have an image header). We
 don't need a preloaded FGimage.id for the first image since one of the other
 tests will catch the very first packet (in case it matched by coincidence). */
 if ( (FGimage.id != ph.pheader.info.id) || mode ==2 || ((mode == 1) && (fg_in_progress == 0)) ) {
   /* normally mode would be 2 for a header packet with HK */
   /* starting a new FG image */
   if (fg_in_progress) {
     printf("new FG, closing the last one\n");
     /* now that we are done, compute the compression factor, also put in total bytes and pixel
     count as a check, should remove after verifying the factor */
     //printf("FGbyteCountI, FGpixelCountI = %d, %d\n", FGbyteCountI, FGpixelCountI);
     //printf("FGbyteCountQUV, FGpixelCountQUV = %d, %d\n", FGbyteCountQUV, FGpixelCountQUV);
     /* compression keys */
     nextKey = code_key_i("BYTECNTI", FGbyteCountI, nextKey);
     nextKey = code_key_i("PIXCNTI", FGpixelCountI, nextKey);
     if (FGpixelCountI > 0) fac = 8.0 * (float) FGbyteCountI/ (float) FGpixelCountI;
       else fac = 0.0;
     //printf("bpp I = %g\n", fac);
     nextKey = code_key_g("BITSPPI", fac, nextKey);
     nextKey = code_key_i("BYTECNTQ", FGbyteCountQUV, nextKey);
     nextKey = code_key_i("PIXCNTQ", FGpixelCountQUV, nextKey);
     if (FGpixelCountQUV > 0) fac = 8.0 * (float) FGbyteCountQUV/ (float) FGpixelCountQUV;
       else fac = 0.0;
     //printf("bpp Q = %g\n", fac);
     nextKey = code_key_g("BITSPPQ", fac, nextKey);
     if ( FGclose() ) printf("problem closing FG file");
   }
   /* free the last image header extension */
   //printf("free FGextension, = %d\n", FGextension);
   // if (FGextension) free(FGextension);XQUERY
   if (FGxalloc) { free(FGextension); FGxalloc = 0; }
   //printf("after free FGextension, = %d\n", FGextension);

   /* start up the fits keyword list */
   clearKeyList(FGfitsKeys);
   /* indicate that we don't yet have the compression serial (version) numbers */
   needVer1 = needVer2 = 1;
   nextKey = FGfitsKeys;
   nextKey = code_key_s("TELESCOP", "SOLAR-B", nextKey);
   nextKey = code_key_u("MDP_CLK", ph.pheader.data.packet_time, nextKey);
   nextKey = code_key_s("FILEORIG", sourceFile, nextKey);
   /* note that FGimageParams does some setups */
   nextKey = FGimageParams(nextKey);
   nextKey = code_key_i("PCK_SN0", FGimage.serial_no, nextKey);
   FGkeyPCK_SN1 = nextKey = code_key_i("PCK_SN1", ph.pheader.info.serial_no, nextKey);
   /* 5/30/2005 - count actual # of packets and update FGkeyNUM_PCKS before write */
   FGimage.num_packets = 1;
   /* also zero our pixel and packet size accumulators */
   FGpixelCountI = FGbyteCountI = FGpixelCountQUV = FGbyteCountQUV =0;
   FGkeyNUM_PCKS = nextKey = code_key_i("NUM_PCKS", FGimage.num_packets, nextKey);
   
   /* if the header is missing we'll have to do something else */

   //nextKey = code_key_s("FPPKEY", xmtextfieldgetstring(fitskey_text), nextKey);
   //nextKey = code_key_s("COMMENT", "test data before flight", nextKey);
   /* allocate for the image */
   /* 7/17/2004 - expand to arrays that may be 2, 3, or 4 D based on observable
   and # of frames */
   /* some notes about how the various observables are handled:
   * wave scans and focus scans are done as individual 2-D arrays, each image
     has its own header, num_frames is 2 but frame counter goes higher
   * modes that use smart memory operations are done as arrays with all the
     images (hence 2D or 3D), this includes DG's, MG's, and various Stokes
   */
   nframes = FGimage.num_frames;
   if (nframes > 2) {
     printf("a multi framed product, nframes = %d\n", nframes);
   }
   if (nframes < 2) nframes = 2;	/* the header and at least one image */
   nb = (nframes - 1) * FGimage.nx * FGimage.ny * sizeof(short);
   FGimage.nimages = nframes - 1;
   printf("nb = %d, nim = %d\n", nb, FGimage.nimages);
   if (nb > sizeof(FGimage.image) ) { printf("FG image illegally large %d\n", nb); return 1; }
   /* use a static array, otherwise the malloc/free cycles use a lot more memory */
   ps = FGimage.image;
   /* start with zeroes, may want to indicate bad data in another manner */
   bzero(ps, nb);
   /* if a header packet (with HK, no image), add HK stuff and return, also many other
   items taken from the image header including the time for the file. */
   if (mode == 2) {
     /* we have HK, so many more parameters */
     HKstatusData *hkStat;
     char *p;
     struct MMSTAT2  mm2;
     short statBuffer;
     float et, edct, edct2;

     if (FGinfoHdr->mode) {
      nextKey = code_key_s("FGMODE", "shuttered", nextKey);
      /* we want FGNINT to be the number of integrations for multiple image
      shuttered products, this is not just FGinfoHdr->n since 1,2, or 4 are 
      combined in smart memory. */
      {
	int  nq = MAXOF(genFunNimages[FGimage.genId], 1);
	nq = FGinfoHdr->n/nq;
	nextKey = code_key_i("FGNINT", nq, nextKey);
      }
     } else {
      nextKey = code_key_s("FGMODE", "shutterless", nextKey);
      nextKey = code_key_i("FGNINT", FGinfoHdr->ncycles, nextKey);
     }
    
   
    fg_header_exists = 1;
     hkStat = (HKstatusData *) FGheaderpackdata1;
     /* looks like a good time to stash the image header for the extension, although already
     copied once into FGheaderpackdata1, it might still get cobblered by an out of place
     header before we have a chance to do the final write. Note that we set FGextensionSize
     earlier when we had psize handy. */
     /* if this is a littleendian system, the copy made to FGheaderpackdata1 has already been
     modified but packdata1 should still be an unchanged copy at this point. So use it for
     the extension copy here. */
     /* 1/10/2007 - the early setting of FGextensionSize was a bug that caused the size
     to frequently reflect the next FG observable. We now buffer this by using another
     variable for the early evaluation. */
     FGextensionSize = FGheaderSize;
     FGextension = malloc(FGextensionSize);
     FGxalloc = 1;
     bcopy((char *) packdata1, (char *) FGextension, FGextensionSize);
     /* add the EXTEND key, this can be anywhere in the primary header */
     nextKey = code_key_s("EXTEND", "T", nextKey);

     p = &hkStat->status2[0] + 108;
     /* the ctme status word */
/*     bcopy(p, (char *) &statBuffer, 2); */
     statBuffer = (((unsigned int) p[0] << 8)) | (unsigned int) p[1]; /* endian independent equivalent */
     /* Also pull out a simple 0/1 keyword for servo on, for reference the bits are:
     15:servo, 14:reserved, 13:op in progress, 12:auto, 11:error, 10,9,8:soft out of ranges,
     7,6,5: hard limits, 4,3,2,1,0: reserved
     see Chapter 7 of EICA for more details */
     nextKey = code_key_i("CTSERVO", (((unsigned int) statBuffer) >> 15) & 0x1, nextKey);
     nextKey = code_key_i("CTMESTAT",(unsigned int) statBuffer, nextKey);
     /* we also want CTME-2 and 3 (aka X and Y), each is also a 16 bit value and we process
     in an endian independent manner */
     p = &hkStat->status2[0] + 110;   /* note 64 less than value in fppem4_v00.160 */
     statBuffer = (((unsigned int) p[0] << 8)) | (unsigned int) p[1]; /* endian independent equivalent */
     nextKey = code_key_i("CTMEX",(unsigned int) statBuffer, nextKey);

     p = &hkStat->status2[0] + 112;   /* note 64 less than value in fppem4_v00.160 */
     statBuffer = (((unsigned int) p[0] << 8)) | (unsigned int) p[1]; /* endian independent equivalent */
     nextKey = code_key_i("CTMEY",(unsigned int) statBuffer, nextKey);
    
     /* the CT mode */
     p = &hkStat->status2[0] + 6;
/*     bcopy(p, (char *) &statBuffer, 2); */
     statBuffer = (((unsigned int) p[0] << 8)) | (unsigned int) p[1]; /* endian independent equivalent */
     nextKey = code_key_i("CTMODE", (unsigned int) statBuffer, nextKey);
     
     /* look at mechs, copy into mm2 for alignment */
     p = &hkStat->status2[0] + 139;
     bcopy( p, (char *) &mm2, 30);
/* from Ankur's version */
#if linux | LITTLEENDIAN
        mmstat2_fix((struct MMSTAT2 *) &mm2);
#endif
     /* decode the temperatures, these are put into a common array alltemps */
     p = &hkStat->status3[0];
     /* the temperatures are put in alltemps. Since we can only process
     one image header packet at a time, there is only one set shared by
     FG and SP */
     getTemperatures(p);
 
     nextKey = code_key_g("T_SPCCD", alltemps[32], nextKey);
     nextKey = code_key_g("T_FGCCD", alltemps[33], nextKey);
     nextKey = code_key_g("T_CTCCD", alltemps[34], nextKey);
     nextKey = code_key_g("T_SPCEB", alltemps[0], nextKey);
     nextKey = code_key_g("T_FGCEB", alltemps[1], nextKey);
     nextKey = code_key_g("T_CTCEB", alltemps[2], nextKey);
     nextKey = code_key_i("MASK",mm2.CM_DevPos[0], nextKey );
     nextKey = code_key_i("WBFW",mm2.CM_DevPos[1], nextKey);
     nextKey = code_key_i("WEDGE",mm2.CM_DevPos[2], nextKey);
     nextKey = code_key_i("NBFW",mm2.CM_DevPos[3], nextKey);
     nextKey = code_key_i("TF1",mm2.CM_DevPos[4], nextKey );
     nextKey = code_key_i("TF2",mm2.CM_DevPos[5], nextKey );
     nextKey = code_key_i("TF3",mm2.CM_DevPos[6], nextKey );
     nextKey = code_key_i("TF4",mm2.CM_DevPos[7], nextKey );
     nextKey = code_key_i("TF5",mm2.CM_DevPos[8], nextKey );
     nextKey = code_key_i("TF6",mm2.CM_DevPos[9], nextKey );
     nextKey = code_key_i("TF7",mm2.CM_DevPos[10], nextKey );
     nextKey = code_key_i("TF8",mm2.CM_DevPos[11], nextKey );

     nextKey = code_key_i("SLIT",mm2.LM_DevPos[0], nextKey );
     nextKey = code_key_i("FOCUS",mm2.LM_DevPos[1], nextKey );
     nextKey = code_key_i("WBEXP",mm2.ExpDur[0], nextKey );
     nextKey = code_key_i("NBEXP",mm2.ExpDur[1], nextKey );
     /* from the image header, we use the last image header encountered
     so this will work only if the FG packetes are in chron order */
     //nextKey = code_key_s("COMMENT", "data from image header", nextKey);
     /* 6/3/2005 - remove the GCUCONFG keyword, this was for ground calibrations */
     //nextKey = code_key_s("COMMENT", "GCUCONFG field became WAVEOFF at some point after GCU testing", nextKey);
     //nextKey = code_key_i("GCUCONFG",FGinfoHdr->woff, nextKey );
     nextKey = code_key_i("WAVEOFF",FGinfoHdr->woff, nextKey );
     nextKey = code_key_i("ROISTART",FGinfoHdr->roiStart, nextKey );
     nextKey = code_key_i("ROISTOP",FGinfoHdr->roiStop, nextKey );
     nextKey = code_key_i("DOPVUSED",FGinfoHdr->v, nextKey );
   { /* camera parameters */
     CONFIG  FGconfig;
     int dacA, dacB, psum, ssum;
     bcopy(&FGinfoHdr->cameraConfig, &FGconfig, 2);
     dacA = ((FGinfoHdr->dac) >> 5) & 0x1f;   dacB = (FGinfoHdr->dac) & 0x1f;
     psum = 1 << (FGconfig.bits.ParSum);  ssum = 1 << (FGconfig.bits.SerSum);

     nextKey = code_key_i("CAMGAIN",FGconfig.bits.Gain, nextKey );
     nextKey = code_key_i("CAMDACA",dacA, nextKey );
     nextKey = code_key_i("CAMDACB",dacB, nextKey );
     nextKey = code_key_i("CAMPSUM",psum, nextKey );
     nextKey = code_key_i("CAMSSUM",ssum, nextKey );
     nextKey = code_key_i("CAMAMP",FGconfig.bits.PreAmp, nextKey );
     nextKey = code_key_i("CAMSCLK",FGconfig.bits.SerClk, nextKey );
   }
   /* load the calendar time at the start of first exposure */
   {
     unsigned int MDP, FGtime, ms, MDP23, MDPatCTref, CTref, ctclose, FGti;
     int timeErrFlag, dt;
     /* probably should make ctrate a global constant but for now ... */
     float  xq;
     double xdt, ctrate = 584.0;
     static unsigned int lastMDP = 0;
     /* calibrate the CTcounter using the entries in the packet header */
     MDPatCTref = FGinfoHdr->MDPclock;
     CTref = FGinfoHdr->CTcounter;
     nextKey = code_key_u("MDPCTREF",MDPatCTref, nextKey );
     nextKey = code_key_u("CTREF",CTref, nextKey );
     nextKey = code_key_g("CTRATE",ctrate, nextKey );
     
//      printf("packet MDP %#x, FGinfoHdr MDP %#x, dt = %d\n", ph.pheader.data.packet_time,
//      	FGinfoHdr->MDPclock, ph.pheader.data.packet_time - FGinfoHdr->MDPclock);
//      if (lastMDP == FGinfoHdr->MDPclock) {
// 	 /* suggests a duplicate header, use the packet time for the name to
// 	 avoid duplicate file names */
//        nextKey = code_key_i("HEADERR",1, nextKey );
//        printf("stale header!!!!!\n");
//        /* This is a temporary patch for the name and to give a more realistic
//        time. It does not check for wraparound but that should be infrequent.
//        It needs to be upgraded to a better method. */
//        MDP = ph.pheader.data.packet_time;
//      } else nextKey = code_key_i("HEADERR",0, nextKey );
     
     //nextKey = code_key_u("PMU_NROT", 9999, nextKey );

     //lastMDP = MDP;
     /* also the sdtp case 11/21/2004 */
     if (sdtp_flag) {
       printf("SDTP time calculation\n");
       /* The best determined time is CTatClose for shuttered exposures. For a
       FITS keyword we take the first exposure if there are multiples. The rest
       can be computed from the image header extension. We backout the exposure
       time to get the time at start of exposure.
       For shutterless it is more complicated. We have the CTcounter for all
       phases of each exposure in the extension. Here we try to get the value
       for the phase of the first integration. */
printf("MDPatCTref, FPPccsdsti: %u, %u\n", MDPatCTref, FPPccsdsti);
       FGti = getTI(MDPatCTref, FPPccsdsti, &timeErrFlag);
printf("FGti is: %d\t%u\n", FGti, FPPccsdsti);
       nextKey = code_key_i("TIMEERR",timeErrFlag, nextKey );
       /* so we have the TI time which has LSB of 1/32 s, use it to get the
       sbtime_pkt time. Remember this is not the start of exposure yet. */
       sb_time_0 = FGti/32.0;
       sb_time_0 = sb_time_0 - sb_time_0*6.95263888075869e-06 + 212176146.475454;
       sbtime_pkt = SB_Time_Convert(FGti, sb_time_0); /* + 946684800.0; */
       if (!finite(sbtime_pkt)) {
         printf("got a nan or infinity from SB_Time_Convert, FGti, sb_time_0 = %u, %20.1f\n",
	   FGti, sb_time_0);
         fprintf(stderr, "got a nan or infinity from SB_Time_Convert, FGti, sb_time_0 = %u, %20.1f\n",
	   FGti, sb_time_0);
       }
printf("sbtime_pkt is: %20.1f\n", sbtime_pkt);
       /* add back in the fraction of a second that we masked out (the lower
       4 bits of MDPatCTref). We assume a fixed rate here. */
       sbtime_pkt  += (double) (MDPatCTref & 0xf)/512.;
       /* shuttered? */
printf("sbtime_pkt with fraction back in: %20.1f\n", sbtime_pkt);
       if (FGinfoHdr->mode) {
         /* this is shuttered type and we expect a FGinfoExpset structure in the
	 image header, get the first actual exposure time, but note that some observables
	 have many shuttered exposures */
	 getFirstExposure(FGinfoHdr, &et, &edct, &edct2, &ctclose );
	 nextKey = code_key_g("EXP0", et, nextKey);
	 nextKey = code_key_g("EXPCT", edct, nextKey);
	 nextKey = code_key_g("EXPCT2", edct2, nextKey);
	 /* get the difference between ctclose and CTref, we expect CTref to be
	 earlier since it was stored as part of the setup just before the exposure. */
	 printf("CTref, ctclose, et, %d, %d, %g\n", CTref, ctclose, et);
	 if (CTref <= ctclose) {
	   dt = ctclose - CTref;
	   xdt = (double) dt / ctrate;	/* the offset in seconds */
	 } else {
	   /* this is probably a rollover */
	   dt = CTref - ctclose;	/* this should be very large if a rollover */
	   if (dt > 0x00ffffff) {	/* assume rollover */
	     xdt = 4294967296.0 - (double) ctclose + (double) CTref;
	     xdt = xdt / ctrate;	/* the offset in seconds */
	   } else {
	     printf("bad dt? = %d\n", dt);
	     xdt = 0.0;
	   }
	 }
	 xdt = xdt - et;		/* also include the exposure time */
	 printf("xdt for shuttered = %g s\n", xdt);
       } else {
         unsigned int ctStart, phaseStart;
	 /* shutterless, we expect a FGinfoPMUset structure in the image header,
	 the third phase is (I think) the start of integration. But this should
	 be checked. */
	 getFirstShutterlessExposure(FGinfoHdr, &ctStart, &phaseStart);
	 printf("CTref, ctStart, phaseStart %d, %d, %d\n", CTref, ctStart, phaseStart);
	 if (CTref <= ctStart) {
	   dt = ctStart - CTref;
	   xdt = (double) dt / ctrate;	/* the offset in seconds */
	 } else {
	   /* this is probably a rollover */
	   dt = CTref - ctStart;	/* this should be very large if a rollover */
	   if (dt > 0x00ffffff) {	/* assume rollover */
	     xdt = 4294967296.0 - (double) ctclose + (double) CTref;
	   } else {
	     printf("bad dt? = %d\n", dt);
	     xdt = 0.0;
	   }
	 }
	 printf("xdt for shutterless = %g s\n", xdt);
       }
       sbtime_pkt = sbtime_pkt + xdt;	/* our time of first exposure *       
       //FGtime = FGtime | ( (unsigned int) (FGinfoHdr->MDPclockHigh) << 23);
       
       //FGtime = timeRef + ((FPPccsdsti >> 5) & 0x07ffffff);
//printf("FGtime is: %d, ccsdsti: %d (old timeRef method)\n", FGtime, FPPccsdsti);
       /* ISAS time method (use in production) */
       FGtime = (unsigned int) sbtime_pkt;
//printf("FGtime is: %d, ccsdsti: %d (new SB_time method)\n", FGtime, FPPccsdsti);
printf("FGtime = %d, sbtime_pkt = %20.0f\n", FGtime, sbtime_pkt);
       xq = (sbtime_pkt - (double) FGtime) * 1000.;
       FGtime = FGtime + 946684800;	/* convert to Unix time */
       //xq = (float) ( (FPPccsdsti) & 0x1f ) *(1000./32.);
       ms = (int) (xq + 0.5);
       if (ms == 1000) { ms = 0;  FGtime++; }
//printf("Old ms: %d, ", ms);
       /* ISAS time method (use in production) */
       //ms = (int) (1000.0*(sbtime_pkt - FGtime) );
printf("New ms: %d\n", ms);
     } else {
       printf("EGSE time calculation\n");
       FGtime = ((MDP) >> 9 ) & 0x007fffff;
       FGtime = FGtime | ( (unsigned int) (FGinfoHdr->MDPclockHigh) << 23);
       timeRefCheck(&FGtime);
       /* also compute milli seconds from MDPclock */
       xq = (float) ( (MDP) & 0x1ff ) *(1000./512.);
       ms = (int) (xq + 0.5);
       if (ms == 1000) { ms = 0;  FGtime++; }
     }
     timeobs = gmtime( (time_t *) &FGtime);
     /* load the various calendar time keys*/
     nextKey = loadCalendarKeys(timeobs, ms, nextKey);
     /* construct file name, changed 1/15/2004 to use dates/times for paths */
     /* 7/18/2004 - now using multi-D arrays and one file per header
     packet; i.e., there is a new name only for a new header, some observables
     come out as a series of single images with headers, these are output
     as multiple files */
     //timeobs = gmtime( (time_t *) &FGtime);
     FGname(timeobs, ms, dir_name, packetpath, &ptype);
   }
   /* HEX was going to be a calculated PMU phase for debugging PMU problems,
   removed 6/3/2005 since it never really got done */
   //nextKey = code_key_i("HEX",gethexfg(FGinfoHdr), nextKey );
   /* 7/20/2004 - new product keyword based on observable */
   //nextKey = code_key_s("PRODUCT", ptype, nextKey );
   nextKey = code_key_i("PMUDELAY",FGinfoHdr->PMUdelay, nextKey );
   //printf("HK done\n");
   fg_in_progress = 1;
   /* construct file name, changed 1/15/2004 to use dates/times for paths */
   /* but wait until we have an image, not for just the header */
   return 0;
   }
 } 
 /* continuing on a FG image, load the packet into the image */
 if (!fg_header_exists) { 
   /* this can happen for the test packets so we have to check for that possibility */
   if (FGimage.obsId == 253) {
     printf("got a ramp test packet\n");
     /* we probably only have these for SDTP data so just bail if EGSE for now. We
     have to duplicate name construction here. A minor re-write could make this
     more sensible but can wait until we do the time correctly. */
     if (sdtp_flag) {
       unsigned int FGtime;
       float  xq;
       int ms;
       /* note that when there is no image header, we have to use the FPPccsdsti time
       for the name */
       printf("SDTP time calculation\n");
       sb_time_0 = FPPccsdsti/32.0;
       sb_time_0 = sb_time_0 - sb_time_0*6.95263888075869e-06 + 212176146.475454;
       sbtime_pkt = SB_Time_Convert(FPPccsdsti, sb_time_0); /* +946684800.0;*/
       sbtime_pkt = SB2UT(sbtime_pkt); /* sbtime_pkt is now UTC */
       FGtime = (unsigned int) sbtime_pkt;
       xq = 1000.0*(sbtime_pkt - FGtime);
       ms = (int) (xq + 0.5);
       if (ms == 1000) { ms = 0;  FGtime++; }
       timeobs = gmtime( (time_t *) &FGtime);
       nextKey = loadCalendarKeys(timeobs, ms, nextKey);
       FGname(timeobs, ms, dir_name, packetpath, &ptype);
       fg_in_progress = 1;
     } else {
       printf("ramp test packets not presently supported for EGSE data\n");
     }
   } else {
     printf("skipping a FG packet because no header yet, obsId = %d, Macro ID = %#x\n",
        FGimage.obsId, FGimage.id);  return 0;
   }
 } 
 /*  the subIdProduct is no longer used for a keyword */
// if (FGimage.subId != (int) ph.pheader.info.subIdProduct) {
//    char *q1 = product_string((int) ph.pheader.info.subIdProduct);
//    if (modKey_s("PRODUCT", q1, keyPRODUCT)) {
//      printf("error modifying PRODUCT keyword\n");
//    }
//   FGimage.subId = ph.pheader.info.subIdProduct;
//   free(q1);
// }
 /* check ID */
 if (FGimage.id != ph.pheader.info.id) {
    /* this can happen for the test packets so we have to check for that possibility */
    printf("skipping a FG packet because of FG ID mismatch\n%#x vs %#x\n",
        FGimage.id, ph.pheader.info.id);
    return 0; }
 /* check that the full image size is consistent with the header we got */
 if (FGimage.nx != ph.pheader.info.ny || FGimage.ny != ph.pheader.info.nx) {
    printf("skipping a FG packet because FG packet doesn't match header\n");
    printf("%d x %d vs %d x %d\n", FGimage.nx, FGimage.ny, ph.pheader.info.ny,ph.pheader.info.nx);
    return 0; }
 ixp0 = ph.pheader.info.x0;
 iyp0 = ph.pheader.info.y0;
 side = ph.pheader.info.subIdCCDseg;
 /* 5/30/2005 - we count packets */
 FGimage.num_packets++;
 FGimage.serial_no = ph.pheader.info.serial_no;
 
 /* 10/18/2006 - now for something curious, we are tasked with getting the compression
 serial numbers (or versions) for type 1 and type2. We get these from the CCSDS packet
 but we didn't know back then if it was a 1 or a 2. So as we go through the image
 here we set the VER1's and VER2's for the first 1 and 2 we find (if any). We don't
 set any we don't find. Note that fg_comp_choice was already computed in the "list"
 section. If we remove that, we must call get_comp_choice here instead. */
 if (needVer1) {
   if (fg_comp_choice == 1) {
     nextKey = code_key_i("BITCVER1", FPPcompIDS[0], nextKey);
     nextKey = code_key_i("ACHFVER1", FPPcompIDS[1], nextKey);
     nextKey = code_key_i("DCHFVER1", FPPcompIDS[2], nextKey);
     nextKey = code_key_i("QTABVER1", FPPcompIDS[3], nextKey);
     needVer1 = 0;  /* until the next file */
   }
 }
 if (needVer2) {
   if (fg_comp_choice == 2) {
     nextKey = code_key_i("BITCVER2", FPPcompIDS[0], nextKey);
     nextKey = code_key_i("ACHFVER2", FPPcompIDS[1], nextKey);
     nextKey = code_key_i("DCHFVER2", FPPcompIDS[2], nextKey);
     nextKey = code_key_i("QTABVER2", FPPcompIDS[3], nextKey);
     needVer2 = 0;  /* until the next file */
   }
 }
 nxp = ph.pheader.info.nxp;
 nyp = ph.pheader.info.nyp;
 /* and now lets work on the compression factor, this is accumulated separately for the
 I component and the others (lumped together) */
 switch (ph.pheader.info.subIdProduct) {
   case DPC_STOKES_Q:
   case DPC_STOKES_U:
   case DPC_STOKES_V:
   case DPC_MAGNETOGRAM:
   case DPC_DOPPLERGRAM:
     FGbyteCountQUV += psizeCompressed;
     FGpixelCountQUV += nyp*nxp;
     break;
   case DPC_STOKES_I:
   case DPC_FG_RAW:
   case DPC_DARK:
   default:
     FGbyteCountI += psizeCompressed;
     FGpixelCountI += nyp*nxp;
     break;
 }
 pp = (short *) packdata1;
 /* load the image with the correct solar orientation, this may evolve */
 /* 9/29/2006 - for the FG we originally had the directions reversed in N/S
 and in E/W. Try to modify to load both axis in reverse. But also have an option
 to do it the old way, especially while debugging. */
 
 if (oldAspect) {
   ystride = ph.pheader.info.ny;
   /* if the LHS, we load as a transpose, if RHS we also reverse x */
   if (side)  { xstride = -1; pbase = FGimage.image + iyp0 + ixp0*ystride + nyp - 1; }
 	  else { xstride =1; pbase = FGimage.image + iyp0 + ixp0*ystride; }
   /* usually we expect ixp0 to be 0  and the packet nx = nxp because of the
   way packets are made but we allow for possible variants */
 } else {
   /* the newer orientation, the very first data pixel is now the last pixel in the
   image */
   ystride = -ph.pheader.info.ny;
   if (ixp0) { printf("**** FG packet ix0 error, ix0 = %d, image may be compromised\n", ixp0); }
   /* since ixp0 must be 0 (or we have a bad packet), just assume 0 here */
   if (side)  { xstride = 1; pbase = FGimage.image + FGimage.nx*FGimage.ny - iyp0 - nyp; }
 	  else { xstride = -1; pbase = FGimage.image + FGimage.nx*FGimage.ny - iyp0 - 1; }
 }
 FGlimit = FGimage.image + sizeof(FGimage.image);
 /* if a multi frame product, we have to compute where this part belongs */
 if (FGimage.num_frames > 2) {
   int noff, iframe, j;
   iframe = ph.pheader.info.main_seq_count;
   /* we may have the frame # go up in a wavelength scan series even for
   multi-image observables. In this case there are num_frames in each set
   (including a header for each set) so we really need iframe% num_frames */
   j = iframe % FGimage.num_frames;
   if (j < 1) {
     printf("bad frame counter = %d\n", iframe);
     j = 1;
   }
   j = j - 1;
   noff = FGimage.nx * FGimage.ny * j;
   pbase = pbase + noff;
   //printf("iframe, j, noff = %d, %d, %d\n", iframe, j, noff);
 }
 //printf("ixp0 = %d, iyp0 = %d, pbase = %#x, FGimage.image = %#x\n",
 //	ixp0, iyp0, pbase, FGimage.image);
 while (nyp--) {
   nn = nxp;
   ps = pbase;
   while (nn--) {
     *ps = *pp++;
     /* add checks on both sides, may be able to relax here by checking ystride
     and xstride outside this loop */
     if ( ps > FGlimit) { printf("**** exceeded FGlimit, %#x, %#x\n", ps, FGlimit);
       return 1; }
     if ( ps < FGimage.image) { printf("**** below start of image, %#x, %#x\n", ps, FGimage.image);
       return 1; }
     ps = ps + ystride;   /* this may go below image on last loop but it is not used */
   }
   pbase = pbase + xstride;
 }

 //printf("FGbyteCountI, FGpixelCountI = %d %d\n", FGbyteCountI, FGpixelCountI);
 //printf("FGbyteCountQUV, FGpixelCountQUV = %d %d\n", FGbyteCountQUV, FGpixelCountQUV);

 /* remove some commented out code here that tried to determine the end of a
 data set. It never worked right because the packet order can vary. See nugu or
 older ungu versions if we ever need to look at this technique again. */
 
 return 0;
 }
 /*------------------------------------------------------------------------- */
int XRTreformat()
 {
 /* XRT data lacks a header packet, if we start w/o the beginning we just use what we get */
 void *XRTname(struct tm *timeobs, int ms, char *dir_name, char *packetpath,
 	int isdark);
 short	*ps, *XRTlimit;
 int	ixp0, iyp0, nb, nframes;
 int	nxp, nyp, nn, side, xstride, ystride;
 short	*pp, *pbase;
 static FITSkey *nextKey;
 struct tm *timeobs;
 int	ms;
 unsigned int XRTtime;
 char *ptype;
 double sbtime_pkt;
 float fac;
 /* XRT has an ID for each image, if this changes and we aren't finished with
 the current one, assume a gap and close the current and begin the new. This will
 obviously not work with scrambled data, it must be time ordered. */
 //printf("XRT reformat, new id = %d, old id = %d\n", ph.xrtheader.info.id, XRTimage.id);
 if ( (XRTimage.id != ph.xrtheader.info.id) || (xrt_in_progress == 0)) {
   /* a new image, initial setups now after closing an old one (if any) */
   printf("new XRT\n");

   if (xrt_in_progress) {
     /* do compression keys */
     nextKey = code_key_i("BYTECNT", XRTbyteCount, nextKey);
     nextKey = code_key_i("PIXCNT", XRTpixelCount, nextKey);
     if (XRTpixelCount > 0) fac = 8.0 * (float) XRTbyteCount/ (float) XRTpixelCount;
       else fac = 0.0;
     nextKey = code_key_g("BITSPP", fac, nextKey);
     printf("new XRT, closing the last one\n");
     if ( XRTclose() ) printf("problem closing XRT file");
   }

   clearKeyList(XRTfitsKeys);
   nextKey = XRTfitsKeys;
   nextKey = code_key_i("SATELLIT", 0X21, nextKey);
   nextKey = code_key_s("TELESCOP", "SOLAR-B", nextKey);
   nextKey = code_key_s("INSTRUME", "XRT", nextKey);
   nextKey = code_key_s("TIMESYS", "UTC (TBR)", nextKey);
   {
    unsigned int MDPclk;
    MDPclk = (((unsigned int) ph.xrtheader.data.e_sclock[0]) << 24) + (((unsigned int) ph.xrtheader.data.e_sclock[1]) << 16) +
    	(((unsigned int) ph.xrtheader.data.e_sclock[2]) << 8) + ((unsigned int) ph.xrtheader.data.e_sclock[3]);
    nextKey = code_key_u("MDP_CLK", MDPclk, nextKey);
   }
   nextKey = code_key_s("FILEORIG", sourceFile, nextKey);
   /* note that XRTimageParams does some setups */
   nextKey = XRTimageParams(nextKey);
   if (nextKey == NULL) {
     /* this is fatal or we get a seg fault, have to abandon */
     xrt_in_progress = 0;	/* this forces a reset on the next packet */
     return 1; }
   nextKey = code_key_i("PCK_SN0", XRTimage.serial_no, nextKey);
   XRTkeyPCK_SN1 = nextKey = code_key_i("PCK_SN1", ph.xrtheader.info.serial_no, nextKey);
   /* 5/30/2005 - count actual # of packets and update XRTkeyNUM_PCKS before write */
   XRTimage.num_packets = 1;
   XRTkeyNUM_PCKS = nextKey = code_key_i("NUM_PCKS", XRTimage.num_packets, nextKey);
   
   /* FITSKEY wasn't used really so take out now 3/27/2006 */
   //nextKey = code_key_s("FITSKEY", xmtextfieldgetstring(fitskey_text), nextKey);
   //nextKey = code_key_s("COMMENT", "test data before flight", nextKey);
   /* allocate for the image */
   nframes = 1;		/* always just one image/frame per file for XRT */
   nb = XRTimage.nx * XRTimage.ny * sizeof(short);
   if (nb > sizeof(XRTimage.image) ) { printf("XRT image illegally large %d\n", nb); return 1; }
   /* use a static array, otherwise the malloc/free cycles use a lot more memory */
   ps = XRTimage.image;
   /* start with zeroes, may want to indicate bad data in another manner */
   bzero(ps, nb);
   /* also zero our pixel and packet size accumulators */
   XRTpixelCount = XRTbyteCount = 0;
   /* load the calendar time, fort XRT we only have the SDTP case */
   {
     int isdark, timeErrFlagHK, timeErrFlagIM, hkTimeSync;
     unsigned int XRTtime, hkTI32, imageTI32;
     double  xq, trim;
     double hkTI, imageTI, ddel, localDel;
     /* the sdtp case only */
     if (sdtp_flag) {
       printf("XRT SDTP time calculation\n");
       /* first check the packet TI times for the image packet and the HK packet we
       want to use for synchronizing the clocks. It won't work if they are
       not close. We get TI based on the S/C times in each case with upper 4 bits
       taken from the CCSDS TI using the function getTI */
       printf("packet TI's are HK %u, IM %u\n", hk0x584.ptime, XRTccsdsti); 
       /* check if we have a valid HK packet, assume not if both items here are 0 */
       if (hk0x584.t_sc_clock  == 0 && hk0x584.ptime == 0) {
         hkTimeSync = 0;
       } else {
         hkTI32 = getTI(hk0x584.t_sc_clock, hk0x584.ptime, &timeErrFlagHK);
         hkTimeSync = 1  /* good so far, another opportunity to fail below */;
       }
       imageTI32 = getTI(e_sclock32, XRTccsdsti, &timeErrFlagIM);
       /* these should be actual times that correspond to the local times in
       the 2 packets. So we can use them to estimate rollovers if necessary. We
       expect the image packet to be later. */
       imageTI = (double) imageTI32;
       if (hkTimeSync) {
	 hkTI = (double) hkTI32;
	 /* these TI times have a lsb of 1/32 s and a range of 4.25 years */
	 ddel = imageTI - hkTI;
	 printf("XRT imageTI - hkTI = %fs\n", ddel/32.);
	 /* check for rollover if a very large difference ( > 1 year) */
	 if (ABS(ddel) >  1.073742E+09) {
           /* this is very unlikely for a given image but will happen someday */
	   if (imageTI > hkTI) hkTI += 4294967296.0; else imageTI += 4294967296.0;
	   /* and recompute ddel */
	   ddel = imageTI - hkTI;
	 }
	 /* these can be in any time order because the IM packet output header may
	 be delayed while the image is exposed and processed.\
	 Are they close? be generous and  allow 10 min (note that the wrap time for the
	 24 bit local clock is only 28 minutes) */
	 if (ABS(ddel) > 19200.0) {
           /* this is a problem, our HK packet is not very close in time */
           printf("**** XRT HK packet not temporally close to XRT image packet? HKTI, imageTI = %d, %d\n",
	     hkTI32, imageTI32);
           fprintf(stderr, "**** XRT HK not temporally close to XRT image packet? HKTI, imageTI = %d, %d\n",
	     hkTI32, imageTI32);
	   /* and we try Plan B */ 
	   hkTimeSync = 0;
	 }
	 /* assuming that we are within 10m of the HK ref time, there should be no more than
	 one rollover between the ref internal clock (%2^24) and the exposure command local clock
	 e_lclock24 is the 24 bit local time for the expose command, there is also a shutter
	 open and close available that could be used the same way. */
	 //printf("local clocks %u  %u  %u\n", e_lclock24, hk0x584.t_lo_clock, hk0x584.t_lo_clock & 0x00ffffff);
	 printf("local clocks e:%u  open:%u  lo:%u  lo24:%u\n", e_lclock24, e_shopenlocal24, hk0x584.t_lo_clock, hk0x584.t_lo_clock & 0x00ffffff);
	 /* 1/17/2007 -  had a bug in here earlier that applied the offset in the wrong
	 direction when the HK (used for reference time) was later than the image packet. This
	 is the usual situation for quicklook and perahps even Sirius. */
	 /* 1/19/2007 - we can base the time on the expose or the shutter open local clock, we have the expose
	 option commented out and use the shutter open now */
         //localDel = (double) e_lclock24  - (double) (hk0x584.t_lo_clock & 0x00ffffff);
         localDel = (double) e_shopenlocal24  - (double) (hk0x584.t_lo_clock & 0x00ffffff);
	 /* localDel can be < 0, and often is because the nearest HK packet usually has
	 a later time tag. If localDel is not the same sign as ddel, we may have a rollover. */
	 printf("XRT localDel = %20.1f, in second that is %10.3f\n", localDel, localDel * 1.E-4 );
	 if ( (ddel < 0.0 && localDel > 0.0) || (ddel > 0.0 && localDel < 0.0) ) {
           /* a potential rollover? */
	   if (ABS(localDel) > 9.0E6) {
	     /* > 15m so assume rollover and add 2^24 */
	     printf("**** XRT  local clock rollover? localDel, ddel = %20.1f, %20.1f\n",localDel, ddel);
	     if (ddel > 0.0) localDel = localDel + 16777216.0; else localDel = localDel - 16777216.0;
	   } else {
	     /* complain but just leave */
	     printf("**** XRT unexpected local clock difference? e_shopenlocal24, hk0x584.t_lo_clock = %d, %d\n",
	       e_shopenlocal24, hk0x584.t_lo_clock);
	     fprintf(stderr, "**** XRT unexpected local clock difference? e_shopenlocal24, hk0x584.t_lo_clock = %d, %d\n",
	       e_shopenlocal24, hk0x584.t_lo_clock);
	   }
	 }
  printf("localDel is: %f,\n", localDel);
	 /* our time is now hkTI32 + leftover bits + localDel, compute and then
	 truncate into a TI time and add any leftovers (<1/32 s) for OBS_TIME */
  	 localDel = localDel * 32./10000.;
// printf("local#00 is: %f\n", localDel);
         trim = ((double) (hk0x584.t_sc_clock & 0xf));
 //printf("trim     is: %f\n", trim);
         trim = trim/16.;
// printf("trim/16  is: %f\n", trim);
   	 localDel = localDel + trim;
  //printf("local #2 is: %f\n", localDel);
	 /* note we have converted localDel to TI units of 1/32s
	 normally we could just add this to hkTI32 time now but there are some
	 infrequent but messy possibilities */
	 hkTI = (double) hkTI32;  /* because it may have been changed above for rollover compare */
	 if (localDel < 0.0) {
            if ( (localDel + hkTI) < 0.0) {
	      /* this means that we have a negative localDel and hkTI32 just rolled,
	      just add 2^32 to localDel here to get the proper pre-rollover value */
	      localDel += 4294967296.0;
	    }
	 }
       } 
  //printf("local #3 is: %f\n", localDel);
       /* we might be using Plan B if the HK synch didn't work out above */
       if (hkTimeSync) {
	 /* this is plan A */
	 XRTtime = (unsigned int) (hkTI + localDel);
	 /* also get the fractional part of 1/32s to contribute to ms later, this redefines localDel */
	 localDel = (hkTI + localDel) - (double) XRTtime;
	 //printf("before nextKey:XRTtime, localDel = %u, %f\n", XRTtime, localDel);
	 nextKey = code_key_i("HKTSYNC", 1, nextKey);	 
	 //printf("after nextKey: XRTtime, localDel = %u, %f\n", XRTtime, localDel);
       } else {
	 XRTtime = (unsigned int) (imageTI);
         localDel = 0.0;
	 fprintf(stderr, "**** XRT - no HK synch for observation time, using e_sclock\n");
	 printf("**** XRT - no HK synch for observation time, using e_sclock\n");
	 nextKey = code_key_i("HKTSYNC", 0, nextKey);	 
       }
       
// printf("before SB_Time_Convert, XRTtime, sb_time_0 = %u, %20.1f\n", XRTtime, sb_time_0);
       sb_time_0 = XRTtime/32.0;
       sb_time_0 = sb_time_0 - sb_time_0*6.95263888075869e-06 + 212176146.475454;
       sbtime_pkt = SB_Time_Convert(XRTtime, sb_time_0); /* + 946684800.0; */
       if (!finite(sbtime_pkt)) {
         printf("got a nan or infinity from SB_Time_Convert, XRTtime, sb_time_0 = %u, %20.1f\n",
	   XRTtime, sb_time_0);
         fprintf(stderr, "got a nan or infinity from SB_Time_Convert, XRTtime, sb_time_0 = %u, %20.1f\n",
	   XRTtime, sb_time_0);
       } else {
// printf("good SB_Time_Convert, XRTtime, sb_time_0 = %u, %20.1f\n", XRTtime, sb_time_0);
       }
       
       
       sbtime_pkt = SB2UT(sbtime_pkt);   /* sbtime_pkt is now UTC */
       sbtime_pkt = sbtime_pkt + localDel/32.0;   /* add the extra fraction here */
       /* we assume that since the input to SB_Time_Convert has lsb of 1/32 s,
       the output has a similar "accuracy", but we also have some fraction
       of 1/32 that we carried earlier, so we have 2 parts for ms */
       XRTtime = (unsigned int) sbtime_pkt;  /* now in integer seconds */

//printf("XRTtime is: %d, ccsdsti: %d (new timeRef method)\n", XRTtime, XRTccsdsti);
       //xq = (float) ( (XRTccsdsti) & 0x1f ) *(1000./32.);
       xq = sbtime_pkt -  (double) XRTtime;
//printf("XRT - fractions are %f, %f\n", xq, localDel/32.0);
	/* we now add the extra fraction in before the truncation */
//       xq = xq + localDel/32.0;
//        /* we could have gone over 1, so have to check */
//        if (xq >= 1.) {
//           xq = xq - 1.0;
// 	  XRTtime++;
// 	  /* XRTtime won't rollover for a while, it is Unix time */
//        }
       ms = (int) (1000. * xq + 0.5);
       if (ms == 1000) { ms = 0;  XRTtime++; }
       /* ISAS time method (use in production) */
       //ms = (int) (1000.0*(sbtime_pkt - XRTtime) );
     } else {
       printf("internal XRT error, sdtp_flag not set?\n");
       exit(2);
     }
     timeobs = gmtime( (time_t *) &XRTtime);
     /* load the various calendar time keys*/
     nextKey = loadCalendarKeys(timeobs, ms, nextKey);
     XRTfixFWkey(XRTtime);
     isdark = ph.xrtheader.data.ec_imtype;
     /* construct file name, changed 1/15/2004 to use dates/times for paths */
     XRTname(timeobs, ms, dir_name_XRT, packetpath, isdark);
     
     /* the DATE_END is just the shutter close time, we can compute that by just
     adding the close - open local clocks (checking for rollover) and adding the
     results in seconds to sbtime_pkt and recomputing an integer time and ms component,
     this duplicate code in loadCalendarKeys() done for the DATE_OBS key */
     xq = e_shcloselocal24 - e_shopenlocal24;
     if (xq < 0.0) xq = xq + 16777216.0;  /* must be a rolloover */
     sbtime_pkt = sbtime_pkt + xq * 1.E-4;
     XRTtime = (unsigned int) sbtime_pkt;  /* now in integer seconds */
     /* get ms part, a bit easier than above because no extra part from localDel */
     xq = sbtime_pkt -  (double) XRTtime;
     ms = (int) (1000. * xq + 0.5);
     if (ms == 1000) { ms = 0;  XRTtime++; }
     timeobs = gmtime( (time_t *) &XRTtime);
     {
       /* similar to code in loadCalendarKeys() */
       char text[32];
       strftime(text, 20, "%Y-%m-%dT%T", timeobs);
       sprintf(&text[19],".%03dZ", ms);
       nextKey = code_key_s("DATE_END", text, nextKey);
     }
    
   }
   xrt_in_progress = 1;
 }

 /* continuing on a XRT image, load the packet into the image */

 /* check that the full image size is consistent with the header we got */
 if (XRTimage.nx != ph.xrtheader.info.nx || XRTimage.ny != ph.xrtheader.info.ny) {
    printf("skipping a XRT packet because XRT packet doesn't match header\n");
    printf("%d x %d vs %d x %d\n", XRTimage.nx, XRTimage.ny, ph.xrtheader.info.ny,ph.xrtheader.info.nx);
    return 1; }
 ixp0 = ph.xrtheader.info.x0;
 iyp0 = ph.xrtheader.info.y0;
 XRTimage.num_packets++;
 XRTimage.serial_no = ph.xrtheader.info.serial_no;
 
 nxp = ph.xrtheader.info.nxp;
 nyp = ph.xrtheader.info.nyp;
 XRTbyteCount += psizeCompressed;
 XRTpixelCount += nyp*nxp;
 pp = (short *) packdata1;
 /* only one side for XRT, note that ixp0 should always be 0 */
 pbase = XRTimage.image + iyp0*XRTimage.nx + ixp0;
 XRTlimit = XRTimage.image + sizeof(XRTimage.image);
 /* presently, we are assuming that XRT is loaded in normal x/y order, this may face
 a different reality later. Hence we don't need xstride and ystride (yet). */
 /* to handle XRT images readout in reverse order, flip in x axis here. We
 assume each packet has the full extent in x. */
 ps = pbase;
 if (XRTflipFlag) {
   /* reversed, left read, we start on RHS and decrease in each row */
   pbase = pbase - 1;
   while (nyp--) {
     pbase = pbase + nxp;
     ps = pbase;
     nn = nxp;
     while (nn--) {
       if ( ps > XRTlimit) { printf("**** exceeded XRTlimit, %d, %d\n", ps, XRTlimit);
       *ps-- = *pp++;
	 return 1; }
     }
   }
 } else {
   /* normal, right read */
   while (nyp--) {
     nn = nxp;
     while (nn--) {
       *ps++ = *pp++;
       if ( ps > XRTlimit) { printf("**** exceeded XRTlimit, %d, %d\n", ps, XRTlimit);
	 return 1; }
     }
   }
 }
 return 0;
 }
 /*------------------------------------------------------------------------- */
int SPreformat(int mode)
 /* mode is 2 for a header packet, 1 for a start packet and 0 for continuing */
 {
 short	*ps;
 int	ixp0, iyp0, noff;
 int	nxp, nyp, nn, xstride, ystride;
 short	*pp, *pbase;
 static FITSkey *nextKey, *keyCCDSIDE, *keyPRODUCT;
 static int sideCheck1, sideCheck0;
 struct tm *timeobs;
 int ms, slitIndex;
 short commandedSlitPosition;
 char *kw_str;
 double sbtime_pkt;
 MDP0x428 hk0x428;
 float xsun, ysun, xcen, ycen, crpix1, crpix2, fac, sat_rot, ftmp;
 static	int needVer1, needVer2;

 /* get latest MDP HK data */
 get_mdp_hk(&hk0x428);

 /* mode will be 0 for a packet that continues a frame, it will be 2 for
 the header packet that initiates a new observing set (e.g., a IQUV set
 for SP or a raw SP image), it will be 1 for the first packet in an
 image frame. For the 4D files, we start a new file for each mode = 2
 but if the header packet is missing, we should still be able to make a
 file but we will lack the header info of course. */
 if (mode) {
   int ixc, iyc, nb, xq, i, nframes;
   float	pixscale, scanscale;
   //printf("SPreformat, mode = %d\n", mode);
   /* starting a new SP image */
  // printf("sp_start_exists = %d\n", sp_start_exists);
   if (sp_start_exists && mode == 1) goto imageprocess;
   if (sp_in_progress) {
     printf("new SP, closing the last one\n");
     nextKey = SPwrapup(nextKey);
     if ( SPclose() ) printf("problem closing SP file");
   }
   /* free the last image header extension */
// if (SPextension) free(SPextension);
   if (SPxalloc) { free(SPextension); SPxalloc = 0; }
   /* at this point we are doing the first packet of a new file, it would
   normally be a image header packet (mode 2) but if this is missing, it
   might be a mode 1. Things that require the image header have to check the
   mode */
   
   /* indicate that we don't yet have the compression serial (version) numbers */
   needVer1 = needVer2 = 1;
   
   /* get image size, we assume that the current packet is our SP */
   SPimage.nw = ph.pheader.info.ny;	/* note x/y interchange */
   SPimage.ny = ph.pheader.info.nx;	/* this is N/S on sun */
   SPimage.ix0 = sp_ix0;
   SPimage.ix1 = sp_ix1;
   SPimage.iy0 = sp_iy0;
   SPimage.iy1 = sp_iy1;
   SPimage.side = ph.pheader.info.subIdCCDseg;
   SPimage.slit_positions = currentSPmacroCommand.parameters.slit_positions;
   xq = currentSPmacroCommand.parameters.bin_slit;
   SPimage.bin_slit = 1 << xq;
   SPimage.scan_step = currentSPmacroCommand.parameters.scan_step + 1;
   xq = currentSPmacroCommand.parameters.scan_sum;
   SPimage.scan_sum = 1 << xq;
   SPimage.repeat_flag = currentSPmacroCommand.parameters.repeat_flag;
   SPimage.CCD_size = currentSPmacroCommand.parameters.CCD_size;
   sideCheck1 = sideCheck0 = 0;
   SPimage.extract_table = currentSPmacroCommand.parameters.extract_table;
   SPimage.cycles = currentSPmacroCommand.parameters.cycles + 1;
   SPimage.nsides = currentSPmacroCommand.parameters.CCD_size + 1;
   /* the subId in the header is only important if it is RAW */
   SPimage.subId = (int) ph.pheader.info.subIdProduct;
   SPimage.num_frames = nframes = ph.pheader.info.num_frames;
   /* to handle a bug that caused the header frame not to be counted in some */
   if (nframes == 4 || nframes == 8) nframes = nframes + 1;
   nb = SPimage.nw * SPimage.ny * sizeof(short);
   if (nb > (1040*448*2)) { printf("illegally large SP image %d\n", nb);  return 1; }
   ps = SPimage.image;
   /* for the 4D images, zero all sets here, how many depends on the frame count */
   nb = nb * (nframes - 1);
   /* check for bad values here since we don't want to zero something else */
   if (nb <= 0 || nb > sizeof(SPimage.image)) {
     printf("illegally sized SP product, nb, nframes = %d, %d\n", nb,nframes);
     return 1;
   }
   /* start with zeroes, may want to indicate incomplete data in another manner */
   bzero(ps, nb);
   /* in spite of the name,  bin_slit is really a summing parameter, pixscale
   is the spatial pixel size in the N/S direction (along the slit),
   spatial scale from Bruce Lites, 10/1/2006 */
   pixscale =  0.1585 * (float) SPimage.bin_slit;
   /* 0.16 is the design slit step size, the actual needs to be put here after
   we get an accurate measure of it, the average slit scan step size from Bruce Lites 10/1/2006 */
   scanscale = 0.1476 * SPimage.scan_step;
   /* also, if we are summing 2 slit positions, double this */
   if (SPimage.scan_sum) scanscale = SPimage.scan_sum * scanscale;
   ixc = currentSPmacroCommand.map_reg.map_center;
   iyc = 0;
   /* no image data to load from the header */
   SPimage.id = ph.pheader.info.id;
   SPimage.serial_no = ph.pheader.info.serial_no;
   /* since the header is a separate frame, we can't use the num_packets in headers
   for the images, so set it to 0 for headers and then use the first image packet
   to get the packets/image */
   SPimage.num_packets = 0;
   /* if the header is missing we'll have to do something else */
   clearKeyList(SPfitsKeys);
   nextKey = SPfitsKeys;
   /* looks like a good time to stash the image header for the extension, although already
   copied once into SPheaderpackdata1, it might still get cobblered by an out of place
   header before we have a chance to do the final write. Note that we set SPextensionSize
   earlier when we had psize handy. */
   /* if this is a littleendian system, the copy made to FGheaderpackdata1 has already been
   modified but packdata1 should still be an unchanged copy at this point. So use it for
   the extension copy here. */
   if (mode == 2) {
     //printf("SP - mode = 2\n");
     SPextensionSize = SPheaderSize;
     SPextension = malloc(SPextensionSize);
     SPxalloc = 1;
     bcopy((char *) packdata1, (char *) SPextension, SPextensionSize);
     /* add the EXTEND key, this can be anywhere in the primary header */
     nextKey = code_key_s("EXTEND", "T", nextKey);
   } else SPextensionSize = 0;
   nextKey = code_key_s("TELESCOP", "SOLAR-B", nextKey);
   nextKey = code_key_s("INSTRUME", "SOT/SP", nextKey);
   nextKey = code_key_u("MDP_CLK", ph.pheader.data.packet_time, nextKey);
   
   /* obsPlanKeys is used for all data products */
   nextKey = obsPlanKeys(nextKey, &currentSPmacroCommand.mdp_obs);

   nextKey = code_key_s("FILEORIG", sourceFile, nextKey);
   /* for SP we want CRPIX2 and 1 where 2 is solar N/S and 1 is the wavelength dimension
   but we also do the solar X as well as Y for xcen and ycen. */
   /* CRPIX1 is in the wavelength direction, the wavelength changes with velocity */
   nextKey = code_key_g("CRPIX1", 112.5 - (float) SPimage.iy0, nextKey);
   crpix2 = (float) (sp_ix1 - 511)/ ((float) SPimage.bin_slit) + 0.5;
   nextKey = code_key_g("CRPIX2", crpix2, nextKey);
   /* note that the 3rd and 4th "axis" or dimensions here are groupings of images,
   hence we do do not define CRPIX3/4, CRVAL3/4, CDELT3/4 although we do put in
   a description in CTYPE3/4 */
   if (dkw) nextKey = code_key_x("UFSS_AB", hk0x428.byte211, nextKey);
   xsun = get_xhelio();		ysun = get_yhelio();  /* we need these more than once */
   /* for SP the first dimension is wavelength and CRVAL1 would shift with orbital
   velocity. This correction is not done here (but might be?) and we just have a nominal
   wavelength value that is not very accurate yet. */
   nextKey = code_key_g("CRVAL1", 6302.0, nextKey);
   nextKey = code_key_g("CRVAL2", ysun, nextKey);
   nextKey = code_key_g("CDELT1", -22.13, nextKey);
   nextKey = code_key_g("CDELT2", pixscale, nextKey);
   nextKey = code_key_s("CUNIT1", "Angstrom", nextKey);
   nextKey = code_key_s("CUNIT2", "arcsec", nextKey);
   nextKey = code_key_s("CTYPE1", "Wavelength", nextKey);
   nextKey = code_key_s("CTYPE2", "Solar-Y", nextKey); 
   nextKey = code_key_s("CTYPE3", "CCD side", nextKey);
   nextKey = code_key_s("CTYPE4", "Stokes component", nextKey);
   sat_rot = get_att_z();
   ftmp = sat_rot + 0.0;
   nextKey = code_key_g("SAT_ROT", sat_rot, nextKey);
   nextKey = code_key_g("INST_ROT", 0.0, nextKey);
   nextKey = code_key_g("CROTA1", ftmp, nextKey);
   nextKey = code_key_g("CROTA2", ftmp, nextKey);

   nextKey = code_key_g("YSCALE", pixscale, nextKey);
   /* for the SP, the x scale, defined as E/W on the sun, relates to the slit scan step
   anf the FOVX is the spatial width of the current slit scan, note that x and y on the
   sun are not (of course) the 2 diemnsions of the images here */
   nextKey = code_key_g("XSCALE", scanscale, nextKey);
   nextKey = code_key_g("FOVX", scanscale * SPimage.slit_positions, nextKey);
   nextKey = code_key_g("FOVY", pixscale * SPimage.ny, nextKey);
   switch (hk0x428.tr_mode) {
     case 0: kw_str = "FIX"; break;
     case 1: kw_str = "TR1"; break;
     case 2: kw_str = "TR2"; break;
     case 3: kw_str = "TR3"; break;
     case 4: kw_str = "TR4"; break;
     default: kw_str = "INVALID"; break;
   }
   nextKey = code_key_s("TR_MODE", kw_str, nextKey);
   /* XCEN and YCEN are the solar coordinates of the center of the image, these
   are computed from the solar position for our N/S reference pixel (the CCD vertical
   center) and the slit offset from 0. We assume the slit center has no offset from
   the S/C. We will have offsets and they won't be the same as FG. */

   /* we can't compute a value for xcen unless we have an image header and hence
   the slit position, so we might not have a xcen for a partial SP image. Move the
   commandedSlitPosition calculation here so we can do xcen */
   if (mode == 2) {
     if (SPinfoHdr->n > 0) {
       short *p;
       p = ( (short *) SPinfoHdr + sizeof(SPinfo));
       /* from Ankur's version, modified 4/3/2006 */
#if linux | LITTLEENDIAN
       swapb((char *)&p[8],2);
#endif
        commandedSlitPosition = p[8];
     } else {
       /* if no PMU cycles, take the other value. This happens for raws. */
       commandedSlitPosition = SPinfoHdr->slitPosition;
     }
     /* assuming that + slit position is West on Sun, may have to change this. */
     xcen = ((float) commandedSlitPosition) * scanscale + xsun;
     nextKey = code_key_g("XCEN", 0.0, nextKey);
   }
    
   ycen = ((float) SPimage.ny/2 + 0.5 - crpix2) * pixscale + ysun;
   nextKey = code_key_g("YCEN", ycen, nextKey);
   nextKey = code_key_i("SPMAPCTR", ixc, nextKey);
   //nextKey = code_key_i("SPYOFF", iyc, nextKey);
   nextKey = code_key_i("SPCCDIX0", SPimage.ix0, nextKey);
   nextKey = code_key_i("SPCCDIX1", SPimage.ix1, nextKey);
   nextKey = code_key_i("SPCCDIY0", SPimage.iy0, nextKey);
   nextKey = code_key_i("SPCCDIY1", SPimage.iy1, nextKey);
   nextKey = code_key_i("MACROID", SPimage.id, nextKey);
   nextKey = code_key_i("PCK_SN0", SPimage.serial_no, nextKey);
   SPkeyPCK_SN1 = nextKey = code_key_i("PCK_SN1", ph.pheader.info.serial_no, nextKey);
   /* 5/30/2005 - count actual # of packets and update keyNUM_PCKS before write */
   SPimage.num_packets = 1;
   SPkeyNUM_PCKS = nextKey = code_key_i("NUM_PCKS", SPimage.num_packets, nextKey);
   nextKey = code_key_i("NSLITPOS", SPimage.slit_positions, nextKey);
   /* the slit index is computed from the frame counter and the # of frames
   for each position */
   slitIndex = ph.pheader.info.main_seq_count/nframes;
   nextKey = code_key_i("SLITINDX", slitIndex, nextKey);
   /* we don't have the map index yet */
   nextKey = code_key_i("SPMAPINX", 0, nextKey);
   //keyCCDSIDE = nextKey = code_key_i("CCDSIDE", SPimage.side, nextKey);
   nextKey = code_key_i("NUM_SIDE", 1 + SPimage.CCD_size, nextKey);
   nextKey = code_key_s("WAVE", "6302A", nextKey);
   nextKey = code_key_i("SPNINT", SPimage.cycles, nextKey);
   nextKey = code_key_i("SP_EXTID", SPimage.extract_table, nextKey);
   nextKey = code_key_i("SCN_STEP", SPimage.scan_step, nextKey);
   nextKey = code_key_i("SCN_SUM", SPimage.scan_sum, nextKey);
   nextKey = code_key_i("SCN_RPT", SPimage.repeat_flag, nextKey);
   nextKey = code_key_i("SPBSHFT", currentSPmacroCommand.parameters.scales, nextKey);

   //{ char *q1 = product_string((int) ph.pheader.info.subIdProduct);
   //  keyPRODUCT = nextKey = code_key_s("PRODUCT", q1, nextKey);
   //  free(q1); }
   /* 6/3/2005 - change PRODUCT to OBS_TYPE */
   if (SPimage.subId == DPC_SP_RAW) keyPRODUCT = code_key_s("OBS_TYPE", "SP raw", nextKey);
   	else keyPRODUCT = code_key_s("OBS_TYPE", "SP IQUV 4D array", nextKey);

   /* stick the compression keywords here, move if this isn't a good place */
   /* 9/6/2006 - the compression parameters are taken from the MC, we use a
   common module for both FG and SP by passing the MC structure appropiate
   to each */
 
   nextKey = compressionKeys((fg_macro_command *) &currentSPmacroCommand, nextKey);

   /* load the calendar time */
   {
     unsigned int SPtime, MDPatCTref, CTref, ctStart, phaseStart;
     float  xq;
     void *SPname(struct tm *timeobs, int ms, char *dir_name, char *packetpath);
     int	SPti, ccsds28, dt;
     double xdt, ctrate = 584.0;
     MDPatCTref = SPinfoHdr->MDPclock;
     CTref = SPinfoHdr->CTcounter;
     nextKey = code_key_i("MDPCTREF",MDPatCTref, nextKey );
     nextKey = code_key_i("CTREF",CTref, nextKey );
     nextKey = code_key_g("CTRATE",ctrate, nextKey );
     /* also the sdtp case 11/21/2004 */
     if (sdtp_flag) {
       printf("SP SDTP time calculation\n");
       /* the SP starts integrating on the second PMU cycle in the image extension.
       But first we get the top bits of SPinfoHdr->MDPclock in the same way done
       for the FG. We could make this a module. */
       SPti = ((MDPatCTref) >> 4 ) & 0x0fffffff;
       ccsds28 = FPPccsdsti & 0x0fffffff;
       printf("SPti and ccsds28 = %d, %d\n", SPti, ccsds28);
       if (SPti > ccsds28) {
         /* probably a rollover but do a sanity check */
	 dt = SPti - ccsds28;  /* dt should be a fairly large + value */
	 printf("**** rollover between FPPccsdsti and SPti, dt = %d\n", dt);
	 if (dt > 0x00ffffff) {
	   SPti = SPti | (FPPccsdsti & 0xf0000000) + 0x10000000;
	   /* this will rollover in 4 years so please figure out what to do
	   in that case before then! */
	   nextKey = code_key_i("TIMEERR",0, nextKey );
	 } else {
	   /* this is unreasonable, just take the  FPPccsdsti time and set
	   the bad exposure time flag */
	   SPti = FPPccsdsti;
	   nextKey = code_key_i("TIMEERR",1, nextKey );
	 }
       } else {
         /* this is expected situation, take the upper bits from FPPccsdsti */
	 SPti = SPti | (FPPccsdsti & 0xf0000000);
	 /* dt should be small here, if it is very large we might have
	 something weird going on. Check for weirdness. */
	 dt = ccsds28 - SPti;
	 if (dt > 0x00ffffff) {
	   printf("**** strange dt = ccsds28 - SPti = %d\n", dt);
	   nextKey = code_key_i("TIMEERR",1, nextKey );
	 } else nextKey = code_key_i("TIMEERR",0, nextKey );
       }
       /* so we have the TI time which has LSB of 1/32 s, use it to get the
       sbtime_pkt time. Remember this is not the start of exposure yet. */
       sb_time_0 = SPti/32.0;
       sb_time_0 = sb_time_0 - sb_time_0*6.95263888075869e-06 + 212176146.475454;
       sbtime_pkt = SB_Time_Convert(SPti, sb_time_0); /* + 946684800.0; */
       if (!finite(sbtime_pkt)) {
         printf("got a nan or infinity from SB_Time_Convert, SPti, sb_time_0 = %u, %20.1f\n",
	   SPti, sb_time_0);
         fprintf(stderr, "got a nan or infinity from SB_Time_Convert, SPti, sb_time_0 = %u, %20.1f\n",
	   SPti, sb_time_0);
       }
       /* add back in the fraction of a second that we masked out (the lower
       4 bits of MDPatCTref). We assume a fixed rate here. */
       sbtime_pkt  += (double) (MDPatCTref & 0xf)/512.;
       getFirstSPintegration(SPinfoHdr, &ctStart, &phaseStart);
       printf("CTref, ctStart, phaseStart = %d, %d, %d\n", CTref, ctStart, phaseStart);
       if (CTref <= ctStart) {
	 dt = ctStart - CTref;
	 xdt = (double) dt / ctrate;	/* the offset in seconds */
       } else {
	 /* this is probably a rollover */
	 dt = CTref - ctStart;	/* this should be very large if a rollover */
	 if (dt > 0x00ffffff) {	/* assume rollover */
	   xdt = 4294967296.0 - (double) ctStart + (double) CTref;
	 } else {
	   printf("bad dt? = %d\n", dt);
	   xdt = 0.0;
	 }
       }
       printf("xdt for SP = %g s\n", xdt);
       sbtime_pkt = sbtime_pkt + xdt;	/* our time of first exposure */      
       SPtime = (unsigned int) sbtime_pkt;
       xq = (sbtime_pkt - (double) SPtime) * 1000.;
       SPtime = SPtime + 946684800;   /* for Unix offset */
       //xq = (float) ( (FPPccsdsti) & 0x1f ) *(1000./32.);
       ms = (int) (xq + 0.5);
       if (ms == 1000) { ms = 0;  SPtime++; }
     } else {
       SPtime = ((SPinfoHdr->MDPclock) >> 9 ) & 0x007fffff;
       SPtime = SPtime | ( (unsigned int) (SPinfoHdr->MDPclockHigh) << 23);
       timeRefCheck(&SPtime);
       /* also compute milli seconds from MDPclock */
       xq = (float) ( (SPinfoHdr->MDPclock) & 0x1ff ) *(1000./512.);
       ms = (int) (xq + 0.5);
       if (ms == 1000) { ms = 0;  SPtime++; }
     }
     timeobs = gmtime( (time_t *) &SPtime);
     /* load the various calendar time keys*/
     nextKey = loadCalendarKeys(timeobs, ms, nextKey);
     /* construct file name, changed 1/15/2004 to use dates/times for paths */
     SPname(timeobs, ms, dir_name, packetpath);
   }

   /* these items need an image header so don't do unless we have a mode 2 */
   if (mode == 2) {
     /* 6/3/2005 - remove the GCUCONFG keyword, this was for ground calibrations */
     //nextKey = code_key_i("GCUCONFG",SPinfoHdr->gcuconfig, nextKey );
     nextKey = code_key_i("ROISTART",SPinfoHdr->roiStart, nextKey );
     nextKey = code_key_i("ROISTOP",SPinfoHdr->roiStop, nextKey );
     nextKey = code_key_i("DOPVUSED",SPinfoHdr->v, nextKey );
     {  /* camera parameters */
       CONFIG  SPconfig;
       int dacA, dacB, psum, ssum;
       bcopy(&SPinfoHdr->cameraConfig, &SPconfig, 2);
       dacA = ((SPinfoHdr->dac) >> 5) & 0x1f;   dacB = (SPinfoHdr->dac) & 0x1f;
       psum = 1 << (SPconfig.bits.ParSum);  ssum = 1 << (SPconfig.bits.SerSum);

       nextKey = code_key_i("CAMGAIN",SPconfig.bits.Gain, nextKey );
       nextKey = code_key_i("CAMDACA",dacA, nextKey );
       nextKey = code_key_i("CAMDACB",dacB, nextKey );
       nextKey = code_key_i("CAMPSUM",psum, nextKey );
       nextKey = code_key_i("CAMSSUM",ssum, nextKey );
       nextKey = code_key_i("CAMAMP",SPconfig.bits.PreAmp, nextKey );
       nextKey = code_key_i("CAMSCLK",SPconfig.bits.SerClk, nextKey );
     }
     nextKey = code_key_i("SLITPOS", commandedSlitPosition, nextKey);
     /* 5/29/2005 - call it SLITENC (slit encoder) instead of SLIT to
     further avoid confusion */
     /* 4/14/2005 - SLIT is redefined, see note below, also add 2048
     to restore it to an encoder value. I did this to help people
     avoid it, otherwise it was usually the same as SLITPOS which might
     cause someone to use it instead of SLITPOS */
     nextKey = code_key_i("SLITENC",SPinfoHdr->slitPosition + 2048, nextKey );
     {
       /* some parameters from the HK snapshot, because we don't get this for
       each SP image, we have to use the "last" one. Also we repeat a lot of work
       here that should be done just once for a set of images. Actually this is
       better now that we do a complete set of IQUV for each file. */
       struct MMSTAT2  mm2;
       unsigned char *p;
       short statBuffer;

       hkStat = (HKstatusData *) SPheaderpackdata1;
       //nextKey = code_key_s("COMMENT", "data from HK status 2", nextKey);
       p = (unsigned char *) &hkStat->status2[0] + 108;
       /* the ctme status word */
    /*   bcopy(p, (char *) &statBuffer, 2); */
       statBuffer = (((unsigned int)p[0]) << 8) | (unsigned int) p[1]; /* endian independent equivalent */
       /* Also pull out a simple 0/1 keyword for servo on, for reference the bits are:
       15:servo, 14:reserved, 13:op in progress, 12:auto, 11:error, 10,9,8:soft out of ranges,
       7,6,5: hard limits, 4,3,2,1,0: reserved
       see Chapter 7 of EICA for more details */
       nextKey = code_key_i("CTSERVO", (((unsigned int) statBuffer) >> 15) &0x1, nextKey);
       nextKey = code_key_i("CTMESTAT",(unsigned int) statBuffer, nextKey);
       /* we also want CTME-2 and 3 (aka X and Y), each is also a 16 bit value and we process
       in an endian independent manner */
       p = (unsigned char *) &hkStat->status2[0] + 110;   /* note 64 less than value in fppem4_v00.160 */
       statBuffer = (((unsigned int)p[0]) << 8) | (unsigned int) p[1]; /* endian independent equivalent */
       nextKey = code_key_i("CTMEX", (int) statBuffer, nextKey);

       p = (unsigned char *) &hkStat->status2[0] + 112;   /* note 64 less than value in fppem4_v00.160 */
       statBuffer = (((unsigned int)p[0]) << 8) | (unsigned int) p[1]; /* endian independent equivalent */
       nextKey = code_key_i("CTMEY",( int) statBuffer, nextKey);

       /* the CT mode */
       p = (unsigned char *) &hkStat->status2[0] + 6;
    /*   bcopy(p, (char *) &statBuffer, 2); */
       statBuffer = (((unsigned int)p[0]) << 8) | (unsigned int) p[1]; /* endian independent equivalent */
       nextKey = code_key_i("CTMODE", (unsigned int) statBuffer, nextKey);
       /* 12/7/2006 - add a DOP_RCV keyword, this is the FPP_DOP_VEL_RCV from status 2 */
       p = (unsigned char *) &hkStat->status2[0] + 25;   /* note 64 less than value in fppem4_v00.160 */
       statBuffer = (((unsigned int)p[0]) << 8) | (unsigned int) p[1]; /* endian independent equivalent */
       nextKey = code_key_i("DOP_RCV", (int) statBuffer, nextKey);

       /* look at mechs, copy into mm2 for alignment */
       p = (unsigned char *) &hkStat->status2[0] + 139;
       bcopy( p, (char *) &mm2, 30);
    /* from Ankur's version */
#if linux | LITTLEENDIAN
       mmstat2_fix((struct MMSTAT2 *) &mm2);
#endif
       /* decode the temperatures, these are put into a common array alltemps */
       p = (unsigned char *) &hkStat->status3[0];
       /* the temperatures are put in alltemps. Since we can only process
       one image header packet at a time, there is only one set shared by
       FG and SP */
       getTemperatures(p);
       /* the SLIT value from the HK snapshot is confusing since it is not
       in synch with the slit motions, hence use SLIT for the encoder position
       read after each slit motion */
       //nextKey = code_key_i("SLIT",mm2.LM_DevPos[0], nextKey );
       nextKey = code_key_i("WEDGE",mm2.CM_DevPos[2] , nextKey);
       /* add focus for matching with FG images (focus does not affect SP) */
       nextKey = code_key_i("FOCUS",mm2.LM_DevPos[1], nextKey );
       nextKey = code_key_g("T_SPCCD", alltemps[32], nextKey);
       nextKey = code_key_g("T_FGCCD", alltemps[33], nextKey);
       nextKey = code_key_g("T_CTCCD", alltemps[34], nextKey);
       nextKey = code_key_g("T_SPCEB", alltemps[0], nextKey);
       nextKey = code_key_g("T_FGCEB", alltemps[1], nextKey);
       nextKey = code_key_g("T_CTCEB", alltemps[2], nextKey);
     }
     nextKey = code_key_i("PMUDELAY",SPinfoHdr->PMUdelay , nextKey);
   } 
   //nextKey = code_key_i("PMU_NROT", 9999, nextKey );
   nextKey = code_key_s("TIMESYS", "UTC", nextKey);
   /* we can provide an exposure time by using 0.8s for each cycle */
   nextKey = code_key_g("EXPTIME", 0.8 * SPimage.cycles, nextKey);

   sp_start_exists = 1;  /* could be a header or just a start packet */
   /* if a header packet (with HK, no image), return now */
   if (mode >= 2) return 0;
 }
 /* continuing on a SP image, load the packet into the image */
imageprocess:
 if (!sp_start_exists) { printf("skipping a SP packet because no header yet\n");  return 0; } 
 sp_in_progress = 1;
 /* check ID */
 if (SPimage.id != ph.pheader.info.id) {
      printf("SP ID mismatch, bad data?\n"); return 1; }
 /* check that the full image size is consistent with the header we got */
 if (SPimage.nw != ph.pheader.info.ny || SPimage.ny != ph.pheader.info.nx) {
      printf("SP packet doesn't match header\n");  return 1; }
 ixp0 = ph.pheader.info.x0;
 iyp0 = ph.pheader.info.y0;
 SPimage.side = ph.pheader.info.subIdCCDseg;
 /* a problem with mangled SDTP data causes the CCD_size bit to be cleared in
 some data, check if we get data from both sides and re-set it if we do.
 Otherwise we have an error with the 4D file */
 if (SPimage.side) sideCheck1 = 1; else sideCheck0 = 1;
 if (sideCheck1 && sideCheck0) SPimage.CCD_size = 1;

 /* the curious serial (aka version) number stuff, see the FG section for more details */
 if (needVer1) {
   if (sp_comp_choice == 1) {
     nextKey = code_key_i("BITCVER1", FPPcompIDS[0], nextKey);
     nextKey = code_key_i("ACHFVER1", FPPcompIDS[1], nextKey);
     nextKey = code_key_i("DCHFVER1", FPPcompIDS[2], nextKey);
     nextKey = code_key_i("QTABVER1", FPPcompIDS[3], nextKey);
     needVer1 = 0;  /* until the next file */
   }
 }
 if (needVer2) {
   if (sp_comp_choice == 2) {
     nextKey = code_key_i("BITCVER2", FPPcompIDS[0], nextKey);
     nextKey = code_key_i("ACHFVER2", FPPcompIDS[1], nextKey);
     nextKey = code_key_i("DCHFVER2", FPPcompIDS[2], nextKey);
     nextKey = code_key_i("QTABVER2", FPPcompIDS[3], nextKey);
     needVer2 = 0;  /* until the next file */
   }
 }
 /* 5/30/2005 - we count packets */
 SPimage.num_packets++;

 nxp = ph.pheader.info.nxp;
 nyp = ph.pheader.info.nyp;
 pp = (short *) packdata1;
 if (oldAspect) {
   ystride = ph.pheader.info.ny;
   /* load the image with space in the y direction to be consistent with FG iamges,
   this puts wavelength in the image x direction, if the LHS, we load as a transpose,
   the RHS is not reversed in x (wavelength) for the SP so it is done the same
   way */
   xstride = 1; pbase = SPimage.image + iyp0 + ixp0*ystride;
 } else {
   ystride = -ph.pheader.info.ny;
   /* 9/30/2006 - don't change the wavelength direction but reverse the spatial */
   if (ixp0) { printf("**** SP packet ix0 error, ix0 = %d, image may be compromised\n", ixp0); }
   xstride = 1; pbase = SPimage.image + iyp0 + (SPimage.ny - 1)* SPimage.nw;
 }
 if (SPimage.subId != DPC_SP_RAW) {
   /* 7/14/2004 - for the 4D SP images, we also have to place this packet according to
   the side and product type, each 2D image is assumed to be nw by ny; we already
   checked that this packet has the right (nw,ny) */
   noff = (SPimage.nw * SPimage.ny);
   if (SPimage.side) pbase = pbase + noff;
   /* the IQUV is the last dimension, so offsets depend on # of sides */
   noff = noff * (SPimage.CCD_size +1);  /* note SPimage.CCD_size is 0 or 1 */
   switch (ph.pheader.info.subIdProduct) {
    case DPC_STOKES_I: break;
    case DPC_STOKES_Q: pbase = pbase + noff; break;
    case DPC_STOKES_U: pbase = pbase + 2*noff; break;
    case DPC_STOKES_V: pbase = pbase + 3*noff; break;
    default: printf("bad subIdProduct = %d\n", ph.pheader.info.subIdProduct); break;
   }
 }
 /* usually we expect ixp0 to be 0  and the packet nx = nxp because of the
 way packets are made but we allow for possible variants */
//   printf("side,ixp0,iyp0,xstride,ystride,nxp,nyp %d %d %d %d %d %d %d\n",
//   	side,ixp0,iyp0,xstride,ystride,nxp,nyp);
 while (nyp--) {
   nn = nxp;
   ps = pbase;
   pbase = pbase + xstride;
   while (nn--) {
     *ps = *pp++;
     ps = ps + ystride;   /* this may go below image on last loop but it is not used */
   }
 }
 nxp = ph.pheader.info.nxp;
 nyp = ph.pheader.info.nyp;
 switch (ph.pheader.info.subIdProduct) {
   case DPC_STOKES_Q:
   case DPC_STOKES_U:
   case DPC_STOKES_V:
   case DPC_MAGNETOGRAM:
   case DPC_DOPPLERGRAM:
     SPbyteCountQUV += psizeCompressed;
     SPpixelCountQUV += nyp*nxp;
     break;
   case DPC_STOKES_I:
   case DPC_SP_RAW:
   case DPC_DARK:
   default:
     SPbyteCountI += psizeCompressed;
     SPpixelCountI += nyp*nxp;
     break;
 }
 /* for the 4D style, we don't close until we have the last frame in each set,
 previously it was the last packet for each frame. The last frame flag will
 not be set until the last in a map however. Since we don't want all the
 images in a map in one file (that would be a 5D file), we have to close also
 for the last V frame. This assumes that the packets are in order (this assumption
 is implicit in several places). */
 if (ph.pheader.info.sub_seq_flag >= 2) {
 /* we are never ready to close unless above is true but it isn't enough */
 if ( ph.pheader.info.main_seq_flag >= 2  || (
   ( ph.pheader.info.subIdProduct == DPC_STOKES_V ) &&
   		(SPimage.CCD_size == 0 || SPimage.side == 1) ) ) {
 /* check if the last packet for this frame, we assume the packets are in order */
//   printf("sub_seq_count = %d, num_packets = %d\n", ph.pheader.info.sub_seq_count, SPimage.num_packets);
//   printf("flag = %d\n", ph.pheader.info.sub_seq_flag);
// if ( ph.pheader.info.sub_seq_flag >= 2 ||
//      ((int) ph.pheader.info.sub_seq_count + 1) >= SPimage.num_packets) {
//    printf("ph.pheader.info.sub_seq_count = %d, SPimage.num_packets = %d\nph.pheader.info.sub_seq_flag = %d\n",
//       ph.pheader.info.sub_seq_count, SPimage.num_packets, ph.pheader.info.sub_seq_flag);
//    printf("last packet for this frame\n");
   /* 11/21/2004 - having trouble with some mangled sdtp files, so a further check
   for the end here */
   
   
   /* write out the result and close up */
   nextKey = SPwrapup(nextKey);
   if ( SPclose() ) printf("problem closing SP file");
 } }
 return 0;
 }
 /*------------------------------------------------------------------------- */
int reformat()
 {
 /* first figure out if we are starting a new set. If so we need to setup
 keywords. More than one image may be generated for a set and these share
 the same header frame with the housekeeping snapshot. Some date products,
 like the CT's, don't have a header frame. These also just have a single
 packet per frame and image. */
 int	rftype, i, stat;
 
 switch (datatype) {
  case DATATYPE0:
  case DATATYPE1:
   rftype = 0;	/* FG */
   break;
  case DATATYPE2:
  case DATATYPE3:
   rftype = 1;  /* SP */
   break;
  case DATACTREF:
   rftype = 2;
   break;
  case DATACTLIVE:
   rftype = 3;
   break;
  case DATADIAGNOSTIC:
   rftype = 4;
   break;
  case DATADIAGNOSTIC2:
   rftype = 5;
   break;
  case DATAMEMDUMP:
   rftype = 6;
   break;
  case DATATYPEXRT2:
  case DATATYPEXRT:
   /* just do the XRT call from here, it works differently than the FPP schemes */
   if (XRTreformat()) { printf("error return for XRTreformat\n");  }
   return 0;

  default:
   printf("reformat got an unknown data type\n");  return 1;
   break;
   }
 /* if a header or a standalone, prepare keywords */
 single_flag = (ph.pheader.info.sub_seq_flag == 3) && (ph.pheader.info.main_seq_flag == 3);
 key_flag = (head_flag || single_flag );
 if (key_flag) {
   /* some data products have only one packet per output file but the
   FG and SP images have several in general, hence we need to check if this
   new one interrupts another image already being formatted, this could happen
   and eventually we'll have an ID to tell how things are supposed to fit
   together but here we'll just do one product (of each type) at a time */
   /* check if we haven't closed the last one */
   //printf("new start, MDP clock = %010u, SN = %d\n", ph.pheader.data.packet_time,
   //	ph.pheader.info.serial_no);
   if (rftype == 0)  stat = FGreformat(2);
   if (rftype == 1)  stat = SPreformat(2);
   /* if we have a CT file, we have the entire thing in this packet */
   if (rftype >1 && rftype < 6) stat = CTreformat(rftype);
   } else {
   int mode = 0;
   /* could be a a new frame (image) without a dedicated header, these would have
   a packet number of 0 or be designated a single packet */
   //printf("continuation, SN = %d\n", ph.pheader.info.serial_no);
   if (ph.pheader.info.sub_seq_count == 0 || ph.pheader.info.sub_seq_flag > 2) mode = 1;
   if (rftype == 0)  stat = FGreformat(mode);
   if (rftype == 1)  stat = SPreformat(mode);
   if (rftype >1 && rftype < 6) {
	printf("type %d not expected for a continuation, ignoring this packet\n");
     }
 }
 return 0;
 }
 /*------------------------------------------------------------------------- */
char *ana_ctime()
 /* returns current time and date in a malloc'ed string */
 {
 char *s;
 time_t	t;
 s = malloc(25);
 t = time(NULL);
 strncpy( s, ctime( &t ), 24);
 *( s + 24) = '\0';
 return s;
 }
 /*------------------------------------------------------------------------- */
void logposition()
 {
  /* put in a line about where we ended up and what we got */
  /* note that the peek.pos file is re-opened for append and closed each time */
  close_time = ana_ctime();
  file_position = (long long) lseek64(infile, 0, SEEK_CUR);
  posfile = fopen(name_pos,"a");
  fprintf(posfile, "%s  %10lld   %10lld  %9d     %s %s\n",
  name_in, file_position, totalbytes, packet_cnt, open_time, close_time);
  fclose(posfile);
 }
 /*------------------------------------------------------------------------- */
void indexx_l(int n, int ra[], int indx[])
 {
  int l,j,ir,i,indxt;
  int q;
 
  for (i=0;i<n;i++) indx[i] = i;
  l = (n/2);
  ir = n-1;
  for (;;) {
   if (l > 0)
    q=ra[(indxt=indx[--l])];
   else {
    q=ra[(indxt=indx[ir])];
    indx[ir]=indx[0];
    if (--ir == 0) {indx[0]=indxt;return; }
   }
   i = l;
   j = l + l + 1;
   while (j <= ir) {
    if (j < ir && ra[indx[j]] < ra[indx[j+1]]) j++;
    if (q < ra[indx[j]]) {
     indx[i] = indx[j];
     j += (i=j) + 1;
    }
    else j = ir + 1;
   }
   indx[i] =indxt;
  }
 }
 /*------------------------------------------------------------------------- */
int scanfiles()
 {
 /* scans for raw data files and if the gui is on, also reloads the
 file list widget */
 static int nfilesmatched;
 static	char *lastNameFilter = NULL;
 struct tm *gtest;
 int i, j, fileSizeMin = 1, iold, stat, nfileslast, delete_flag;

 lastfilesizes = goodsizes;
 lastfiles = goodfiles;
 nfileslast = nfiles;
 if (nameFilter == NULL) {
     nameFilter = "sci$";
 }
 printf("nameFilter: %s\n", nameFilter);
 printf("scanning for files\n");
 /* if the filter has changed, it is likely that the old list is no longer
 relevant. Hence we just delete the old list if we have one and start over. */
 printf("lastNameFilter = %d\n", lastNameFilter);
 if (lastNameFilter) {

   if (strcmp(nameFilter, lastNameFilter)) {
     free(lastNameFilter);
     printf("starting list from scratch\n");
     if (nfileslast > 0) {
       for (i=0;i<nfileslast;i++) free(lastfiles[i]); free(lastfiles);
       nfileslast = 0;
     }
   }
 free(lastNameFilter);
 }
 lastNameFilter = strdup(nameFilter);
 nfilesmatched = getmatchedfiles(tf2_path, &flist, nameFilter, 5000);
 nfiles = nfilesmatched;
 printf("scanning finished, %d files found\n", nfiles);
 /* get the sizes and store them, it doesn't take long */
 filesizes = (long long *) malloc(nfiles * sizeof(long long));
 filetimes = (int *) malloc(nfiles * sizeof(int));
 bzero(filetimes, nfiles * sizeof(int));
 for (i=0;i<nfilesmatched;i++)  filesizes[i] = filesize64(flist[i]);
 /* if these are SDTP files, try to get the start times, thkis can take a while
 since we have to search for the log files and read part of each one */
 /* the case of one file is handled below */
 if (sdtp_flag ) {
   int iq;
   char	**scflist;
   long long *scfilesizes;
   int	*scfiletimes, *indx;
   for (i=0;i<nfilesmatched;i++) {
     name_in = flist[i];
     getBaseTime();  /* this puts time in sdtpbasetime */
     filetimes[i] = sdtpbasetime;
    }
    /* and we want to sort now according to the times */
   indx = (int *) malloc(nfiles * sizeof(int));
   if (nfilesmatched == 1) indx[0] = 0; else indexx_l(nfilesmatched, filetimes, indx);
   /* and we need to copy the sorted items, hence need several scratch arrays */
   scfilesizes = (long long *) malloc(nfiles * sizeof(long long));
   scfiletimes = (int *) malloc(nfiles * sizeof(int));
   scflist = malloc( nfiles * sizeof(char *) );
   for (i=0;i<nfilesmatched;i++) {
     iq = indx[i];
     scflist[i] = flist[iq];
     scfilesizes[i] = filesizes[iq];
     scfiletimes[i] = filetimes[iq];
   }
   free(flist); free(filesizes); free(filetimes);
   flist = scflist;  filesizes = scfilesizes;  filetimes = scfiletimes;
 }
 goodfiles = malloc( nfiles * sizeof(char *) );
 goodsizes = (long long *) malloc( nfiles * sizeof(long long) );
 goodtimes = (int *) malloc(nfiles * sizeof(int));
 bzero(goodtimes, nfiles * sizeof(int));
 j = 0;
 /* both file lists are from getmatchedfiles and hence are sorted already, step
 through the new files and make any changes to the list widget. Just clearing
 the list widget and replacing them all seems to take a very long time when there
 are several hundred files. So we do a more complicated but (maybe) faster approach. */
 /* might want to try XmListAddItemsUnselected someday */
 iold = 0;
 for (i=0;i<nfilesmatched;i++) {
   /* delete_flag indicates the file didn't make the cut and we should delete the
   name string */
   delete_flag = 1;
   fsize64 = filesizes[i];
   if (iold < nfileslast) {
     stat = strcmp(flist[i], lastfiles[iold]);
     if (stat > 0 ) {
       /* the new one is alphabetically greater than this old one, this means
       some of the old ones must not be in the new list so we have to step
       through iold, deleting names, until iold catches up with i */
       printf("flist[i]: %s,  lastfiles[iold]: %s\n", flist[i], lastfiles[iold]);
       do {
	 printf("name gone,  i,j,iold = %d, %d, %d\n",i,j+1,iold);
	 iold++;
	 if (iold >= nfileslast) { 
	      /* we've run out of old ones, process this and then continue i loop */
	      //printf("new name after deletions: %s\n", flist[i]);
	      //sprintf(linebuf, "%2d: %9lld: %s", i+1, fsize64, flist[i]);
	      if (filetimes[i]) {
		char text[64];
                gtest = gmtime((time_t *) &filetimes[i]);
		strftime(text, 30, "%a, %D %T UT", gtest);
		sprintf(linebuf, "%9lld: %s: %.25s", fsize64, flist[i], text);
	      } else sprintf(linebuf, "%9lld: %s", fsize64, flist[i]);
	      goodsizes[j] = fsize64;
	      goodfiles[j] = flist[i];
	      goodtimes[j] = filetimes[i];
	      j++;  delete_flag = 0;
	      break; }
       } while ( (stat = strcmp(flist[i], lastfiles[iold])) > 0);
       /* now we have one of the other 2 cases */
     }
     if (stat < 0) {
	 /* because these are sorted lists, this implies that the flist name
	 is not in the last list, check if length OK */
 	 //printf("new name: %s\n", flist[i]);
	 if (fsize64 >= fileSizeMin) {
           //printf("new case, i,j,iold = %d, %d, %d\n",i,j,iold);
	   //sprintf(linebuf, "%2d: %9lld: %s", j+1, fsize64, flist[i]);
	   if (filetimes[i]) {
	     char text[64];
             gtest = gmtime((time_t *) &filetimes[i]);
	     strftime(text, 30, "%a, %D %T UT", gtest);
	     sprintf(linebuf, "%9lld: %s: %.25s", fsize64, flist[i], text);
	   } else sprintf(linebuf, "%9lld: %s", fsize64, flist[i]);
	   goodsizes[j] = fsize64;
	   goodfiles[j] = flist[i];
	   goodtimes[j] = filetimes[i];
	   j++;  delete_flag = 0;
	 }
	 /* since i is incrementing but not iold, we will eventually
	 get == or > case by just going on */
     } 
     if (stat == 0) {
       /* the 2 file names are the same, has the length changed or the condition? */
       if (fsize64 < fileSizeMin) {
	 /* no longer qualifies for our list, remove, don't bump j */
	 //printf("delete for size, i,j,iold = %d, %d, %d\n",i,j,iold);
	 //break;
       } else {
	 /* we qualify but check if size has changed */
	 if (fsize64 != lastfilesizes[iold]) {
	   //printf("size changes,  i,j,iold = %d, %d, %d\n",i,j,iold);
           //sprintf(linebuf, "%2d: %9lld: %s", j+1, fsize64, flist[i]);
	   if (filetimes[i]) {
	     char text[64];
             gtest = gmtime((time_t *) &filetimes[i]);
	     strftime(text, 30, "%a, %D %T UT", gtest);
	     sprintf(linebuf, "%9lld: %s: %.25s", fsize64, flist[i], text);
	   } else sprintf(linebuf, "%9lld: %s", fsize64, flist[i]);
	 }
	 goodsizes[j] = fsize64;
	 goodfiles[j] = flist[i];
	 goodtimes[j] = filetimes[i];
	 j++;  delete_flag = 0;
       }
       iold++;
       //printf("iold = %d, nfileslast = %d\n", iold, nfileslast);
     }

   } else {
     /* we have run out of the old list, must add this new one to the end of the list
     if it meets the size requirement */
     if (fsize64 >= fileSizeMin) {
       //sprintf(linebuf, "%2d: %9lld: %s", i+1, fsize64, flist[i]);
       if (filetimes[i]) {
	 char text[64];
         gtest = gmtime((time_t *) &filetimes[i]);
	 strftime(text, 30, "%a, %D %T UT", gtest);
	 sprintf(linebuf, "%9lld: %s: %.25s", fsize64, flist[i], text);
       } else sprintf(linebuf, "%9lld: %s", fsize64, flist[i]);
       goodsizes[j] = fsize64;
       goodfiles[j] = flist[i];
       goodtimes[j] = filetimes[i];
       j++;  delete_flag = 0;
     }
   }
 if (delete_flag) free(flist[i]);
 }
 /* we have finished running through the new list, any thing in the old list that
 we didn't get now must be removed */
 while (iold < nfileslast) {
  //printf("old non-matches, j, iold = %d, %d\n",  j, iold);
  iold++;  /* j stays the same since we are shortening list */
 }
 nfiles = j;
 totalGbytes = 0.0;
 for (i=0;i<nfiles;i++) totalGbytes += (float) goodsizes[i];
 totalGbytes = totalGbytes/1.E9;
 sprintf(linebuf, "   %d files matched, total storage is %9.4f Gbytes",nfiles, totalGbytes);
 if (lastfiles && nfileslast) { for (i=0;i<nfileslast;i++) free(lastfiles[i]); free(lastfiles); }
 /* also free the complete lists since we have the good lists now */
 }
 /*--------------------------------------------------------------------------*/
void getBaseTime()
 {
 /* create a likely name for the log file */
 char *p, *q, *flogname;
 int	nq, ns = strlen(name_in);
 FILE *logfile;
 extern int needTimeRef;
 extern time_t getSdtpCalendarTime(char *buf);
 sdtpbasetime = 0;  /* in case we fail */
 needTimeRef = 1;
 p = strrchr(name_in, '.');
 /* we won't try w/o the . */
 if (p) {
   nq = p - name_in;
   flogname = q = malloc(nq + 5);
   nq ++;	/* to get the dot also in the copy */
   p = name_in;
   while (nq--) *q++ = *p++;
   *q++ = 'l';  *q++ = 'o';  *q++ = 'g';  *q++ = 0;
   printf("log file name: %s\n", flogname);
   /* and try to open it */
      if ((logfile = fopen(flogname, "r")) == NULL) {
        /* here if it didn't work */
	printf("could not open a log file, no base time\nthe name was: %s\n",
	  flogname);
      } else {
        /* still on track, read the file looking for the first CCSDS pkt, TIME */
      while ( fgets(linebuf, 500, logfile) ) {
       if (strstr (linebuf, "SOCKFILE")) {
         if (strstr (linebuf, "SIRIUS")) {
           sirius_pkts = 1;
         } else {
           sirius_pkts = 0;
         }
       }
       if (strstr (linebuf, "CCSDS pkt, TIME [")) {
         printf("time: %s\n", linebuf);
	 /* got one, parse it and convert to a calendar time*/
	 sdtpbasetime = (int) getSdtpCalendarTime(linebuf);
	 break;
       }
       }
       fclose(logfile);
      }
    }
 }
 /*--------------------------------------------------------------------------*/
void newfile()
 {
 extern	int msgsock, checkRefTimeFlag ;
 /* if a file open, close it first */
 if (file_flag) { close(msgsock);  file_flag = 0; }
 /* the path is already in the name */
 fsize64 = filesize64(name_in);
 if (fsize64 <= 0) {
   snprintf(linebuf, 500, "file %s\nindicates a size of %lld\ncheck name and path", name_in, fsize64);
   return;
 }

#if __APPLE__
 if ((infile=open(name_in, O_RDONLY)) < 0) {
#else
 if ((infile=open(name_in, O_RDONLY|O_LARGEFILE)) < 0) {
#endif
   snprintf(linebuf, 500, "error opening file\n%s", name_in);
  return; }
  /* if an sdtp file, look for a log file (or maybe a sdtpx file in the future)
  to get a time reference. Also note that sdtp files don't allow offset entries
  so that logic is bypassed below via the same if */
  
  if (sdtp_flag) {
    getBaseTime();
  } else {
   /* re-cock checkRefTimeFlag so that we do a time sanity check on first header */
   checkRefTimeFlag = 1;
   
   /* check if we are offsetting, this could be specified with the O option
   or because we are using a *.pos file, invalid for a socket */
   if (ipos64 > 0 ) {
       off64_t offset, offset_2;	/* the files might be big */
       if (ipos64 >= fsize64) {
       snprintf(linebuf, 500, "position %lld exceeds\nfile size (%lld)", ipos64, fsize64);
     } else {
       offset = (off64_t) ipos64;
       offset_2 = lseek64(infile, offset, SEEK_SET);
       printf("seek went to: %lld\n", offset_2);
       if (offset_2 < 0) { printf("error in lseek64\n");  exit(1); }
     }
   }
 }
 /* if a file, also save a bunch of pointers to past frames to allow stepping back */
   iframe = 0;
   past_frames[0] = 0;
   past_frames_pc[0] = 0;
 file_flag = 1;	/* indicates a successful file open */
 /* are we re-formatting into image files ? */
 /* also get time from file here by forcing a call to format_setup since we now want to
 always use for checking, this shouldn't bother anything if we aren't re-formatting */
 //if (format_flag) format_setup(name_in);  /* pass the input file name if any */
 format_setup(name_in);  /* pass the input file name if any */
   
 msgsock = infile;	nfilesread++;
 current_position = 0;
 }
 /*------------------------------------------------------------------------- */
int nextfile(log_flag)
 int	log_flag;
 {
 extern	int msgsock, checkRefTimeFlag;
 int	i, k;
 /* only used for -a flag (append or automatic), first log the results from the
 last file */
 if (log_flag) logposition();
 close(msgsock);
 file_flag = 0;
 all_totalbytes += totalbytes;
 all_packet_cnt += packet_cnt;
 totalbytes = packet_cnt = 0;
 /* note that we don't scan for any new files that may have appeared while we
 were doing the last one, this is supposed to make it easier to coordinate
 with a STOL procedure. If this isn't the right approach, another getmatchedfiles
 could be done here. */
 k = 1;
 for (i=0;i<nfiles;i++) {
   /* remove any leading paths from names and then just find the first goodfiles entry with a
   name > name_in */
   char *p1, *p2;
   p2 = strrchr(name_in, '/');
   if (p2) { p2++; } else { p2 = name_in; }
   p1 = strrchr(goodfiles[i], '/');
   if (p1) { p1++; } else { p1 = goodfiles[i]; }
   if (strcmp(p2, p1) < 0) {
     //if (name_in) free(name_in);
     printf("a hit comparing %s with %s\n", p2, p1);
     name_in = strdup(goodfiles[i]);
     k = 0; break;
   }
 }
 if (k) { printf("no file found later than %s\n", name_in);  return 1; }
 /* must have a name, try to open it, etc */
 printf("new file: %s\n", name_in);
 /* we can safely assume that this is not a socket and that the offset is 0 */
 fsize64 = filesize64(name_in);
 printf("size of input file = %lld bytes\n", fsize64);
#if __APPLE__
 if ((infile=open(name_in, O_RDONLY)) < 0) {
#else
 if ((infile=open(name_in, O_RDONLY|O_LARGEFILE)) < 0) {
#endif
  perror("opening input file");
  fprintf(stdout,"can't open input file, name: %s\n", name_in);
  return 1; }
 file_flag = 1;
 if (sdtp_flag) {
   getBaseTime();
 } else {
   checkRefTimeFlag = 1;
 }
 /* are we re-formatting into image files ? */
 /* also get time from file here by forcing a call to format_setup since we now want to
 always use for checking, this shouldn't bother anything if we aren't re-formatting */
 //if (format_flag) format_setup(name_in);  /* pass the input file name if any */
 format_setup(name_in);  /* pass the input file name if any */
 msgsock = infile;
 ipos64 = 0;
 open_time = ana_ctime();
 nfilesread++;
 iframe = 0;	/* reset the frame pointers for the new file */
 past_frames[0] = 0;
 past_frames_pc[0] = 0;
 /* note that there is no provision for going backwards to previous
 files in the GUI interface, just backwards within a file */
 return 0;
 }
 /*------------------------------------------------------------------------- */
int get_obs_kw_vals(char *cfg_file_name)
{
  FILE *lucfg;
  char kw[80], val[80];
  
  if (lucfg = fopen(cfg_file_name, "r") ) {
    while (fgets(kw, 80, lucfg)) { kw[strlen(kw)] = 0;
      fgets(val, 80, lucfg); val[strlen(val)] = 0;
      if (!strncmp(kw, "ORIGIN", 6)) strcpy(kw_origin, val);
      else if (!strncmp(kw, "OBSTITLE", 8)) strcpy(kw_obstitle, val);
      else if (!strncmp(kw, "TARGET", 6)) strcpy(kw_target, val);
      else if (!strncmp(kw, "SCI_OBJ", 7)) strcpy(kw_sci_obj, val);
      else if (!strncmp(kw, "OBS_DEC", 7)) strcpy(kw_obs_dec, val);
      else if (!strncmp(kw, "JOIN_SB", 7)) strcpy(kw_join_sb, val);
      else if (!strncmp(kw, "OBS_NUM", 7)) strcpy(kw_obs_num, val);
      else if (!strncmp(kw, "JOP_ID", 6)) strcpy(kw_jop_id, val);
      else if (!strncmp(kw, "NOAA_NUM", 8)) strcpy(kw_noaa_num, val);
      else if (!strncmp(kw, "OBSERVER", 8)) strcpy(kw_observer, val);
      else if (!strncmp(kw, "PLANNER", 7)) strcpy(kw_planner, val);
      else if (!strncmp(kw, "TOHBANS", 7)) strcpy(kw_tohbans, val);
      else if (!strncmp(kw, "DATATYPE", 8)) strcpy(kw_datatype, val);
      else fprintf(stderr, "Bad keyword: %s in %s\n", kw, cfg_file_name);
    }
    return 0;
  } else {
    fprintf(stderr, "Could not open keyword file.\n");
    return 1;
  }
}
 /*------------------------------------------------------------------------- */
int main(argc,argv)
 int argc;
 char *argv[];
 {
 int	ix, iy, i, nset1, ix1, ix2, bigendian, path_flag=0, offset_flag=0;
 int	input_flag = 0;
 int	ncbset1;
 float	pmiss;
 char	output_file_name[128], *path_name, *cfg_file_name=NULL;
 char 	*fontname, *sq;
 char	*raw_packet_path = "/net/fppem3/disk3/log/raw_data/";
#if SOLARIS
 char	*def_dir = "/net/fppem3/disk3/log/raw_data/";
 //char	*def_dir = "/net/fppem3/disk3/log/mission_data/";
#endif
#if __sgi
 char	*def_dir = "/hosts/solserv/home/fpptc/packets/";
#endif
#if __APPLE__
 char	*def_dir = "/Users/shine/packets/";
#endif
#if linux | LITTLEENDIAN
 char   *def_dir = "/home/fpptc/packets/";
#endif
 char *modes_label[] = { "display",  "auto erase", "auto scale", "at EOF, read next", "list",
 	"MC dump", "HK data", "format"};
 extern	int msgsock;
 if (putenv("TZ=UTC")) fprintf(stderr, "putenv TZ failed\n");
 nset1 = sizeof(itemset1)/sizeof(char *);
 ncbset1 = sizeof(modes_label)/sizeof(char *);
 tf2_path = tf2_defpath;	/* the default */
 progname = argv[0];

 /* Set default time conversion paths for pg1. */
   strcpy(cnvfile_path, "/data/SOLAR-B/TIMSET/CNV_FILE_2006");
   strcpy(leapsec_path, "/data/SOLAR-B/TIMSET/Lepasec.dat");
 /* Set default reformat paths for pg1. If path does not exist, use "." */
   strcpy(reformatPath, "/home/sbussot/data/level0");
   strcpy(reformatPathXRT, "/home/sbusxrt/data/level0");
 /* check for command line input */
 /* list of options:
 	i - input file (rather then socket) -i filename
	s - alternate synch for FPGA generated packets (not standard)
	dump - dump values
	display - show images
	t - test GUI
	goff - turn off gui, on by default
 */
 if (argc>=2) {
  for (i=1;i<argc;i++) {
   if (argv[i][0] == '-') {
    switch (argv[i][1])
    {
    case '1': /* only reformat this 1 file, -i path still required for now */
      nameFilter = argv[i+1]; i++;
      break;
    case 'a':
    case 'A': /* append flag, we check to see if we've already read part
    		of this input file (doesn't make sense for sockets) */
     socket_flag = 0;
     append_flag = 1;  break;
    case 'b':
    case 'B': /* bad show flag, use for debugging */
     badshow_flag = 1;  break;
    case 'c': cfg_file_name = argv[i+1]; break; /* various keyword values */
    case 'C': /* connect rather than listen or CCSDS debug */
     if (argv[i][2] == 'c' || argv[i][2] == 'C') {
       extern int ccsdsdebug;  ccsdsdebug = 1;  break; }
     connect_flag = 1;  break;
    case 'd':
    case 'D': /* data dump flag*/
     data_product_dump_flag = 1;  break;
    case 'f':
    case 'F': /* format into images and output the files */
     display_flag = 0;   format_flag = 1;  break;
    case 'g':
    case 'G': /* turn off gui  or on*/
     if (strcmp( &argv[i][2], "off") == 0) gui_flag = 0;  else 
      if (strcmp( &argv[i][2], "on") == 0) gui_flag = 1;  else { 
       printf("illegal option for g flag %s\n", &argv[i][2]);
       exit(1);}
     break;
    case 'i':
    case 'I': /* input file specified, make sure we have a name here */
     /* 10/28/2002 - this has changed since we now look at a set of files
     for append mode and want to show the files for selection in GUI
     mode. For these cases we'll use a name here only to set a path. */
     if ( (i+1) >= argc || argv[i+1][0] == '-') {
      fprintf(stdout,"no input file name after -i key (or it begins with a -)\n");
      fprintf(stdout,"%s fatal error\n", progname);
      exit(1); }
     /* this implies we use a file instead of the socket */
     input_flag = 1;
     socket_flag = 0;
     name_in = argv[i+1];
     /* defer the open and such until we know more about the mode */
     i++;	/* bump i an extra */
     break;
    case 'j':  /* number of packets offset to simulate having read prev files */
     npack_offset = atoi(argv[i+1]);
     i++;
     break;
    case 'k': dkw = 1; break; /* turn on diagnostic keywords */
    case 'l':
    case 'L': /* a list flag, for listing packets */
     list_flag = 1;  break;
    case 'n':
    case 'N': /* bytes to try before giving up */
     if (argv[i][2]) ntry = strtol(&argv[i][2],NULL,0);
      else { ntry = strtol(argv[i+1],NULL,0); i++; }
      /* catch some possible errors */
      if ( ntry <= 0) {
	printf("illegal value for ntry %d, exiting\n", ntry);
	exit(1); }
     printf("new value of ntry = %d\n", ntry);
     break;
    case 'o':
    case 'O': /* offset, not valid for a socket */
     if (argv[i][2]) ipos64 = strtoll(&argv[i][2],NULL,0);
      else { ipos64 = strtoll(argv[i+1],NULL,0); i++; }
     if (ipos64 < 0) {
       printf("bad offset in -o option %lld\n", ipos64); exit(1); }
     printf("offset specified via -o option = %lld\n", ipos64);
     offset_flag = 1;  break;
    case 'p':
    case 'P': /* port or path? */
     if (strcmp( &argv[i][1], "path") == 0) {
      /* this allows a specified path for the pos file (and any other
      output we may add later) */
     if ( (i+1) >= argc || argv[i+1][0] == '-') {
      fprintf(stdout,"no path name after -path key (or it begins with a -)\n");
      fprintf(stdout,"%s fatal error\n", progname);
      exit(1); }
      path_name = argv[i+1];
      path_flag = 1;
      printf("specified path for pos file is: %s\n", path_name);
     } else {
     /* use a different port ID */
     if (argv[i][2]) data_port = strtol(&argv[i][2],NULL,0);
      else { data_port = strtol(argv[i+1],NULL,0); i++; }
      /* catch some possible errors */
      if (data_port <= 0) {
	printf("illegal socket port ID %d, exiting\n", data_port);
	exit(1); }
     port_flag = 1;
     }
     break;
    case 's':
    case 'S': /* simple synch for reading some test packets or status dumps
    	or sdtp mode */
     /* if sy, assume the sync, if sd, assume the sdtp flag, else the status dump */
     if (argv[i][2] == 'y' || argv[i][2] == 'Y') { verify_macro_synch = 1;  break; }
     if (argv[i][2] == 'd' || argv[i][2] == 'D') { sdtp_flag = 1;  break; }
     status_buf_dump_flag = 1;  break;
    case 't':
    case 'T': /* mostly to test GUI mods */
     test_flag = 1;  break;

    case 'x':
    case 'X':
     if ( (i+1) >= argc || argv[i+1][0] == '-') {
      fprintf(stdout,"no output path name after -x (or it begins with a -)\n");
      fprintf(stdout,"%s fatal error\n", progname);
      exit(1); }
     strcpy(reformatPathXRT, argv[++i]);
     break;

    case 'z':
    case 'Z':
     if ( (i+1) >= argc || argv[i+1][0] == '-') {
      fprintf(stdout,"no output path name after -z (or it begins with a -)\n");
      fprintf(stdout,"%s fatal error\n", progname);
      exit(1); }
     strcpy(reformatPath, argv[++i]);
     break;

    default:
     fprintf(stdout,"%s warning\n", progname);
     fprintf(stdout,"bad command line key %s, ignored\n", argv[i]);
     break;
    }
   }
 } }
 /* done with argument checking */

 /* Initialize SB - UT conversion (read leap second file) */

 if ( UtTt_Init(leapsec_path)) {
   fprintf(stderr, "Can't init SB time to UT conversion: %s.\n", leapsec_path);
   exit (1);
 }

 /* get values for observation planning keywords */

 if (cfg_file_name) get_obs_kw_vals(cfg_file_name);

 /* 6/3/2003 - always assume an input file rather than a socket in this
 version. If there is an -i option, use it for the path, otherwise look
 for an environmental FPP_RAW_SOURCE */
 /* if -i was specified with -a, use name_in as the path; if no -a the
 file is opened (below) using name_in (after skipping the -a stuff) */
 if (input_flag ) {
      /* use as a path for the tf2.raw files */
      tf2_path = strdup(name_in);
 } else {
 tf2_path = getenv("FPP_RAW_SOURCE");
 /* and use a last resort builtin default if we got nothing */
 if (tf2_path) {
  sq = (char *) malloc(strlen(tf2_path) + 2);
  strcpy(sq, tf2_path);  strcat(sq, "/");
  tf2_path = sq;
  } else {
  tf2_path = def_dir;
  }
 }

 /* check if we are appending/logging and setup if we are */
 if (append_flag) {
  /* doesn't make sense if on a socket */
  if (socket_flag) append_flag = 0; else {
   int	name_size, nc, i;
   char *ext_ptr, *slash_ptr, linebuf[512];
   struct stat statbuf;
   int	ipos;
   char *pq;
   int	add_slash = 0, path_size;
   /* the pos file is now just called peek.pos, use the data path
   unless a special path was input with the -path key */
   if (!path_flag) path_name = tf2_path;
   path_size = strlen(path_name);
   name_size = strlen(name_pos);
   if (path_name[path_size-1] != '/') add_slash = 1;
   pq = (char *) malloc(path_size + name_size + add_slash +1);
   strncpy(pq, path_name, path_size);
   if (add_slash) pq[path_size] = '/';
   strncpy(pq + path_size + add_slash, name_pos, name_size+1);
   name_pos = pq;
   printf("pos file name: %s\n", name_pos);

   /* check if the pos file already exists and is appendable */
   /* note that we use the stream file functions for this file but not the
   input file since the latter might be a socket */
   if( stat(name_pos, &statbuf)) {  
    /* probably doesn't exist, so try to create and write the header lines */
    printf("no position file found, creating %s\n", name_pos);
    posfile = fopen(name_pos,"w");
    if (posfile == NULL) { perror("can't setup new position file\n"); exit(1); }
    fprintf(posfile,
    "#  file name:last position:bytes:packets:open time:close time\n\n");
    fclose(posfile);

    /* because there are no previous results, we want to open the first file
    in the list, the offset will be 0 unless it was entered via command line */
    
    name_in = strdup(flist[0]);
    printf("name_in: %s\n", name_in);
    } else {
    posfile = fopen(name_pos,"r+");
    
    if (posfile == NULL) { perror("can't setup old position file for r/w, check privileges\n"); exit(1); }
    /* have to read this and find last position, etc. Assume an ASCII file */
    while ( fgets(linebuf, 500, posfile) ) {
     char *s = linebuf, *s1;
     while (strchr (" \t", *s)) ++s;  /* skip any blanks or tabs */
     if (strchr("#%;!\n", *s)) continue; /* ignore comments and blank lines */
     /* get the filename (can't have blanks in the name) */
     name_in = strdup(strtok(s, " \t#\n"));
     s1 = strtok(NULL, " \t#\n"); 
     nc = sscanf(s1, "%lld", &ipos64);
     }
     fprintf(posfile, "# new startup at %s\n",ana_ctime());
     fclose(posfile);
     printf("last file read: %s\n", name_in);
     printf("last read position = %lld\n", ipos64);
     /* if we have an offset, position the input file */
    }
  }
 }

 /* unless we are doing the socket, we now have a file to open */
//  if (!socket_flag) {
// 
//    fsize64 = filesize64(name_in);
//    printf("size of input file = %lld bytes\n", fsize64);
//    if ((infile=open(name_in, O_RDONLY|O_LARGEFILE)) < 0) {
//     perror("opening input file");
//     fprintf(stdout,"can't open input file, name: %s\n", name_in);
//     exit(1); }
//    msgsock = infile;	nfilesread = 1;
//    /* get the open time, used if we are logging the results */
//    open_time = ana_ctime();
// 
//    /* check if we are offsetting, this could be specified with the O option
//    or because we are using a *.pos file, invalid for a socket */
//    if (ipos64 > 0 ) {
//      off64_t offset, offset_2;	/* the files might be big */
//      if (ipos64 >= fsize64) {
//        printf("offset position >= file size (%lld vs %lld)\n",ipos64, fsize64);
//        /* check if another available (for -a), exit if things don't work out */
//        if (append_flag) {
// 	if ( nextfile(1) ) exit(1);
// 	} else { exit(1); }
//    } else {
//      offset = (off64_t) ipos64;
//      offset_2 = lseek64(infile, offset, SEEK_SET);
//      printf("seek went to: %lld\n", offset_2);
//      if (offset_2 < 0) { printf("error in lseek64\n");  exit(1); }
//    }
//  }
// 
 /* if a file, also save a bunch of pointers to past frames to allow stepping back */
   
   past_frames = malloc( NPASTFRAMES * sizeof(off64_t) );
   past_frames_pc = malloc( NPASTFRAMES * sizeof(int));
   if (past_frames == NULL) { printf("error allocating memory for frame pointers\n");
   	exit(1); }
   iframe = 0;
   past_frames[0] = 0;
   past_frames_pc[0] = 0;
 
 /* omit the motif stuff if no gui desired, note that displaying only
 will work with gui on */
 if ( !gui_flag) display_flag = 0;
 
 if (gui_flag) {
 scanfiles();
 }  /* end of gui conditional */

 sprintf(cnvfile_path, "/data/SOLAR-B/TIMSET/CNV_FILE_%4.4d", cnv_year);
 
 /* open output files to store packets if requested (only for socket) */

 /* open the motor dump file if requested */
 if (mdumpFlag) {
   if ((mdumpFile=fopen("motordump.txt","w")) == NULL) {
    fprintf(stdout,"can't open motordump.txt output file\n");
    mdumpFlag = 0;
   }  
 }

 /* show some structure sizes */
 //printf("some sizes, int = %d, short = %d, long = %d, off64_t = %d, long long =%d\n", sizeof(int), sizeof(short),
 //	sizeof(long), sizeof(off64_t), sizeof(long long));
 /* test endian */
 { int one = 1; bigendian = (*(char *)&one == 0); }
 //printf("bigendian = %d\n", bigendian);
 //printf("some structure sizes:\nsizeof(PacketHeader) = %d\n",sizeof(PacketHeader));
 //printf("sizeof(packet_info) = %d\n",sizeof(packet_info));
 //printf("sizeof(compression_parameters) = %d\n",sizeof(compression_parameters));
 //printf("sizeof(data_info) = %d\n",sizeof(data_info));
 //printf("sizeof(fg_macro_command) = %d\n",sizeof(fg_macro_command));
 //printf("sizeof(macro_command) = %d\n",sizeof(macro_command));
 printf("sizeof(PacketHeader) = %d\n",sizeof(PacketHeader));
 printf("sizeof(XRTpacket_data_info) = %d\n",sizeof(XRTpacket_data_info));
 printf("sizeof(XRTpacketHeader) = %d\n",sizeof(XRTpacketHeader));

 /* in case we are reformatting and we start up in the middle of an image,
 defines something for SPinfoHdr and FGinfoHdr */
 SPinfoHdr = &fakeSPinfoHdr;
 FGinfoHdr = &fakeFGinfoHdr;

 for (i=0; i<nfiles; i++) {
     name_in = flist[i];

 /* Initialize SB Time so TI can be calculated  */
 /* SB Time is 0 on 2000 Jan 1 = 946684800 unix time */

  sb_time_0 = filetimes[i] - 946684800.0;
  if (SB_Time_Init(cnvfile_path, sb_time_0) ) {
    fprintf(stderr, "Can't init SB Time\n");
    exit (1);
  }
  fprintf(stderr,"SB init time: %f, UNIX time: %d\n", sb_time_0, filetimes[i]);
  fprintf(stderr, "Date: %s\n", ctime( (time_t *) &(filetimes[i])));
  printf("SB init time: %f, UNIX time: %d\n", sb_time_0, filetimes[i]);
  printf("Date: %s\n", ctime((time_t *) &(filetimes[i])));

printf("Outer loop: Processing '%s', %d of %d files\n", name_in, i, nfiles);
     newfile();
printf("Outer loop: returned from newfile\n");
     while (data_update() == 0 ) ;
printf("Outer loop: data_update() done with '%s', %d of %d files\n", name_in, i, nfiles);
 }

 printf("out of loop 0\n");
 /* close the file or socket */
 if (file_flag) close(msgsock);
 if (fg_in_progress) {
   printf("closing the last FG\n");
   if ( FGclose() ) printf("problem closing FG file");
 }
 if (sp_in_progress) {
   printf("new SP, closing the last one\n");
   if ( SPclose() ) printf("problem closing SP file");
 }
 if (xrt_in_progress) {
   printf("closing the last XRT\n");
   if ( XRTclose() ) printf("problem closing XRT file");
 }

 /* a modest start at version control/documentation */
 printf("ungu v %s, 2007-01-18\n", rf0_ver);
 printf("total files read = %d\n", nfilesread);
 if (all_packet_cnt == 0) all_packet_cnt = packet_cnt;
 if (all_totalbytes == 0) all_totalbytes = totalbytes;
 printf("total packets = %d, total bytes = %lld\n", all_packet_cnt, all_totalbytes);
 printf("SP packets        = %d, FG packets      = %d\n", numSP, numFG);
 printf("CT ref packets    = %d, CT live packets = %d\n", numCTref, numCTlive);
 printf("diagnostic packets= %d, memory packets  = %d\n", numDIAG, numMEM);
 printf("channel packets   = %d, I scan packets  = %d\n", numCHAN, numISCAN);
 printf("XRT packets       = %d\n", numXRT);
 if (packet_cnt > 0)
 	pmiss = 100.0*(float) gap_count/((float) gap_count + (float) packet_cnt); else
	pmiss =0.0;
 printf("serial # gaps %d, percentage missing packets = %7.3f%%\n", gap_count,
 	pmiss);
 if (append_flag) fclose(posfile);
 if (slitFile) fclose(slitFile);
 exit(0);
 }
 /*------------------------------------------------------------------------- */
/*
$Id: reform.c,v 1.1 2006/05/08 19:54:04 fpptc Exp fpptc $

$Log: reform.c,v $
Revision 1.1  2006/05/08 19:54:04  fpptc
Initial revision


*/
