 /* for XRT specific data structures, this requires command.h to
 be compiled first since it uses many defintions there. I didn't
 just add these to command.h since it is also used for the FPP
 flight s/w and I didn't want to redefine that. */

 /* because this is used by many files, do not put any declarations
   in here */
 /* XRT plate scale, milli-arcsec / pixel, 2006-12-06, jps, based on
  * Shimizu-san analysis
  * #define XRT_SCALE	1056
  * updated to reflect Shimuzu and Hara analysis of 2007-01-10, jps
  */
  #define XRT_SCALE	1032


 /* the XRT packet headers are 96 bytes, they have almost the same first 32
 bytes as the FPP packets Only differs in details of the SubID.
 The 64 byte data section is much different. */

typedef struct {
	unsigned char type;
	unsigned char size[3];  /* packet length in bytes */
	int	 serial_no;
	short	 id;
	unsigned main_seq_flag : 2;
	unsigned main_seq_count : 14;
	unsigned reserved : 2;
	unsigned num_packets : 8;
	unsigned num_frames : 6;
	/* sub ID, 16 bits as with FPP but we don't know what they mean yet */
	short    XRTsubID;

	unsigned	sub_seq_flag : 2;
	unsigned	sub_seq_count : 14;
	short	nx;	/* size of image obtained by FPP, called S, N/S for FG */
	short	ny;	/* called P, E/W for FG */
	short	x0;	/* coord (upper left corner) of partial image */
	short	y0;
	short	nxp;	/* size of partial image in a packet */
	short	nyp;
	/* the compression parameters were moved into here to make this
	structure a multiple of 4 bytes long */
	unsigned reserved_1 : 1;
	unsigned bit_compression_mode : 4;
	unsigned image_compression_mode : 3;
	unsigned reserved_2 : 1;
	unsigned huffman_ac : 2;
	unsigned huffman_dc : 2;
	unsigned quantization : 3;
 } XRTpacket_info;

typedef struct {
	unsigned imageMode : 2;
	unsigned AECflag : 1;
	unsigned AECnum : 1;
	unsigned AECresult : 4;
 } xrt_mdp_info;
typedef struct {
 /* 9/19/2005 - this structure has the correct size (64 bytes) for both the
 SGI and the Apple (running Panther 32 bit). Not tested yet on Sun's or Linux X86 */
	//unsigned imageMode : 2;
	//unsigned AECflag : 1;
	//unsigned AECnum : 1;
	//unsigned AECresult : 4;
 /* the 20 bytes of MDP OBS table info is assumed to be the same as for FPP */
 /* not sure this will align w/o a gap and in fact it doesn't so we have to
 declare as a byte array here. To be used, it will have to be copied. Note
 that the first byte has to be included in the array. It is the cause of the
 alignment problem. */
	unsigned char  mdp_obs_raw[21];
	//unsigned char  xrtE[7];  /* not known yet, a 7 byte XRT-E image header */
	//unsigned char  reserve[10];
	/* the 7 bytes of XRT-E data are also in AP ID 0x5A4 where there is some
	documentation. Not all the data is here. My interpretation follows: */
 	unsigned xrte_unused_a : 3;
 	unsigned xrte_cal_info : 1;		/* 1 = cal */
 	unsigned xrte_chip_sum : 4;		/* pixel summation */
 	unsigned xrte_roi_h_sta_pos : 8;	/* ROI H start/8 */
 	unsigned xrte_roi_v_sta_pos : 8;	/* ROI V start/8 */
 	unsigned xrte_unused_b : 2;
 	unsigned xrte_roi_h_size : 6;		/* encoded size */
 	unsigned xrte_unused_c : 2;
 	unsigned xrte_roi_v_size : 6;		/* encoded size */
 	unsigned xrte_unused_d : 7;
 	unsigned xrte_ccd_read_port : 1;	/* readout port, 0 = right, 1 = left */
 	unsigned xrte_ccd_temp : 8;		/* maybe, error in docs */
 	unsigned xrte_unused_e : 8;		/* not part of XRT-E, part of reserve */
	unsigned char  reserve[9];
	/* now 26 byte of XRT-D image header */
	short	 ec_id;			/* main ID */
 	unsigned ec_eindex : 6;		/* exp index */
 	unsigned ec_cd_mode : 1;	/* 0 = safe, 1 = fast */
 	unsigned ec_imtype : 1;		/* 1 = dark */
	unsigned ec_fw1 : 3;		/* filter wheel 1 position */
	unsigned ec_fw2 : 3;		/* filter wheel 2 position */
	unsigned ec_vl : 1;		/* 0= VLS closed, 1 = open */
	unsigned ec_reserve : 1;
 	/* the S/C clock is I*4 but not aligned here so declare as a byte array */
 	unsigned char	e_sclock[4];		/* S/C clock when expose cmd arrived */
 	/* they have a lot of 3 byte times, we'll have to declare here as
 	3 byte arrays and then construct from that when we need them, because
	of that we don't need to endianize them */
 	unsigned char  e_lclock[3];	/* local clock when expose cmd arrived */
 	unsigned char  e_sh_opening[3];	/* when CCD_EXPOSE and OPENOU signals raised */
 	unsigned char  e_sh_closed[3];	/* when CCD_EXPOSE and OPENOU signals lowered */
 	unsigned char  e_sh_pos;	/* shutter encoder position */
	unsigned e_wait_a : 1;		/* waiting position A */
	unsigned e_wait_b : 1;		/* waiting position B */
	unsigned e_wait_c : 1;		/* waiting position C */
	unsigned e_wait_cw : 1;		/* waiting clockwise exposure time */
	unsigned e_wait_ccw : 1;	/* waiting counter clockwise exposure time */
	unsigned e_vlo : 1;		/* 0 = VLS open */
	unsigned e_vlc : 1;		/* 0 = VLS closed */
	unsigned e_sh_cmd_err : 1;	/* 1 = shutter command error */
	unsigned char  e_fw1_pos;	/* filter wheel 1 coarse position */
	unsigned e_fw1_stat : 6;	/* filter wheel 1 status */
	unsigned e_fw1_reserve : 2;
	unsigned char  e_fw2_pos;	/* filter wheel 2 coarse position */
 	unsigned e_fw2_stat : 6;	/* filter wheel 2 status */
 	unsigned e_exptime_e : 2;	/* exposure time exponent */
	/* this is is an odd offset so we can't declare as I*2 */
 	unsigned char  e_exptime_m[2];		/* exposure time mantissa */
 	unsigned e_ttn : 4;		/* rev # of exposure table */
 	unsigned e_ttn_reserved : 4;
} XRTpacket_data_info;
 /* a structure type for XRT packet headers */
typedef struct {	/* XRTpacketHeader */
	XRTpacket_info	info;
	XRTpacket_data_info	data;	/* not THE data, just data info */
 } XRTpacketHeader;

typedef struct {        /* XRT HK APID 0x584 */
  int ver;
  int type;
  int sh;
  int apid;
  int seg;
  int psn;
  int plen;
  unsigned int ptime;
  unsigned int bor_code;
  int pkt_and_hdr_len;
  int ptyp_code;
  int reserv0;
  unsigned int ts_log;
  int bilevel;
  unsigned int hdr_area;
  int busy_area;
  char img_hdr[26];
  char temperatures[11];
  char analogs[12];
  char digitals[3];
  unsigned int t_sc_clock;
  unsigned int t_lo_clock;
  unsigned int t_lst_act;
  char software[20];
  char commanding[14];
  char reserved1[3];
  unsigned int reset_info;
} XRT0x584;

typedef struct {        /* XRT HK APID 0x5a4 */
  int ver;
  int type;
  int sh;
  int apid;
  int seg;
  int psn;
  int plen;
  unsigned int ptime;
  int cal_info;
  int chip_sum;
  int roi_h_sta_pos;
  int roi_v_sta_pos;
  int roi_h_size;
  int roi_v_size;
  int ccd_read_port;
  int ccd_temp;
  int ccd_ope_sts1;
  int ccd_ope_sts2;
  int ccd_ope_sts3;
  int ccd_ope_sts4;
  int ccd_ope_sts5;
  int ccd_ope_sts6;
  int ccd_ope_sts7;
  int ccd_ope_sts8;
  int exp_sta_time;
  int exp_end_time;
  int read_end_time;
  int timer_counter;
} XRT0x5a4;

int get_xrt_hk(XRT0x584 *hk0x584, XRT0x5a4 *hk0x5a4);
