;+
; NAME: eis_status_sts1_conversions.pro
;
; PURPOSE: To convert EIS status 1 parameters from telemetered values
;          to engineering values
;      
; CATEGORY:
;
; CALLING SEQUENCE: 
;
; INPUTS: 
;
; KEYWORD PARAMETERS: None
;
; OUTPUTS: 
;
; CALLS:
;
; COMMON BLOCKS: None
;
; PROCEDURE:
;
; RESTRICTIONS: Uses SolarSoft
;
; MODIFICATION HISTORY:
;	24/November/2006 v1.0 mcrw wrote
;
;-------------------------------------------------------------------------------------------------
; files - string array of filenames in time order
; output - string pathname to where to write ps files
;
pro status_check, files, lu
  tmp = eis_get_daily_data(files, 'SAT_ROT',   1,  1, maxp1, minp1, start_time, end_time)
;  mom = moment(tmp)
;  avgp1 = mom[0]
  tmp = eis_get_daily_data(files, 'UFSAXANG', 2,  1, maxp2, minp2)
;  mom = moment(tmp)
;  avgp2 = mom[0]
  tmp = eis_get_daily_data(files, 'UFSAYANG', 3,  1, maxp3, minp3)
;  mom = moment(tmp)
;  avgp3 = mom[0]
  tmp = eis_get_daily_data(files, 'UFSBXANG', 4,  1, maxp4, minp4)
;  mom = moment(tmp)
;  avgp4 = mom[0]
  tmp = eis_get_daily_data(files, 'UFSBYANG', 5,  1, maxp5, minp5)
;  mom = moment(tmp)
;  avgp5 = mom[0]
  tmp = eis_get_daily_data(files, 'ERRANGZ', 6,  1, maxp6, minp6)
;  mom = moment(tmp)
;  avgp6 = mom[0]

;  title_str = 'HK2 status                      min            max                avg'
  title_str = 'HK2 status                      min            max'

  frmt = 'count'
  p0_str  = eis_param_string('SAT_ROT               ', frmt, minp1,  maxp1); + '	'  + eis_num2str(avgp1, type=frmt)
  p1_str  = eis_param_string('UFSAXANG              ', frmt, minp2,  maxp2); + '	'  + eis_num2str(avgp2, type=frmt)
  p2_str  = eis_param_string('UFSAYANG              ', frmt, minp3,  maxp3); + '	'  + eis_num2str(avgp3, type=frmt)
  p3_str  = eis_param_string('UFSBXANG              ', frmt, minp4,  maxp4); + '	'  + eis_num2str(avgp4, type=frmt)
  p4_str  = eis_param_string('UFSBYANG              ', frmt, minp5,  maxp5); + '	'  + eis_num2str(avgp5, type=frmt)
  p5_str  = eis_param_string('ERRANGZ               ', frmt, minp6,  maxp6); + '	'  + eis_num2str(avgp6, type=frmt)

  if n_elements(lu) ne 0 then begin
     print, '	aocs1_status_check'
     printf, lu, title_str
     printf, lu, p0_str
     printf, lu, p1_str
     printf, lu, p2_str
     printf, lu, p3_str
     printf, lu, p4_str
     printf, lu, p5_str
     printf, lu
  endif

 end


pro eis_status_aocs1_check, dir, lu

  print, 'eis_status_aocs1_check'

    files = findfile(dir + 'eis_aocs1_*fits*', count=count)
    if count eq 0 then begin
        print, 'eis_status_aocs1_check'
        print, '	No files'
        return
    endif

    if n_elements(lu) ne 0 then begin
        print, 'eis_status_aocs1_check'
        status_check, files, lu
        return
    endif

    status_check, files

end
