;+
; NAME: eis_status_sts1_conversions.pro
;
; PURPOSE: To convert EIS status 1 parameters from telemetered values
;          to engineering values
;      
; CATEGORY:
;
; CALLING SEQUENCE: 
;
; INPUTS: 
;
; KEYWORD PARAMETERS: None
;
; OUTPUTS: 
;
; CALLS:
;
; COMMON BLOCKS: None
;
; PROCEDURE:
;
; RESTRICTIONS: Uses SolarSoft
;
; MODIFICATION HISTORY:
;	24/November/2006 v1.0 mcrw wrote
;
;-------------------------------------------------------------------------------------------------
; files - string array of filenames in time order
; output - string pathname to where to write ps files
;
pro htr_temp_check, files, lu

    tmp = eis_get_daily_data(files,'HK1_EIS_A_HTR_TMP', 1, 1, maxp1, minp1, start_time, end_time)
    mom = moment(tmp)
    avgp1 = eis_convert_hk1_htra_temp([mom[0]])
    tmp = eis_get_daily_data(files,'HK1_EIS_B_HTR_TMP', 2, 1, maxp2, minp2)
    mom = moment(tmp)
    avgp2 = eis_convert_hk1_htrb_temp([mom[0]])
    tmp = eis_get_daily_data(files,'HK1_EIS_C_HTR_TMP', 3, 1, maxp3, minp3)
    mom = moment(tmp)
    avgp3 = eis_convert_hk1_htrc_temp([mom[0]])

    title_str = 'HTR temperatures (C)            min            max                avg'

    htra_str = eis_min_max_str('Htr-A                 ', 'degC', 'eis_convert_hk1_htra_temp', maxp1,  minp1)
    htrb_str = eis_min_max_str('Htr-B                 ', 'degC', 'eis_convert_hk1_htrb_temp', maxp2,  minp2)
    htrc_str = eis_min_max_str('Htr-C                 ', 'degC', 'eis_convert_hk1_htrc_temp', maxp3,  minp3)

    if n_elements(lu) ne 0 then begin
        print, '	htr_temp_check'
        printf, lu, title_str
        printf, lu, htra_str + '            ' + strtrim(string(avgp1,format='(F7.2)'), 0)
        printf, lu, htrb_str + '            ' + strtrim(string(avgp2,format='(F7.2)'), 0)
        printf, lu, htrc_str + '            ' + strtrim(string(avgp3,format='(F7.2)'), 0)
        printf, lu
    endif else begin
        print, title_str
        print, htra_str
        print, htrb_str
        print, htrc_str
        print
    endelse
end

pro icu_temp_check, files, lu

    tmp = eis_get_daily_data(files,'HK1_EIS_ICU_1_TEMP', 4, 1, maxp1, minp1, start_time, end_time)
    mom = moment(tmp)
    avgp1 = eis_convert_hk1_icu1_temp([mom[0]])
    tmp = eis_get_daily_data(files,'HK1_EIS_ICU_2_TEMP', 5, 1, maxp2, minp2)
    mom = moment(tmp)
    avgp2 = eis_convert_hk1_icu2_temp([mom[0]])

    title_str = 'ICU temperatures (C)            min            max                avg'

    icu1_str = eis_min_max_str('Icu-1                 ', 'degC', 'eis_convert_hk1_icu1_temp', minp1,  maxp1)
    icu2_str = eis_min_max_str('Icu-2                 ', 'degC', 'eis_convert_hk1_icu2_temp', minp2,  maxp2)

    if n_elements(lu) ne 0 then begin
        print, '	icu_temp_check'
        printf, lu, title_str
        printf, lu, icu1_str + '            ' + strtrim(string(avgp1,format='(F7.2)'), 0)
        printf, lu, icu2_str + '            ' + strtrim(string(avgp2,format='(F7.2)'), 0)
        printf, lu
    endif else begin
        print, title_str
        print, icu1_str
        print, icu2_str
;        print, htrc_str
        print
    endelse
end

pro str_temp_check, files, lu

    tmp = eis_get_daily_data(files,'HK1_EIS_STR_1_TEMP', 6,  1, maxp1, minp1, start_time, end_time)
    mom = moment(tmp)
    avgp1 = eis_convert_hk1_str1_temp([mom[0]])
    tmp = eis_get_daily_data(files,'HK1_EIS_STR_2_TEMP', 7,  1, maxp2, minp2)
    mom = moment(tmp)
    avgp2 = eis_convert_hk1_str2_temp([mom[0]])
    tmp = eis_get_daily_data(files,'HK1_EIS_STR_3_TEMP', 8,  1, maxp3, minp3)
    mom = moment(tmp)
    avgp3 = eis_convert_hk1_str3_temp([mom[0]])
    tmp = eis_get_daily_data(files,'HK1_EIS_STR_4_TEMP', 9,  1, maxp4, minp4)
    mom = moment(tmp)
    avgp4 = eis_convert_hk1_str4_temp([mom[0]])
    tmp = eis_get_daily_data(files,'HK1_EIS_STR_5_TEMP', 10, 1, maxp5, minp5)
    mom = moment(tmp)
    avgp5 = eis_convert_hk1_str5_temp([mom[0]])
    tmp = eis_get_daily_data(files,'HK1_EIS_STR_6_TEMP', 11, 1, maxp6, minp6)
    mom = moment(tmp)
    avgp6 = eis_convert_hk1_str6_temp([mom[0]])
    tmp = eis_get_daily_data(files,'HK1_EIS_STR_7_TEMP', 12, 1, maxp7, minp7)
    mom = moment(tmp)
    avgp7 = eis_convert_hk1_str7_temp([mom[0]])

    title_str = 'STR temperatures (C)            min            max                avg'

    str1_str = eis_min_max_str('Str-1                 ', 'degC', 'eis_convert_hk1_str1_temp', minp1,  maxp1)
    str2_str = eis_min_max_str('Str-2                 ', 'degC', 'eis_convert_hk1_str2_temp', minp2,  maxp2)
    str3_str = eis_min_max_str('Str-3                 ', 'degC', 'eis_convert_hk1_str3_temp', minp3,  maxp3)
    str4_str = eis_min_max_str('Str-4                 ', 'degC', 'eis_convert_hk1_str4_temp', minp4,  maxp4)
    str5_str = eis_min_max_str('Str-5                 ', 'degC', 'eis_convert_hk1_str5_temp', minp5,  maxp5)
    str6_str = eis_min_max_str('Str-6                 ', 'degC', 'eis_convert_hk1_str6_temp', minp6,  maxp6)
    str7_str = eis_min_max_str('Str-7                 ', 'degC', 'eis_convert_hk1_str7_temp', minp7,  maxp7)

    if n_elements(lu) ne 0 then begin
        print, '	str_temp_check'
        printf, lu, title_str
        printf, lu, str1_str + '            ' + strtrim(string(avgp1,format='(F7.2)'), 0)
        printf, lu, str2_str + '            ' + strtrim(string(avgp2,format='(F7.2)'), 0)
        printf, lu, str3_str + '            ' + strtrim(string(avgp3,format='(F7.2)'), 0)
        printf, lu, str4_str + '            ' + strtrim(string(avgp4,format='(F7.2)'), 0)
        printf, lu, str5_str + '            ' + strtrim(string(avgp5,format='(F7.2)'), 0)
        printf, lu, str6_str + '            ' + strtrim(string(avgp6,format='(F7.2)'), 0)
        printf, lu, str7_str + '            ' + strtrim(string(avgp7,format='(F7.2)'), 0)
        printf, lu
    endif else begin
        print, title_str
        print, str1_str
        print, str2_str
        print, str3_str
        print, str4_str
        print, str5_str
        print, str6_str
        print, str7_str
        print
    endelse
end

pro status_check, files, lu
  tmp = eis_get_daily_data(files, 'HK1_EIS_ON_OFF',   1,  2, maxp1, minp1, start_time, end_time)
  tmp = eis_get_daily_data(files, 'HK1_EIS_A_HTR_ED', 2,  2, maxp2, minp2)
  tmp = eis_get_daily_data(files, 'HK1_EIS_B_HTR_ED', 3,  2, maxp3, minp3)
  tmp = eis_get_daily_data(files, 'HK1_EIS_C_HTR_ED', 4,  2, maxp4, minp4)

  title_str = 'STR status                      min            max'

  frmt = 'count'
  p0_str  = eis_param_string('HK1_EIS_ON_OFF        ', frmt, minp1,  maxp1)
  p1_str  = eis_param_string('HK1_EIS_A_HTR_ED      ', frmt, minp2,  maxp2)
  p2_str  = eis_param_string('HK1_EIS_B_HTR_ED      ', frmt, minp3,  maxp3)
  p3_str  = eis_param_string('HK1_EIS_C_HTR_ED      ', frmt, minp4,  maxp4)

  if n_elements(lu) ne 0 then begin
     print, '	hk1_status_check'
     printf, lu, title_str
     printf, lu, p0_str
     printf, lu, p1_str
     printf, lu, p2_str
     printf, lu, p3_str
     printf, lu
  endif

 end

pro mdp_check, files, lu
  tmp = eis_get_daily_data(files, 'HK1_DIST_28V_VOLT', 1,  3, maxp1, minp1, start_time, end_time)
  tmp = eis_get_daily_data(files, 'HK1_DIST_28V_CUR',  2,  3, maxp2, minp2)
  tmp = eis_get_daily_data(files, 'EIS_DATA_RATE',     3,  3, maxp3, minp3)

  title_str = 'STR MDP                         min            max'

  frmt = 'count'
  p0_str  = eis_param_string('HK1_DIST_28V_VOLT     ', frmt, minp1,  maxp1)
  p1_str  = eis_param_string('HK1_DIST_28V_CUR      ', frmt, minp2,  maxp2)
  p2_str  = eis_param_string('EIS_DATA_RATE         ', frmt, minp3,  maxp3)

  if n_elements(lu) ne 0 then begin
     print, '	hk1_status_check'
     printf, lu, title_str
     printf, lu, p0_str
     printf, lu, p1_str
     printf, lu, p2_str
     printf, lu
  endif

 end


pro eis_status_hk1_check, dir, lu

  print, 'eis_status_hk1_check'

    files = findfile(dir + 'eis_hk1_*fits*', count=count)
    if count eq 0 then begin
        print, 'eis_status_hk1_check'
        print, '	No files'
        return
    endif

    if n_elements(lu) ne 0 then begin
        print, 'eis_status_hk1_check'
        htr_temp_check, files, lu
        icu_temp_check, files, lu
        str_temp_check, files, lu

        status_check,   files, lu
        mdp_check,      files, lu

        return
    endif

    htr_temp_check, files
    icu_temp_check, files
    str_temp_check, files

end
