;+
; NAME: eis_status_sts2_conversions.pro
;
; PURPOSE: 
;      
; CATEGORY:
;
; CALLING SEQUENCE: 
;
; INPUTS: 
;
; KEYWORD PARAMETERS: None
;
; OUTPUTS: 
;
; CALLS:
;
; COMMON BLOCKS: None
;
; PROCEDURE:
;
; RESTRICTIONS: Uses SolarSoft
;
; MODIFICATION HISTORY:
;	24/November/2006 v1.0 mcrw wrote
;
;-------------------------------------------------------------------------------------------------
; Given an array arr, return an array of where arr is not 0 or max.
; count will be set to the number in the returned array.
function non_defaults_old, arr, maxv, count
    ; Find all values which are not minimum or maximum
    ndefs = where(arr lt maxv and arr gt 0, count)
;;;    ndefs = where(arr ne maxv and arr ne 0, count)
    if count gt 0 then begin
       foo = arr[ndefs]
       ret = arr[ndefs[uniq(foo[sort(foo)])]]
       count  = n_elements(ret)
       return, ret
    endif
    return, ndefs
end

function non_defaults, arr, maxv, count
                                ; Find all the indices of the values
                                ; which are not minimum or maximum                                                                                                                              
  non_defaults_indices = where(arr gt 0 and arr lt maxv, count)
  if count gt 0 then begin
     matched_values = arr[non_defaults_indices]
     sorted = sort(matched_values)
     vals = non_defaults_indices[sorted]
     sorted_vals = arr[vals]
     unique = uniq(sorted_vals)
     ret = sorted_vals[unique]
     count  = n_elements(ret)
     return, ret
 endif
 return, non_defaults_indices
end

; If c is not zero then print to lu the values in arr.
pro report_non_defaults, lu, arr, c
;    if c eq -1 then return
    if c ne 0 then begin
        for i = 0, c-1 do printf, lu, '		' + strtrim(string(arr[i]))
    endif
end

;pro cam_voltages, files, output, end_time
pro cam_voltages_check, files, lu

    title_str = 'CAM voltages (volts)            min            max                avg'
        
    tmp = eis_get_daily_data(files,'CAM_P5V1_DIG',  1,  1, maxp1,  minp1, base_time, end_time)
    mom = moment(tmp)
    avgp1 = eis_convert_cam_voltage_p5v1dig([mom[0]])
    tmp = eis_get_daily_data(files,'CAM_P2V5_DIG',  2,  1, maxp2,  minp2)
    mom = moment(tmp)
    avgp2 = eis_convert_cam_voltage_p2v5dig([mom[0]])
    tmp = eis_get_daily_data(files,'CAM_P5V_AN_A',  3,  1, maxp3,  minp3)
    mom = moment(tmp)
    avgp3 = eis_convert_cam_voltage_p5vana([mom[0]])
    tmp = eis_get_daily_data(files,'CAM_P5V_AN_B',  4,  1, maxp4,  minp4)
    mom = moment(tmp)
    avgp4 = eis_convert_cam_voltage_p5vanb([mom[0]])
    tmp = eis_get_daily_data(files,'CAM_N5V_AN_A',  5,  1, maxp5,  minp5)
    mom = moment(tmp)
    avgp5 = eis_convert_cam_voltage_n5vana([mom[0]])
    tmp = eis_get_daily_data(files,'CAM_N5V_AN_B',  6,  1, maxp6,  minp6)
    mom = moment(tmp)
    avgp6 = eis_convert_cam_voltage_n5vanb([mom[0]])
    tmp = eis_get_daily_data(files,'CAM_P36V_A',    7,  1, maxp7,  minp7)
    mom = moment(tmp)
    avgp7 = eis_convert_cam_voltage_p36va([mom[0]])
    tmp = eis_get_daily_data(files,'CAM_P36V_B',    8,  1, maxp8,  minp8)
    mom = moment(tmp)
    avgp8 = eis_convert_cam_voltage_p36vb([mom[0]])
    tmp = eis_get_daily_data(files,'CAM_P12V_A',    9,  1, maxp9,  minp9)
    mom = moment(tmp)
    avgp9 = eis_convert_cam_voltage_p12va([mom[0]])
    tmp = eis_get_daily_data(files,'CAM_P12V_B',   10,  1, maxp10, minp10)
    mom = moment(tmp)
    avgp10 = eis_convert_cam_voltage_p12vb([mom[0]])
    tmp = eis_get_daily_data(files,'CAM_N10V_A',   11,  1, maxp11, minp11)
    mom = moment(tmp)
    avgp11 = eis_convert_cam_voltage_n10va([mom[0]])
    tmp = eis_get_daily_data(files,'CAM_N10V_B',   12,  1, maxp12, minp12)
    mom = moment(tmp)
    avgp12 = eis_convert_cam_voltage_n10vb([mom[0]])

    p5v1dig_str  = eis_min_max_str('+5.1v dig             ', 'volts', 'eis_convert_cam_voltage_p5v1dig', minp1,  maxp1)
    p2v5dig_str  = eis_min_max_str('+2.5v dig             ', 'volts', 'eis_convert_cam_voltage_p2v5dig', minp2,  maxp2)
    p5vana_str   = eis_min_max_str('+5v an a              ', 'volts', 'eis_convert_cam_voltage_p5vana',  minp3,  maxp3)
    p5vanb_str   = eis_min_max_str('+5v an b              ', 'volts', 'eis_convert_cam_voltage_p5vanb',  minp4,  maxp4)
    n5vana_str   = eis_min_max_str('-5v an a              ', 'volts', 'eis_convert_cam_voltage_n5vana',  minp5,  maxp5)
    n5vanb_str   = eis_min_max_str('-5v an b              ', 'volts', 'eis_convert_cam_voltage_n5vanb',  minp6,  maxp6)
    p36va_str    = eis_min_max_str('+36v a                ', 'volts', 'eis_convert_cam_voltage_p36va',   minp7,  maxp7)
    p36vb_str    = eis_min_max_str('+36v b                ', 'volts', 'eis_convert_cam_voltage_p36vb',   minp8,  maxp8)
    p12va_str    = eis_min_max_str('+12v a                ', 'volts', 'eis_convert_cam_voltage_p12va',   minp9,  maxp9)
    p12vb_str    = eis_min_max_str('+12v b                ', 'volts', 'eis_convert_cam_voltage_p12vb',   minp10, maxp10)
    n10va_str    = eis_min_max_str('-10v a                ', 'volts', 'eis_convert_cam_voltage_n10va',   minp11, maxp11)
    n10vb_str    = eis_min_max_str('-10v b                ', 'volts', 'eis_convert_cam_voltage_n10vb',   minp12, maxp12)

    if n_elements(lu) ne 0 then begin
        print, '	cam_voltages_check'
        printf, lu, title_str
        printf, lu, p5v1dig_str + '            ' + strtrim(string(avgp1,format='(F7.2)'), 0)
        printf, lu, p2v5dig_str + '            ' + strtrim(string(avgp2,format='(F7.2)'), 0)
        printf, lu, p5vana_str + '            ' + strtrim(string(avgp3,format='(F7.2)'), 0)
        printf, lu, p5vanb_str + '            ' + strtrim(string(avgp4,format='(F7.2)'), 0)
        printf, lu, n5vana_str + '            ' + strtrim(string(avgp5,format='(F7.2)'), 0)
        printf, lu, n5vanb_str + '            ' + strtrim(string(avgp6,format='(F7.2)'), 0)
        printf, lu, p36va_str + '            ' + strtrim(string(avgp7,format='(F7.2)'), 0)
        printf, lu, p36vb_str + '            ' + strtrim(string(avgp8,format='(F7.2)'), 0)
        printf, lu, p12va_str + '            ' + strtrim(string(avgp9,format='(F7.2)'), 0)
        printf, lu, p12vb_str + '            ' + strtrim(string(avgp10,format='(F7.2)'), 0)
        printf, lu, n10va_str + '            ' + strtrim(string(avgp11,format='(F7.2)'), 0)
        printf, lu, n10vb_str + '            ' + strtrim(string(avgp12,format='(F7.2)'), 0)
        printf, lu
    endif else begin
        print, title_str
        print, p5v1dig_str
        print, p2v5dig_str
        print, p5vana_str
        print, p5vanb_str
        print, n5vana_str
        print, n5vanb_str
        print, p36va_str
        print, p36vb_str
        print, p12va_str
        print, p12vb_str
        print, n10va_str
        print, n10vb_str
        print
    endelse

end

;pro cam_currents, files, output, end_time
pro cam_currents_check, files, lu

    title_str = 'CAM currents (amps)             min            max                avg'

    tmp = eis_get_daily_data(files,'CAM_P5VI_DIG',  1,  2, maxp1,  minp1, base_time, end_time)
    mom = moment(tmp)
    avgp1 = eis_convert_cam_current_p5vdig([mom[0]])
    tmp = eis_get_daily_data(files,'CAM_P2V5I_DIG', 2,  2, maxp2,  minp2)
    mom = moment(tmp)
    avgp2 = eis_convert_cam_current_p2p5vdig([mom[0]])
    tmp = eis_get_daily_data(files,'CAM_P5VI_AN_A', 3,  2, maxp3,  minp3)
    mom = moment(tmp)
    avgp3 = eis_convert_cam_current_p5vana([mom[0]])
    tmp = eis_get_daily_data(files,'CAM_P5VI_AN_B', 4,  2, maxp4,  minp4)
    mom = moment(tmp)
    avgp4 = eis_convert_cam_current_p5vanb([mom[0]])
    tmp = eis_get_daily_data(files,'CAM_N5VI_AN_A', 5,  2, maxp5,  minp5)
    mom = moment(tmp)
    avgp5 = eis_convert_cam_current_n5vana([mom[0]])
    tmp = eis_get_daily_data(files,'CAM_N5VI_AN_B', 6,  2, maxp6,  minp6)
    mom = moment(tmp)
    avgp6 = eis_convert_cam_current_n5vanb([mom[0]])
    tmp = eis_get_daily_data(files,'CAM_P36VI_A',   7,  2, maxp7,  minp7)
    mom = moment(tmp)
    avgp7 = eis_convert_cam_current_p36va([mom[0]])
    tmp = eis_get_daily_data(files,'CAM_P36VI_B',   8,  2, maxp8,  minp8)
    mom = moment(tmp)
    avgp8 = eis_convert_cam_current_p36vb([mom[0]])
    tmp = eis_get_daily_data(files,'CAM_P12VI_A',   9,  2, maxp9,  minp9)
    mom = moment(tmp)
    avgp9 = eis_convert_cam_current_p12va([mom[0]])
    tmp = eis_get_daily_data(files,'CAM_P12VI_B',   10, 2, maxp10, minp10)
    mom = moment(tmp)
    avgp10 = eis_convert_cam_current_p12vb([mom[0]])

    p5v1dig_str  = eis_min_max_str('+5.1v dig             ', 'amps', 'eis_convert_cam_current_p5vdig',   minp1,  maxp1)
    p2v5dig_str  = eis_min_max_str('+2.5v dig             ', 'amps', 'eis_convert_cam_current_p2p5vdig', minp2,  maxp2)
    p5vana_str   = eis_min_max_str('+5v ana a             ', 'amps', 'eis_convert_cam_current_p5vana',   minp3,  maxp3)
    p5vanb_str   = eis_min_max_str('+5v ana b             ', 'amps', 'eis_convert_cam_current_p5vanb',   minp4,  maxp4)
    n5vana_str   = eis_min_max_str('-5v ana a             ', 'amps', 'eis_convert_cam_current_n5vana',   minp5,  maxp5)
    n5vanb_str   = eis_min_max_str('-5v ana b             ', 'amps', 'eis_convert_cam_current_n5vanb',   minp6,  maxp6)
    p36va_str    = eis_min_max_str('+36v a                ', 'amps', 'eis_convert_cam_current_p36va',    minp7,  maxp7)
    p36vb_str    = eis_min_max_str('+36v b                ', 'amps', 'eis_convert_cam_current_p36vb',    minp8,  maxp8)
    p12va_str    = eis_min_max_str('+12v a                ', 'amps', 'eis_convert_cam_current_p12va',    minp9,  maxp9)
    p12vb_str    = eis_min_max_str('+12v b                ', 'amps', 'eis_convert_cam_current_p12vb',    minp10, maxp10)

    if n_elements(lu) ne 0 then begin
        print, '	cam_currents_check'
        printf, lu, title_str
        printf, lu, p5v1dig_str + '            ' + strtrim(string(avgp1,format='(F7.3)'), 0)
        printf, lu, p2v5dig_str + '            ' + strtrim(string(avgp2,format='(F7.3)'), 0)
        printf, lu, p5vana_str + '            ' + strtrim(string(avgp3,format='(F7.3)'), 0)
        printf, lu, p5vanb_str + '            ' + strtrim(string(avgp4,format='(F7.3)'), 0)
        printf, lu, n5vana_str + '            ' + strtrim(string(avgp5,format='(F7.3)'), 0)
        printf, lu, n5vanb_str + '            ' + strtrim(string(avgp6,format='(F7.3)'), 0)
        printf, lu, p36va_str + '            ' + strtrim(string(avgp7,format='(F7.3)'), 0)
        printf, lu, p36vb_str + '            ' + strtrim(string(avgp8,format='(F7.3)'), 0)
        printf, lu, p12va_str + '            ' + strtrim(string(avgp9,format='(F7.3)'), 0)
        printf, lu, p12vb_str + '            ' + strtrim(string(avgp10,format='(F7.3)'), 0)
        printf, lu
    endif else begin
        print, title_str
        print, p5v1dig_str
        print, p2v5dig_str
        print, p5vana_str
        print, p5vanb_str
        print, n5vana_str
        print, n5vanb_str
        print, p36va_str
        print, p36vb_str
        print, p12va_str
        print, p12vb_str
        print
    endelse

end

;pro cam_ccd_biases, files, output, end_time
pro cam_ccd_biases_check, files, lu

    title_str = 'CAM ccd biases (volts)          min            max                avg'

    tmp = eis_get_daily_data(files,'CAM_VOD_A',  1,  3, maxp1, minp1, base_time, end_time)
    mom = moment(tmp)
    avgp1 = eis_convert_cam_bias_vod_a([mom[0]])

    tmp = eis_get_daily_data(files,'CAM_VRD_A',  2,  3, maxp2, minp2)
    mom = moment(tmp)
    avgp2 = eis_convert_cam_bias_vrd_a([mom[0]])

    tmp = eis_get_daily_data(files,'CAM_VSS_A',  3,  3, maxp3, minp3)
    mom = moment(tmp)
    avgp3 = eis_convert_cam_bias_vss_a([mom[0]])

    tmp = eis_get_daily_data(files,'CAM_VOD_B',  4,  3, maxp4, minp4)
    mom = moment(tmp)
    avgp4 = eis_convert_cam_bias_vod_b([mom[0]])

    tmp = eis_get_daily_data(files,'CAM_VRD_B',  5,  3, maxp5, minp5)
    mom = moment(tmp)
    avgp5 = eis_convert_cam_bias_vrd_b([mom[0]])

    tmp = eis_get_daily_data(files,'CAM_VSS_B',  6,  3, maxp6, minp6)
    mom = moment(tmp)
    avgp6 = eis_convert_cam_bias_vss_b([mom[0]])

    tmp = eis_get_daily_data(files,'CAM_VOD',    7,  3, maxp7, minp7)
    mom = moment(tmp)
    avgp7 = eis_convert_cam_bias_vod([mom[0]])

    tmp = eis_get_daily_data(files,'CAM_VRD',    8,  3, maxp8, minp8)
    mom = moment(tmp)
    avgp8 = eis_convert_cam_bias_vrd([mom[0]])

    tmp = eis_get_daily_data(files,'CAM_VSS',    9,  3, maxp9, minp9)
    mom = moment(tmp)
    avgp9 = eis_convert_cam_bias_vss([mom[0]])

    voda_str  = eis_min_max_str('VOD A                 ', 'volts', 'eis_convert_cam_bias_vod_a', minp1, maxp1)
    vrda_str  = eis_min_max_str('VRD A                 ', 'volts', 'eis_convert_cam_bias_vrd_a', minp2, maxp2)
    vssa_str  = eis_min_max_str('VSS A                 ', 'volts', 'eis_convert_cam_bias_vss_a', minp3, maxp3)
    vodb_str  = eis_min_max_str('VOD B                 ', 'volts', 'eis_convert_cam_bias_vod_b', minp4, maxp4)
    vrdb_str  = eis_min_max_str('VRD B                 ', 'volts', 'eis_convert_cam_bias_vrd_b', minp5, maxp5)
    vssb_str  = eis_min_max_str('VSS B                 ', 'volts', 'eis_convert_cam_bias_vss_b', minp6, maxp6)
    vod_str   = eis_min_max_str('VOD                   ', 'volts', 'eis_convert_cam_bias_vod',   minp7, maxp7)
    vrd_str   = eis_min_max_str('VRD                   ', 'volts', 'eis_convert_cam_bias_vrd',   minp8, maxp8)
    vss_str   = eis_min_max_str('VSS                   ', 'volts', 'eis_convert_cam_bias_vss',   minp9, maxp9)

    if n_elements(lu) ne 0 then begin
        print, '	cam_ccd_biases_check'
        printf, lu, title_str
        printf, lu, voda_str + '            ' + strtrim(string(avgp1,format='(F7.2)'), 0)
        printf, lu, vrda_str + '            ' + strtrim(string(avgp2,format='(F7.2)'), 0)
        printf, lu, vssa_str + '            ' + strtrim(string(avgp3,format='(F7.2)'), 0)
        printf, lu, vodb_str + '            ' + strtrim(string(avgp4,format='(F7.2)'), 0)
        printf, lu, vrdb_str + '            ' + strtrim(string(avgp5,format='(F7.2)'), 0)
        printf, lu, vssb_str + '            ' + strtrim(string(avgp6,format='(F7.2)'), 0)
        printf, lu, vod_str  + '            ' + strtrim(string(avgp7,format='(F7.2)'), 0)
        printf, lu, vrd_str  + '            ' + strtrim(string(avgp8,format='(F7.2)'), 0)
        printf, lu, vss_str  + '            ' + strtrim(string(avgp9,format='(F7.2)'), 0)
        printf, lu
    endif else begin
        print, title_str
        print, voda_str
        print, vrda_str
        print, vssa_str
        print, vodb_str
        print, vrdb_str
        print, vssb_str
        print, vod_str
        print, vrd_str
        print, vss_str
        print
    endelse

end

;pro cam_psu_voltages, files, output, end_time
pro cam_psu_voltages_check, files, lu

    title_str = 'CAM psu voltages (volts)        min            max                avg'

    tmp = eis_get_daily_data(files,'PSU_CAM_P39V',  1,  4, maxp1, minp1, base_time, end_time)
    mom = moment(tmp)
    avgp1 = eis_convert_cam_voltage_psup39v([mom[0]])
    tmp = eis_get_daily_data(files,'PSU_CAM_P7V',   2,  4, maxp2, minp2)
    mom = moment(tmp)
    avgp2 = eis_convert_cam_voltage_psup7v([mom[0]])
    tmp = eis_get_daily_data(files,'PSU_CAM_N8V',   3,  4, maxp3, minp3)
    mom = moment(tmp)
    avgp3 = eis_convert_cam_voltage_psun8v([mom[0]])
    tmp = eis_get_daily_data(files,'PSU_CAM_P8V',   4,  4, maxp4, minp4)
    mom = moment(tmp)
    avgp4 = eis_convert_cam_voltage_psup8v([mom[0]])
    tmp = eis_get_daily_data(files,'PSU_CAM_P13V',  5,  4, maxp5, minp5)
    mom = moment(tmp)
    avgp5 = eis_convert_cam_voltage_psup13v([mom[0]])

;   title_str =                'CAM psu voltages (volts)	min	    max'
    p39v_str = eis_min_max_str('+39v                  ', 'volts', 'eis_convert_cam_voltage_psup39v', minp1, maxp1)
    p7v_str  = eis_min_max_str('+7v                   ', 'volts', 'eis_convert_cam_voltage_psup7v',  minp2, maxp2)
    n8v_str  = eis_min_max_str('-8v                   ', 'volts', 'eis_convert_cam_voltage_psun8v',  minp3, maxp3)
    p8v_str  = eis_min_max_str('+8v                   ', 'volts', 'eis_convert_cam_voltage_psup8v',  minp4, maxp4)
    p13v_str = eis_min_max_str('+13v                  ', 'volts', 'eis_convert_cam_voltage_psup13v', minp5, maxp5)

    if n_elements(lu) ne 0 then begin
        print, '	cam_psu_voltages_check'
        printf, lu, title_str
        printf, lu, p39v_str + '            ' + strtrim(string(avgp1,format='(F7.2)'), 0)
        printf, lu, p7v_str + '            ' + strtrim(string(avgp2,format='(F7.2)'), 0)
        printf, lu, n8v_str + '            ' + strtrim(string(avgp3,format='(F7.2)'), 0)
        printf, lu, p8v_str + '            ' + strtrim(string(avgp4,format='(F7.2)'), 0)
        printf, lu, p13v_str + '            ' + strtrim(string(avgp5,format='(F7.2)'), 0)
        printf, lu
    endif else begin
        print, title_str
        print, p39v_str
        print, p7v_str
        print, n8v_str
        print, p8v_str
        print, p13v_str
        print
    endelse

end

;pro cam_psu_currents, files, output, end_time
pro cam_psu_currents_check, files, lu

    title_str = 'CAM psu currents (amps)         min            max                avg'

    tmp = eis_get_daily_data(files,'PSU_CAM_P39VI',  1,  5, maxp1, minp1, base_time, end_time)
    mom = moment(tmp)
    avgp1 = eis_convert_cam_current_psup39v([mom[0]])
    tmp = eis_get_daily_data(files,'PSU_CAM_P7VI',   2,  5, maxp2, minp2)
    mom = moment(tmp)
    avgp2 = eis_convert_cam_current_psup7v([mom[0]])
    tmp = eis_get_daily_data(files,'PSU_CAM_N8VI',   3,  5, maxp3, minp3)
    mom = moment(tmp)
    avgp3 = eis_convert_cam_current_psun8v([mom[0]])
    tmp = eis_get_daily_data(files,'PSU_CAM_P8VI',   4,  5, maxp4, minp4)
    mom = moment(tmp)
    avgp4 = eis_convert_cam_current_psup8v([mom[0]])
    tmp = eis_get_daily_data(files,'PSU_CAM_P13VI',  5,  5, maxp5, minp5)
    mom = moment(tmp)
    avgp5 = eis_convert_cam_current_psup13v([mom[0]])

    p39v_str = eis_min_max_str('+39v                  ', 'amps', 'eis_convert_cam_current_psup39v', minp1, maxp1)
    p7v_str  = eis_min_max_str('+7v                   ', 'amps', 'eis_convert_cam_current_psup7v',  minp2, maxp2)
    n8v_str  = eis_min_max_str('-8v                   ', 'amps', 'eis_convert_cam_current_psun8v',  minp3, maxp3)
    p8v_str  = eis_min_max_str('+8v                   ', 'amps', 'eis_convert_cam_current_psup8v',  minp4, maxp4)
    p13v_str = eis_min_max_str('+13v                  ', 'amps', 'eis_convert_cam_current_psup13v', minp5, maxp5)

    if n_elements(lu) ne 0 then begin
        print, '	cam_psu_currents_check'
        printf, lu, title_str
        printf, lu, p39v_str + '            ' + strtrim(string(avgp1,format='(F7.3)'), 0)
        printf, lu, p7v_str + '            ' + strtrim(string(avgp2,format='(F7.3)'), 0)
        printf, lu, n8v_str + '            ' + strtrim(string(avgp3,format='(F7.3)'), 0)
        printf, lu, p8v_str + '            ' + strtrim(string(avgp4,format='(F7.3)'), 0)
        printf, lu, p13v_str + '            ' + strtrim(string(avgp5,format='(F7.3)'), 0)
        printf, lu
    endif else begin
        print, title_str
        print, p39v_str
        print, p7v_str
        print, n8v_str
        print, p8v_str
        print, p13v_str
        print
    endelse

end

;pro cam_icu_parameters, files, output, end_time
pro cam_icu_parameters_check, files, lu

;    print, '	cam_icu_parameters_check'

    p0  = eis_get_daily_data(files,'CCD_BUF_ADD_F',   1,  6, maxp1,  minp1, base_time, end_time)
    p1  = eis_get_daily_data(files,'CCD_BUF_COUNT',   2,  6, maxp2,  minp2)
    p2  = eis_get_daily_data(files,'MHC_ALIVE_SYSEC', 3,  6, maxp3,  minp3)
    p3  = eis_get_daily_data(files,'EIS_XRT_X',       4,  6, maxp4,  minp4)
    p4  = eis_get_daily_data(files,'EIS_XRT_Y',       5,  6, maxp5,  minp5)
    p5  = eis_get_daily_data(files,'CMIR_POS_ARCS',   6,  6, maxp6,  minp6)
    p6  = eis_get_daily_data(files,'FMIR_OFFSET',     7,  6, maxp7,  minp7)
    p7  = eis_get_daily_data(files,'FMIR_SLOPE',      8,  6, maxp8,  minp8)
    p8  = eis_get_daily_data(files,'CMIR_SLOPE',      9,  6, maxp9,  minp9)
    p9  = eis_get_daily_data(files,'CMIR_RES_PX',    10,  6, maxp10, minp10)
    p10 = eis_get_daily_data(files,'CMIR_RES_NX',    11,  6, maxp11, minp11)
    p11 = eis_get_daily_data(files,'MHC_RESPONSE_TO',12,  6, maxp12, minp12)
    p12 = eis_get_daily_data(files,'FMIR_S_TIME',    13,  6, maxp13, minp13)
    p13 = eis_get_daily_data(files,'CMIR_SPAN_ARCS', 14,  6, maxp14, minp14)
    p14 = eis_get_daily_data(files,'EIS_XFOV',       15,  6, maxp15, minp15)
    p15 = eis_get_daily_data(files,'FT_XF',          16,  6, maxp16, minp16)
    p16 = eis_get_daily_data(files,'FT_YF',          17,  6, maxp17, minp17)
    p17 = eis_get_daily_data(files,'FT_XBIN_PEAK',   18,  6, maxp18, minp18)
    p18 = eis_get_daily_data(files,'FT_YBIN_PEAK',   19,  6, maxp19, minp19)
    p19 = eis_get_daily_data(files,'ET_XF',          20,  6, maxp20, minp20)
    p20 = eis_get_daily_data(files,'ET_YF',          21,  6, maxp21, minp21)
    p21 = eis_get_daily_data(files,'ET_XBIN_PEAK',   22,  6, maxp22, minp22)
    p22 = eis_get_daily_data(files,'ET_YBIN_PEAK',   23,  6, maxp23, minp23)

    ; Get other values other than min, max
    ; for parameters p15 to p22 inclusive
    ; Array contains unique values
    p15_array = non_defaults(p15, long(2)^16-1, c15)		; FT XF
    p16_array = non_defaults(p16, long(2)^16-1, c16)		; FT YF
;    p17_array = non_defaults(p17, 2.^32-1, c17)
;    p18_array = non_defaults(p18, 2.^32-1, c18)
    p17_array = non_defaults(p17, 4294967295, c17)	; FT XBIN PEAK
    p18_array = non_defaults(p18, 4294967295, c18)	; FT YBIN PEAK

    p19_array = non_defaults(p19, long(2)^16-1, c19)		; ET XF
    p20_array = non_defaults(p20, long(2)^16-1, c20)		; ET YF
;    p21_array = non_defaults(p21, 2.^32-1, c21)
;    p22_array = non_defaults(p22, 2.^32-1, c22)
    p21_array = non_defaults(p21, 4294967295, c21)	; ET XBIN PEAK
    p22_array = non_defaults(p22, 4294967295, c22)	; ET YBIN PEAK
    
    title_str = 'CAM ICU Parameters              min            max'

    str1   = eis_param_string('CCD_BUF_ADD_F         ', 'count', minp1, maxp1)
    str2   = eis_param_string('CCD_BUF_COUNT         ', 'count', minp2,  maxp2)
    str3   = eis_param_string('MHC_ALIVE_SYSEC       ', 'count', minp3,  maxp3)
    str4   = eis_param_string('EIS_XRT_X             ', 'count', minp4,  maxp4)
    str5   = eis_param_string('EIS_XRT_Y             ', 'count', minp5,  maxp5)
    str6   = eis_param_string('CMIR_POS_ARCS         ', 'count', minp6,  maxp6)
    str7   = eis_param_string('FMIR_OFFSET           ', 'count', minp7,  maxp7)
    str8   = eis_param_string('FMIR_SLOPE            ', 'count', minp8,  maxp8)
    str9   = eis_param_string('CMIR_SLOPE            ', 'count', minp9,  maxp9)
    str10  = eis_param_string('CMIR_RES_PX           ', 'count', minp10, maxp10)
    str11  = eis_param_string('CMIR_RES_NX           ', 'count', minp11, maxp11)
    str12  = eis_param_string('MHC_RESPONSE_TO       ', 'count', minp12, maxp12)
    str13  = eis_param_string('FMIR_S_TIME           ', 'count', minp13, maxp13)
    str14  = eis_param_string('CMIR_SPAN_ARCS        ', 'count', minp14, maxp14)
    str15  = eis_param_string('EIS_XFOV              ', 'count', minp15, maxp15)
    str16  = eis_param_string('FT_XF                 ', 'count', minp16, maxp16)
    str17  = eis_param_string('FT_YF                 ', 'count', minp17, maxp17)
    str18  = eis_param_string('FT_XBIN_PEAK          ', 'count', minp18, maxp18)
    str19  = eis_param_string('FT_YBIN_PEAK          ', 'count', minp19, maxp19)
    str20  = eis_param_string('ET_XF                 ', 'count', minp20, maxp20)
    str21  = eis_param_string('ET_YF                 ', 'count', minp21, maxp21)
    str22  = eis_param_string('ET_XBIN_PEAK          ', 'count', minp22, maxp22)
    str23  = eis_param_string('ET_YBIN_PEAK          ', 'count', minp23, maxp23)

    if n_elements(lu) ne 0 then begin
        print, '	cam_icu_parameters_check'
        printf, lu, title_str
        printf, lu, str1
        printf, lu, str2
        printf, lu, str3
        printf, lu, str4
        printf, lu, str5
        printf, lu, str6
        printf, lu, str7
        printf, lu, str8
        printf, lu, str9
        printf, lu, str10
        printf, lu, str11
        printf, lu, str12
        printf, lu, str13
        printf, lu, str14
        printf, lu, str15

        printf, lu, str16
        report_non_defaults, lu, p15_array, c15
        printf, lu, str17
        report_non_defaults, lu, p16_array, c16
        printf, lu, str18
        report_non_defaults, lu, p17_array, c17
        printf, lu, str19
        report_non_defaults, lu, p18_array, c18
        printf, lu, str20
        report_non_defaults, lu, p19_array, c19
        printf, lu, str21
        report_non_defaults, lu, p20_array, c20
        printf, lu, str22
        report_non_defaults, lu, p21_array, c21
        printf, lu, str23
        report_non_defaults, lu, p22_array, c22
        printf, lu
    endif else begin
        print, str1
        print, str2
        print, str3
        print, str4
        print, str5
        print, str6
        print, str7
        print, str8
        print, str9
        print, str10
        print, str11
        print, str12
        print, str13
        print, str14
        print, str15
        print, str16
        print, str17
        print, str18
        print, str19
        print, str20
        print, str21
        print, str22
        print, str23
        print
    endelse

end

pro cam_misc_check, files, lu

    p0   = eis_get_daily_data(files,'CAM_CTL_REG1',     1,  7, maxp1, minp1, base_time, end_time)
    p1   = eis_get_daily_data(files,'CAM_CTL_REG2',     2,  7, maxp2, minp2)
    p2   = eis_get_daily_data(files,'CAM_SEU_COUNTER',  3,  7, maxp3, minp3)

    title_str = 'CAM misc                        min            max'

    seu_str  = eis_param_string('SEU count             ', 'count', minp3, maxp3)
;    seu_str = 'SEU count : min ' + $
;    eis_num2str(minp3, type='count') + $
;      ' max ' + $
;      eis_num2str(maxp3, type='count')
    ctl1_str = eis_param_string('Ctl reg 1             ', 'count', minp1, maxp1)
    ctl2_str = eis_param_string('Ctl reg 2             ', 'count', minp2, maxp2)

    if n_elements(lu) ne 0 then begin
        print, '	cam_misc_check'
        printf, lu, title_str
        printf, lu, seu_str
        printf, lu, ctl1_str
        printf, lu, ctl2_str
        printf, lu
    endif else begin
        print, title_str
        print, seu_str
        print
    endelse
        
end

;pro cam_temperatures, files, output, end_time
pro cam_temperatures_check, files, lu

    title_str = 'CAM temperatures (C)            min            max                avg'

    tmp = eis_get_daily_data(files,'CAM_UP_TEMP',  1,  8, maxp1, minp1, base_time, end_time)
    mom = moment(tmp)
    avgp1 = eis_convert_cam_up_temperature([mom[0]])
    tmp = eis_get_daily_data(files,'CAM_LO_TEMP',  2,  8, maxp2, minp2)
    mom = moment(tmp)
    avgp2 = eis_convert_cam_lo_temperature([mom[0]])

;    up_str = eis_min_max_str('Upper', ' degC', 'eis_convert_cam_up_temperature', minp1, maxp1)
;    lo_str = eis_min_max_str('Lower', ' degC', 'eis_convert_cam_lo_temperature', minp2, maxp2)

    up_str = eis_min_max_str('Upper                 ', 'degC', 'eis_convert_cam_up_temperature', maxp1, minp1)
    lo_str = eis_min_max_str('Lower                 ', 'degC', 'eis_convert_cam_lo_temperature', maxp2, minp2)

    if n_elements(lu) ne 0 then begin
        print, '	cam_temperatures_check'
        printf, lu, title_str
        printf, lu, up_str + '            ' + strtrim(string(avgp1,format='(F7.2)'), 0)
        printf, lu, lo_str + '            ' + strtrim(string(avgp2,format='(F7.2)'), 0)
        printf, lu
    endif else begin
        print, title_str
        print, up_str
        print, lo_str
        print
    endelse

end

pro cam_spacecraft, files, output, end_time

    p0  = eis_get_daily_data(files,'TIME', 1,  9, maxp1, minp1, base_time, end_time)
    p1  = eis_get_daily_data(files,'SEQ_COUNTER', 2,  9, maxp2, minp2)

end

pro eis_status_sts2_check, dir, lu

  print, 'eis_status_sts2_check'

    catch, err_stat
    if err_stat ne 0 then begin
        print, 'Error in EIS_STATUS_STS2_CHECK'
        print, 'Error index ', err_stat
        print, !err_string
        return
    endif
    files = findfile(dir + 'eis_sts2_*fits*', count=count)
    if count eq 0 then begin
        print, 'eis_status_sts2_check'
        print, '	No files'
        return
    endif

    if n_elements(lu) ne 0 then begin
        print, 'eis_status_sts2_check'
        cam_voltages_check,       files, lu
        cam_currents_check,       files, lu
        cam_ccd_biases_check,     files, lu
        cam_psu_voltages_check,   files, lu
        cam_psu_currents_check,   files, lu
        cam_icu_parameters_check, files, lu
        cam_misc_check,           files, lu
        cam_temperatures_check,   files, lu
;        cam_spacecraft  ,   files, lu
    endif else begin
        cam_voltages_check,       files
        cam_currents_check,       files
        cam_ccd_biases_check,     files
        cam_psu_voltages_check,   files
        cam_psu_currents_check,   files
        cam_icu_parameters_check, files
        cam_misc_check,           files
        cam_temperatures_check,   files
;        cam_spacecraft  ,   files, output, end_time
    endelse
end
